/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The type of bucketed aggregation performed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BucketsAggregationType implements SdkPojo, Serializable,
        ToCopyableBuilder<BucketsAggregationType.Builder, BucketsAggregationType> {
    private static final SdkField<TermsAggregation> TERMS_AGGREGATION_FIELD = SdkField
            .<TermsAggregation> builder(MarshallingType.SDK_POJO).memberName("termsAggregation")
            .getter(getter(BucketsAggregationType::termsAggregation)).setter(setter(Builder::termsAggregation))
            .constructor(TermsAggregation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("termsAggregation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TERMS_AGGREGATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TermsAggregation termsAggregation;

    private BucketsAggregationType(BuilderImpl builder) {
        this.termsAggregation = builder.termsAggregation;
    }

    /**
     * <p>
     * Performs an aggregation that will return a list of buckets. The list of buckets is a ranked list of the number of
     * occurrences of an aggregation field value.
     * </p>
     * 
     * @return Performs an aggregation that will return a list of buckets. The list of buckets is a ranked list of the
     *         number of occurrences of an aggregation field value.
     */
    public final TermsAggregation termsAggregation() {
        return termsAggregation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(termsAggregation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BucketsAggregationType)) {
            return false;
        }
        BucketsAggregationType other = (BucketsAggregationType) obj;
        return Objects.equals(termsAggregation(), other.termsAggregation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BucketsAggregationType").add("TermsAggregation", termsAggregation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "termsAggregation":
            return Optional.ofNullable(clazz.cast(termsAggregation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("termsAggregation", TERMS_AGGREGATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BucketsAggregationType, T> g) {
        return obj -> g.apply((BucketsAggregationType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BucketsAggregationType> {
        /**
         * <p>
         * Performs an aggregation that will return a list of buckets. The list of buckets is a ranked list of the
         * number of occurrences of an aggregation field value.
         * </p>
         * 
         * @param termsAggregation
         *        Performs an aggregation that will return a list of buckets. The list of buckets is a ranked list of
         *        the number of occurrences of an aggregation field value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder termsAggregation(TermsAggregation termsAggregation);

        /**
         * <p>
         * Performs an aggregation that will return a list of buckets. The list of buckets is a ranked list of the
         * number of occurrences of an aggregation field value.
         * </p>
         * This is a convenience method that creates an instance of the {@link TermsAggregation.Builder} avoiding the
         * need to create one manually via {@link TermsAggregation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TermsAggregation.Builder#build()} is called immediately and its
         * result is passed to {@link #termsAggregation(TermsAggregation)}.
         * 
         * @param termsAggregation
         *        a consumer that will call methods on {@link TermsAggregation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #termsAggregation(TermsAggregation)
         */
        default Builder termsAggregation(Consumer<TermsAggregation.Builder> termsAggregation) {
            return termsAggregation(TermsAggregation.builder().applyMutation(termsAggregation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TermsAggregation termsAggregation;

        private BuilderImpl() {
        }

        private BuilderImpl(BucketsAggregationType model) {
            termsAggregation(model.termsAggregation);
        }

        public final TermsAggregation.Builder getTermsAggregation() {
            return termsAggregation != null ? termsAggregation.toBuilder() : null;
        }

        public final void setTermsAggregation(TermsAggregation.BuilderImpl termsAggregation) {
            this.termsAggregation = termsAggregation != null ? termsAggregation.build() : null;
        }

        @Override
        public final Builder termsAggregation(TermsAggregation termsAggregation) {
            this.termsAggregation = termsAggregation;
            return this;
        }

        @Override
        public BucketsAggregationType build() {
            return new BucketsAggregationType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
