/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The server certificate configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServerCertificateConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ServerCertificateConfig.Builder, ServerCertificateConfig> {
    private static final SdkField<Boolean> ENABLE_OCSP_CHECK_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableOCSPCheck").getter(getter(ServerCertificateConfig::enableOCSPCheck))
            .setter(setter(Builder::enableOCSPCheck))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableOCSPCheck").build()).build();

    private static final SdkField<String> OCSP_LAMBDA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ocspLambdaArn").getter(getter(ServerCertificateConfig::ocspLambdaArn))
            .setter(setter(Builder::ocspLambdaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ocspLambdaArn").build()).build();

    private static final SdkField<String> OCSP_AUTHORIZED_RESPONDER_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ocspAuthorizedResponderArn")
            .getter(getter(ServerCertificateConfig::ocspAuthorizedResponderArn))
            .setter(setter(Builder::ocspAuthorizedResponderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ocspAuthorizedResponderArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_OCSP_CHECK_FIELD,
            OCSP_LAMBDA_ARN_FIELD, OCSP_AUTHORIZED_RESPONDER_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enableOCSPCheck;

    private final String ocspLambdaArn;

    private final String ocspAuthorizedResponderArn;

    private ServerCertificateConfig(BuilderImpl builder) {
        this.enableOCSPCheck = builder.enableOCSPCheck;
        this.ocspLambdaArn = builder.ocspLambdaArn;
        this.ocspAuthorizedResponderArn = builder.ocspAuthorizedResponderArn;
    }

    /**
     * <p>
     * A Boolean value that indicates whether Online Certificate Status Protocol (OCSP) server certificate check is
     * enabled or not.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-custom-endpoints-cert-config.html"> Server
     * certificate configuration for OCSP stapling</a> from Amazon Web Services IoT Core Developer Guide.
     * </p>
     * 
     * @return A Boolean value that indicates whether Online Certificate Status Protocol (OCSP) server certificate check
     *         is enabled or not.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-custom-endpoints-cert-config.html">
     *         Server certificate configuration for OCSP stapling</a> from Amazon Web Services IoT Core Developer Guide.
     */
    public final Boolean enableOCSPCheck() {
        return enableOCSPCheck;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for a Lambda function that acts as a Request for Comments (RFC) 6960-compliant
     * Online Certificate Status Protocol (OCSP) responder, supporting basic OCSP responses. The Lambda function accepts
     * a base64-encoding of the OCSP request in the Distinguished Encoding Rules (DER) format. The Lambda function's
     * response is also a base64-encoded OCSP response in the DER format. The response size must not exceed 4 kilobytes
     * (KiB). The Lambda function must be in the same Amazon Web Services account and region as the domain
     * configuration. For more information, see <a href=
     * "https://docs.aws.amazon.com/iot/latest/developerguide/iot-custom-endpoints-cert-config.html#iot-custom-endpoints-cert-config-ocsp-private-endpoint.html"
     * >Configuring server certificate OCSP for private endpoints in Amazon Web Services IoT Core</a> from the Amazon
     * Web Services IoT Core developer guide.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for a Lambda function that acts as a Request for Comments (RFC)
     *         6960-compliant Online Certificate Status Protocol (OCSP) responder, supporting basic OCSP responses. The
     *         Lambda function accepts a base64-encoding of the OCSP request in the Distinguished Encoding Rules (DER)
     *         format. The Lambda function's response is also a base64-encoded OCSP response in the DER format. The
     *         response size must not exceed 4 kilobytes (KiB). The Lambda function must be in the same Amazon Web
     *         Services account and region as the domain configuration. For more information, see <a href=
     *         "https://docs.aws.amazon.com/iot/latest/developerguide/iot-custom-endpoints-cert-config.html#iot-custom-endpoints-cert-config-ocsp-private-endpoint.html"
     *         >Configuring server certificate OCSP for private endpoints in Amazon Web Services IoT Core</a> from the
     *         Amazon Web Services IoT Core developer guide.
     */
    public final String ocspLambdaArn() {
        return ocspLambdaArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for an X.509 certificate stored in Amazon Web Services Certificate Manager (ACM).
     * If provided, Amazon Web Services IoT Core will use this certificate to validate the signature of the received
     * OCSP response. The OCSP responder must sign responses using either this authorized responder certificate or the
     * issuing certificate, depending on whether the ARN is provided or not. The certificate must be in the same Amazon
     * Web Services account and region as the domain configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for an X.509 certificate stored in Amazon Web Services Certificate Manager
     *         (ACM). If provided, Amazon Web Services IoT Core will use this certificate to validate the signature of
     *         the received OCSP response. The OCSP responder must sign responses using either this authorized responder
     *         certificate or the issuing certificate, depending on whether the ARN is provided or not. The certificate
     *         must be in the same Amazon Web Services account and region as the domain configuration.
     */
    public final String ocspAuthorizedResponderArn() {
        return ocspAuthorizedResponderArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enableOCSPCheck());
        hashCode = 31 * hashCode + Objects.hashCode(ocspLambdaArn());
        hashCode = 31 * hashCode + Objects.hashCode(ocspAuthorizedResponderArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerCertificateConfig)) {
            return false;
        }
        ServerCertificateConfig other = (ServerCertificateConfig) obj;
        return Objects.equals(enableOCSPCheck(), other.enableOCSPCheck())
                && Objects.equals(ocspLambdaArn(), other.ocspLambdaArn())
                && Objects.equals(ocspAuthorizedResponderArn(), other.ocspAuthorizedResponderArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServerCertificateConfig").add("EnableOCSPCheck", enableOCSPCheck())
                .add("OcspLambdaArn", ocspLambdaArn()).add("OcspAuthorizedResponderArn", ocspAuthorizedResponderArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enableOCSPCheck":
            return Optional.ofNullable(clazz.cast(enableOCSPCheck()));
        case "ocspLambdaArn":
            return Optional.ofNullable(clazz.cast(ocspLambdaArn()));
        case "ocspAuthorizedResponderArn":
            return Optional.ofNullable(clazz.cast(ocspAuthorizedResponderArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("enableOCSPCheck", ENABLE_OCSP_CHECK_FIELD);
        map.put("ocspLambdaArn", OCSP_LAMBDA_ARN_FIELD);
        map.put("ocspAuthorizedResponderArn", OCSP_AUTHORIZED_RESPONDER_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServerCertificateConfig, T> g) {
        return obj -> g.apply((ServerCertificateConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServerCertificateConfig> {
        /**
         * <p>
         * A Boolean value that indicates whether Online Certificate Status Protocol (OCSP) server certificate check is
         * enabled or not.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-custom-endpoints-cert-config.html"> Server
         * certificate configuration for OCSP stapling</a> from Amazon Web Services IoT Core Developer Guide.
         * </p>
         * 
         * @param enableOCSPCheck
         *        A Boolean value that indicates whether Online Certificate Status Protocol (OCSP) server certificate
         *        check is enabled or not.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-custom-endpoints-cert-config.html">
         *        Server certificate configuration for OCSP stapling</a> from Amazon Web Services IoT Core Developer
         *        Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableOCSPCheck(Boolean enableOCSPCheck);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for a Lambda function that acts as a Request for Comments (RFC) 6960-compliant
         * Online Certificate Status Protocol (OCSP) responder, supporting basic OCSP responses. The Lambda function
         * accepts a base64-encoding of the OCSP request in the Distinguished Encoding Rules (DER) format. The Lambda
         * function's response is also a base64-encoded OCSP response in the DER format. The response size must not
         * exceed 4 kilobytes (KiB). The Lambda function must be in the same Amazon Web Services account and region as
         * the domain configuration. For more information, see <a href=
         * "https://docs.aws.amazon.com/iot/latest/developerguide/iot-custom-endpoints-cert-config.html#iot-custom-endpoints-cert-config-ocsp-private-endpoint.html"
         * >Configuring server certificate OCSP for private endpoints in Amazon Web Services IoT Core</a> from the
         * Amazon Web Services IoT Core developer guide.
         * </p>
         * 
         * @param ocspLambdaArn
         *        The Amazon Resource Name (ARN) for a Lambda function that acts as a Request for Comments (RFC)
         *        6960-compliant Online Certificate Status Protocol (OCSP) responder, supporting basic OCSP responses.
         *        The Lambda function accepts a base64-encoding of the OCSP request in the Distinguished Encoding Rules
         *        (DER) format. The Lambda function's response is also a base64-encoded OCSP response in the DER format.
         *        The response size must not exceed 4 kilobytes (KiB). The Lambda function must be in the same Amazon
         *        Web Services account and region as the domain configuration. For more information, see <a href=
         *        "https://docs.aws.amazon.com/iot/latest/developerguide/iot-custom-endpoints-cert-config.html#iot-custom-endpoints-cert-config-ocsp-private-endpoint.html"
         *        >Configuring server certificate OCSP for private endpoints in Amazon Web Services IoT Core</a> from
         *        the Amazon Web Services IoT Core developer guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ocspLambdaArn(String ocspLambdaArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for an X.509 certificate stored in Amazon Web Services Certificate Manager
         * (ACM). If provided, Amazon Web Services IoT Core will use this certificate to validate the signature of the
         * received OCSP response. The OCSP responder must sign responses using either this authorized responder
         * certificate or the issuing certificate, depending on whether the ARN is provided or not. The certificate must
         * be in the same Amazon Web Services account and region as the domain configuration.
         * </p>
         * 
         * @param ocspAuthorizedResponderArn
         *        The Amazon Resource Name (ARN) for an X.509 certificate stored in Amazon Web Services Certificate
         *        Manager (ACM). If provided, Amazon Web Services IoT Core will use this certificate to validate the
         *        signature of the received OCSP response. The OCSP responder must sign responses using either this
         *        authorized responder certificate or the issuing certificate, depending on whether the ARN is provided
         *        or not. The certificate must be in the same Amazon Web Services account and region as the domain
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ocspAuthorizedResponderArn(String ocspAuthorizedResponderArn);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enableOCSPCheck;

        private String ocspLambdaArn;

        private String ocspAuthorizedResponderArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerCertificateConfig model) {
            enableOCSPCheck(model.enableOCSPCheck);
            ocspLambdaArn(model.ocspLambdaArn);
            ocspAuthorizedResponderArn(model.ocspAuthorizedResponderArn);
        }

        public final Boolean getEnableOCSPCheck() {
            return enableOCSPCheck;
        }

        public final void setEnableOCSPCheck(Boolean enableOCSPCheck) {
            this.enableOCSPCheck = enableOCSPCheck;
        }

        @Override
        public final Builder enableOCSPCheck(Boolean enableOCSPCheck) {
            this.enableOCSPCheck = enableOCSPCheck;
            return this;
        }

        public final String getOcspLambdaArn() {
            return ocspLambdaArn;
        }

        public final void setOcspLambdaArn(String ocspLambdaArn) {
            this.ocspLambdaArn = ocspLambdaArn;
        }

        @Override
        public final Builder ocspLambdaArn(String ocspLambdaArn) {
            this.ocspLambdaArn = ocspLambdaArn;
            return this;
        }

        public final String getOcspAuthorizedResponderArn() {
            return ocspAuthorizedResponderArn;
        }

        public final void setOcspAuthorizedResponderArn(String ocspAuthorizedResponderArn) {
            this.ocspAuthorizedResponderArn = ocspAuthorizedResponderArn;
        }

        @Override
        public final Builder ocspAuthorizedResponderArn(String ocspAuthorizedResponderArn) {
            this.ocspAuthorizedResponderArn = ocspAuthorizedResponderArn;
            return this;
        }

        @Override
        public ServerCertificateConfig build() {
            return new ServerCertificateConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
