/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSecurityProfileRequest extends IotRequest implements
        ToCopyableBuilder<UpdateSecurityProfileRequest.Builder, UpdateSecurityProfileRequest> {
    private static final SdkField<String> SECURITY_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("securityProfileName").getter(getter(UpdateSecurityProfileRequest::securityProfileName))
            .setter(setter(Builder::securityProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("securityProfileName").build()).build();

    private static final SdkField<String> SECURITY_PROFILE_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("securityProfileDescription")
            .getter(getter(UpdateSecurityProfileRequest::securityProfileDescription))
            .setter(setter(Builder::securityProfileDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityProfileDescription").build())
            .build();

    private static final SdkField<List<Behavior>> BEHAVIORS_FIELD = SdkField
            .<List<Behavior>> builder(MarshallingType.LIST)
            .memberName("behaviors")
            .getter(getter(UpdateSecurityProfileRequest::behaviors))
            .setter(setter(Builder::behaviors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("behaviors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Behavior> builder(MarshallingType.SDK_POJO)
                                            .constructor(Behavior::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, AlertTarget>> ALERT_TARGETS_FIELD = SdkField
            .<Map<String, AlertTarget>> builder(MarshallingType.MAP)
            .memberName("alertTargets")
            .getter(getter(UpdateSecurityProfileRequest::alertTargetsAsStrings))
            .setter(setter(Builder::alertTargetsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alertTargets").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AlertTarget> builder(MarshallingType.SDK_POJO)
                                            .constructor(AlertTarget::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> ADDITIONAL_METRICS_TO_RETAIN_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("additionalMetricsToRetain")
            .getter(getter(UpdateSecurityProfileRequest::additionalMetricsToRetain))
            .setter(setter(Builder::additionalMetricsToRetain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalMetricsToRetain").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MetricToRetain>> ADDITIONAL_METRICS_TO_RETAIN_V2_FIELD = SdkField
            .<List<MetricToRetain>> builder(MarshallingType.LIST)
            .memberName("additionalMetricsToRetainV2")
            .getter(getter(UpdateSecurityProfileRequest::additionalMetricsToRetainV2))
            .setter(setter(Builder::additionalMetricsToRetainV2))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalMetricsToRetainV2")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricToRetain> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricToRetain::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> DELETE_BEHAVIORS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("deleteBehaviors").getter(getter(UpdateSecurityProfileRequest::deleteBehaviors))
            .setter(setter(Builder::deleteBehaviors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteBehaviors").build()).build();

    private static final SdkField<Boolean> DELETE_ALERT_TARGETS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("deleteAlertTargets").getter(getter(UpdateSecurityProfileRequest::deleteAlertTargets))
            .setter(setter(Builder::deleteAlertTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteAlertTargets").build())
            .build();

    private static final SdkField<Boolean> DELETE_ADDITIONAL_METRICS_TO_RETAIN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("deleteAdditionalMetricsToRetain")
            .getter(getter(UpdateSecurityProfileRequest::deleteAdditionalMetricsToRetain))
            .setter(setter(Builder::deleteAdditionalMetricsToRetain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteAdditionalMetricsToRetain")
                    .build()).build();

    private static final SdkField<Long> EXPECTED_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("expectedVersion").getter(getter(UpdateSecurityProfileRequest::expectedVersion))
            .setter(setter(Builder::expectedVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("expectedVersion").build())
            .build();

    private static final SdkField<MetricsExportConfig> METRICS_EXPORT_CONFIG_FIELD = SdkField
            .<MetricsExportConfig> builder(MarshallingType.SDK_POJO).memberName("metricsExportConfig")
            .getter(getter(UpdateSecurityProfileRequest::metricsExportConfig)).setter(setter(Builder::metricsExportConfig))
            .constructor(MetricsExportConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsExportConfig").build())
            .build();

    private static final SdkField<Boolean> DELETE_METRICS_EXPORT_CONFIG_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("deleteMetricsExportConfig")
            .getter(getter(UpdateSecurityProfileRequest::deleteMetricsExportConfig))
            .setter(setter(Builder::deleteMetricsExportConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteMetricsExportConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_PROFILE_NAME_FIELD,
            SECURITY_PROFILE_DESCRIPTION_FIELD, BEHAVIORS_FIELD, ALERT_TARGETS_FIELD, ADDITIONAL_METRICS_TO_RETAIN_FIELD,
            ADDITIONAL_METRICS_TO_RETAIN_V2_FIELD, DELETE_BEHAVIORS_FIELD, DELETE_ALERT_TARGETS_FIELD,
            DELETE_ADDITIONAL_METRICS_TO_RETAIN_FIELD, EXPECTED_VERSION_FIELD, METRICS_EXPORT_CONFIG_FIELD,
            DELETE_METRICS_EXPORT_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String securityProfileName;

    private final String securityProfileDescription;

    private final List<Behavior> behaviors;

    private final Map<String, AlertTarget> alertTargets;

    private final List<String> additionalMetricsToRetain;

    private final List<MetricToRetain> additionalMetricsToRetainV2;

    private final Boolean deleteBehaviors;

    private final Boolean deleteAlertTargets;

    private final Boolean deleteAdditionalMetricsToRetain;

    private final Long expectedVersion;

    private final MetricsExportConfig metricsExportConfig;

    private final Boolean deleteMetricsExportConfig;

    private UpdateSecurityProfileRequest(BuilderImpl builder) {
        super(builder);
        this.securityProfileName = builder.securityProfileName;
        this.securityProfileDescription = builder.securityProfileDescription;
        this.behaviors = builder.behaviors;
        this.alertTargets = builder.alertTargets;
        this.additionalMetricsToRetain = builder.additionalMetricsToRetain;
        this.additionalMetricsToRetainV2 = builder.additionalMetricsToRetainV2;
        this.deleteBehaviors = builder.deleteBehaviors;
        this.deleteAlertTargets = builder.deleteAlertTargets;
        this.deleteAdditionalMetricsToRetain = builder.deleteAdditionalMetricsToRetain;
        this.expectedVersion = builder.expectedVersion;
        this.metricsExportConfig = builder.metricsExportConfig;
        this.deleteMetricsExportConfig = builder.deleteMetricsExportConfig;
    }

    /**
     * <p>
     * The name of the security profile you want to update.
     * </p>
     * 
     * @return The name of the security profile you want to update.
     */
    public final String securityProfileName() {
        return securityProfileName;
    }

    /**
     * <p>
     * A description of the security profile.
     * </p>
     * 
     * @return A description of the security profile.
     */
    public final String securityProfileDescription() {
        return securityProfileDescription;
    }

    /**
     * For responses, this returns true if the service returned a value for the Behaviors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBehaviors() {
        return behaviors != null && !(behaviors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the behaviors that, when violated by a device (thing), cause an alert.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBehaviors} method.
     * </p>
     * 
     * @return Specifies the behaviors that, when violated by a device (thing), cause an alert.
     */
    public final List<Behavior> behaviors() {
        return behaviors;
    }

    /**
     * <p>
     * Where the alerts are sent. (Alerts are always sent to the console.)
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAlertTargets} method.
     * </p>
     * 
     * @return Where the alerts are sent. (Alerts are always sent to the console.)
     */
    public final Map<AlertTargetType, AlertTarget> alertTargets() {
        return AlertTargetsCopier.copyStringToEnum(alertTargets);
    }

    /**
     * For responses, this returns true if the service returned a value for the AlertTargets property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAlertTargets() {
        return alertTargets != null && !(alertTargets instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Where the alerts are sent. (Alerts are always sent to the console.)
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAlertTargets} method.
     * </p>
     * 
     * @return Where the alerts are sent. (Alerts are always sent to the console.)
     */
    public final Map<String, AlertTarget> alertTargetsAsStrings() {
        return alertTargets;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalMetricsToRetain property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     *
     * @deprecated Use additionalMetricsToRetainV2.
     */
    @Deprecated
    public final boolean hasAdditionalMetricsToRetain() {
        return additionalMetricsToRetain != null && !(additionalMetricsToRetain instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * <i>Please use <a>UpdateSecurityProfileRequest$additionalMetricsToRetainV2</a> instead.</i>
     * </p>
     * <p>
     * A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the
     * profile's <code>behaviors</code>, but it is also retained for any metric specified here. Can be used with custom
     * metrics; cannot be used with dimensions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalMetricsToRetain} method.
     * </p>
     * 
     * @return <i>Please use <a>UpdateSecurityProfileRequest$additionalMetricsToRetainV2</a> instead.</i> </p>
     *         <p>
     *         A list of metrics whose data is retained (stored). By default, data is retained for any metric used in
     *         the profile's <code>behaviors</code>, but it is also retained for any metric specified here. Can be used
     *         with custom metrics; cannot be used with dimensions.
     * @deprecated Use additionalMetricsToRetainV2.
     */
    @Deprecated
    public final List<String> additionalMetricsToRetain() {
        return additionalMetricsToRetain;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalMetricsToRetainV2 property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdditionalMetricsToRetainV2() {
        return additionalMetricsToRetainV2 != null && !(additionalMetricsToRetainV2 instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the
     * profile's behaviors, but it is also retained for any metric specified here. Can be used with custom metrics;
     * cannot be used with dimensions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalMetricsToRetainV2} method.
     * </p>
     * 
     * @return A list of metrics whose data is retained (stored). By default, data is retained for any metric used in
     *         the profile's behaviors, but it is also retained for any metric specified here. Can be used with custom
     *         metrics; cannot be used with dimensions.
     */
    public final List<MetricToRetain> additionalMetricsToRetainV2() {
        return additionalMetricsToRetainV2;
    }

    /**
     * <p>
     * If true, delete all <code>behaviors</code> defined for this security profile. If any <code>behaviors</code> are
     * defined in the current invocation, an exception occurs.
     * </p>
     * 
     * @return If true, delete all <code>behaviors</code> defined for this security profile. If any
     *         <code>behaviors</code> are defined in the current invocation, an exception occurs.
     */
    public final Boolean deleteBehaviors() {
        return deleteBehaviors;
    }

    /**
     * <p>
     * If true, delete all <code>alertTargets</code> defined for this security profile. If any <code>alertTargets</code>
     * are defined in the current invocation, an exception occurs.
     * </p>
     * 
     * @return If true, delete all <code>alertTargets</code> defined for this security profile. If any
     *         <code>alertTargets</code> are defined in the current invocation, an exception occurs.
     */
    public final Boolean deleteAlertTargets() {
        return deleteAlertTargets;
    }

    /**
     * <p>
     * If true, delete all <code>additionalMetricsToRetain</code> defined for this security profile. If any
     * <code>additionalMetricsToRetain</code> are defined in the current invocation, an exception occurs.
     * </p>
     * 
     * @return If true, delete all <code>additionalMetricsToRetain</code> defined for this security profile. If any
     *         <code>additionalMetricsToRetain</code> are defined in the current invocation, an exception occurs.
     */
    public final Boolean deleteAdditionalMetricsToRetain() {
        return deleteAdditionalMetricsToRetain;
    }

    /**
     * <p>
     * The expected version of the security profile. A new version is generated whenever the security profile is
     * updated. If you specify a value that is different from the actual version, a
     * <code>VersionConflictException</code> is thrown.
     * </p>
     * 
     * @return The expected version of the security profile. A new version is generated whenever the security profile is
     *         updated. If you specify a value that is different from the actual version, a
     *         <code>VersionConflictException</code> is thrown.
     */
    public final Long expectedVersion() {
        return expectedVersion;
    }

    /**
     * <p>
     * Specifies the MQTT topic and role ARN required for metric export.
     * </p>
     * 
     * @return Specifies the MQTT topic and role ARN required for metric export.
     */
    public final MetricsExportConfig metricsExportConfig() {
        return metricsExportConfig;
    }

    /**
     * <p>
     * Set the value as true to delete metrics export related configurations.
     * </p>
     * 
     * @return Set the value as true to delete metrics export related configurations.
     */
    public final Boolean deleteMetricsExportConfig() {
        return deleteMetricsExportConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(securityProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(securityProfileDescription());
        hashCode = 31 * hashCode + Objects.hashCode(hasBehaviors() ? behaviors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAlertTargets() ? alertTargetsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalMetricsToRetain() ? additionalMetricsToRetain() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalMetricsToRetainV2() ? additionalMetricsToRetainV2() : null);
        hashCode = 31 * hashCode + Objects.hashCode(deleteBehaviors());
        hashCode = 31 * hashCode + Objects.hashCode(deleteAlertTargets());
        hashCode = 31 * hashCode + Objects.hashCode(deleteAdditionalMetricsToRetain());
        hashCode = 31 * hashCode + Objects.hashCode(expectedVersion());
        hashCode = 31 * hashCode + Objects.hashCode(metricsExportConfig());
        hashCode = 31 * hashCode + Objects.hashCode(deleteMetricsExportConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSecurityProfileRequest)) {
            return false;
        }
        UpdateSecurityProfileRequest other = (UpdateSecurityProfileRequest) obj;
        return Objects.equals(securityProfileName(), other.securityProfileName())
                && Objects.equals(securityProfileDescription(), other.securityProfileDescription())
                && hasBehaviors() == other.hasBehaviors() && Objects.equals(behaviors(), other.behaviors())
                && hasAlertTargets() == other.hasAlertTargets()
                && Objects.equals(alertTargetsAsStrings(), other.alertTargetsAsStrings())
                && hasAdditionalMetricsToRetain() == other.hasAdditionalMetricsToRetain()
                && Objects.equals(additionalMetricsToRetain(), other.additionalMetricsToRetain())
                && hasAdditionalMetricsToRetainV2() == other.hasAdditionalMetricsToRetainV2()
                && Objects.equals(additionalMetricsToRetainV2(), other.additionalMetricsToRetainV2())
                && Objects.equals(deleteBehaviors(), other.deleteBehaviors())
                && Objects.equals(deleteAlertTargets(), other.deleteAlertTargets())
                && Objects.equals(deleteAdditionalMetricsToRetain(), other.deleteAdditionalMetricsToRetain())
                && Objects.equals(expectedVersion(), other.expectedVersion())
                && Objects.equals(metricsExportConfig(), other.metricsExportConfig())
                && Objects.equals(deleteMetricsExportConfig(), other.deleteMetricsExportConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSecurityProfileRequest").add("SecurityProfileName", securityProfileName())
                .add("SecurityProfileDescription", securityProfileDescription())
                .add("Behaviors", hasBehaviors() ? behaviors() : null)
                .add("AlertTargets", hasAlertTargets() ? alertTargetsAsStrings() : null)
                .add("AdditionalMetricsToRetain", hasAdditionalMetricsToRetain() ? additionalMetricsToRetain() : null)
                .add("AdditionalMetricsToRetainV2", hasAdditionalMetricsToRetainV2() ? additionalMetricsToRetainV2() : null)
                .add("DeleteBehaviors", deleteBehaviors()).add("DeleteAlertTargets", deleteAlertTargets())
                .add("DeleteAdditionalMetricsToRetain", deleteAdditionalMetricsToRetain())
                .add("ExpectedVersion", expectedVersion()).add("MetricsExportConfig", metricsExportConfig())
                .add("DeleteMetricsExportConfig", deleteMetricsExportConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "securityProfileName":
            return Optional.ofNullable(clazz.cast(securityProfileName()));
        case "securityProfileDescription":
            return Optional.ofNullable(clazz.cast(securityProfileDescription()));
        case "behaviors":
            return Optional.ofNullable(clazz.cast(behaviors()));
        case "alertTargets":
            return Optional.ofNullable(clazz.cast(alertTargetsAsStrings()));
        case "additionalMetricsToRetain":
            return Optional.ofNullable(clazz.cast(additionalMetricsToRetain()));
        case "additionalMetricsToRetainV2":
            return Optional.ofNullable(clazz.cast(additionalMetricsToRetainV2()));
        case "deleteBehaviors":
            return Optional.ofNullable(clazz.cast(deleteBehaviors()));
        case "deleteAlertTargets":
            return Optional.ofNullable(clazz.cast(deleteAlertTargets()));
        case "deleteAdditionalMetricsToRetain":
            return Optional.ofNullable(clazz.cast(deleteAdditionalMetricsToRetain()));
        case "expectedVersion":
            return Optional.ofNullable(clazz.cast(expectedVersion()));
        case "metricsExportConfig":
            return Optional.ofNullable(clazz.cast(metricsExportConfig()));
        case "deleteMetricsExportConfig":
            return Optional.ofNullable(clazz.cast(deleteMetricsExportConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("securityProfileName", SECURITY_PROFILE_NAME_FIELD);
        map.put("securityProfileDescription", SECURITY_PROFILE_DESCRIPTION_FIELD);
        map.put("behaviors", BEHAVIORS_FIELD);
        map.put("alertTargets", ALERT_TARGETS_FIELD);
        map.put("additionalMetricsToRetain", ADDITIONAL_METRICS_TO_RETAIN_FIELD);
        map.put("additionalMetricsToRetainV2", ADDITIONAL_METRICS_TO_RETAIN_V2_FIELD);
        map.put("deleteBehaviors", DELETE_BEHAVIORS_FIELD);
        map.put("deleteAlertTargets", DELETE_ALERT_TARGETS_FIELD);
        map.put("deleteAdditionalMetricsToRetain", DELETE_ADDITIONAL_METRICS_TO_RETAIN_FIELD);
        map.put("expectedVersion", EXPECTED_VERSION_FIELD);
        map.put("metricsExportConfig", METRICS_EXPORT_CONFIG_FIELD);
        map.put("deleteMetricsExportConfig", DELETE_METRICS_EXPORT_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSecurityProfileRequest, T> g) {
        return obj -> g.apply((UpdateSecurityProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSecurityProfileRequest> {
        /**
         * <p>
         * The name of the security profile you want to update.
         * </p>
         * 
         * @param securityProfileName
         *        The name of the security profile you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileName(String securityProfileName);

        /**
         * <p>
         * A description of the security profile.
         * </p>
         * 
         * @param securityProfileDescription
         *        A description of the security profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileDescription(String securityProfileDescription);

        /**
         * <p>
         * Specifies the behaviors that, when violated by a device (thing), cause an alert.
         * </p>
         * 
         * @param behaviors
         *        Specifies the behaviors that, when violated by a device (thing), cause an alert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder behaviors(Collection<Behavior> behaviors);

        /**
         * <p>
         * Specifies the behaviors that, when violated by a device (thing), cause an alert.
         * </p>
         * 
         * @param behaviors
         *        Specifies the behaviors that, when violated by a device (thing), cause an alert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder behaviors(Behavior... behaviors);

        /**
         * <p>
         * Specifies the behaviors that, when violated by a device (thing), cause an alert.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iot.model.Behavior.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.iot.model.Behavior#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iot.model.Behavior.Builder#build()} is called immediately and its
         * result is passed to {@link #behaviors(List<Behavior>)}.
         * 
         * @param behaviors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iot.model.Behavior.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #behaviors(java.util.Collection<Behavior>)
         */
        Builder behaviors(Consumer<Behavior.Builder>... behaviors);

        /**
         * <p>
         * Where the alerts are sent. (Alerts are always sent to the console.)
         * </p>
         * 
         * @param alertTargets
         *        Where the alerts are sent. (Alerts are always sent to the console.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alertTargetsWithStrings(Map<String, AlertTarget> alertTargets);

        /**
         * <p>
         * Where the alerts are sent. (Alerts are always sent to the console.)
         * </p>
         * 
         * @param alertTargets
         *        Where the alerts are sent. (Alerts are always sent to the console.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alertTargets(Map<AlertTargetType, AlertTarget> alertTargets);

        /**
         * <p>
         * <i>Please use <a>UpdateSecurityProfileRequest$additionalMetricsToRetainV2</a> instead.</i>
         * </p>
         * <p>
         * A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the
         * profile's <code>behaviors</code>, but it is also retained for any metric specified here. Can be used with
         * custom metrics; cannot be used with dimensions.
         * </p>
         * 
         * @param additionalMetricsToRetain
         *        <i>Please use <a>UpdateSecurityProfileRequest$additionalMetricsToRetainV2</a> instead.</i> </p>
         *        <p>
         *        A list of metrics whose data is retained (stored). By default, data is retained for any metric used in
         *        the profile's <code>behaviors</code>, but it is also retained for any metric specified here. Can be
         *        used with custom metrics; cannot be used with dimensions.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated Use additionalMetricsToRetainV2.
         */
        @Deprecated
        Builder additionalMetricsToRetain(Collection<String> additionalMetricsToRetain);

        /**
         * <p>
         * <i>Please use <a>UpdateSecurityProfileRequest$additionalMetricsToRetainV2</a> instead.</i>
         * </p>
         * <p>
         * A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the
         * profile's <code>behaviors</code>, but it is also retained for any metric specified here. Can be used with
         * custom metrics; cannot be used with dimensions.
         * </p>
         * 
         * @param additionalMetricsToRetain
         *        <i>Please use <a>UpdateSecurityProfileRequest$additionalMetricsToRetainV2</a> instead.</i> </p>
         *        <p>
         *        A list of metrics whose data is retained (stored). By default, data is retained for any metric used in
         *        the profile's <code>behaviors</code>, but it is also retained for any metric specified here. Can be
         *        used with custom metrics; cannot be used with dimensions.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated Use additionalMetricsToRetainV2.
         */
        @Deprecated
        Builder additionalMetricsToRetain(String... additionalMetricsToRetain);

        /**
         * <p>
         * A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the
         * profile's behaviors, but it is also retained for any metric specified here. Can be used with custom metrics;
         * cannot be used with dimensions.
         * </p>
         * 
         * @param additionalMetricsToRetainV2
         *        A list of metrics whose data is retained (stored). By default, data is retained for any metric used in
         *        the profile's behaviors, but it is also retained for any metric specified here. Can be used with
         *        custom metrics; cannot be used with dimensions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalMetricsToRetainV2(Collection<MetricToRetain> additionalMetricsToRetainV2);

        /**
         * <p>
         * A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the
         * profile's behaviors, but it is also retained for any metric specified here. Can be used with custom metrics;
         * cannot be used with dimensions.
         * </p>
         * 
         * @param additionalMetricsToRetainV2
         *        A list of metrics whose data is retained (stored). By default, data is retained for any metric used in
         *        the profile's behaviors, but it is also retained for any metric specified here. Can be used with
         *        custom metrics; cannot be used with dimensions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalMetricsToRetainV2(MetricToRetain... additionalMetricsToRetainV2);

        /**
         * <p>
         * A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the
         * profile's behaviors, but it is also retained for any metric specified here. Can be used with custom metrics;
         * cannot be used with dimensions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iot.model.MetricToRetain.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iot.model.MetricToRetain#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iot.model.MetricToRetain.Builder#build()} is called immediately and
         * its result is passed to {@link #additionalMetricsToRetainV2(List<MetricToRetain>)}.
         * 
         * @param additionalMetricsToRetainV2
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iot.model.MetricToRetain.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalMetricsToRetainV2(java.util.Collection<MetricToRetain>)
         */
        Builder additionalMetricsToRetainV2(Consumer<MetricToRetain.Builder>... additionalMetricsToRetainV2);

        /**
         * <p>
         * If true, delete all <code>behaviors</code> defined for this security profile. If any <code>behaviors</code>
         * are defined in the current invocation, an exception occurs.
         * </p>
         * 
         * @param deleteBehaviors
         *        If true, delete all <code>behaviors</code> defined for this security profile. If any
         *        <code>behaviors</code> are defined in the current invocation, an exception occurs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteBehaviors(Boolean deleteBehaviors);

        /**
         * <p>
         * If true, delete all <code>alertTargets</code> defined for this security profile. If any
         * <code>alertTargets</code> are defined in the current invocation, an exception occurs.
         * </p>
         * 
         * @param deleteAlertTargets
         *        If true, delete all <code>alertTargets</code> defined for this security profile. If any
         *        <code>alertTargets</code> are defined in the current invocation, an exception occurs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteAlertTargets(Boolean deleteAlertTargets);

        /**
         * <p>
         * If true, delete all <code>additionalMetricsToRetain</code> defined for this security profile. If any
         * <code>additionalMetricsToRetain</code> are defined in the current invocation, an exception occurs.
         * </p>
         * 
         * @param deleteAdditionalMetricsToRetain
         *        If true, delete all <code>additionalMetricsToRetain</code> defined for this security profile. If any
         *        <code>additionalMetricsToRetain</code> are defined in the current invocation, an exception occurs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteAdditionalMetricsToRetain(Boolean deleteAdditionalMetricsToRetain);

        /**
         * <p>
         * The expected version of the security profile. A new version is generated whenever the security profile is
         * updated. If you specify a value that is different from the actual version, a
         * <code>VersionConflictException</code> is thrown.
         * </p>
         * 
         * @param expectedVersion
         *        The expected version of the security profile. A new version is generated whenever the security profile
         *        is updated. If you specify a value that is different from the actual version, a
         *        <code>VersionConflictException</code> is thrown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedVersion(Long expectedVersion);

        /**
         * <p>
         * Specifies the MQTT topic and role ARN required for metric export.
         * </p>
         * 
         * @param metricsExportConfig
         *        Specifies the MQTT topic and role ARN required for metric export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricsExportConfig(MetricsExportConfig metricsExportConfig);

        /**
         * <p>
         * Specifies the MQTT topic and role ARN required for metric export.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetricsExportConfig.Builder} avoiding the
         * need to create one manually via {@link MetricsExportConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetricsExportConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #metricsExportConfig(MetricsExportConfig)}.
         * 
         * @param metricsExportConfig
         *        a consumer that will call methods on {@link MetricsExportConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricsExportConfig(MetricsExportConfig)
         */
        default Builder metricsExportConfig(Consumer<MetricsExportConfig.Builder> metricsExportConfig) {
            return metricsExportConfig(MetricsExportConfig.builder().applyMutation(metricsExportConfig).build());
        }

        /**
         * <p>
         * Set the value as true to delete metrics export related configurations.
         * </p>
         * 
         * @param deleteMetricsExportConfig
         *        Set the value as true to delete metrics export related configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteMetricsExportConfig(Boolean deleteMetricsExportConfig);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String securityProfileName;

        private String securityProfileDescription;

        private List<Behavior> behaviors = DefaultSdkAutoConstructList.getInstance();

        private Map<String, AlertTarget> alertTargets = DefaultSdkAutoConstructMap.getInstance();

        private List<String> additionalMetricsToRetain = DefaultSdkAutoConstructList.getInstance();

        private List<MetricToRetain> additionalMetricsToRetainV2 = DefaultSdkAutoConstructList.getInstance();

        private Boolean deleteBehaviors;

        private Boolean deleteAlertTargets;

        private Boolean deleteAdditionalMetricsToRetain;

        private Long expectedVersion;

        private MetricsExportConfig metricsExportConfig;

        private Boolean deleteMetricsExportConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSecurityProfileRequest model) {
            super(model);
            securityProfileName(model.securityProfileName);
            securityProfileDescription(model.securityProfileDescription);
            behaviors(model.behaviors);
            alertTargetsWithStrings(model.alertTargets);
            additionalMetricsToRetain(model.additionalMetricsToRetain);
            additionalMetricsToRetainV2(model.additionalMetricsToRetainV2);
            deleteBehaviors(model.deleteBehaviors);
            deleteAlertTargets(model.deleteAlertTargets);
            deleteAdditionalMetricsToRetain(model.deleteAdditionalMetricsToRetain);
            expectedVersion(model.expectedVersion);
            metricsExportConfig(model.metricsExportConfig);
            deleteMetricsExportConfig(model.deleteMetricsExportConfig);
        }

        public final String getSecurityProfileName() {
            return securityProfileName;
        }

        public final void setSecurityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
        }

        @Override
        public final Builder securityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
            return this;
        }

        public final String getSecurityProfileDescription() {
            return securityProfileDescription;
        }

        public final void setSecurityProfileDescription(String securityProfileDescription) {
            this.securityProfileDescription = securityProfileDescription;
        }

        @Override
        public final Builder securityProfileDescription(String securityProfileDescription) {
            this.securityProfileDescription = securityProfileDescription;
            return this;
        }

        public final List<Behavior.Builder> getBehaviors() {
            List<Behavior.Builder> result = BehaviorsCopier.copyToBuilder(this.behaviors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBehaviors(Collection<Behavior.BuilderImpl> behaviors) {
            this.behaviors = BehaviorsCopier.copyFromBuilder(behaviors);
        }

        @Override
        public final Builder behaviors(Collection<Behavior> behaviors) {
            this.behaviors = BehaviorsCopier.copy(behaviors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder behaviors(Behavior... behaviors) {
            behaviors(Arrays.asList(behaviors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder behaviors(Consumer<Behavior.Builder>... behaviors) {
            behaviors(Stream.of(behaviors).map(c -> Behavior.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, AlertTarget.Builder> getAlertTargets() {
            Map<String, AlertTarget.Builder> result = AlertTargetsCopier.copyToBuilder(this.alertTargets);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAlertTargets(Map<String, AlertTarget.BuilderImpl> alertTargets) {
            this.alertTargets = AlertTargetsCopier.copyFromBuilder(alertTargets);
        }

        @Override
        public final Builder alertTargetsWithStrings(Map<String, AlertTarget> alertTargets) {
            this.alertTargets = AlertTargetsCopier.copy(alertTargets);
            return this;
        }

        @Override
        public final Builder alertTargets(Map<AlertTargetType, AlertTarget> alertTargets) {
            this.alertTargets = AlertTargetsCopier.copyEnumToString(alertTargets);
            return this;
        }

        @Deprecated
        public final Collection<String> getAdditionalMetricsToRetain() {
            if (additionalMetricsToRetain instanceof SdkAutoConstructList) {
                return null;
            }
            return additionalMetricsToRetain;
        }

        @Deprecated
        public final void setAdditionalMetricsToRetain(Collection<String> additionalMetricsToRetain) {
            this.additionalMetricsToRetain = AdditionalMetricsToRetainListCopier.copy(additionalMetricsToRetain);
        }

        @Override
        @Deprecated
        public final Builder additionalMetricsToRetain(Collection<String> additionalMetricsToRetain) {
            this.additionalMetricsToRetain = AdditionalMetricsToRetainListCopier.copy(additionalMetricsToRetain);
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder additionalMetricsToRetain(String... additionalMetricsToRetain) {
            additionalMetricsToRetain(Arrays.asList(additionalMetricsToRetain));
            return this;
        }

        public final List<MetricToRetain.Builder> getAdditionalMetricsToRetainV2() {
            List<MetricToRetain.Builder> result = AdditionalMetricsToRetainV2ListCopier
                    .copyToBuilder(this.additionalMetricsToRetainV2);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalMetricsToRetainV2(Collection<MetricToRetain.BuilderImpl> additionalMetricsToRetainV2) {
            this.additionalMetricsToRetainV2 = AdditionalMetricsToRetainV2ListCopier.copyFromBuilder(additionalMetricsToRetainV2);
        }

        @Override
        public final Builder additionalMetricsToRetainV2(Collection<MetricToRetain> additionalMetricsToRetainV2) {
            this.additionalMetricsToRetainV2 = AdditionalMetricsToRetainV2ListCopier.copy(additionalMetricsToRetainV2);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalMetricsToRetainV2(MetricToRetain... additionalMetricsToRetainV2) {
            additionalMetricsToRetainV2(Arrays.asList(additionalMetricsToRetainV2));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalMetricsToRetainV2(Consumer<MetricToRetain.Builder>... additionalMetricsToRetainV2) {
            additionalMetricsToRetainV2(Stream.of(additionalMetricsToRetainV2)
                    .map(c -> MetricToRetain.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDeleteBehaviors() {
            return deleteBehaviors;
        }

        public final void setDeleteBehaviors(Boolean deleteBehaviors) {
            this.deleteBehaviors = deleteBehaviors;
        }

        @Override
        public final Builder deleteBehaviors(Boolean deleteBehaviors) {
            this.deleteBehaviors = deleteBehaviors;
            return this;
        }

        public final Boolean getDeleteAlertTargets() {
            return deleteAlertTargets;
        }

        public final void setDeleteAlertTargets(Boolean deleteAlertTargets) {
            this.deleteAlertTargets = deleteAlertTargets;
        }

        @Override
        public final Builder deleteAlertTargets(Boolean deleteAlertTargets) {
            this.deleteAlertTargets = deleteAlertTargets;
            return this;
        }

        public final Boolean getDeleteAdditionalMetricsToRetain() {
            return deleteAdditionalMetricsToRetain;
        }

        public final void setDeleteAdditionalMetricsToRetain(Boolean deleteAdditionalMetricsToRetain) {
            this.deleteAdditionalMetricsToRetain = deleteAdditionalMetricsToRetain;
        }

        @Override
        public final Builder deleteAdditionalMetricsToRetain(Boolean deleteAdditionalMetricsToRetain) {
            this.deleteAdditionalMetricsToRetain = deleteAdditionalMetricsToRetain;
            return this;
        }

        public final Long getExpectedVersion() {
            return expectedVersion;
        }

        public final void setExpectedVersion(Long expectedVersion) {
            this.expectedVersion = expectedVersion;
        }

        @Override
        public final Builder expectedVersion(Long expectedVersion) {
            this.expectedVersion = expectedVersion;
            return this;
        }

        public final MetricsExportConfig.Builder getMetricsExportConfig() {
            return metricsExportConfig != null ? metricsExportConfig.toBuilder() : null;
        }

        public final void setMetricsExportConfig(MetricsExportConfig.BuilderImpl metricsExportConfig) {
            this.metricsExportConfig = metricsExportConfig != null ? metricsExportConfig.build() : null;
        }

        @Override
        public final Builder metricsExportConfig(MetricsExportConfig metricsExportConfig) {
            this.metricsExportConfig = metricsExportConfig;
            return this;
        }

        public final Boolean getDeleteMetricsExportConfig() {
            return deleteMetricsExportConfig;
        }

        public final void setDeleteMetricsExportConfig(Boolean deleteMetricsExportConfig) {
            this.deleteMetricsExportConfig = deleteMetricsExportConfig;
        }

        @Override
        public final Builder deleteMetricsExportConfig(Boolean deleteMetricsExportConfig) {
            this.deleteMetricsExportConfig = deleteMetricsExportConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSecurityProfileRequest build() {
            return new UpdateSecurityProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
