/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateThingGroupRequest extends IotRequest implements
        ToCopyableBuilder<UpdateThingGroupRequest.Builder, UpdateThingGroupRequest> {
    private static final SdkField<String> THING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingGroupName").getter(getter(UpdateThingGroupRequest::thingGroupName))
            .setter(setter(Builder::thingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("thingGroupName").build()).build();

    private static final SdkField<ThingGroupProperties> THING_GROUP_PROPERTIES_FIELD = SdkField
            .<ThingGroupProperties> builder(MarshallingType.SDK_POJO).memberName("thingGroupProperties")
            .getter(getter(UpdateThingGroupRequest::thingGroupProperties)).setter(setter(Builder::thingGroupProperties))
            .constructor(ThingGroupProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupProperties").build())
            .build();

    private static final SdkField<Long> EXPECTED_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("expectedVersion").getter(getter(UpdateThingGroupRequest::expectedVersion))
            .setter(setter(Builder::expectedVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_GROUP_NAME_FIELD,
            THING_GROUP_PROPERTIES_FIELD, EXPECTED_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String thingGroupName;

    private final ThingGroupProperties thingGroupProperties;

    private final Long expectedVersion;

    private UpdateThingGroupRequest(BuilderImpl builder) {
        super(builder);
        this.thingGroupName = builder.thingGroupName;
        this.thingGroupProperties = builder.thingGroupProperties;
        this.expectedVersion = builder.expectedVersion;
    }

    /**
     * <p>
     * The thing group to update.
     * </p>
     * 
     * @return The thing group to update.
     */
    public final String thingGroupName() {
        return thingGroupName;
    }

    /**
     * <p>
     * The thing group properties.
     * </p>
     * 
     * @return The thing group properties.
     */
    public final ThingGroupProperties thingGroupProperties() {
        return thingGroupProperties;
    }

    /**
     * <p>
     * The expected version of the thing group. If this does not match the version of the thing group being updated, the
     * update will fail.
     * </p>
     * 
     * @return The expected version of the thing group. If this does not match the version of the thing group being
     *         updated, the update will fail.
     */
    public final Long expectedVersion() {
        return expectedVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(thingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(thingGroupProperties());
        hashCode = 31 * hashCode + Objects.hashCode(expectedVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateThingGroupRequest)) {
            return false;
        }
        UpdateThingGroupRequest other = (UpdateThingGroupRequest) obj;
        return Objects.equals(thingGroupName(), other.thingGroupName())
                && Objects.equals(thingGroupProperties(), other.thingGroupProperties())
                && Objects.equals(expectedVersion(), other.expectedVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateThingGroupRequest").add("ThingGroupName", thingGroupName())
                .add("ThingGroupProperties", thingGroupProperties()).add("ExpectedVersion", expectedVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingGroupName":
            return Optional.ofNullable(clazz.cast(thingGroupName()));
        case "thingGroupProperties":
            return Optional.ofNullable(clazz.cast(thingGroupProperties()));
        case "expectedVersion":
            return Optional.ofNullable(clazz.cast(expectedVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("thingGroupName", THING_GROUP_NAME_FIELD);
        map.put("thingGroupProperties", THING_GROUP_PROPERTIES_FIELD);
        map.put("expectedVersion", EXPECTED_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateThingGroupRequest, T> g) {
        return obj -> g.apply((UpdateThingGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateThingGroupRequest> {
        /**
         * <p>
         * The thing group to update.
         * </p>
         * 
         * @param thingGroupName
         *        The thing group to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupName(String thingGroupName);

        /**
         * <p>
         * The thing group properties.
         * </p>
         * 
         * @param thingGroupProperties
         *        The thing group properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupProperties(ThingGroupProperties thingGroupProperties);

        /**
         * <p>
         * The thing group properties.
         * </p>
         * This is a convenience method that creates an instance of the {@link ThingGroupProperties.Builder} avoiding
         * the need to create one manually via {@link ThingGroupProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ThingGroupProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #thingGroupProperties(ThingGroupProperties)}.
         * 
         * @param thingGroupProperties
         *        a consumer that will call methods on {@link ThingGroupProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #thingGroupProperties(ThingGroupProperties)
         */
        default Builder thingGroupProperties(Consumer<ThingGroupProperties.Builder> thingGroupProperties) {
            return thingGroupProperties(ThingGroupProperties.builder().applyMutation(thingGroupProperties).build());
        }

        /**
         * <p>
         * The expected version of the thing group. If this does not match the version of the thing group being updated,
         * the update will fail.
         * </p>
         * 
         * @param expectedVersion
         *        The expected version of the thing group. If this does not match the version of the thing group being
         *        updated, the update will fail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedVersion(Long expectedVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String thingGroupName;

        private ThingGroupProperties thingGroupProperties;

        private Long expectedVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateThingGroupRequest model) {
            super(model);
            thingGroupName(model.thingGroupName);
            thingGroupProperties(model.thingGroupProperties);
            expectedVersion(model.expectedVersion);
        }

        public final String getThingGroupName() {
            return thingGroupName;
        }

        public final void setThingGroupName(String thingGroupName) {
            this.thingGroupName = thingGroupName;
        }

        @Override
        public final Builder thingGroupName(String thingGroupName) {
            this.thingGroupName = thingGroupName;
            return this;
        }

        public final ThingGroupProperties.Builder getThingGroupProperties() {
            return thingGroupProperties != null ? thingGroupProperties.toBuilder() : null;
        }

        public final void setThingGroupProperties(ThingGroupProperties.BuilderImpl thingGroupProperties) {
            this.thingGroupProperties = thingGroupProperties != null ? thingGroupProperties.build() : null;
        }

        @Override
        public final Builder thingGroupProperties(ThingGroupProperties thingGroupProperties) {
            this.thingGroupProperties = thingGroupProperties;
            return this;
        }

        public final Long getExpectedVersion() {
            return expectedVersion;
        }

        public final void setExpectedVersion(Long expectedVersion) {
            this.expectedVersion = expectedVersion;
        }

        @Override
        public final Builder expectedVersion(Long expectedVersion) {
            this.expectedVersion = expectedVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateThingGroupRequest build() {
            return new UpdateThingGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
