/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBucketsAggregationResponse extends IotResponse implements
        ToCopyableBuilder<GetBucketsAggregationResponse.Builder, GetBucketsAggregationResponse> {
    private static final SdkField<Integer> TOTAL_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalCount").getter(getter(GetBucketsAggregationResponse::totalCount))
            .setter(setter(Builder::totalCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalCount").build()).build();

    private static final SdkField<List<Bucket>> BUCKETS_FIELD = SdkField
            .<List<Bucket>> builder(MarshallingType.LIST)
            .memberName("buckets")
            .getter(getter(GetBucketsAggregationResponse::buckets))
            .setter(setter(Builder::buckets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buckets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Bucket> builder(MarshallingType.SDK_POJO)
                                            .constructor(Bucket::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_COUNT_FIELD,
            BUCKETS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer totalCount;

    private final List<Bucket> buckets;

    private GetBucketsAggregationResponse(BuilderImpl builder) {
        super(builder);
        this.totalCount = builder.totalCount;
        this.buckets = builder.buckets;
    }

    /**
     * <p>
     * The total number of things that fit the query string criteria.
     * </p>
     * 
     * @return The total number of things that fit the query string criteria.
     */
    public final Integer totalCount() {
        return totalCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the Buckets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBuckets() {
        return buckets != null && !(buckets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The main part of the response with a list of buckets. Each bucket contains a <code>keyValue</code> and a
     * <code>count</code>.
     * </p>
     * <p>
     * <code>keyValue</code>: The aggregation field value counted for the particular bucket.
     * </p>
     * <p>
     * <code>count</code>: The number of documents that have that value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBuckets} method.
     * </p>
     * 
     * @return The main part of the response with a list of buckets. Each bucket contains a <code>keyValue</code> and a
     *         <code>count</code>.</p>
     *         <p>
     *         <code>keyValue</code>: The aggregation field value counted for the particular bucket.
     *         </p>
     *         <p>
     *         <code>count</code>: The number of documents that have that value.
     */
    public final List<Bucket> buckets() {
        return buckets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(totalCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasBuckets() ? buckets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketsAggregationResponse)) {
            return false;
        }
        GetBucketsAggregationResponse other = (GetBucketsAggregationResponse) obj;
        return Objects.equals(totalCount(), other.totalCount()) && hasBuckets() == other.hasBuckets()
                && Objects.equals(buckets(), other.buckets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetBucketsAggregationResponse").add("TotalCount", totalCount())
                .add("Buckets", hasBuckets() ? buckets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "totalCount":
            return Optional.ofNullable(clazz.cast(totalCount()));
        case "buckets":
            return Optional.ofNullable(clazz.cast(buckets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("totalCount", TOTAL_COUNT_FIELD);
        map.put("buckets", BUCKETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetBucketsAggregationResponse, T> g) {
        return obj -> g.apply((GetBucketsAggregationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetBucketsAggregationResponse> {
        /**
         * <p>
         * The total number of things that fit the query string criteria.
         * </p>
         * 
         * @param totalCount
         *        The total number of things that fit the query string criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCount(Integer totalCount);

        /**
         * <p>
         * The main part of the response with a list of buckets. Each bucket contains a <code>keyValue</code> and a
         * <code>count</code>.
         * </p>
         * <p>
         * <code>keyValue</code>: The aggregation field value counted for the particular bucket.
         * </p>
         * <p>
         * <code>count</code>: The number of documents that have that value.
         * </p>
         * 
         * @param buckets
         *        The main part of the response with a list of buckets. Each bucket contains a <code>keyValue</code> and
         *        a <code>count</code>.</p>
         *        <p>
         *        <code>keyValue</code>: The aggregation field value counted for the particular bucket.
         *        </p>
         *        <p>
         *        <code>count</code>: The number of documents that have that value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buckets(Collection<Bucket> buckets);

        /**
         * <p>
         * The main part of the response with a list of buckets. Each bucket contains a <code>keyValue</code> and a
         * <code>count</code>.
         * </p>
         * <p>
         * <code>keyValue</code>: The aggregation field value counted for the particular bucket.
         * </p>
         * <p>
         * <code>count</code>: The number of documents that have that value.
         * </p>
         * 
         * @param buckets
         *        The main part of the response with a list of buckets. Each bucket contains a <code>keyValue</code> and
         *        a <code>count</code>.</p>
         *        <p>
         *        <code>keyValue</code>: The aggregation field value counted for the particular bucket.
         *        </p>
         *        <p>
         *        <code>count</code>: The number of documents that have that value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buckets(Bucket... buckets);

        /**
         * <p>
         * The main part of the response with a list of buckets. Each bucket contains a <code>keyValue</code> and a
         * <code>count</code>.
         * </p>
         * <p>
         * <code>keyValue</code>: The aggregation field value counted for the particular bucket.
         * </p>
         * <p>
         * <code>count</code>: The number of documents that have that value.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iot.model.Bucket.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.iot.model.Bucket#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.iot.model.Bucket.Builder#build()}
         * is called immediately and its result is passed to {@link #buckets(List<Bucket>)}.
         * 
         * @param buckets
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.iot.model.Bucket.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #buckets(java.util.Collection<Bucket>)
         */
        Builder buckets(Consumer<Bucket.Builder>... buckets);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private Integer totalCount;

        private List<Bucket> buckets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketsAggregationResponse model) {
            super(model);
            totalCount(model.totalCount);
            buckets(model.buckets);
        }

        public final Integer getTotalCount() {
            return totalCount;
        }

        public final void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @Override
        public final Builder totalCount(Integer totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public final List<Bucket.Builder> getBuckets() {
            List<Bucket.Builder> result = BucketsCopier.copyToBuilder(this.buckets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBuckets(Collection<Bucket.BuilderImpl> buckets) {
            this.buckets = BucketsCopier.copyFromBuilder(buckets);
        }

        @Override
        public final Builder buckets(Collection<Bucket> buckets) {
            this.buckets = BucketsCopier.copy(buckets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buckets(Bucket... buckets) {
            buckets(Arrays.asList(buckets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buckets(Consumer<Bucket.Builder>... buckets) {
            buckets(Stream.of(buckets).map(c -> Bucket.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetBucketsAggregationResponse build() {
            return new GetBucketsAggregationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
