/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListV2LoggingLevelsResponse extends IotResponse implements
        ToCopyableBuilder<ListV2LoggingLevelsResponse.Builder, ListV2LoggingLevelsResponse> {
    private static final SdkField<List<LogTargetConfiguration>> LOG_TARGET_CONFIGURATIONS_FIELD = SdkField
            .<List<LogTargetConfiguration>> builder(MarshallingType.LIST)
            .memberName("logTargetConfigurations")
            .getter(getter(ListV2LoggingLevelsResponse::logTargetConfigurations))
            .setter(setter(Builder::logTargetConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logTargetConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LogTargetConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(LogTargetConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListV2LoggingLevelsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LOG_TARGET_CONFIGURATIONS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<LogTargetConfiguration> logTargetConfigurations;

    private final String nextToken;

    private ListV2LoggingLevelsResponse(BuilderImpl builder) {
        super(builder);
        this.logTargetConfigurations = builder.logTargetConfigurations;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogTargetConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLogTargetConfigurations() {
        return logTargetConfigurations != null && !(logTargetConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The logging configuration for a target.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogTargetConfigurations} method.
     * </p>
     * 
     * @return The logging configuration for a target.
     */
    public final List<LogTargetConfiguration> logTargetConfigurations() {
        return logTargetConfigurations;
    }

    /**
     * <p>
     * The token to use to get the next set of results, or <b>null</b> if there are no additional results.
     * </p>
     * 
     * @return The token to use to get the next set of results, or <b>null</b> if there are no additional results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLogTargetConfigurations() ? logTargetConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListV2LoggingLevelsResponse)) {
            return false;
        }
        ListV2LoggingLevelsResponse other = (ListV2LoggingLevelsResponse) obj;
        return hasLogTargetConfigurations() == other.hasLogTargetConfigurations()
                && Objects.equals(logTargetConfigurations(), other.logTargetConfigurations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListV2LoggingLevelsResponse")
                .add("LogTargetConfigurations", hasLogTargetConfigurations() ? logTargetConfigurations() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logTargetConfigurations":
            return Optional.ofNullable(clazz.cast(logTargetConfigurations()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("logTargetConfigurations", LOG_TARGET_CONFIGURATIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListV2LoggingLevelsResponse, T> g) {
        return obj -> g.apply((ListV2LoggingLevelsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListV2LoggingLevelsResponse> {
        /**
         * <p>
         * The logging configuration for a target.
         * </p>
         * 
         * @param logTargetConfigurations
         *        The logging configuration for a target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logTargetConfigurations(Collection<LogTargetConfiguration> logTargetConfigurations);

        /**
         * <p>
         * The logging configuration for a target.
         * </p>
         * 
         * @param logTargetConfigurations
         *        The logging configuration for a target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logTargetConfigurations(LogTargetConfiguration... logTargetConfigurations);

        /**
         * <p>
         * The logging configuration for a target.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iot.model.LogTargetConfiguration.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.iot.model.LogTargetConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iot.model.LogTargetConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #logTargetConfigurations(List<LogTargetConfiguration>)}.
         * 
         * @param logTargetConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iot.model.LogTargetConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logTargetConfigurations(java.util.Collection<LogTargetConfiguration>)
         */
        Builder logTargetConfigurations(Consumer<LogTargetConfiguration.Builder>... logTargetConfigurations);

        /**
         * <p>
         * The token to use to get the next set of results, or <b>null</b> if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token to use to get the next set of results, or <b>null</b> if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<LogTargetConfiguration> logTargetConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListV2LoggingLevelsResponse model) {
            super(model);
            logTargetConfigurations(model.logTargetConfigurations);
            nextToken(model.nextToken);
        }

        public final List<LogTargetConfiguration.Builder> getLogTargetConfigurations() {
            List<LogTargetConfiguration.Builder> result = LogTargetConfigurationsCopier
                    .copyToBuilder(this.logTargetConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLogTargetConfigurations(Collection<LogTargetConfiguration.BuilderImpl> logTargetConfigurations) {
            this.logTargetConfigurations = LogTargetConfigurationsCopier.copyFromBuilder(logTargetConfigurations);
        }

        @Override
        public final Builder logTargetConfigurations(Collection<LogTargetConfiguration> logTargetConfigurations) {
            this.logTargetConfigurations = LogTargetConfigurationsCopier.copy(logTargetConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logTargetConfigurations(LogTargetConfiguration... logTargetConfigurations) {
            logTargetConfigurations(Arrays.asList(logTargetConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logTargetConfigurations(Consumer<LogTargetConfiguration.Builder>... logTargetConfigurations) {
            logTargetConfigurations(Stream.of(logTargetConfigurations)
                    .map(c -> LogTargetConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListV2LoggingLevelsResponse build() {
            return new ListV2LoggingLevelsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
