/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CommandPayload
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CommandPayload> {
    private static final SdkField<SdkBytes> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("content").getter(CommandPayload.getter(CommandPayload::content)).setter(CommandPayload.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentType").getter(CommandPayload.getter(CommandPayload::contentType)).setter(CommandPayload.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD, CONTENT_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CommandPayload.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SdkBytes content;
    private final String contentType;

    private CommandPayload(BuilderImpl builder) {
        this.content = builder.content;
        this.contentType = builder.contentType;
    }

    public final SdkBytes content() {
        return this.content;
    }

    public final String contentType() {
        return this.contentType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommandPayload)) {
            return false;
        }
        CommandPayload other = (CommandPayload)obj;
        return Objects.equals(this.content(), other.content()) && Objects.equals(this.contentType(), other.contentType());
    }

    public final String toString() {
        return ToString.builder((String)"CommandPayload").add("Content", (Object)this.content()).add("ContentType", (Object)this.contentType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "contentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("content", CONTENT_FIELD);
        map.put("contentType", CONTENT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CommandPayload, T> g) {
        return obj -> g.apply((CommandPayload)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SdkBytes content;
        private String contentType;

        private BuilderImpl() {
        }

        private BuilderImpl(CommandPayload model) {
            this.content(model.content);
            this.contentType(model.contentType);
        }

        public final ByteBuffer getContent() {
            return this.content == null ? null : this.content.asByteBuffer();
        }

        public final void setContent(ByteBuffer content) {
            this.content(content == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)content));
        }

        @Override
        public final Builder content(SdkBytes content) {
            this.content = content;
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public CommandPayload build() {
            return new CommandPayload(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CommandPayload> {
        public Builder content(SdkBytes var1);

        public Builder contentType(String var1);
    }
}

