/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAccountAuditConfigurationRequest extends IotRequest implements
        ToCopyableBuilder<UpdateAccountAuditConfigurationRequest.Builder, UpdateAccountAuditConfigurationRequest> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(UpdateAccountAuditConfigurationRequest::roleArn))
            .setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<Map<String, AuditNotificationTarget>> AUDIT_NOTIFICATION_TARGET_CONFIGURATIONS_FIELD = SdkField
            .<Map<String, AuditNotificationTarget>> builder(MarshallingType.MAP)
            .memberName("auditNotificationTargetConfigurations")
            .getter(getter(UpdateAccountAuditConfigurationRequest::auditNotificationTargetConfigurationsAsStrings))
            .setter(setter(Builder::auditNotificationTargetConfigurationsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("auditNotificationTargetConfigurations").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AuditNotificationTarget> builder(MarshallingType.SDK_POJO)
                                            .constructor(AuditNotificationTarget::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, AuditCheckConfiguration>> AUDIT_CHECK_CONFIGURATIONS_FIELD = SdkField
            .<Map<String, AuditCheckConfiguration>> builder(MarshallingType.MAP)
            .memberName("auditCheckConfigurations")
            .getter(getter(UpdateAccountAuditConfigurationRequest::auditCheckConfigurations))
            .setter(setter(Builder::auditCheckConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("auditCheckConfigurations").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AuditCheckConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(AuditCheckConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD,
            AUDIT_NOTIFICATION_TARGET_CONFIGURATIONS_FIELD, AUDIT_CHECK_CONFIGURATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String roleArn;

    private final Map<String, AuditNotificationTarget> auditNotificationTargetConfigurations;

    private final Map<String, AuditCheckConfiguration> auditCheckConfigurations;

    private UpdateAccountAuditConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.roleArn = builder.roleArn;
        this.auditNotificationTargetConfigurations = builder.auditNotificationTargetConfigurations;
        this.auditCheckConfigurations = builder.auditCheckConfigurations;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the role that grants permission to IoT to access information about your
     * devices, policies, certificates, and other items as required when performing an audit.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the role that grants permission to IoT to access information about your
     *         devices, policies, certificates, and other items as required when performing an audit.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Information about the targets to which audit notifications are sent.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuditNotificationTargetConfigurations}
     * method.
     * </p>
     * 
     * @return Information about the targets to which audit notifications are sent.
     */
    public final Map<AuditNotificationType, AuditNotificationTarget> auditNotificationTargetConfigurations() {
        return AuditNotificationTargetConfigurationsCopier.copyStringToEnum(auditNotificationTargetConfigurations);
    }

    /**
     * For responses, this returns true if the service returned a value for the AuditNotificationTargetConfigurations
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasAuditNotificationTargetConfigurations() {
        return auditNotificationTargetConfigurations != null
                && !(auditNotificationTargetConfigurations instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Information about the targets to which audit notifications are sent.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuditNotificationTargetConfigurations}
     * method.
     * </p>
     * 
     * @return Information about the targets to which audit notifications are sent.
     */
    public final Map<String, AuditNotificationTarget> auditNotificationTargetConfigurationsAsStrings() {
        return auditNotificationTargetConfigurations;
    }

    /**
     * For responses, this returns true if the service returned a value for the AuditCheckConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAuditCheckConfigurations() {
        return auditCheckConfigurations != null && !(auditCheckConfigurations instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Specifies which audit checks are enabled and disabled for this account. Use
     * <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are currently
     * enabled.
     * </p>
     * <p>
     * Some data collection might start immediately when certain checks are enabled. When a check is disabled, any data
     * collected so far in relation to the check is deleted.
     * </p>
     * <p>
     * You cannot disable a check if it's used by any scheduled audit. You must first delete the check from the
     * scheduled audit or delete the scheduled audit itself.
     * </p>
     * <p>
     * On the first call to <code>UpdateAccountAuditConfiguration</code>, this parameter is required and must specify at
     * least one enabled check.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuditCheckConfigurations} method.
     * </p>
     * 
     * @return Specifies which audit checks are enabled and disabled for this account. Use
     *         <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are
     *         currently enabled.</p>
     *         <p>
     *         Some data collection might start immediately when certain checks are enabled. When a check is disabled,
     *         any data collected so far in relation to the check is deleted.
     *         </p>
     *         <p>
     *         You cannot disable a check if it's used by any scheduled audit. You must first delete the check from the
     *         scheduled audit or delete the scheduled audit itself.
     *         </p>
     *         <p>
     *         On the first call to <code>UpdateAccountAuditConfiguration</code>, this parameter is required and must
     *         specify at least one enabled check.
     */
    public final Map<String, AuditCheckConfiguration> auditCheckConfigurations() {
        return auditCheckConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31
                * hashCode
                + Objects.hashCode(hasAuditNotificationTargetConfigurations() ? auditNotificationTargetConfigurationsAsStrings()
                        : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAuditCheckConfigurations() ? auditCheckConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAccountAuditConfigurationRequest)) {
            return false;
        }
        UpdateAccountAuditConfigurationRequest other = (UpdateAccountAuditConfigurationRequest) obj;
        return Objects.equals(roleArn(), other.roleArn())
                && hasAuditNotificationTargetConfigurations() == other.hasAuditNotificationTargetConfigurations()
                && Objects.equals(auditNotificationTargetConfigurationsAsStrings(),
                        other.auditNotificationTargetConfigurationsAsStrings())
                && hasAuditCheckConfigurations() == other.hasAuditCheckConfigurations()
                && Objects.equals(auditCheckConfigurations(), other.auditCheckConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("UpdateAccountAuditConfigurationRequest")
                .add("RoleArn", roleArn())
                .add("AuditNotificationTargetConfigurations",
                        hasAuditNotificationTargetConfigurations() ? auditNotificationTargetConfigurationsAsStrings() : null)
                .add("AuditCheckConfigurations", hasAuditCheckConfigurations() ? auditCheckConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "auditNotificationTargetConfigurations":
            return Optional.ofNullable(clazz.cast(auditNotificationTargetConfigurationsAsStrings()));
        case "auditCheckConfigurations":
            return Optional.ofNullable(clazz.cast(auditCheckConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("auditNotificationTargetConfigurations", AUDIT_NOTIFICATION_TARGET_CONFIGURATIONS_FIELD);
        map.put("auditCheckConfigurations", AUDIT_CHECK_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAccountAuditConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateAccountAuditConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateAccountAuditConfigurationRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the role that grants permission to IoT to access information about your
         * devices, policies, certificates, and other items as required when performing an audit.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the role that grants permission to IoT to access information about
         *        your devices, policies, certificates, and other items as required when performing an audit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Information about the targets to which audit notifications are sent.
         * </p>
         * 
         * @param auditNotificationTargetConfigurations
         *        Information about the targets to which audit notifications are sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditNotificationTargetConfigurationsWithStrings(
                Map<String, AuditNotificationTarget> auditNotificationTargetConfigurations);

        /**
         * <p>
         * Information about the targets to which audit notifications are sent.
         * </p>
         * 
         * @param auditNotificationTargetConfigurations
         *        Information about the targets to which audit notifications are sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditNotificationTargetConfigurations(
                Map<AuditNotificationType, AuditNotificationTarget> auditNotificationTargetConfigurations);

        /**
         * <p>
         * Specifies which audit checks are enabled and disabled for this account. Use
         * <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are
         * currently enabled.
         * </p>
         * <p>
         * Some data collection might start immediately when certain checks are enabled. When a check is disabled, any
         * data collected so far in relation to the check is deleted.
         * </p>
         * <p>
         * You cannot disable a check if it's used by any scheduled audit. You must first delete the check from the
         * scheduled audit or delete the scheduled audit itself.
         * </p>
         * <p>
         * On the first call to <code>UpdateAccountAuditConfiguration</code>, this parameter is required and must
         * specify at least one enabled check.
         * </p>
         * 
         * @param auditCheckConfigurations
         *        Specifies which audit checks are enabled and disabled for this account. Use
         *        <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are
         *        currently enabled.</p>
         *        <p>
         *        Some data collection might start immediately when certain checks are enabled. When a check is
         *        disabled, any data collected so far in relation to the check is deleted.
         *        </p>
         *        <p>
         *        You cannot disable a check if it's used by any scheduled audit. You must first delete the check from
         *        the scheduled audit or delete the scheduled audit itself.
         *        </p>
         *        <p>
         *        On the first call to <code>UpdateAccountAuditConfiguration</code>, this parameter is required and must
         *        specify at least one enabled check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditCheckConfigurations(Map<String, AuditCheckConfiguration> auditCheckConfigurations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String roleArn;

        private Map<String, AuditNotificationTarget> auditNotificationTargetConfigurations = DefaultSdkAutoConstructMap
                .getInstance();

        private Map<String, AuditCheckConfiguration> auditCheckConfigurations = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAccountAuditConfigurationRequest model) {
            super(model);
            roleArn(model.roleArn);
            auditNotificationTargetConfigurationsWithStrings(model.auditNotificationTargetConfigurations);
            auditCheckConfigurations(model.auditCheckConfigurations);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Map<String, AuditNotificationTarget.Builder> getAuditNotificationTargetConfigurations() {
            Map<String, AuditNotificationTarget.Builder> result = AuditNotificationTargetConfigurationsCopier
                    .copyToBuilder(this.auditNotificationTargetConfigurations);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAuditNotificationTargetConfigurations(
                Map<String, AuditNotificationTarget.BuilderImpl> auditNotificationTargetConfigurations) {
            this.auditNotificationTargetConfigurations = AuditNotificationTargetConfigurationsCopier
                    .copyFromBuilder(auditNotificationTargetConfigurations);
        }

        @Override
        public final Builder auditNotificationTargetConfigurationsWithStrings(
                Map<String, AuditNotificationTarget> auditNotificationTargetConfigurations) {
            this.auditNotificationTargetConfigurations = AuditNotificationTargetConfigurationsCopier
                    .copy(auditNotificationTargetConfigurations);
            return this;
        }

        @Override
        public final Builder auditNotificationTargetConfigurations(
                Map<AuditNotificationType, AuditNotificationTarget> auditNotificationTargetConfigurations) {
            this.auditNotificationTargetConfigurations = AuditNotificationTargetConfigurationsCopier
                    .copyEnumToString(auditNotificationTargetConfigurations);
            return this;
        }

        public final Map<String, AuditCheckConfiguration.Builder> getAuditCheckConfigurations() {
            Map<String, AuditCheckConfiguration.Builder> result = AuditCheckConfigurationsCopier
                    .copyToBuilder(this.auditCheckConfigurations);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAuditCheckConfigurations(Map<String, AuditCheckConfiguration.BuilderImpl> auditCheckConfigurations) {
            this.auditCheckConfigurations = AuditCheckConfigurationsCopier.copyFromBuilder(auditCheckConfigurations);
        }

        @Override
        public final Builder auditCheckConfigurations(Map<String, AuditCheckConfiguration> auditCheckConfigurations) {
            this.auditCheckConfigurations = AuditCheckConfigurationsCopier.copy(auditCheckConfigurations);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAccountAuditConfigurationRequest build() {
            return new UpdateAccountAuditConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
