/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateOtaUpdateResponse extends IotResponse implements
        ToCopyableBuilder<CreateOtaUpdateResponse.Builder, CreateOtaUpdateResponse> {
    private static final SdkField<String> OTA_UPDATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("otaUpdateId").getter(getter(CreateOtaUpdateResponse::otaUpdateId)).setter(setter(Builder::otaUpdateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("otaUpdateId").build()).build();

    private static final SdkField<String> AWS_IOT_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsIotJobId").getter(getter(CreateOtaUpdateResponse::awsIotJobId)).setter(setter(Builder::awsIotJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsIotJobId").build()).build();

    private static final SdkField<String> OTA_UPDATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("otaUpdateArn").getter(getter(CreateOtaUpdateResponse::otaUpdateArn))
            .setter(setter(Builder::otaUpdateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("otaUpdateArn").build()).build();

    private static final SdkField<String> AWS_IOT_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsIotJobArn").getter(getter(CreateOtaUpdateResponse::awsIotJobArn))
            .setter(setter(Builder::awsIotJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsIotJobArn").build()).build();

    private static final SdkField<String> OTA_UPDATE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("otaUpdateStatus").getter(getter(CreateOtaUpdateResponse::otaUpdateStatusAsString))
            .setter(setter(Builder::otaUpdateStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("otaUpdateStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OTA_UPDATE_ID_FIELD,
            AWS_IOT_JOB_ID_FIELD, OTA_UPDATE_ARN_FIELD, AWS_IOT_JOB_ARN_FIELD, OTA_UPDATE_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String otaUpdateId;

    private final String awsIotJobId;

    private final String otaUpdateArn;

    private final String awsIotJobArn;

    private final String otaUpdateStatus;

    private CreateOtaUpdateResponse(BuilderImpl builder) {
        super(builder);
        this.otaUpdateId = builder.otaUpdateId;
        this.awsIotJobId = builder.awsIotJobId;
        this.otaUpdateArn = builder.otaUpdateArn;
        this.awsIotJobArn = builder.awsIotJobArn;
        this.otaUpdateStatus = builder.otaUpdateStatus;
    }

    /**
     * <p>
     * The OTA update ID.
     * </p>
     * 
     * @return The OTA update ID.
     */
    public final String otaUpdateId() {
        return otaUpdateId;
    }

    /**
     * <p>
     * The IoT job ID associated with the OTA update.
     * </p>
     * 
     * @return The IoT job ID associated with the OTA update.
     */
    public final String awsIotJobId() {
        return awsIotJobId;
    }

    /**
     * <p>
     * The OTA update ARN.
     * </p>
     * 
     * @return The OTA update ARN.
     */
    public final String otaUpdateArn() {
        return otaUpdateArn;
    }

    /**
     * <p>
     * The IoT job ARN associated with the OTA update.
     * </p>
     * 
     * @return The IoT job ARN associated with the OTA update.
     */
    public final String awsIotJobArn() {
        return awsIotJobArn;
    }

    /**
     * <p>
     * The OTA update status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #otaUpdateStatus}
     * will return {@link OTAUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #otaUpdateStatusAsString}.
     * </p>
     * 
     * @return The OTA update status.
     * @see OTAUpdateStatus
     */
    public final OTAUpdateStatus otaUpdateStatus() {
        return OTAUpdateStatus.fromValue(otaUpdateStatus);
    }

    /**
     * <p>
     * The OTA update status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #otaUpdateStatus}
     * will return {@link OTAUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #otaUpdateStatusAsString}.
     * </p>
     * 
     * @return The OTA update status.
     * @see OTAUpdateStatus
     */
    public final String otaUpdateStatusAsString() {
        return otaUpdateStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(otaUpdateId());
        hashCode = 31 * hashCode + Objects.hashCode(awsIotJobId());
        hashCode = 31 * hashCode + Objects.hashCode(otaUpdateArn());
        hashCode = 31 * hashCode + Objects.hashCode(awsIotJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(otaUpdateStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOtaUpdateResponse)) {
            return false;
        }
        CreateOtaUpdateResponse other = (CreateOtaUpdateResponse) obj;
        return Objects.equals(otaUpdateId(), other.otaUpdateId()) && Objects.equals(awsIotJobId(), other.awsIotJobId())
                && Objects.equals(otaUpdateArn(), other.otaUpdateArn()) && Objects.equals(awsIotJobArn(), other.awsIotJobArn())
                && Objects.equals(otaUpdateStatusAsString(), other.otaUpdateStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateOtaUpdateResponse").add("OtaUpdateId", otaUpdateId()).add("AwsIotJobId", awsIotJobId())
                .add("OtaUpdateArn", otaUpdateArn()).add("AwsIotJobArn", awsIotJobArn())
                .add("OtaUpdateStatus", otaUpdateStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "otaUpdateId":
            return Optional.ofNullable(clazz.cast(otaUpdateId()));
        case "awsIotJobId":
            return Optional.ofNullable(clazz.cast(awsIotJobId()));
        case "otaUpdateArn":
            return Optional.ofNullable(clazz.cast(otaUpdateArn()));
        case "awsIotJobArn":
            return Optional.ofNullable(clazz.cast(awsIotJobArn()));
        case "otaUpdateStatus":
            return Optional.ofNullable(clazz.cast(otaUpdateStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("otaUpdateId", OTA_UPDATE_ID_FIELD);
        map.put("awsIotJobId", AWS_IOT_JOB_ID_FIELD);
        map.put("otaUpdateArn", OTA_UPDATE_ARN_FIELD);
        map.put("awsIotJobArn", AWS_IOT_JOB_ARN_FIELD);
        map.put("otaUpdateStatus", OTA_UPDATE_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateOtaUpdateResponse, T> g) {
        return obj -> g.apply((CreateOtaUpdateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateOtaUpdateResponse> {
        /**
         * <p>
         * The OTA update ID.
         * </p>
         * 
         * @param otaUpdateId
         *        The OTA update ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otaUpdateId(String otaUpdateId);

        /**
         * <p>
         * The IoT job ID associated with the OTA update.
         * </p>
         * 
         * @param awsIotJobId
         *        The IoT job ID associated with the OTA update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsIotJobId(String awsIotJobId);

        /**
         * <p>
         * The OTA update ARN.
         * </p>
         * 
         * @param otaUpdateArn
         *        The OTA update ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otaUpdateArn(String otaUpdateArn);

        /**
         * <p>
         * The IoT job ARN associated with the OTA update.
         * </p>
         * 
         * @param awsIotJobArn
         *        The IoT job ARN associated with the OTA update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsIotJobArn(String awsIotJobArn);

        /**
         * <p>
         * The OTA update status.
         * </p>
         * 
         * @param otaUpdateStatus
         *        The OTA update status.
         * @see OTAUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OTAUpdateStatus
         */
        Builder otaUpdateStatus(String otaUpdateStatus);

        /**
         * <p>
         * The OTA update status.
         * </p>
         * 
         * @param otaUpdateStatus
         *        The OTA update status.
         * @see OTAUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OTAUpdateStatus
         */
        Builder otaUpdateStatus(OTAUpdateStatus otaUpdateStatus);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String otaUpdateId;

        private String awsIotJobId;

        private String otaUpdateArn;

        private String awsIotJobArn;

        private String otaUpdateStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOtaUpdateResponse model) {
            super(model);
            otaUpdateId(model.otaUpdateId);
            awsIotJobId(model.awsIotJobId);
            otaUpdateArn(model.otaUpdateArn);
            awsIotJobArn(model.awsIotJobArn);
            otaUpdateStatus(model.otaUpdateStatus);
        }

        public final String getOtaUpdateId() {
            return otaUpdateId;
        }

        public final void setOtaUpdateId(String otaUpdateId) {
            this.otaUpdateId = otaUpdateId;
        }

        @Override
        public final Builder otaUpdateId(String otaUpdateId) {
            this.otaUpdateId = otaUpdateId;
            return this;
        }

        public final String getAwsIotJobId() {
            return awsIotJobId;
        }

        public final void setAwsIotJobId(String awsIotJobId) {
            this.awsIotJobId = awsIotJobId;
        }

        @Override
        public final Builder awsIotJobId(String awsIotJobId) {
            this.awsIotJobId = awsIotJobId;
            return this;
        }

        public final String getOtaUpdateArn() {
            return otaUpdateArn;
        }

        public final void setOtaUpdateArn(String otaUpdateArn) {
            this.otaUpdateArn = otaUpdateArn;
        }

        @Override
        public final Builder otaUpdateArn(String otaUpdateArn) {
            this.otaUpdateArn = otaUpdateArn;
            return this;
        }

        public final String getAwsIotJobArn() {
            return awsIotJobArn;
        }

        public final void setAwsIotJobArn(String awsIotJobArn) {
            this.awsIotJobArn = awsIotJobArn;
        }

        @Override
        public final Builder awsIotJobArn(String awsIotJobArn) {
            this.awsIotJobArn = awsIotJobArn;
            return this;
        }

        public final String getOtaUpdateStatus() {
            return otaUpdateStatus;
        }

        public final void setOtaUpdateStatus(String otaUpdateStatus) {
            this.otaUpdateStatus = otaUpdateStatus;
        }

        @Override
        public final Builder otaUpdateStatus(String otaUpdateStatus) {
            this.otaUpdateStatus = otaUpdateStatus;
            return this;
        }

        @Override
        public final Builder otaUpdateStatus(OTAUpdateStatus otaUpdateStatus) {
            this.otaUpdateStatus(otaUpdateStatus == null ? null : otaUpdateStatus.toString());
            return this;
        }

        @Override
        public CreateOtaUpdateResponse build() {
            return new CreateOtaUpdateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
