/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a Device Defender security profile behavior violation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ViolationEvent implements SdkPojo, Serializable, ToCopyableBuilder<ViolationEvent.Builder, ViolationEvent> {
    private static final SdkField<String> VIOLATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("violationId").getter(getter(ViolationEvent::violationId)).setter(setter(Builder::violationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("violationId").build()).build();

    private static final SdkField<String> THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingName").getter(getter(ViolationEvent::thingName)).setter(setter(Builder::thingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingName").build()).build();

    private static final SdkField<String> SECURITY_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("securityProfileName").getter(getter(ViolationEvent::securityProfileName))
            .setter(setter(Builder::securityProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityProfileName").build())
            .build();

    private static final SdkField<Behavior> BEHAVIOR_FIELD = SdkField.<Behavior> builder(MarshallingType.SDK_POJO)
            .memberName("behavior").getter(getter(ViolationEvent::behavior)).setter(setter(Builder::behavior))
            .constructor(Behavior::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("behavior").build()).build();

    private static final SdkField<MetricValue> METRIC_VALUE_FIELD = SdkField.<MetricValue> builder(MarshallingType.SDK_POJO)
            .memberName("metricValue").getter(getter(ViolationEvent::metricValue)).setter(setter(Builder::metricValue))
            .constructor(MetricValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricValue").build()).build();

    private static final SdkField<ViolationEventAdditionalInfo> VIOLATION_EVENT_ADDITIONAL_INFO_FIELD = SdkField
            .<ViolationEventAdditionalInfo> builder(MarshallingType.SDK_POJO)
            .memberName("violationEventAdditionalInfo")
            .getter(getter(ViolationEvent::violationEventAdditionalInfo))
            .setter(setter(Builder::violationEventAdditionalInfo))
            .constructor(ViolationEventAdditionalInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("violationEventAdditionalInfo")
                    .build()).build();

    private static final SdkField<String> VIOLATION_EVENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("violationEventType").getter(getter(ViolationEvent::violationEventTypeAsString))
            .setter(setter(Builder::violationEventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("violationEventType").build())
            .build();

    private static final SdkField<String> VERIFICATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("verificationState").getter(getter(ViolationEvent::verificationStateAsString))
            .setter(setter(Builder::verificationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("verificationState").build()).build();

    private static final SdkField<String> VERIFICATION_STATE_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("verificationStateDescription")
            .getter(getter(ViolationEvent::verificationStateDescription))
            .setter(setter(Builder::verificationStateDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("verificationStateDescription")
                    .build()).build();

    private static final SdkField<Instant> VIOLATION_EVENT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("violationEventTime").getter(getter(ViolationEvent::violationEventTime))
            .setter(setter(Builder::violationEventTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("violationEventTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIOLATION_ID_FIELD,
            THING_NAME_FIELD, SECURITY_PROFILE_NAME_FIELD, BEHAVIOR_FIELD, METRIC_VALUE_FIELD,
            VIOLATION_EVENT_ADDITIONAL_INFO_FIELD, VIOLATION_EVENT_TYPE_FIELD, VERIFICATION_STATE_FIELD,
            VERIFICATION_STATE_DESCRIPTION_FIELD, VIOLATION_EVENT_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String violationId;

    private final String thingName;

    private final String securityProfileName;

    private final Behavior behavior;

    private final MetricValue metricValue;

    private final ViolationEventAdditionalInfo violationEventAdditionalInfo;

    private final String violationEventType;

    private final String verificationState;

    private final String verificationStateDescription;

    private final Instant violationEventTime;

    private ViolationEvent(BuilderImpl builder) {
        this.violationId = builder.violationId;
        this.thingName = builder.thingName;
        this.securityProfileName = builder.securityProfileName;
        this.behavior = builder.behavior;
        this.metricValue = builder.metricValue;
        this.violationEventAdditionalInfo = builder.violationEventAdditionalInfo;
        this.violationEventType = builder.violationEventType;
        this.verificationState = builder.verificationState;
        this.verificationStateDescription = builder.verificationStateDescription;
        this.violationEventTime = builder.violationEventTime;
    }

    /**
     * <p>
     * The ID of the violation event.
     * </p>
     * 
     * @return The ID of the violation event.
     */
    public final String violationId() {
        return violationId;
    }

    /**
     * <p>
     * The name of the thing responsible for the violation event.
     * </p>
     * 
     * @return The name of the thing responsible for the violation event.
     */
    public final String thingName() {
        return thingName;
    }

    /**
     * <p>
     * The name of the security profile whose behavior was violated.
     * </p>
     * 
     * @return The name of the security profile whose behavior was violated.
     */
    public final String securityProfileName() {
        return securityProfileName;
    }

    /**
     * <p>
     * The behavior that was violated.
     * </p>
     * 
     * @return The behavior that was violated.
     */
    public final Behavior behavior() {
        return behavior;
    }

    /**
     * <p>
     * The value of the metric (the measurement).
     * </p>
     * 
     * @return The value of the metric (the measurement).
     */
    public final MetricValue metricValue() {
        return metricValue;
    }

    /**
     * <p>
     * The details of a violation event.
     * </p>
     * 
     * @return The details of a violation event.
     */
    public final ViolationEventAdditionalInfo violationEventAdditionalInfo() {
        return violationEventAdditionalInfo;
    }

    /**
     * <p>
     * The type of violation event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #violationEventType} will return {@link ViolationEventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #violationEventTypeAsString}.
     * </p>
     * 
     * @return The type of violation event.
     * @see ViolationEventType
     */
    public final ViolationEventType violationEventType() {
        return ViolationEventType.fromValue(violationEventType);
    }

    /**
     * <p>
     * The type of violation event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #violationEventType} will return {@link ViolationEventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #violationEventTypeAsString}.
     * </p>
     * 
     * @return The type of violation event.
     * @see ViolationEventType
     */
    public final String violationEventTypeAsString() {
        return violationEventType;
    }

    /**
     * <p>
     * The verification state of the violation (detect alarm).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #verificationState}
     * will return {@link VerificationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #verificationStateAsString}.
     * </p>
     * 
     * @return The verification state of the violation (detect alarm).
     * @see VerificationState
     */
    public final VerificationState verificationState() {
        return VerificationState.fromValue(verificationState);
    }

    /**
     * <p>
     * The verification state of the violation (detect alarm).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #verificationState}
     * will return {@link VerificationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #verificationStateAsString}.
     * </p>
     * 
     * @return The verification state of the violation (detect alarm).
     * @see VerificationState
     */
    public final String verificationStateAsString() {
        return verificationState;
    }

    /**
     * <p>
     * The description of the verification state of the violation.
     * </p>
     * 
     * @return The description of the verification state of the violation.
     */
    public final String verificationStateDescription() {
        return verificationStateDescription;
    }

    /**
     * <p>
     * The time the violation event occurred.
     * </p>
     * 
     * @return The time the violation event occurred.
     */
    public final Instant violationEventTime() {
        return violationEventTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(violationId());
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        hashCode = 31 * hashCode + Objects.hashCode(securityProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(behavior());
        hashCode = 31 * hashCode + Objects.hashCode(metricValue());
        hashCode = 31 * hashCode + Objects.hashCode(violationEventAdditionalInfo());
        hashCode = 31 * hashCode + Objects.hashCode(violationEventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(verificationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(verificationStateDescription());
        hashCode = 31 * hashCode + Objects.hashCode(violationEventTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ViolationEvent)) {
            return false;
        }
        ViolationEvent other = (ViolationEvent) obj;
        return Objects.equals(violationId(), other.violationId()) && Objects.equals(thingName(), other.thingName())
                && Objects.equals(securityProfileName(), other.securityProfileName())
                && Objects.equals(behavior(), other.behavior()) && Objects.equals(metricValue(), other.metricValue())
                && Objects.equals(violationEventAdditionalInfo(), other.violationEventAdditionalInfo())
                && Objects.equals(violationEventTypeAsString(), other.violationEventTypeAsString())
                && Objects.equals(verificationStateAsString(), other.verificationStateAsString())
                && Objects.equals(verificationStateDescription(), other.verificationStateDescription())
                && Objects.equals(violationEventTime(), other.violationEventTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ViolationEvent").add("ViolationId", violationId()).add("ThingName", thingName())
                .add("SecurityProfileName", securityProfileName()).add("Behavior", behavior()).add("MetricValue", metricValue())
                .add("ViolationEventAdditionalInfo", violationEventAdditionalInfo())
                .add("ViolationEventType", violationEventTypeAsString()).add("VerificationState", verificationStateAsString())
                .add("VerificationStateDescription", verificationStateDescription())
                .add("ViolationEventTime", violationEventTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "violationId":
            return Optional.ofNullable(clazz.cast(violationId()));
        case "thingName":
            return Optional.ofNullable(clazz.cast(thingName()));
        case "securityProfileName":
            return Optional.ofNullable(clazz.cast(securityProfileName()));
        case "behavior":
            return Optional.ofNullable(clazz.cast(behavior()));
        case "metricValue":
            return Optional.ofNullable(clazz.cast(metricValue()));
        case "violationEventAdditionalInfo":
            return Optional.ofNullable(clazz.cast(violationEventAdditionalInfo()));
        case "violationEventType":
            return Optional.ofNullable(clazz.cast(violationEventTypeAsString()));
        case "verificationState":
            return Optional.ofNullable(clazz.cast(verificationStateAsString()));
        case "verificationStateDescription":
            return Optional.ofNullable(clazz.cast(verificationStateDescription()));
        case "violationEventTime":
            return Optional.ofNullable(clazz.cast(violationEventTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("violationId", VIOLATION_ID_FIELD);
        map.put("thingName", THING_NAME_FIELD);
        map.put("securityProfileName", SECURITY_PROFILE_NAME_FIELD);
        map.put("behavior", BEHAVIOR_FIELD);
        map.put("metricValue", METRIC_VALUE_FIELD);
        map.put("violationEventAdditionalInfo", VIOLATION_EVENT_ADDITIONAL_INFO_FIELD);
        map.put("violationEventType", VIOLATION_EVENT_TYPE_FIELD);
        map.put("verificationState", VERIFICATION_STATE_FIELD);
        map.put("verificationStateDescription", VERIFICATION_STATE_DESCRIPTION_FIELD);
        map.put("violationEventTime", VIOLATION_EVENT_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ViolationEvent, T> g) {
        return obj -> g.apply((ViolationEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ViolationEvent> {
        /**
         * <p>
         * The ID of the violation event.
         * </p>
         * 
         * @param violationId
         *        The ID of the violation event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violationId(String violationId);

        /**
         * <p>
         * The name of the thing responsible for the violation event.
         * </p>
         * 
         * @param thingName
         *        The name of the thing responsible for the violation event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * The name of the security profile whose behavior was violated.
         * </p>
         * 
         * @param securityProfileName
         *        The name of the security profile whose behavior was violated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileName(String securityProfileName);

        /**
         * <p>
         * The behavior that was violated.
         * </p>
         * 
         * @param behavior
         *        The behavior that was violated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder behavior(Behavior behavior);

        /**
         * <p>
         * The behavior that was violated.
         * </p>
         * This is a convenience method that creates an instance of the {@link Behavior.Builder} avoiding the need to
         * create one manually via {@link Behavior#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Behavior.Builder#build()} is called immediately and its result is
         * passed to {@link #behavior(Behavior)}.
         * 
         * @param behavior
         *        a consumer that will call methods on {@link Behavior.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #behavior(Behavior)
         */
        default Builder behavior(Consumer<Behavior.Builder> behavior) {
            return behavior(Behavior.builder().applyMutation(behavior).build());
        }

        /**
         * <p>
         * The value of the metric (the measurement).
         * </p>
         * 
         * @param metricValue
         *        The value of the metric (the measurement).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricValue(MetricValue metricValue);

        /**
         * <p>
         * The value of the metric (the measurement).
         * </p>
         * This is a convenience method that creates an instance of the {@link MetricValue.Builder} avoiding the need to
         * create one manually via {@link MetricValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetricValue.Builder#build()} is called immediately and its result
         * is passed to {@link #metricValue(MetricValue)}.
         * 
         * @param metricValue
         *        a consumer that will call methods on {@link MetricValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricValue(MetricValue)
         */
        default Builder metricValue(Consumer<MetricValue.Builder> metricValue) {
            return metricValue(MetricValue.builder().applyMutation(metricValue).build());
        }

        /**
         * <p>
         * The details of a violation event.
         * </p>
         * 
         * @param violationEventAdditionalInfo
         *        The details of a violation event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violationEventAdditionalInfo(ViolationEventAdditionalInfo violationEventAdditionalInfo);

        /**
         * <p>
         * The details of a violation event.
         * </p>
         * This is a convenience method that creates an instance of the {@link ViolationEventAdditionalInfo.Builder}
         * avoiding the need to create one manually via {@link ViolationEventAdditionalInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ViolationEventAdditionalInfo.Builder#build()} is called
         * immediately and its result is passed to {@link #violationEventAdditionalInfo(ViolationEventAdditionalInfo)}.
         * 
         * @param violationEventAdditionalInfo
         *        a consumer that will call methods on {@link ViolationEventAdditionalInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #violationEventAdditionalInfo(ViolationEventAdditionalInfo)
         */
        default Builder violationEventAdditionalInfo(Consumer<ViolationEventAdditionalInfo.Builder> violationEventAdditionalInfo) {
            return violationEventAdditionalInfo(ViolationEventAdditionalInfo.builder()
                    .applyMutation(violationEventAdditionalInfo).build());
        }

        /**
         * <p>
         * The type of violation event.
         * </p>
         * 
         * @param violationEventType
         *        The type of violation event.
         * @see ViolationEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ViolationEventType
         */
        Builder violationEventType(String violationEventType);

        /**
         * <p>
         * The type of violation event.
         * </p>
         * 
         * @param violationEventType
         *        The type of violation event.
         * @see ViolationEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ViolationEventType
         */
        Builder violationEventType(ViolationEventType violationEventType);

        /**
         * <p>
         * The verification state of the violation (detect alarm).
         * </p>
         * 
         * @param verificationState
         *        The verification state of the violation (detect alarm).
         * @see VerificationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerificationState
         */
        Builder verificationState(String verificationState);

        /**
         * <p>
         * The verification state of the violation (detect alarm).
         * </p>
         * 
         * @param verificationState
         *        The verification state of the violation (detect alarm).
         * @see VerificationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerificationState
         */
        Builder verificationState(VerificationState verificationState);

        /**
         * <p>
         * The description of the verification state of the violation.
         * </p>
         * 
         * @param verificationStateDescription
         *        The description of the verification state of the violation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verificationStateDescription(String verificationStateDescription);

        /**
         * <p>
         * The time the violation event occurred.
         * </p>
         * 
         * @param violationEventTime
         *        The time the violation event occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violationEventTime(Instant violationEventTime);
    }

    static final class BuilderImpl implements Builder {
        private String violationId;

        private String thingName;

        private String securityProfileName;

        private Behavior behavior;

        private MetricValue metricValue;

        private ViolationEventAdditionalInfo violationEventAdditionalInfo;

        private String violationEventType;

        private String verificationState;

        private String verificationStateDescription;

        private Instant violationEventTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ViolationEvent model) {
            violationId(model.violationId);
            thingName(model.thingName);
            securityProfileName(model.securityProfileName);
            behavior(model.behavior);
            metricValue(model.metricValue);
            violationEventAdditionalInfo(model.violationEventAdditionalInfo);
            violationEventType(model.violationEventType);
            verificationState(model.verificationState);
            verificationStateDescription(model.verificationStateDescription);
            violationEventTime(model.violationEventTime);
        }

        public final String getViolationId() {
            return violationId;
        }

        public final void setViolationId(String violationId) {
            this.violationId = violationId;
        }

        @Override
        public final Builder violationId(String violationId) {
            this.violationId = violationId;
            return this;
        }

        public final String getThingName() {
            return thingName;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final String getSecurityProfileName() {
            return securityProfileName;
        }

        public final void setSecurityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
        }

        @Override
        public final Builder securityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
            return this;
        }

        public final Behavior.Builder getBehavior() {
            return behavior != null ? behavior.toBuilder() : null;
        }

        public final void setBehavior(Behavior.BuilderImpl behavior) {
            this.behavior = behavior != null ? behavior.build() : null;
        }

        @Override
        public final Builder behavior(Behavior behavior) {
            this.behavior = behavior;
            return this;
        }

        public final MetricValue.Builder getMetricValue() {
            return metricValue != null ? metricValue.toBuilder() : null;
        }

        public final void setMetricValue(MetricValue.BuilderImpl metricValue) {
            this.metricValue = metricValue != null ? metricValue.build() : null;
        }

        @Override
        public final Builder metricValue(MetricValue metricValue) {
            this.metricValue = metricValue;
            return this;
        }

        public final ViolationEventAdditionalInfo.Builder getViolationEventAdditionalInfo() {
            return violationEventAdditionalInfo != null ? violationEventAdditionalInfo.toBuilder() : null;
        }

        public final void setViolationEventAdditionalInfo(ViolationEventAdditionalInfo.BuilderImpl violationEventAdditionalInfo) {
            this.violationEventAdditionalInfo = violationEventAdditionalInfo != null ? violationEventAdditionalInfo.build()
                    : null;
        }

        @Override
        public final Builder violationEventAdditionalInfo(ViolationEventAdditionalInfo violationEventAdditionalInfo) {
            this.violationEventAdditionalInfo = violationEventAdditionalInfo;
            return this;
        }

        public final String getViolationEventType() {
            return violationEventType;
        }

        public final void setViolationEventType(String violationEventType) {
            this.violationEventType = violationEventType;
        }

        @Override
        public final Builder violationEventType(String violationEventType) {
            this.violationEventType = violationEventType;
            return this;
        }

        @Override
        public final Builder violationEventType(ViolationEventType violationEventType) {
            this.violationEventType(violationEventType == null ? null : violationEventType.toString());
            return this;
        }

        public final String getVerificationState() {
            return verificationState;
        }

        public final void setVerificationState(String verificationState) {
            this.verificationState = verificationState;
        }

        @Override
        public final Builder verificationState(String verificationState) {
            this.verificationState = verificationState;
            return this;
        }

        @Override
        public final Builder verificationState(VerificationState verificationState) {
            this.verificationState(verificationState == null ? null : verificationState.toString());
            return this;
        }

        public final String getVerificationStateDescription() {
            return verificationStateDescription;
        }

        public final void setVerificationStateDescription(String verificationStateDescription) {
            this.verificationStateDescription = verificationStateDescription;
        }

        @Override
        public final Builder verificationStateDescription(String verificationStateDescription) {
            this.verificationStateDescription = verificationStateDescription;
            return this;
        }

        public final Instant getViolationEventTime() {
            return violationEventTime;
        }

        public final void setViolationEventTime(Instant violationEventTime) {
            this.violationEventTime = violationEventTime;
        }

        @Override
        public final Builder violationEventTime(Instant violationEventTime) {
            this.violationEventTime = violationEventTime;
            return this;
        }

        @Override
        public ViolationEvent build() {
            return new ViolationEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
