/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDomainConfigurationResponse extends IotResponse implements
        ToCopyableBuilder<DescribeDomainConfigurationResponse.Builder, DescribeDomainConfigurationResponse> {
    private static final SdkField<String> DOMAIN_CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainConfigurationName").getter(getter(DescribeDomainConfigurationResponse::domainConfigurationName))
            .setter(setter(Builder::domainConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainConfigurationName").build())
            .build();

    private static final SdkField<String> DOMAIN_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainConfigurationArn").getter(getter(DescribeDomainConfigurationResponse::domainConfigurationArn))
            .setter(setter(Builder::domainConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainConfigurationArn").build())
            .build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainName").getter(getter(DescribeDomainConfigurationResponse::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()).build();

    private static final SdkField<List<ServerCertificateSummary>> SERVER_CERTIFICATES_FIELD = SdkField
            .<List<ServerCertificateSummary>> builder(MarshallingType.LIST)
            .memberName("serverCertificates")
            .getter(getter(DescribeDomainConfigurationResponse::serverCertificates))
            .setter(setter(Builder::serverCertificates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverCertificates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServerCertificateSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServerCertificateSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AuthorizerConfig> AUTHORIZER_CONFIG_FIELD = SdkField
            .<AuthorizerConfig> builder(MarshallingType.SDK_POJO).memberName("authorizerConfig")
            .getter(getter(DescribeDomainConfigurationResponse::authorizerConfig)).setter(setter(Builder::authorizerConfig))
            .constructor(AuthorizerConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerConfig").build()).build();

    private static final SdkField<String> DOMAIN_CONFIGURATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainConfigurationStatus")
            .getter(getter(DescribeDomainConfigurationResponse::domainConfigurationStatusAsString))
            .setter(setter(Builder::domainConfigurationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainConfigurationStatus").build())
            .build();

    private static final SdkField<String> SERVICE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceType").getter(getter(DescribeDomainConfigurationResponse::serviceTypeAsString))
            .setter(setter(Builder::serviceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceType").build()).build();

    private static final SdkField<String> DOMAIN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainType").getter(getter(DescribeDomainConfigurationResponse::domainTypeAsString))
            .setter(setter(Builder::domainType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainType").build()).build();

    private static final SdkField<Instant> LAST_STATUS_CHANGE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastStatusChangeDate").getter(getter(DescribeDomainConfigurationResponse::lastStatusChangeDate))
            .setter(setter(Builder::lastStatusChangeDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStatusChangeDate").build())
            .build();

    private static final SdkField<TlsConfig> TLS_CONFIG_FIELD = SdkField.<TlsConfig> builder(MarshallingType.SDK_POJO)
            .memberName("tlsConfig").getter(getter(DescribeDomainConfigurationResponse::tlsConfig))
            .setter(setter(Builder::tlsConfig)).constructor(TlsConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tlsConfig").build()).build();

    private static final SdkField<ServerCertificateConfig> SERVER_CERTIFICATE_CONFIG_FIELD = SdkField
            .<ServerCertificateConfig> builder(MarshallingType.SDK_POJO).memberName("serverCertificateConfig")
            .getter(getter(DescribeDomainConfigurationResponse::serverCertificateConfig))
            .setter(setter(Builder::serverCertificateConfig)).constructor(ServerCertificateConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverCertificateConfig").build())
            .build();

    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authenticationType").getter(getter(DescribeDomainConfigurationResponse::authenticationTypeAsString))
            .setter(setter(Builder::authenticationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationType").build())
            .build();

    private static final SdkField<String> APPLICATION_PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationProtocol").getter(getter(DescribeDomainConfigurationResponse::applicationProtocolAsString))
            .setter(setter(Builder::applicationProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationProtocol").build())
            .build();

    private static final SdkField<ClientCertificateConfig> CLIENT_CERTIFICATE_CONFIG_FIELD = SdkField
            .<ClientCertificateConfig> builder(MarshallingType.SDK_POJO).memberName("clientCertificateConfig")
            .getter(getter(DescribeDomainConfigurationResponse::clientCertificateConfig))
            .setter(setter(Builder::clientCertificateConfig)).constructor(ClientCertificateConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientCertificateConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DOMAIN_CONFIGURATION_NAME_FIELD, DOMAIN_CONFIGURATION_ARN_FIELD, DOMAIN_NAME_FIELD, SERVER_CERTIFICATES_FIELD,
            AUTHORIZER_CONFIG_FIELD, DOMAIN_CONFIGURATION_STATUS_FIELD, SERVICE_TYPE_FIELD, DOMAIN_TYPE_FIELD,
            LAST_STATUS_CHANGE_DATE_FIELD, TLS_CONFIG_FIELD, SERVER_CERTIFICATE_CONFIG_FIELD, AUTHENTICATION_TYPE_FIELD,
            APPLICATION_PROTOCOL_FIELD, CLIENT_CERTIFICATE_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainConfigurationName;

    private final String domainConfigurationArn;

    private final String domainName;

    private final List<ServerCertificateSummary> serverCertificates;

    private final AuthorizerConfig authorizerConfig;

    private final String domainConfigurationStatus;

    private final String serviceType;

    private final String domainType;

    private final Instant lastStatusChangeDate;

    private final TlsConfig tlsConfig;

    private final ServerCertificateConfig serverCertificateConfig;

    private final String authenticationType;

    private final String applicationProtocol;

    private final ClientCertificateConfig clientCertificateConfig;

    private DescribeDomainConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.domainConfigurationName = builder.domainConfigurationName;
        this.domainConfigurationArn = builder.domainConfigurationArn;
        this.domainName = builder.domainName;
        this.serverCertificates = builder.serverCertificates;
        this.authorizerConfig = builder.authorizerConfig;
        this.domainConfigurationStatus = builder.domainConfigurationStatus;
        this.serviceType = builder.serviceType;
        this.domainType = builder.domainType;
        this.lastStatusChangeDate = builder.lastStatusChangeDate;
        this.tlsConfig = builder.tlsConfig;
        this.serverCertificateConfig = builder.serverCertificateConfig;
        this.authenticationType = builder.authenticationType;
        this.applicationProtocol = builder.applicationProtocol;
        this.clientCertificateConfig = builder.clientCertificateConfig;
    }

    /**
     * <p>
     * The name of the domain configuration.
     * </p>
     * 
     * @return The name of the domain configuration.
     */
    public final String domainConfigurationName() {
        return domainConfigurationName;
    }

    /**
     * <p>
     * The ARN of the domain configuration.
     * </p>
     * 
     * @return The ARN of the domain configuration.
     */
    public final String domainConfigurationArn() {
        return domainConfigurationArn;
    }

    /**
     * <p>
     * The name of the domain.
     * </p>
     * 
     * @return The name of the domain.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServerCertificates property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasServerCertificates() {
        return serverCertificates != null && !(serverCertificates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list containing summary information about the server certificate included in the domain configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServerCertificates} method.
     * </p>
     * 
     * @return A list containing summary information about the server certificate included in the domain configuration.
     */
    public final List<ServerCertificateSummary> serverCertificates() {
        return serverCertificates;
    }

    /**
     * <p>
     * An object that specifies the authorization service for a domain.
     * </p>
     * 
     * @return An object that specifies the authorization service for a domain.
     */
    public final AuthorizerConfig authorizerConfig() {
        return authorizerConfig;
    }

    /**
     * <p>
     * A Boolean value that specifies the current state of the domain configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #domainConfigurationStatus} will return {@link DomainConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #domainConfigurationStatusAsString}.
     * </p>
     * 
     * @return A Boolean value that specifies the current state of the domain configuration.
     * @see DomainConfigurationStatus
     */
    public final DomainConfigurationStatus domainConfigurationStatus() {
        return DomainConfigurationStatus.fromValue(domainConfigurationStatus);
    }

    /**
     * <p>
     * A Boolean value that specifies the current state of the domain configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #domainConfigurationStatus} will return {@link DomainConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #domainConfigurationStatusAsString}.
     * </p>
     * 
     * @return A Boolean value that specifies the current state of the domain configuration.
     * @see DomainConfigurationStatus
     */
    public final String domainConfigurationStatusAsString() {
        return domainConfigurationStatus;
    }

    /**
     * <p>
     * The type of service delivered by the endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceType} will
     * return {@link ServiceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceTypeAsString}.
     * </p>
     * 
     * @return The type of service delivered by the endpoint.
     * @see ServiceType
     */
    public final ServiceType serviceType() {
        return ServiceType.fromValue(serviceType);
    }

    /**
     * <p>
     * The type of service delivered by the endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceType} will
     * return {@link ServiceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceTypeAsString}.
     * </p>
     * 
     * @return The type of service delivered by the endpoint.
     * @see ServiceType
     */
    public final String serviceTypeAsString() {
        return serviceType;
    }

    /**
     * <p>
     * The type of the domain.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domainType} will
     * return {@link DomainType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainTypeAsString}.
     * </p>
     * 
     * @return The type of the domain.
     * @see DomainType
     */
    public final DomainType domainType() {
        return DomainType.fromValue(domainType);
    }

    /**
     * <p>
     * The type of the domain.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domainType} will
     * return {@link DomainType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainTypeAsString}.
     * </p>
     * 
     * @return The type of the domain.
     * @see DomainType
     */
    public final String domainTypeAsString() {
        return domainType;
    }

    /**
     * <p>
     * The date and time the domain configuration's status was last changed.
     * </p>
     * 
     * @return The date and time the domain configuration's status was last changed.
     */
    public final Instant lastStatusChangeDate() {
        return lastStatusChangeDate;
    }

    /**
     * <p>
     * An object that specifies the TLS configuration for a domain.
     * </p>
     * 
     * @return An object that specifies the TLS configuration for a domain.
     */
    public final TlsConfig tlsConfig() {
        return tlsConfig;
    }

    /**
     * <p>
     * The server certificate configuration.
     * </p>
     * 
     * @return The server certificate configuration.
     */
    public final ServerCertificateConfig serverCertificateConfig() {
        return serverCertificateConfig;
    }

    /**
     * <p>
     * An enumerated string that speciﬁes the authentication type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CUSTOM_AUTH_X509</code> - Use custom authentication and authorization with additional details from the
     * X.509 client certificate.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <code>CUSTOM_AUTH</code> - Use custom authentication and authorization. For more information, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/custom-authentication.html">Custom authentication and
     * authorization</a>.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <code>AWS_X509</code> - Use X.509 client certificates without custom authentication and authorization. For more
     * information, see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html">X.509
     * client certificates</a>.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <code>AWS_SIGV4</code> - Use Amazon Web Services Signature Version 4. For more information, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/custom-authentication.html">IAM users, groups, and
     * roles</a>.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <code>DEFAULT</code> - Use a combination of port and Application Layer Protocol Negotiation (ALPN) to specify
     * authentication type. For more information, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/protocols.html">Device communication protocols</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return An enumerated string that speciﬁes the authentication type.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CUSTOM_AUTH_X509</code> - Use custom authentication and authorization with additional details from
     *         the X.509 client certificate.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CUSTOM_AUTH</code> - Use custom authentication and authorization. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot/latest/developerguide/custom-authentication.html">Custom
     *         authentication and authorization</a>.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AWS_X509</code> - Use X.509 client certificates without custom authentication and authorization.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html">X.509 client
     *         certificates</a>.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AWS_SIGV4</code> - Use Amazon Web Services Signature Version 4. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot/latest/developerguide/custom-authentication.html">IAM users,
     *         groups, and roles</a>.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DEFAULT</code> - Use a combination of port and Application Layer Protocol Negotiation (ALPN) to
     *         specify authentication type. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot/latest/developerguide/protocols.html">Device communication
     *         protocols</a>.
     *         </p>
     *         </li>
     * @see AuthenticationType
     */
    public final AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(authenticationType);
    }

    /**
     * <p>
     * An enumerated string that speciﬁes the authentication type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CUSTOM_AUTH_X509</code> - Use custom authentication and authorization with additional details from the
     * X.509 client certificate.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <code>CUSTOM_AUTH</code> - Use custom authentication and authorization. For more information, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/custom-authentication.html">Custom authentication and
     * authorization</a>.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <code>AWS_X509</code> - Use X.509 client certificates without custom authentication and authorization. For more
     * information, see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html">X.509
     * client certificates</a>.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <code>AWS_SIGV4</code> - Use Amazon Web Services Signature Version 4. For more information, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/custom-authentication.html">IAM users, groups, and
     * roles</a>.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <code>DEFAULT</code> - Use a combination of port and Application Layer Protocol Negotiation (ALPN) to specify
     * authentication type. For more information, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/protocols.html">Device communication protocols</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return An enumerated string that speciﬁes the authentication type.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CUSTOM_AUTH_X509</code> - Use custom authentication and authorization with additional details from
     *         the X.509 client certificate.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CUSTOM_AUTH</code> - Use custom authentication and authorization. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot/latest/developerguide/custom-authentication.html">Custom
     *         authentication and authorization</a>.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AWS_X509</code> - Use X.509 client certificates without custom authentication and authorization.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html">X.509 client
     *         certificates</a>.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AWS_SIGV4</code> - Use Amazon Web Services Signature Version 4. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot/latest/developerguide/custom-authentication.html">IAM users,
     *         groups, and roles</a>.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DEFAULT</code> - Use a combination of port and Application Layer Protocol Negotiation (ALPN) to
     *         specify authentication type. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot/latest/developerguide/protocols.html">Device communication
     *         protocols</a>.
     *         </p>
     *         </li>
     * @see AuthenticationType
     */
    public final String authenticationTypeAsString() {
        return authenticationType;
    }

    /**
     * <p>
     * An enumerated string that speciﬁes the application-layer protocol.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SECURE_MQTT</code> - MQTT over TLS.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <code>MQTT_WSS</code> - MQTT over WebSocket.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <code>HTTPS</code> - HTTP over TLS.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <code>DEFAULT</code> - Use a combination of port and Application Layer Protocol Negotiation (ALPN) to specify
     * application_layer protocol. For more information, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/protocols.html">Device communication protocols</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #applicationProtocol} will return {@link ApplicationProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #applicationProtocolAsString}.
     * </p>
     * 
     * @return An enumerated string that speciﬁes the application-layer protocol.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SECURE_MQTT</code> - MQTT over TLS.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>MQTT_WSS</code> - MQTT over WebSocket.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HTTPS</code> - HTTP over TLS.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DEFAULT</code> - Use a combination of port and Application Layer Protocol Negotiation (ALPN) to
     *         specify application_layer protocol. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot/latest/developerguide/protocols.html">Device communication
     *         protocols</a>.
     *         </p>
     *         </li>
     * @see ApplicationProtocol
     */
    public final ApplicationProtocol applicationProtocol() {
        return ApplicationProtocol.fromValue(applicationProtocol);
    }

    /**
     * <p>
     * An enumerated string that speciﬁes the application-layer protocol.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SECURE_MQTT</code> - MQTT over TLS.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <code>MQTT_WSS</code> - MQTT over WebSocket.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <code>HTTPS</code> - HTTP over TLS.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <code>DEFAULT</code> - Use a combination of port and Application Layer Protocol Negotiation (ALPN) to specify
     * application_layer protocol. For more information, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/protocols.html">Device communication protocols</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #applicationProtocol} will return {@link ApplicationProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #applicationProtocolAsString}.
     * </p>
     * 
     * @return An enumerated string that speciﬁes the application-layer protocol.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SECURE_MQTT</code> - MQTT over TLS.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>MQTT_WSS</code> - MQTT over WebSocket.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HTTPS</code> - HTTP over TLS.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DEFAULT</code> - Use a combination of port and Application Layer Protocol Negotiation (ALPN) to
     *         specify application_layer protocol. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot/latest/developerguide/protocols.html">Device communication
     *         protocols</a>.
     *         </p>
     *         </li>
     * @see ApplicationProtocol
     */
    public final String applicationProtocolAsString() {
        return applicationProtocol;
    }

    /**
     * <p>
     * An object that speciﬁes the client certificate conﬁguration for a domain.
     * </p>
     * 
     * @return An object that speciﬁes the client certificate conﬁguration for a domain.
     */
    public final ClientCertificateConfig clientCertificateConfig() {
        return clientCertificateConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(domainConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(hasServerCertificates() ? serverCertificates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(authorizerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(domainConfigurationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(domainTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastStatusChangeDate());
        hashCode = 31 * hashCode + Objects.hashCode(tlsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(serverCertificateConfig());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(applicationProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientCertificateConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDomainConfigurationResponse)) {
            return false;
        }
        DescribeDomainConfigurationResponse other = (DescribeDomainConfigurationResponse) obj;
        return Objects.equals(domainConfigurationName(), other.domainConfigurationName())
                && Objects.equals(domainConfigurationArn(), other.domainConfigurationArn())
                && Objects.equals(domainName(), other.domainName()) && hasServerCertificates() == other.hasServerCertificates()
                && Objects.equals(serverCertificates(), other.serverCertificates())
                && Objects.equals(authorizerConfig(), other.authorizerConfig())
                && Objects.equals(domainConfigurationStatusAsString(), other.domainConfigurationStatusAsString())
                && Objects.equals(serviceTypeAsString(), other.serviceTypeAsString())
                && Objects.equals(domainTypeAsString(), other.domainTypeAsString())
                && Objects.equals(lastStatusChangeDate(), other.lastStatusChangeDate())
                && Objects.equals(tlsConfig(), other.tlsConfig())
                && Objects.equals(serverCertificateConfig(), other.serverCertificateConfig())
                && Objects.equals(authenticationTypeAsString(), other.authenticationTypeAsString())
                && Objects.equals(applicationProtocolAsString(), other.applicationProtocolAsString())
                && Objects.equals(clientCertificateConfig(), other.clientCertificateConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDomainConfigurationResponse").add("DomainConfigurationName", domainConfigurationName())
                .add("DomainConfigurationArn", domainConfigurationArn()).add("DomainName", domainName())
                .add("ServerCertificates", hasServerCertificates() ? serverCertificates() : null)
                .add("AuthorizerConfig", authorizerConfig())
                .add("DomainConfigurationStatus", domainConfigurationStatusAsString()).add("ServiceType", serviceTypeAsString())
                .add("DomainType", domainTypeAsString()).add("LastStatusChangeDate", lastStatusChangeDate())
                .add("TlsConfig", tlsConfig()).add("ServerCertificateConfig", serverCertificateConfig())
                .add("AuthenticationType", authenticationTypeAsString())
                .add("ApplicationProtocol", applicationProtocolAsString())
                .add("ClientCertificateConfig", clientCertificateConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainConfigurationName":
            return Optional.ofNullable(clazz.cast(domainConfigurationName()));
        case "domainConfigurationArn":
            return Optional.ofNullable(clazz.cast(domainConfigurationArn()));
        case "domainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "serverCertificates":
            return Optional.ofNullable(clazz.cast(serverCertificates()));
        case "authorizerConfig":
            return Optional.ofNullable(clazz.cast(authorizerConfig()));
        case "domainConfigurationStatus":
            return Optional.ofNullable(clazz.cast(domainConfigurationStatusAsString()));
        case "serviceType":
            return Optional.ofNullable(clazz.cast(serviceTypeAsString()));
        case "domainType":
            return Optional.ofNullable(clazz.cast(domainTypeAsString()));
        case "lastStatusChangeDate":
            return Optional.ofNullable(clazz.cast(lastStatusChangeDate()));
        case "tlsConfig":
            return Optional.ofNullable(clazz.cast(tlsConfig()));
        case "serverCertificateConfig":
            return Optional.ofNullable(clazz.cast(serverCertificateConfig()));
        case "authenticationType":
            return Optional.ofNullable(clazz.cast(authenticationTypeAsString()));
        case "applicationProtocol":
            return Optional.ofNullable(clazz.cast(applicationProtocolAsString()));
        case "clientCertificateConfig":
            return Optional.ofNullable(clazz.cast(clientCertificateConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("domainConfigurationName", DOMAIN_CONFIGURATION_NAME_FIELD);
        map.put("domainConfigurationArn", DOMAIN_CONFIGURATION_ARN_FIELD);
        map.put("domainName", DOMAIN_NAME_FIELD);
        map.put("serverCertificates", SERVER_CERTIFICATES_FIELD);
        map.put("authorizerConfig", AUTHORIZER_CONFIG_FIELD);
        map.put("domainConfigurationStatus", DOMAIN_CONFIGURATION_STATUS_FIELD);
        map.put("serviceType", SERVICE_TYPE_FIELD);
        map.put("domainType", DOMAIN_TYPE_FIELD);
        map.put("lastStatusChangeDate", LAST_STATUS_CHANGE_DATE_FIELD);
        map.put("tlsConfig", TLS_CONFIG_FIELD);
        map.put("serverCertificateConfig", SERVER_CERTIFICATE_CONFIG_FIELD);
        map.put("authenticationType", AUTHENTICATION_TYPE_FIELD);
        map.put("applicationProtocol", APPLICATION_PROTOCOL_FIELD);
        map.put("clientCertificateConfig", CLIENT_CERTIFICATE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDomainConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeDomainConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDomainConfigurationResponse> {
        /**
         * <p>
         * The name of the domain configuration.
         * </p>
         * 
         * @param domainConfigurationName
         *        The name of the domain configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainConfigurationName(String domainConfigurationName);

        /**
         * <p>
         * The ARN of the domain configuration.
         * </p>
         * 
         * @param domainConfigurationArn
         *        The ARN of the domain configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainConfigurationArn(String domainConfigurationArn);

        /**
         * <p>
         * The name of the domain.
         * </p>
         * 
         * @param domainName
         *        The name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * A list containing summary information about the server certificate included in the domain configuration.
         * </p>
         * 
         * @param serverCertificates
         *        A list containing summary information about the server certificate included in the domain
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverCertificates(Collection<ServerCertificateSummary> serverCertificates);

        /**
         * <p>
         * A list containing summary information about the server certificate included in the domain configuration.
         * </p>
         * 
         * @param serverCertificates
         *        A list containing summary information about the server certificate included in the domain
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverCertificates(ServerCertificateSummary... serverCertificates);

        /**
         * <p>
         * A list containing summary information about the server certificate included in the domain configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iot.model.ServerCertificateSummary.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.iot.model.ServerCertificateSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iot.model.ServerCertificateSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #serverCertificates(List<ServerCertificateSummary>)}.
         * 
         * @param serverCertificates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iot.model.ServerCertificateSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverCertificates(java.util.Collection<ServerCertificateSummary>)
         */
        Builder serverCertificates(Consumer<ServerCertificateSummary.Builder>... serverCertificates);

        /**
         * <p>
         * An object that specifies the authorization service for a domain.
         * </p>
         * 
         * @param authorizerConfig
         *        An object that specifies the authorization service for a domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizerConfig(AuthorizerConfig authorizerConfig);

        /**
         * <p>
         * An object that specifies the authorization service for a domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuthorizerConfig.Builder} avoiding the
         * need to create one manually via {@link AuthorizerConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AuthorizerConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #authorizerConfig(AuthorizerConfig)}.
         * 
         * @param authorizerConfig
         *        a consumer that will call methods on {@link AuthorizerConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authorizerConfig(AuthorizerConfig)
         */
        default Builder authorizerConfig(Consumer<AuthorizerConfig.Builder> authorizerConfig) {
            return authorizerConfig(AuthorizerConfig.builder().applyMutation(authorizerConfig).build());
        }

        /**
         * <p>
         * A Boolean value that specifies the current state of the domain configuration.
         * </p>
         * 
         * @param domainConfigurationStatus
         *        A Boolean value that specifies the current state of the domain configuration.
         * @see DomainConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainConfigurationStatus
         */
        Builder domainConfigurationStatus(String domainConfigurationStatus);

        /**
         * <p>
         * A Boolean value that specifies the current state of the domain configuration.
         * </p>
         * 
         * @param domainConfigurationStatus
         *        A Boolean value that specifies the current state of the domain configuration.
         * @see DomainConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainConfigurationStatus
         */
        Builder domainConfigurationStatus(DomainConfigurationStatus domainConfigurationStatus);

        /**
         * <p>
         * The type of service delivered by the endpoint.
         * </p>
         * 
         * @param serviceType
         *        The type of service delivered by the endpoint.
         * @see ServiceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceType
         */
        Builder serviceType(String serviceType);

        /**
         * <p>
         * The type of service delivered by the endpoint.
         * </p>
         * 
         * @param serviceType
         *        The type of service delivered by the endpoint.
         * @see ServiceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceType
         */
        Builder serviceType(ServiceType serviceType);

        /**
         * <p>
         * The type of the domain.
         * </p>
         * 
         * @param domainType
         *        The type of the domain.
         * @see DomainType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainType
         */
        Builder domainType(String domainType);

        /**
         * <p>
         * The type of the domain.
         * </p>
         * 
         * @param domainType
         *        The type of the domain.
         * @see DomainType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainType
         */
        Builder domainType(DomainType domainType);

        /**
         * <p>
         * The date and time the domain configuration's status was last changed.
         * </p>
         * 
         * @param lastStatusChangeDate
         *        The date and time the domain configuration's status was last changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastStatusChangeDate(Instant lastStatusChangeDate);

        /**
         * <p>
         * An object that specifies the TLS configuration for a domain.
         * </p>
         * 
         * @param tlsConfig
         *        An object that specifies the TLS configuration for a domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tlsConfig(TlsConfig tlsConfig);

        /**
         * <p>
         * An object that specifies the TLS configuration for a domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link TlsConfig.Builder} avoiding the need to
         * create one manually via {@link TlsConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TlsConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #tlsConfig(TlsConfig)}.
         * 
         * @param tlsConfig
         *        a consumer that will call methods on {@link TlsConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tlsConfig(TlsConfig)
         */
        default Builder tlsConfig(Consumer<TlsConfig.Builder> tlsConfig) {
            return tlsConfig(TlsConfig.builder().applyMutation(tlsConfig).build());
        }

        /**
         * <p>
         * The server certificate configuration.
         * </p>
         * 
         * @param serverCertificateConfig
         *        The server certificate configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverCertificateConfig(ServerCertificateConfig serverCertificateConfig);

        /**
         * <p>
         * The server certificate configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServerCertificateConfig.Builder} avoiding
         * the need to create one manually via {@link ServerCertificateConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServerCertificateConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #serverCertificateConfig(ServerCertificateConfig)}.
         * 
         * @param serverCertificateConfig
         *        a consumer that will call methods on {@link ServerCertificateConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverCertificateConfig(ServerCertificateConfig)
         */
        default Builder serverCertificateConfig(Consumer<ServerCertificateConfig.Builder> serverCertificateConfig) {
            return serverCertificateConfig(ServerCertificateConfig.builder().applyMutation(serverCertificateConfig).build());
        }

        /**
         * <p>
         * An enumerated string that speciﬁes the authentication type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CUSTOM_AUTH_X509</code> - Use custom authentication and authorization with additional details from the
         * X.509 client certificate.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * <code>CUSTOM_AUTH</code> - Use custom authentication and authorization. For more information, see <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/custom-authentication.html">Custom authentication
         * and authorization</a>.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * <code>AWS_X509</code> - Use X.509 client certificates without custom authentication and authorization. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html">X.509 client
         * certificates</a>.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * <code>AWS_SIGV4</code> - Use Amazon Web Services Signature Version 4. For more information, see <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/custom-authentication.html">IAM users, groups,
         * and roles</a>.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * <code>DEFAULT</code> - Use a combination of port and Application Layer Protocol Negotiation (ALPN) to specify
         * authentication type. For more information, see <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/protocols.html">Device communication
         * protocols</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param authenticationType
         *        An enumerated string that speciﬁes the authentication type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CUSTOM_AUTH_X509</code> - Use custom authentication and authorization with additional details
         *        from the X.509 client certificate.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CUSTOM_AUTH</code> - Use custom authentication and authorization. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot/latest/developerguide/custom-authentication.html">Custom
         *        authentication and authorization</a>.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AWS_X509</code> - Use X.509 client certificates without custom authentication and authorization.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html">X.509 client
         *        certificates</a>.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AWS_SIGV4</code> - Use Amazon Web Services Signature Version 4. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot/latest/developerguide/custom-authentication.html">IAM users,
         *        groups, and roles</a>.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DEFAULT</code> - Use a combination of port and Application Layer Protocol Negotiation (ALPN) to
         *        specify authentication type. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot/latest/developerguide/protocols.html">Device communication
         *        protocols</a>.
         *        </p>
         *        </li>
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(String authenticationType);

        /**
         * <p>
         * An enumerated string that speciﬁes the authentication type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CUSTOM_AUTH_X509</code> - Use custom authentication and authorization with additional details from the
         * X.509 client certificate.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * <code>CUSTOM_AUTH</code> - Use custom authentication and authorization. For more information, see <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/custom-authentication.html">Custom authentication
         * and authorization</a>.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * <code>AWS_X509</code> - Use X.509 client certificates without custom authentication and authorization. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html">X.509 client
         * certificates</a>.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * <code>AWS_SIGV4</code> - Use Amazon Web Services Signature Version 4. For more information, see <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/custom-authentication.html">IAM users, groups,
         * and roles</a>.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * <code>DEFAULT</code> - Use a combination of port and Application Layer Protocol Negotiation (ALPN) to specify
         * authentication type. For more information, see <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/protocols.html">Device communication
         * protocols</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param authenticationType
         *        An enumerated string that speciﬁes the authentication type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CUSTOM_AUTH_X509</code> - Use custom authentication and authorization with additional details
         *        from the X.509 client certificate.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CUSTOM_AUTH</code> - Use custom authentication and authorization. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot/latest/developerguide/custom-authentication.html">Custom
         *        authentication and authorization</a>.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AWS_X509</code> - Use X.509 client certificates without custom authentication and authorization.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html">X.509 client
         *        certificates</a>.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AWS_SIGV4</code> - Use Amazon Web Services Signature Version 4. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot/latest/developerguide/custom-authentication.html">IAM users,
         *        groups, and roles</a>.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DEFAULT</code> - Use a combination of port and Application Layer Protocol Negotiation (ALPN) to
         *        specify authentication type. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot/latest/developerguide/protocols.html">Device communication
         *        protocols</a>.
         *        </p>
         *        </li>
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(AuthenticationType authenticationType);

        /**
         * <p>
         * An enumerated string that speciﬁes the application-layer protocol.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SECURE_MQTT</code> - MQTT over TLS.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * <code>MQTT_WSS</code> - MQTT over WebSocket.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * <code>HTTPS</code> - HTTP over TLS.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * <code>DEFAULT</code> - Use a combination of port and Application Layer Protocol Negotiation (ALPN) to specify
         * application_layer protocol. For more information, see <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/protocols.html">Device communication
         * protocols</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param applicationProtocol
         *        An enumerated string that speciﬁes the application-layer protocol.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SECURE_MQTT</code> - MQTT over TLS.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>MQTT_WSS</code> - MQTT over WebSocket.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HTTPS</code> - HTTP over TLS.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DEFAULT</code> - Use a combination of port and Application Layer Protocol Negotiation (ALPN) to
         *        specify application_layer protocol. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot/latest/developerguide/protocols.html">Device communication
         *        protocols</a>.
         *        </p>
         *        </li>
         * @see ApplicationProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationProtocol
         */
        Builder applicationProtocol(String applicationProtocol);

        /**
         * <p>
         * An enumerated string that speciﬁes the application-layer protocol.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SECURE_MQTT</code> - MQTT over TLS.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * <code>MQTT_WSS</code> - MQTT over WebSocket.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * <code>HTTPS</code> - HTTP over TLS.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * <code>DEFAULT</code> - Use a combination of port and Application Layer Protocol Negotiation (ALPN) to specify
         * application_layer protocol. For more information, see <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/protocols.html">Device communication
         * protocols</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param applicationProtocol
         *        An enumerated string that speciﬁes the application-layer protocol.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SECURE_MQTT</code> - MQTT over TLS.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>MQTT_WSS</code> - MQTT over WebSocket.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HTTPS</code> - HTTP over TLS.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DEFAULT</code> - Use a combination of port and Application Layer Protocol Negotiation (ALPN) to
         *        specify application_layer protocol. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot/latest/developerguide/protocols.html">Device communication
         *        protocols</a>.
         *        </p>
         *        </li>
         * @see ApplicationProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationProtocol
         */
        Builder applicationProtocol(ApplicationProtocol applicationProtocol);

        /**
         * <p>
         * An object that speciﬁes the client certificate conﬁguration for a domain.
         * </p>
         * 
         * @param clientCertificateConfig
         *        An object that speciﬁes the client certificate conﬁguration for a domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientCertificateConfig(ClientCertificateConfig clientCertificateConfig);

        /**
         * <p>
         * An object that speciﬁes the client certificate conﬁguration for a domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClientCertificateConfig.Builder} avoiding
         * the need to create one manually via {@link ClientCertificateConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClientCertificateConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #clientCertificateConfig(ClientCertificateConfig)}.
         * 
         * @param clientCertificateConfig
         *        a consumer that will call methods on {@link ClientCertificateConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientCertificateConfig(ClientCertificateConfig)
         */
        default Builder clientCertificateConfig(Consumer<ClientCertificateConfig.Builder> clientCertificateConfig) {
            return clientCertificateConfig(ClientCertificateConfig.builder().applyMutation(clientCertificateConfig).build());
        }
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String domainConfigurationName;

        private String domainConfigurationArn;

        private String domainName;

        private List<ServerCertificateSummary> serverCertificates = DefaultSdkAutoConstructList.getInstance();

        private AuthorizerConfig authorizerConfig;

        private String domainConfigurationStatus;

        private String serviceType;

        private String domainType;

        private Instant lastStatusChangeDate;

        private TlsConfig tlsConfig;

        private ServerCertificateConfig serverCertificateConfig;

        private String authenticationType;

        private String applicationProtocol;

        private ClientCertificateConfig clientCertificateConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDomainConfigurationResponse model) {
            super(model);
            domainConfigurationName(model.domainConfigurationName);
            domainConfigurationArn(model.domainConfigurationArn);
            domainName(model.domainName);
            serverCertificates(model.serverCertificates);
            authorizerConfig(model.authorizerConfig);
            domainConfigurationStatus(model.domainConfigurationStatus);
            serviceType(model.serviceType);
            domainType(model.domainType);
            lastStatusChangeDate(model.lastStatusChangeDate);
            tlsConfig(model.tlsConfig);
            serverCertificateConfig(model.serverCertificateConfig);
            authenticationType(model.authenticationType);
            applicationProtocol(model.applicationProtocol);
            clientCertificateConfig(model.clientCertificateConfig);
        }

        public final String getDomainConfigurationName() {
            return domainConfigurationName;
        }

        public final void setDomainConfigurationName(String domainConfigurationName) {
            this.domainConfigurationName = domainConfigurationName;
        }

        @Override
        public final Builder domainConfigurationName(String domainConfigurationName) {
            this.domainConfigurationName = domainConfigurationName;
            return this;
        }

        public final String getDomainConfigurationArn() {
            return domainConfigurationArn;
        }

        public final void setDomainConfigurationArn(String domainConfigurationArn) {
            this.domainConfigurationArn = domainConfigurationArn;
        }

        @Override
        public final Builder domainConfigurationArn(String domainConfigurationArn) {
            this.domainConfigurationArn = domainConfigurationArn;
            return this;
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final List<ServerCertificateSummary.Builder> getServerCertificates() {
            List<ServerCertificateSummary.Builder> result = ServerCertificatesCopier.copyToBuilder(this.serverCertificates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServerCertificates(Collection<ServerCertificateSummary.BuilderImpl> serverCertificates) {
            this.serverCertificates = ServerCertificatesCopier.copyFromBuilder(serverCertificates);
        }

        @Override
        public final Builder serverCertificates(Collection<ServerCertificateSummary> serverCertificates) {
            this.serverCertificates = ServerCertificatesCopier.copy(serverCertificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverCertificates(ServerCertificateSummary... serverCertificates) {
            serverCertificates(Arrays.asList(serverCertificates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverCertificates(Consumer<ServerCertificateSummary.Builder>... serverCertificates) {
            serverCertificates(Stream.of(serverCertificates)
                    .map(c -> ServerCertificateSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final AuthorizerConfig.Builder getAuthorizerConfig() {
            return authorizerConfig != null ? authorizerConfig.toBuilder() : null;
        }

        public final void setAuthorizerConfig(AuthorizerConfig.BuilderImpl authorizerConfig) {
            this.authorizerConfig = authorizerConfig != null ? authorizerConfig.build() : null;
        }

        @Override
        public final Builder authorizerConfig(AuthorizerConfig authorizerConfig) {
            this.authorizerConfig = authorizerConfig;
            return this;
        }

        public final String getDomainConfigurationStatus() {
            return domainConfigurationStatus;
        }

        public final void setDomainConfigurationStatus(String domainConfigurationStatus) {
            this.domainConfigurationStatus = domainConfigurationStatus;
        }

        @Override
        public final Builder domainConfigurationStatus(String domainConfigurationStatus) {
            this.domainConfigurationStatus = domainConfigurationStatus;
            return this;
        }

        @Override
        public final Builder domainConfigurationStatus(DomainConfigurationStatus domainConfigurationStatus) {
            this.domainConfigurationStatus(domainConfigurationStatus == null ? null : domainConfigurationStatus.toString());
            return this;
        }

        public final String getServiceType() {
            return serviceType;
        }

        public final void setServiceType(String serviceType) {
            this.serviceType = serviceType;
        }

        @Override
        public final Builder serviceType(String serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        @Override
        public final Builder serviceType(ServiceType serviceType) {
            this.serviceType(serviceType == null ? null : serviceType.toString());
            return this;
        }

        public final String getDomainType() {
            return domainType;
        }

        public final void setDomainType(String domainType) {
            this.domainType = domainType;
        }

        @Override
        public final Builder domainType(String domainType) {
            this.domainType = domainType;
            return this;
        }

        @Override
        public final Builder domainType(DomainType domainType) {
            this.domainType(domainType == null ? null : domainType.toString());
            return this;
        }

        public final Instant getLastStatusChangeDate() {
            return lastStatusChangeDate;
        }

        public final void setLastStatusChangeDate(Instant lastStatusChangeDate) {
            this.lastStatusChangeDate = lastStatusChangeDate;
        }

        @Override
        public final Builder lastStatusChangeDate(Instant lastStatusChangeDate) {
            this.lastStatusChangeDate = lastStatusChangeDate;
            return this;
        }

        public final TlsConfig.Builder getTlsConfig() {
            return tlsConfig != null ? tlsConfig.toBuilder() : null;
        }

        public final void setTlsConfig(TlsConfig.BuilderImpl tlsConfig) {
            this.tlsConfig = tlsConfig != null ? tlsConfig.build() : null;
        }

        @Override
        public final Builder tlsConfig(TlsConfig tlsConfig) {
            this.tlsConfig = tlsConfig;
            return this;
        }

        public final ServerCertificateConfig.Builder getServerCertificateConfig() {
            return serverCertificateConfig != null ? serverCertificateConfig.toBuilder() : null;
        }

        public final void setServerCertificateConfig(ServerCertificateConfig.BuilderImpl serverCertificateConfig) {
            this.serverCertificateConfig = serverCertificateConfig != null ? serverCertificateConfig.build() : null;
        }

        @Override
        public final Builder serverCertificateConfig(ServerCertificateConfig serverCertificateConfig) {
            this.serverCertificateConfig = serverCertificateConfig;
            return this;
        }

        public final String getAuthenticationType() {
            return authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final String getApplicationProtocol() {
            return applicationProtocol;
        }

        public final void setApplicationProtocol(String applicationProtocol) {
            this.applicationProtocol = applicationProtocol;
        }

        @Override
        public final Builder applicationProtocol(String applicationProtocol) {
            this.applicationProtocol = applicationProtocol;
            return this;
        }

        @Override
        public final Builder applicationProtocol(ApplicationProtocol applicationProtocol) {
            this.applicationProtocol(applicationProtocol == null ? null : applicationProtocol.toString());
            return this;
        }

        public final ClientCertificateConfig.Builder getClientCertificateConfig() {
            return clientCertificateConfig != null ? clientCertificateConfig.toBuilder() : null;
        }

        public final void setClientCertificateConfig(ClientCertificateConfig.BuilderImpl clientCertificateConfig) {
            this.clientCertificateConfig = clientCertificateConfig != null ? clientCertificateConfig.build() : null;
        }

        @Override
        public final Builder clientCertificateConfig(ClientCertificateConfig clientCertificateConfig) {
            this.clientCertificateConfig = clientCertificateConfig;
            return this;
        }

        @Override
        public DescribeDomainConfigurationResponse build() {
            return new DescribeDomainConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
