/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter that can be used to list command executions for a device that started or completed before or after a
 * particular date and time.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimeFilter implements SdkPojo, Serializable, ToCopyableBuilder<TimeFilter.Builder, TimeFilter> {
    private static final SdkField<String> AFTER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("after")
            .getter(getter(TimeFilter::after)).setter(setter(Builder::after))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("after").build()).build();

    private static final SdkField<String> BEFORE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("before")
            .getter(getter(TimeFilter::before)).setter(setter(Builder::before))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("before").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AFTER_FIELD, BEFORE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String after;

    private final String before;

    private TimeFilter(BuilderImpl builder) {
        this.after = builder.after;
        this.before = builder.before;
    }

    /**
     * <p>
     * Filter to display command executions that started or completed only after a particular date and time.
     * </p>
     * 
     * @return Filter to display command executions that started or completed only after a particular date and time.
     */
    public final String after() {
        return after;
    }

    /**
     * <p>
     * Filter to display command executions that started or completed only before a particular date and time.
     * </p>
     * 
     * @return Filter to display command executions that started or completed only before a particular date and time.
     */
    public final String before() {
        return before;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(after());
        hashCode = 31 * hashCode + Objects.hashCode(before());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeFilter)) {
            return false;
        }
        TimeFilter other = (TimeFilter) obj;
        return Objects.equals(after(), other.after()) && Objects.equals(before(), other.before());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimeFilter").add("After", after()).add("Before", before()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "after":
            return Optional.ofNullable(clazz.cast(after()));
        case "before":
            return Optional.ofNullable(clazz.cast(before()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("after", AFTER_FIELD);
        map.put("before", BEFORE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TimeFilter, T> g) {
        return obj -> g.apply((TimeFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimeFilter> {
        /**
         * <p>
         * Filter to display command executions that started or completed only after a particular date and time.
         * </p>
         * 
         * @param after
         *        Filter to display command executions that started or completed only after a particular date and time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder after(String after);

        /**
         * <p>
         * Filter to display command executions that started or completed only before a particular date and time.
         * </p>
         * 
         * @param before
         *        Filter to display command executions that started or completed only before a particular date and time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder before(String before);
    }

    static final class BuilderImpl implements Builder {
        private String after;

        private String before;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeFilter model) {
            after(model.after);
            before(model.before);
        }

        public final String getAfter() {
            return after;
        }

        public final void setAfter(String after) {
            this.after = after;
        }

        @Override
        public final Builder after(String after) {
            this.after = after;
            return this;
        }

        public final String getBefore() {
            return before;
        }

        public final void setBefore(String before) {
            this.before = before;
        }

        @Override
        public final Builder before(String before) {
            this.before = before;
            return this;
        }

        @Override
        public TimeFilter build() {
            return new TimeFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
