/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Role alias description.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RoleAliasDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<RoleAliasDescription.Builder, RoleAliasDescription> {
    private static final SdkField<String> ROLE_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleAlias").getter(getter(RoleAliasDescription::roleAlias)).setter(setter(Builder::roleAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleAlias").build()).build();

    private static final SdkField<String> ROLE_ALIAS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleAliasArn").getter(getter(RoleAliasDescription::roleAliasArn)).setter(setter(Builder::roleAliasArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleAliasArn").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(RoleAliasDescription::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("owner")
            .getter(getter(RoleAliasDescription::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()).build();

    private static final SdkField<Integer> CREDENTIAL_DURATION_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("credentialDurationSeconds")
            .getter(getter(RoleAliasDescription::credentialDurationSeconds)).setter(setter(Builder::credentialDurationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialDurationSeconds").build())
            .build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate").getter(getter(RoleAliasDescription::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedDate").getter(getter(RoleAliasDescription::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ALIAS_FIELD,
            ROLE_ALIAS_ARN_FIELD, ROLE_ARN_FIELD, OWNER_FIELD, CREDENTIAL_DURATION_SECONDS_FIELD, CREATION_DATE_FIELD,
            LAST_MODIFIED_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String roleAlias;

    private final String roleAliasArn;

    private final String roleArn;

    private final String owner;

    private final Integer credentialDurationSeconds;

    private final Instant creationDate;

    private final Instant lastModifiedDate;

    private RoleAliasDescription(BuilderImpl builder) {
        this.roleAlias = builder.roleAlias;
        this.roleAliasArn = builder.roleAliasArn;
        this.roleArn = builder.roleArn;
        this.owner = builder.owner;
        this.credentialDurationSeconds = builder.credentialDurationSeconds;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    /**
     * <p>
     * The role alias.
     * </p>
     * 
     * @return The role alias.
     */
    public final String roleAlias() {
        return roleAlias;
    }

    /**
     * <p>
     * The ARN of the role alias.
     * </p>
     * 
     * @return The ARN of the role alias.
     */
    public final String roleAliasArn() {
        return roleAliasArn;
    }

    /**
     * <p>
     * The role ARN.
     * </p>
     * 
     * @return The role ARN.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The role alias owner.
     * </p>
     * 
     * @return The role alias owner.
     */
    public final String owner() {
        return owner;
    }

    /**
     * <p>
     * The number of seconds for which the credential is valid.
     * </p>
     * 
     * @return The number of seconds for which the credential is valid.
     */
    public final Integer credentialDurationSeconds() {
        return credentialDurationSeconds;
    }

    /**
     * <p>
     * The UNIX timestamp of when the role alias was created.
     * </p>
     * 
     * @return The UNIX timestamp of when the role alias was created.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The UNIX timestamp of when the role alias was last modified.
     * </p>
     * 
     * @return The UNIX timestamp of when the role alias was last modified.
     */
    public final Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleAlias());
        hashCode = 31 * hashCode + Objects.hashCode(roleAliasArn());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(credentialDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoleAliasDescription)) {
            return false;
        }
        RoleAliasDescription other = (RoleAliasDescription) obj;
        return Objects.equals(roleAlias(), other.roleAlias()) && Objects.equals(roleAliasArn(), other.roleAliasArn())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(owner(), other.owner())
                && Objects.equals(credentialDurationSeconds(), other.credentialDurationSeconds())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RoleAliasDescription").add("RoleAlias", roleAlias()).add("RoleAliasArn", roleAliasArn())
                .add("RoleArn", roleArn()).add("Owner", owner()).add("CredentialDurationSeconds", credentialDurationSeconds())
                .add("CreationDate", creationDate()).add("LastModifiedDate", lastModifiedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleAlias":
            return Optional.ofNullable(clazz.cast(roleAlias()));
        case "roleAliasArn":
            return Optional.ofNullable(clazz.cast(roleAliasArn()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "credentialDurationSeconds":
            return Optional.ofNullable(clazz.cast(credentialDurationSeconds()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "lastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("roleAlias", ROLE_ALIAS_FIELD);
        map.put("roleAliasArn", ROLE_ALIAS_ARN_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("owner", OWNER_FIELD);
        map.put("credentialDurationSeconds", CREDENTIAL_DURATION_SECONDS_FIELD);
        map.put("creationDate", CREATION_DATE_FIELD);
        map.put("lastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RoleAliasDescription, T> g) {
        return obj -> g.apply((RoleAliasDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RoleAliasDescription> {
        /**
         * <p>
         * The role alias.
         * </p>
         * 
         * @param roleAlias
         *        The role alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleAlias(String roleAlias);

        /**
         * <p>
         * The ARN of the role alias.
         * </p>
         * 
         * @param roleAliasArn
         *        The ARN of the role alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleAliasArn(String roleAliasArn);

        /**
         * <p>
         * The role ARN.
         * </p>
         * 
         * @param roleArn
         *        The role ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The role alias owner.
         * </p>
         * 
         * @param owner
         *        The role alias owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * The number of seconds for which the credential is valid.
         * </p>
         * 
         * @param credentialDurationSeconds
         *        The number of seconds for which the credential is valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialDurationSeconds(Integer credentialDurationSeconds);

        /**
         * <p>
         * The UNIX timestamp of when the role alias was created.
         * </p>
         * 
         * @param creationDate
         *        The UNIX timestamp of when the role alias was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The UNIX timestamp of when the role alias was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The UNIX timestamp of when the role alias was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);
    }

    static final class BuilderImpl implements Builder {
        private String roleAlias;

        private String roleAliasArn;

        private String roleArn;

        private String owner;

        private Integer credentialDurationSeconds;

        private Instant creationDate;

        private Instant lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(RoleAliasDescription model) {
            roleAlias(model.roleAlias);
            roleAliasArn(model.roleAliasArn);
            roleArn(model.roleArn);
            owner(model.owner);
            credentialDurationSeconds(model.credentialDurationSeconds);
            creationDate(model.creationDate);
            lastModifiedDate(model.lastModifiedDate);
        }

        public final String getRoleAlias() {
            return roleAlias;
        }

        public final void setRoleAlias(String roleAlias) {
            this.roleAlias = roleAlias;
        }

        @Override
        public final Builder roleAlias(String roleAlias) {
            this.roleAlias = roleAlias;
            return this;
        }

        public final String getRoleAliasArn() {
            return roleAliasArn;
        }

        public final void setRoleAliasArn(String roleAliasArn) {
            this.roleAliasArn = roleAliasArn;
        }

        @Override
        public final Builder roleAliasArn(String roleAliasArn) {
            this.roleAliasArn = roleAliasArn;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final Integer getCredentialDurationSeconds() {
            return credentialDurationSeconds;
        }

        public final void setCredentialDurationSeconds(Integer credentialDurationSeconds) {
            this.credentialDurationSeconds = credentialDurationSeconds;
        }

        @Override
        public final Builder credentialDurationSeconds(Integer credentialDurationSeconds) {
            this.credentialDurationSeconds = credentialDurationSeconds;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        @Override
        public RoleAliasDescription build() {
            return new RoleAliasDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
