/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCommandRequest extends IotRequest implements
        ToCopyableBuilder<UpdateCommandRequest.Builder, UpdateCommandRequest> {
    private static final SdkField<String> COMMAND_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("commandId").getter(getter(UpdateCommandRequest::commandId)).setter(setter(Builder::commandId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("commandId").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(UpdateCommandRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateCommandRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Boolean> DEPRECATED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("deprecated").getter(getter(UpdateCommandRequest::deprecated)).setter(setter(Builder::deprecated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deprecated").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMAND_ID_FIELD,
            DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, DEPRECATED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String commandId;

    private final String displayName;

    private final String description;

    private final Boolean deprecated;

    private UpdateCommandRequest(BuilderImpl builder) {
        super(builder);
        this.commandId = builder.commandId;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.deprecated = builder.deprecated;
    }

    /**
     * <p>
     * The unique identifier of the command to be updated.
     * </p>
     * 
     * @return The unique identifier of the command to be updated.
     */
    public final String commandId() {
        return commandId;
    }

    /**
     * <p>
     * The new user-friendly name to use in the console for the command.
     * </p>
     * 
     * @return The new user-friendly name to use in the console for the command.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * A short text description of the command.
     * </p>
     * 
     * @return A short text description of the command.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A boolean that you can use to specify whether to deprecate a command.
     * </p>
     * 
     * @return A boolean that you can use to specify whether to deprecate a command.
     */
    public final Boolean deprecated() {
        return deprecated;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(commandId());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(deprecated());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCommandRequest)) {
            return false;
        }
        UpdateCommandRequest other = (UpdateCommandRequest) obj;
        return Objects.equals(commandId(), other.commandId()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(description(), other.description()) && Objects.equals(deprecated(), other.deprecated());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateCommandRequest").add("CommandId", commandId()).add("DisplayName", displayName())
                .add("Description", description()).add("Deprecated", deprecated()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "commandId":
            return Optional.ofNullable(clazz.cast(commandId()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "deprecated":
            return Optional.ofNullable(clazz.cast(deprecated()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("commandId", COMMAND_ID_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("deprecated", DEPRECATED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCommandRequest, T> g) {
        return obj -> g.apply((UpdateCommandRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateCommandRequest> {
        /**
         * <p>
         * The unique identifier of the command to be updated.
         * </p>
         * 
         * @param commandId
         *        The unique identifier of the command to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commandId(String commandId);

        /**
         * <p>
         * The new user-friendly name to use in the console for the command.
         * </p>
         * 
         * @param displayName
         *        The new user-friendly name to use in the console for the command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * A short text description of the command.
         * </p>
         * 
         * @param description
         *        A short text description of the command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A boolean that you can use to specify whether to deprecate a command.
         * </p>
         * 
         * @param deprecated
         *        A boolean that you can use to specify whether to deprecate a command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deprecated(Boolean deprecated);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String commandId;

        private String displayName;

        private String description;

        private Boolean deprecated;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCommandRequest model) {
            super(model);
            commandId(model.commandId);
            displayName(model.displayName);
            description(model.description);
            deprecated(model.deprecated);
        }

        public final String getCommandId() {
            return commandId;
        }

        public final void setCommandId(String commandId) {
            this.commandId = commandId;
        }

        @Override
        public final Builder commandId(String commandId) {
            this.commandId = commandId;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getDeprecated() {
            return deprecated;
        }

        public final void setDeprecated(Boolean deprecated) {
            this.deprecated = deprecated;
        }

        @Override
        public final Builder deprecated(Boolean deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCommandRequest build() {
            return new UpdateCommandRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
