/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.DomainConfigurationSummary;
import software.amazon.awssdk.services.iot.model.DomainConfigurationsCopier;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDomainConfigurationsResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListDomainConfigurationsResponse> {
    private static final SdkField<List<DomainConfigurationSummary>> DOMAIN_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("domainConfigurations").getter(ListDomainConfigurationsResponse.getter(ListDomainConfigurationsResponse::domainConfigurations)).setter(ListDomainConfigurationsResponse.setter(Builder::domainConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DomainConfigurationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextMarker").getter(ListDomainConfigurationsResponse.getter(ListDomainConfigurationsResponse::nextMarker)).setter(ListDomainConfigurationsResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextMarker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_CONFIGURATIONS_FIELD, NEXT_MARKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDomainConfigurationsResponse.memberNameToFieldInitializer();
    private final List<DomainConfigurationSummary> domainConfigurations;
    private final String nextMarker;

    private ListDomainConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.domainConfigurations = builder.domainConfigurations;
        this.nextMarker = builder.nextMarker;
    }

    public final boolean hasDomainConfigurations() {
        return this.domainConfigurations != null && !(this.domainConfigurations instanceof SdkAutoConstructList);
    }

    public final List<DomainConfigurationSummary> domainConfigurations() {
        return this.domainConfigurations;
    }

    public final String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDomainConfigurations() ? this.domainConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDomainConfigurationsResponse)) {
            return false;
        }
        ListDomainConfigurationsResponse other = (ListDomainConfigurationsResponse)((Object)obj);
        return this.hasDomainConfigurations() == other.hasDomainConfigurations() && Objects.equals(this.domainConfigurations(), other.domainConfigurations()) && Objects.equals(this.nextMarker(), other.nextMarker());
    }

    public final String toString() {
        return ToString.builder((String)"ListDomainConfigurationsResponse").add("DomainConfigurations", this.hasDomainConfigurations() ? this.domainConfigurations() : null).add("NextMarker", (Object)this.nextMarker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainConfigurations": {
                return Optional.ofNullable(clazz.cast(this.domainConfigurations()));
            }
            case "nextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("domainConfigurations", DOMAIN_CONFIGURATIONS_FIELD);
        map.put("nextMarker", NEXT_MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDomainConfigurationsResponse, T> g) {
        return obj -> g.apply((ListDomainConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<DomainConfigurationSummary> domainConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDomainConfigurationsResponse model) {
            super(model);
            this.domainConfigurations(model.domainConfigurations);
            this.nextMarker(model.nextMarker);
        }

        public final List<DomainConfigurationSummary.Builder> getDomainConfigurations() {
            List<DomainConfigurationSummary.Builder> result = DomainConfigurationsCopier.copyToBuilder(this.domainConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDomainConfigurations(Collection<DomainConfigurationSummary.BuilderImpl> domainConfigurations) {
            this.domainConfigurations = DomainConfigurationsCopier.copyFromBuilder(domainConfigurations);
        }

        @Override
        public final Builder domainConfigurations(Collection<DomainConfigurationSummary> domainConfigurations) {
            this.domainConfigurations = DomainConfigurationsCopier.copy(domainConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainConfigurations(DomainConfigurationSummary ... domainConfigurations) {
            this.domainConfigurations(Arrays.asList(domainConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainConfigurations(Consumer<DomainConfigurationSummary.Builder> ... domainConfigurations) {
            this.domainConfigurations(Stream.of(domainConfigurations).map(c -> (DomainConfigurationSummary)((DomainConfigurationSummary.Builder)DomainConfigurationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        @Override
        public ListDomainConfigurationsResponse build() {
            return new ListDomainConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDomainConfigurationsResponse> {
        public Builder domainConfigurations(Collection<DomainConfigurationSummary> var1);

        public Builder domainConfigurations(DomainConfigurationSummary ... var1);

        public Builder domainConfigurations(Consumer<DomainConfigurationSummary.Builder> ... var1);

        public Builder nextMarker(String var1);
    }
}

