/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for the ListThingTypes operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListThingTypesResponse extends IotResponse implements
        ToCopyableBuilder<ListThingTypesResponse.Builder, ListThingTypesResponse> {
    private static final SdkField<List<ThingTypeDefinition>> THING_TYPES_FIELD = SdkField
            .<List<ThingTypeDefinition>> builder(MarshallingType.LIST)
            .memberName("thingTypes")
            .getter(getter(ListThingTypesResponse::thingTypes))
            .setter(setter(Builder::thingTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ThingTypeDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(ThingTypeDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListThingTypesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_TYPES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ThingTypeDefinition> thingTypes;

    private final String nextToken;

    private ListThingTypesResponse(BuilderImpl builder) {
        super(builder);
        this.thingTypes = builder.thingTypes;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ThingTypes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasThingTypes() {
        return thingTypes != null && !(thingTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The thing types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasThingTypes} method.
     * </p>
     * 
     * @return The thing types.
     */
    public final List<ThingTypeDefinition> thingTypes() {
        return thingTypes;
    }

    /**
     * <p>
     * The token for the next set of results. Will not be returned if operation has returned all results.
     * </p>
     * 
     * @return The token for the next set of results. Will not be returned if operation has returned all results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasThingTypes() ? thingTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListThingTypesResponse)) {
            return false;
        }
        ListThingTypesResponse other = (ListThingTypesResponse) obj;
        return hasThingTypes() == other.hasThingTypes() && Objects.equals(thingTypes(), other.thingTypes())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListThingTypesResponse").add("ThingTypes", hasThingTypes() ? thingTypes() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingTypes":
            return Optional.ofNullable(clazz.cast(thingTypes()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("thingTypes", THING_TYPES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListThingTypesResponse, T> g) {
        return obj -> g.apply((ListThingTypesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListThingTypesResponse> {
        /**
         * <p>
         * The thing types.
         * </p>
         * 
         * @param thingTypes
         *        The thing types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingTypes(Collection<ThingTypeDefinition> thingTypes);

        /**
         * <p>
         * The thing types.
         * </p>
         * 
         * @param thingTypes
         *        The thing types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingTypes(ThingTypeDefinition... thingTypes);

        /**
         * <p>
         * The thing types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iot.model.ThingTypeDefinition.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iot.model.ThingTypeDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iot.model.ThingTypeDefinition.Builder#build()} is called immediately
         * and its result is passed to {@link #thingTypes(List<ThingTypeDefinition>)}.
         * 
         * @param thingTypes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iot.model.ThingTypeDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #thingTypes(java.util.Collection<ThingTypeDefinition>)
         */
        Builder thingTypes(Consumer<ThingTypeDefinition.Builder>... thingTypes);

        /**
         * <p>
         * The token for the next set of results. Will not be returned if operation has returned all results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. Will not be returned if operation has returned all results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<ThingTypeDefinition> thingTypes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListThingTypesResponse model) {
            super(model);
            thingTypes(model.thingTypes);
            nextToken(model.nextToken);
        }

        public final List<ThingTypeDefinition.Builder> getThingTypes() {
            List<ThingTypeDefinition.Builder> result = ThingTypeListCopier.copyToBuilder(this.thingTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThingTypes(Collection<ThingTypeDefinition.BuilderImpl> thingTypes) {
            this.thingTypes = ThingTypeListCopier.copyFromBuilder(thingTypes);
        }

        @Override
        public final Builder thingTypes(Collection<ThingTypeDefinition> thingTypes) {
            this.thingTypes = ThingTypeListCopier.copy(thingTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thingTypes(ThingTypeDefinition... thingTypes) {
            thingTypes(Arrays.asList(thingTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thingTypes(Consumer<ThingTypeDefinition.Builder>... thingTypes) {
            thingTypes(Stream.of(thingTypes).map(c -> ThingTypeDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListThingTypesResponse build() {
            return new ListThingTypesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
