/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output from the DescribeEndpoint operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEndpointResponse extends IotResponse implements
        ToCopyableBuilder<DescribeEndpointResponse.Builder, DescribeEndpointResponse> {
    private static final SdkField<String> ENDPOINT_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endpointAddress").getter(getter(DescribeEndpointResponse::endpointAddress))
            .setter(setter(Builder::endpointAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointAddress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_ADDRESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String endpointAddress;

    private DescribeEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.endpointAddress = builder.endpointAddress;
    }

    /**
     * <p>
     * The endpoint. The format of the endpoint is as follows: <i>identifier</i>.iot.<i>region</i>.amazonaws.com.
     * </p>
     * 
     * @return The endpoint. The format of the endpoint is as follows:
     *         <i>identifier</i>.iot.<i>region</i>.amazonaws.com.
     */
    public final String endpointAddress() {
        return endpointAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endpointAddress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEndpointResponse)) {
            return false;
        }
        DescribeEndpointResponse other = (DescribeEndpointResponse) obj;
        return Objects.equals(endpointAddress(), other.endpointAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEndpointResponse").add("EndpointAddress", endpointAddress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "endpointAddress":
            return Optional.ofNullable(clazz.cast(endpointAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("endpointAddress", ENDPOINT_ADDRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeEndpointResponse, T> g) {
        return obj -> g.apply((DescribeEndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeEndpointResponse> {
        /**
         * <p>
         * The endpoint. The format of the endpoint is as follows: <i>identifier</i>.iot.<i>region</i>.amazonaws.com.
         * </p>
         * 
         * @param endpointAddress
         *        The endpoint. The format of the endpoint is as follows:
         *        <i>identifier</i>.iot.<i>region</i>.amazonaws.com.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointAddress(String endpointAddress);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String endpointAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEndpointResponse model) {
            super(model);
            endpointAddress(model.endpointAddress);
        }

        public final String getEndpointAddress() {
            return endpointAddress;
        }

        public final void setEndpointAddress(String endpointAddress) {
            this.endpointAddress = endpointAddress;
        }

        @Override
        public final Builder endpointAddress(String endpointAddress) {
            this.endpointAddress = endpointAddress;
            return this;
        }

        @Override
        public DescribeEndpointResponse build() {
            return new DescribeEndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
