/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDimensionResponse extends IotResponse implements
        ToCopyableBuilder<DescribeDimensionResponse.Builder, DescribeDimensionResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DescribeDimensionResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(DescribeDimensionResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(DescribeDimensionResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<List<String>> STRING_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("stringValues")
            .getter(getter(DescribeDimensionResponse::stringValues))
            .setter(setter(Builder::stringValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate").getter(getter(DescribeDimensionResponse::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedDate").getter(getter(DescribeDimensionResponse::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD,
            TYPE_FIELD, STRING_VALUES_FIELD, CREATION_DATE_FIELD, LAST_MODIFIED_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String arn;

    private final String type;

    private final List<String> stringValues;

    private final Instant creationDate;

    private final Instant lastModifiedDate;

    private DescribeDimensionResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.arn = builder.arn;
        this.type = builder.type;
        this.stringValues = builder.stringValues;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    /**
     * <p>
     * The unique identifier for the dimension.
     * </p>
     * 
     * @return The unique identifier for the dimension.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the dimension.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the dimension.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The type of the dimension.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DimensionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the dimension.
     * @see DimensionType
     */
    public final DimensionType type() {
        return DimensionType.fromValue(type);
    }

    /**
     * <p>
     * The type of the dimension.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DimensionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the dimension.
     * @see DimensionType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * For responses, this returns true if the service returned a value for the StringValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStringValues() {
        return stringValues != null && !(stringValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The value or list of values used to scope the dimension. For example, for topic filters, this is the pattern used
     * to match the MQTT topic name.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStringValues} method.
     * </p>
     * 
     * @return The value or list of values used to scope the dimension. For example, for topic filters, this is the
     *         pattern used to match the MQTT topic name.
     */
    public final List<String> stringValues() {
        return stringValues;
    }

    /**
     * <p>
     * The date the dimension was created.
     * </p>
     * 
     * @return The date the dimension was created.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The date the dimension was last modified.
     * </p>
     * 
     * @return The date the dimension was last modified.
     */
    public final Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasStringValues() ? stringValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDimensionResponse)) {
            return false;
        }
        DescribeDimensionResponse other = (DescribeDimensionResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(typeAsString(), other.typeAsString()) && hasStringValues() == other.hasStringValues()
                && Objects.equals(stringValues(), other.stringValues()) && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDimensionResponse").add("Name", name()).add("Arn", arn()).add("Type", typeAsString())
                .add("StringValues", hasStringValues() ? stringValues() : null).add("CreationDate", creationDate())
                .add("LastModifiedDate", lastModifiedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "stringValues":
            return Optional.ofNullable(clazz.cast(stringValues()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "lastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("stringValues", STRING_VALUES_FIELD);
        map.put("creationDate", CREATION_DATE_FIELD);
        map.put("lastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDimensionResponse, T> g) {
        return obj -> g.apply((DescribeDimensionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDimensionResponse> {
        /**
         * <p>
         * The unique identifier for the dimension.
         * </p>
         * 
         * @param name
         *        The unique identifier for the dimension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the dimension.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) for the dimension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The type of the dimension.
         * </p>
         * 
         * @param type
         *        The type of the dimension.
         * @see DimensionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DimensionType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the dimension.
         * </p>
         * 
         * @param type
         *        The type of the dimension.
         * @see DimensionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DimensionType
         */
        Builder type(DimensionType type);

        /**
         * <p>
         * The value or list of values used to scope the dimension. For example, for topic filters, this is the pattern
         * used to match the MQTT topic name.
         * </p>
         * 
         * @param stringValues
         *        The value or list of values used to scope the dimension. For example, for topic filters, this is the
         *        pattern used to match the MQTT topic name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValues(Collection<String> stringValues);

        /**
         * <p>
         * The value or list of values used to scope the dimension. For example, for topic filters, this is the pattern
         * used to match the MQTT topic name.
         * </p>
         * 
         * @param stringValues
         *        The value or list of values used to scope the dimension. For example, for topic filters, this is the
         *        pattern used to match the MQTT topic name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValues(String... stringValues);

        /**
         * <p>
         * The date the dimension was created.
         * </p>
         * 
         * @param creationDate
         *        The date the dimension was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The date the dimension was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date the dimension was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String name;

        private String arn;

        private String type;

        private List<String> stringValues = DefaultSdkAutoConstructList.getInstance();

        private Instant creationDate;

        private Instant lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDimensionResponse model) {
            super(model);
            name(model.name);
            arn(model.arn);
            type(model.type);
            stringValues(model.stringValues);
            creationDate(model.creationDate);
            lastModifiedDate(model.lastModifiedDate);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DimensionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Collection<String> getStringValues() {
            if (stringValues instanceof SdkAutoConstructList) {
                return null;
            }
            return stringValues;
        }

        public final void setStringValues(Collection<String> stringValues) {
            this.stringValues = DimensionStringValuesCopier.copy(stringValues);
        }

        @Override
        public final Builder stringValues(Collection<String> stringValues) {
            this.stringValues = DimensionStringValuesCopier.copy(stringValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringValues(String... stringValues) {
            stringValues(Arrays.asList(stringValues));
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        @Override
        public DescribeDimensionResponse build() {
            return new DescribeDimensionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
