/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the connection attribute, thing attribute, and the user property key.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PropagatingAttribute implements SdkPojo, Serializable,
        ToCopyableBuilder<PropagatingAttribute.Builder, PropagatingAttribute> {
    private static final SdkField<String> USER_PROPERTY_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userPropertyKey").getter(getter(PropagatingAttribute::userPropertyKey))
            .setter(setter(Builder::userPropertyKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userPropertyKey").build()).build();

    private static final SdkField<String> THING_ATTRIBUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingAttribute").getter(getter(PropagatingAttribute::thingAttribute))
            .setter(setter(Builder::thingAttribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingAttribute").build()).build();

    private static final SdkField<String> CONNECTION_ATTRIBUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectionAttribute").getter(getter(PropagatingAttribute::connectionAttribute))
            .setter(setter(Builder::connectionAttribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionAttribute").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_PROPERTY_KEY_FIELD,
            THING_ATTRIBUTE_FIELD, CONNECTION_ATTRIBUTE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String userPropertyKey;

    private final String thingAttribute;

    private final String connectionAttribute;

    private PropagatingAttribute(BuilderImpl builder) {
        this.userPropertyKey = builder.userPropertyKey;
        this.thingAttribute = builder.thingAttribute;
        this.connectionAttribute = builder.connectionAttribute;
    }

    /**
     * <p>
     * The key of the user property key-value pair.
     * </p>
     * 
     * @return The key of the user property key-value pair.
     */
    public final String userPropertyKey() {
        return userPropertyKey;
    }

    /**
     * <p>
     * The user-defined thing attribute that is propagating for MQTT 5 message enrichment.
     * </p>
     * 
     * @return The user-defined thing attribute that is propagating for MQTT 5 message enrichment.
     */
    public final String thingAttribute() {
        return thingAttribute;
    }

    /**
     * <p>
     * The attribute associated with the connection between a device and Amazon Web Services IoT Core.
     * </p>
     * 
     * @return The attribute associated with the connection between a device and Amazon Web Services IoT Core.
     */
    public final String connectionAttribute() {
        return connectionAttribute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userPropertyKey());
        hashCode = 31 * hashCode + Objects.hashCode(thingAttribute());
        hashCode = 31 * hashCode + Objects.hashCode(connectionAttribute());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropagatingAttribute)) {
            return false;
        }
        PropagatingAttribute other = (PropagatingAttribute) obj;
        return Objects.equals(userPropertyKey(), other.userPropertyKey())
                && Objects.equals(thingAttribute(), other.thingAttribute())
                && Objects.equals(connectionAttribute(), other.connectionAttribute());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PropagatingAttribute").add("UserPropertyKey", userPropertyKey())
                .add("ThingAttribute", thingAttribute()).add("ConnectionAttribute", connectionAttribute()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "userPropertyKey":
            return Optional.ofNullable(clazz.cast(userPropertyKey()));
        case "thingAttribute":
            return Optional.ofNullable(clazz.cast(thingAttribute()));
        case "connectionAttribute":
            return Optional.ofNullable(clazz.cast(connectionAttribute()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("userPropertyKey", USER_PROPERTY_KEY_FIELD);
        map.put("thingAttribute", THING_ATTRIBUTE_FIELD);
        map.put("connectionAttribute", CONNECTION_ATTRIBUTE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PropagatingAttribute, T> g) {
        return obj -> g.apply((PropagatingAttribute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PropagatingAttribute> {
        /**
         * <p>
         * The key of the user property key-value pair.
         * </p>
         * 
         * @param userPropertyKey
         *        The key of the user property key-value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPropertyKey(String userPropertyKey);

        /**
         * <p>
         * The user-defined thing attribute that is propagating for MQTT 5 message enrichment.
         * </p>
         * 
         * @param thingAttribute
         *        The user-defined thing attribute that is propagating for MQTT 5 message enrichment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingAttribute(String thingAttribute);

        /**
         * <p>
         * The attribute associated with the connection between a device and Amazon Web Services IoT Core.
         * </p>
         * 
         * @param connectionAttribute
         *        The attribute associated with the connection between a device and Amazon Web Services IoT Core.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionAttribute(String connectionAttribute);
    }

    static final class BuilderImpl implements Builder {
        private String userPropertyKey;

        private String thingAttribute;

        private String connectionAttribute;

        private BuilderImpl() {
        }

        private BuilderImpl(PropagatingAttribute model) {
            userPropertyKey(model.userPropertyKey);
            thingAttribute(model.thingAttribute);
            connectionAttribute(model.connectionAttribute);
        }

        public final String getUserPropertyKey() {
            return userPropertyKey;
        }

        public final void setUserPropertyKey(String userPropertyKey) {
            this.userPropertyKey = userPropertyKey;
        }

        @Override
        public final Builder userPropertyKey(String userPropertyKey) {
            this.userPropertyKey = userPropertyKey;
            return this;
        }

        public final String getThingAttribute() {
            return thingAttribute;
        }

        public final void setThingAttribute(String thingAttribute) {
            this.thingAttribute = thingAttribute;
        }

        @Override
        public final Builder thingAttribute(String thingAttribute) {
            this.thingAttribute = thingAttribute;
            return this;
        }

        public final String getConnectionAttribute() {
            return connectionAttribute;
        }

        public final void setConnectionAttribute(String connectionAttribute) {
            this.connectionAttribute = connectionAttribute;
        }

        @Override
        public final Builder connectionAttribute(String connectionAttribute) {
            this.connectionAttribute = connectionAttribute;
            return this;
        }

        @Override
        public PropagatingAttribute build() {
            return new PropagatingAttribute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
