/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTopicRuleDestinationResponse extends IotResponse implements
        ToCopyableBuilder<GetTopicRuleDestinationResponse.Builder, GetTopicRuleDestinationResponse> {
    private static final SdkField<TopicRuleDestination> TOPIC_RULE_DESTINATION_FIELD = SdkField
            .<TopicRuleDestination> builder(MarshallingType.SDK_POJO).memberName("topicRuleDestination")
            .getter(getter(GetTopicRuleDestinationResponse::topicRuleDestination)).setter(setter(Builder::topicRuleDestination))
            .constructor(TopicRuleDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicRuleDestination").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_RULE_DESTINATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final TopicRuleDestination topicRuleDestination;

    private GetTopicRuleDestinationResponse(BuilderImpl builder) {
        super(builder);
        this.topicRuleDestination = builder.topicRuleDestination;
    }

    /**
     * <p>
     * The topic rule destination.
     * </p>
     * 
     * @return The topic rule destination.
     */
    public final TopicRuleDestination topicRuleDestination() {
        return topicRuleDestination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(topicRuleDestination());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTopicRuleDestinationResponse)) {
            return false;
        }
        GetTopicRuleDestinationResponse other = (GetTopicRuleDestinationResponse) obj;
        return Objects.equals(topicRuleDestination(), other.topicRuleDestination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTopicRuleDestinationResponse").add("TopicRuleDestination", topicRuleDestination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "topicRuleDestination":
            return Optional.ofNullable(clazz.cast(topicRuleDestination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("topicRuleDestination", TOPIC_RULE_DESTINATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTopicRuleDestinationResponse, T> g) {
        return obj -> g.apply((GetTopicRuleDestinationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTopicRuleDestinationResponse> {
        /**
         * <p>
         * The topic rule destination.
         * </p>
         * 
         * @param topicRuleDestination
         *        The topic rule destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicRuleDestination(TopicRuleDestination topicRuleDestination);

        /**
         * <p>
         * The topic rule destination.
         * </p>
         * This is a convenience method that creates an instance of the {@link TopicRuleDestination.Builder} avoiding
         * the need to create one manually via {@link TopicRuleDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TopicRuleDestination.Builder#build()} is called immediately and
         * its result is passed to {@link #topicRuleDestination(TopicRuleDestination)}.
         * 
         * @param topicRuleDestination
         *        a consumer that will call methods on {@link TopicRuleDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #topicRuleDestination(TopicRuleDestination)
         */
        default Builder topicRuleDestination(Consumer<TopicRuleDestination.Builder> topicRuleDestination) {
            return topicRuleDestination(TopicRuleDestination.builder().applyMutation(topicRuleDestination).build());
        }
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private TopicRuleDestination topicRuleDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTopicRuleDestinationResponse model) {
            super(model);
            topicRuleDestination(model.topicRuleDestination);
        }

        public final TopicRuleDestination.Builder getTopicRuleDestination() {
            return topicRuleDestination != null ? topicRuleDestination.toBuilder() : null;
        }

        public final void setTopicRuleDestination(TopicRuleDestination.BuilderImpl topicRuleDestination) {
            this.topicRuleDestination = topicRuleDestination != null ? topicRuleDestination.build() : null;
        }

        @Override
        public final Builder topicRuleDestination(TopicRuleDestination topicRuleDestination) {
            this.topicRuleDestination = topicRuleDestination;
            return this;
        }

        @Override
        public GetTopicRuleDestinationResponse build() {
            return new GetTopicRuleDestinationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
