/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMetricValuesRequest extends IotRequest implements
        ToCopyableBuilder<ListMetricValuesRequest.Builder, ListMetricValuesRequest> {
    private static final SdkField<String> THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingName").getter(getter(ListMetricValuesRequest::thingName)).setter(setter(Builder::thingName))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("thingName").build()).build();

    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metricName").getter(getter(ListMetricValuesRequest::metricName)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("metricName").build()).build();

    private static final SdkField<String> DIMENSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dimensionName").getter(getter(ListMetricValuesRequest::dimensionName))
            .setter(setter(Builder::dimensionName))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("dimensionName").build()).build();

    private static final SdkField<String> DIMENSION_VALUE_OPERATOR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("dimensionValueOperator")
            .getter(getter(ListMetricValuesRequest::dimensionValueOperatorAsString))
            .setter(setter(Builder::dimensionValueOperator))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("dimensionValueOperator").build())
            .build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(ListMetricValuesRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(ListMetricValuesRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("endTime").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListMetricValuesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListMetricValuesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_NAME_FIELD,
            METRIC_NAME_FIELD, DIMENSION_NAME_FIELD, DIMENSION_VALUE_OPERATOR_FIELD, START_TIME_FIELD, END_TIME_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String thingName;

    private final String metricName;

    private final String dimensionName;

    private final String dimensionValueOperator;

    private final Instant startTime;

    private final Instant endTime;

    private final Integer maxResults;

    private final String nextToken;

    private ListMetricValuesRequest(BuilderImpl builder) {
        super(builder);
        this.thingName = builder.thingName;
        this.metricName = builder.metricName;
        this.dimensionName = builder.dimensionName;
        this.dimensionValueOperator = builder.dimensionValueOperator;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the thing for which security profile metric values are returned.
     * </p>
     * 
     * @return The name of the thing for which security profile metric values are returned.
     */
    public final String thingName() {
        return thingName;
    }

    /**
     * <p>
     * The name of the security profile metric for which values are returned.
     * </p>
     * 
     * @return The name of the security profile metric for which values are returned.
     */
    public final String metricName() {
        return metricName;
    }

    /**
     * <p>
     * The dimension name.
     * </p>
     * 
     * @return The dimension name.
     */
    public final String dimensionName() {
        return dimensionName;
    }

    /**
     * <p>
     * The dimension value operator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dimensionValueOperator} will return {@link DimensionValueOperator#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dimensionValueOperatorAsString}.
     * </p>
     * 
     * @return The dimension value operator.
     * @see DimensionValueOperator
     */
    public final DimensionValueOperator dimensionValueOperator() {
        return DimensionValueOperator.fromValue(dimensionValueOperator);
    }

    /**
     * <p>
     * The dimension value operator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dimensionValueOperator} will return {@link DimensionValueOperator#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dimensionValueOperatorAsString}.
     * </p>
     * 
     * @return The dimension value operator.
     * @see DimensionValueOperator
     */
    public final String dimensionValueOperatorAsString() {
        return dimensionValueOperator;
    }

    /**
     * <p>
     * The start of the time period for which metric values are returned.
     * </p>
     * 
     * @return The start of the time period for which metric values are returned.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end of the time period for which metric values are returned.
     * </p>
     * 
     * @return The end of the time period for which metric values are returned.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The maximum number of results to return at one time.
     * </p>
     * 
     * @return The maximum number of results to return at one time.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of results.
     * </p>
     * 
     * @return The token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(dimensionName());
        hashCode = 31 * hashCode + Objects.hashCode(dimensionValueOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMetricValuesRequest)) {
            return false;
        }
        ListMetricValuesRequest other = (ListMetricValuesRequest) obj;
        return Objects.equals(thingName(), other.thingName()) && Objects.equals(metricName(), other.metricName())
                && Objects.equals(dimensionName(), other.dimensionName())
                && Objects.equals(dimensionValueOperatorAsString(), other.dimensionValueOperatorAsString())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMetricValuesRequest").add("ThingName", thingName()).add("MetricName", metricName())
                .add("DimensionName", dimensionName()).add("DimensionValueOperator", dimensionValueOperatorAsString())
                .add("StartTime", startTime()).add("EndTime", endTime()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingName":
            return Optional.ofNullable(clazz.cast(thingName()));
        case "metricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "dimensionName":
            return Optional.ofNullable(clazz.cast(dimensionName()));
        case "dimensionValueOperator":
            return Optional.ofNullable(clazz.cast(dimensionValueOperatorAsString()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("thingName", THING_NAME_FIELD);
        map.put("metricName", METRIC_NAME_FIELD);
        map.put("dimensionName", DIMENSION_NAME_FIELD);
        map.put("dimensionValueOperator", DIMENSION_VALUE_OPERATOR_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMetricValuesRequest, T> g) {
        return obj -> g.apply((ListMetricValuesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListMetricValuesRequest> {
        /**
         * <p>
         * The name of the thing for which security profile metric values are returned.
         * </p>
         * 
         * @param thingName
         *        The name of the thing for which security profile metric values are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * The name of the security profile metric for which values are returned.
         * </p>
         * 
         * @param metricName
         *        The name of the security profile metric for which values are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The dimension name.
         * </p>
         * 
         * @param dimensionName
         *        The dimension name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionName(String dimensionName);

        /**
         * <p>
         * The dimension value operator.
         * </p>
         * 
         * @param dimensionValueOperator
         *        The dimension value operator.
         * @see DimensionValueOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DimensionValueOperator
         */
        Builder dimensionValueOperator(String dimensionValueOperator);

        /**
         * <p>
         * The dimension value operator.
         * </p>
         * 
         * @param dimensionValueOperator
         *        The dimension value operator.
         * @see DimensionValueOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DimensionValueOperator
         */
        Builder dimensionValueOperator(DimensionValueOperator dimensionValueOperator);

        /**
         * <p>
         * The start of the time period for which metric values are returned.
         * </p>
         * 
         * @param startTime
         *        The start of the time period for which metric values are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end of the time period for which metric values are returned.
         * </p>
         * 
         * @param endTime
         *        The end of the time period for which metric values are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The maximum number of results to return at one time.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return at one time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String thingName;

        private String metricName;

        private String dimensionName;

        private String dimensionValueOperator;

        private Instant startTime;

        private Instant endTime;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMetricValuesRequest model) {
            super(model);
            thingName(model.thingName);
            metricName(model.metricName);
            dimensionName(model.dimensionName);
            dimensionValueOperator(model.dimensionValueOperator);
            startTime(model.startTime);
            endTime(model.endTime);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getThingName() {
            return thingName;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final String getMetricName() {
            return metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getDimensionName() {
            return dimensionName;
        }

        public final void setDimensionName(String dimensionName) {
            this.dimensionName = dimensionName;
        }

        @Override
        public final Builder dimensionName(String dimensionName) {
            this.dimensionName = dimensionName;
            return this;
        }

        public final String getDimensionValueOperator() {
            return dimensionValueOperator;
        }

        public final void setDimensionValueOperator(String dimensionValueOperator) {
            this.dimensionValueOperator = dimensionValueOperator;
        }

        @Override
        public final Builder dimensionValueOperator(String dimensionValueOperator) {
            this.dimensionValueOperator = dimensionValueOperator;
            return this;
        }

        @Override
        public final Builder dimensionValueOperator(DimensionValueOperator dimensionValueOperator) {
            this.dimensionValueOperator(dimensionValueOperator == null ? null : dimensionValueOperator.toString());
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListMetricValuesRequest build() {
            return new ListMetricValuesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
