/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePackageConfigurationRequest extends IotRequest implements
        ToCopyableBuilder<UpdatePackageConfigurationRequest.Builder, UpdatePackageConfigurationRequest> {
    private static final SdkField<VersionUpdateByJobsConfig> VERSION_UPDATE_BY_JOBS_CONFIG_FIELD = SdkField
            .<VersionUpdateByJobsConfig> builder(MarshallingType.SDK_POJO).memberName("versionUpdateByJobsConfig")
            .getter(getter(UpdatePackageConfigurationRequest::versionUpdateByJobsConfig))
            .setter(setter(Builder::versionUpdateByJobsConfig)).constructor(VersionUpdateByJobsConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionUpdateByJobsConfig").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdatePackageConfigurationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VERSION_UPDATE_BY_JOBS_CONFIG_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final VersionUpdateByJobsConfig versionUpdateByJobsConfig;

    private final String clientToken;

    private UpdatePackageConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.versionUpdateByJobsConfig = builder.versionUpdateByJobsConfig;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * Configuration to manage job's package version reporting. This updates the thing's reserved named shadow that the
     * job targets.
     * </p>
     * 
     * @return Configuration to manage job's package version reporting. This updates the thing's reserved named shadow
     *         that the job targets.
     */
    public final VersionUpdateByJobsConfig versionUpdateByJobsConfig() {
        return versionUpdateByJobsConfig;
    }

    /**
     * <p>
     * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
     * this client token if a new idempotent request is required.
     * </p>
     * 
     * @return A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't
     *         reuse this client token if a new idempotent request is required.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(versionUpdateByJobsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePackageConfigurationRequest)) {
            return false;
        }
        UpdatePackageConfigurationRequest other = (UpdatePackageConfigurationRequest) obj;
        return Objects.equals(versionUpdateByJobsConfig(), other.versionUpdateByJobsConfig())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePackageConfigurationRequest")
                .add("VersionUpdateByJobsConfig", versionUpdateByJobsConfig()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "versionUpdateByJobsConfig":
            return Optional.ofNullable(clazz.cast(versionUpdateByJobsConfig()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("versionUpdateByJobsConfig", VERSION_UPDATE_BY_JOBS_CONFIG_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePackageConfigurationRequest, T> g) {
        return obj -> g.apply((UpdatePackageConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdatePackageConfigurationRequest> {
        /**
         * <p>
         * Configuration to manage job's package version reporting. This updates the thing's reserved named shadow that
         * the job targets.
         * </p>
         * 
         * @param versionUpdateByJobsConfig
         *        Configuration to manage job's package version reporting. This updates the thing's reserved named
         *        shadow that the job targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionUpdateByJobsConfig(VersionUpdateByJobsConfig versionUpdateByJobsConfig);

        /**
         * <p>
         * Configuration to manage job's package version reporting. This updates the thing's reserved named shadow that
         * the job targets.
         * </p>
         * This is a convenience method that creates an instance of the {@link VersionUpdateByJobsConfig.Builder}
         * avoiding the need to create one manually via {@link VersionUpdateByJobsConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VersionUpdateByJobsConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #versionUpdateByJobsConfig(VersionUpdateByJobsConfig)}.
         * 
         * @param versionUpdateByJobsConfig
         *        a consumer that will call methods on {@link VersionUpdateByJobsConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #versionUpdateByJobsConfig(VersionUpdateByJobsConfig)
         */
        default Builder versionUpdateByJobsConfig(Consumer<VersionUpdateByJobsConfig.Builder> versionUpdateByJobsConfig) {
            return versionUpdateByJobsConfig(VersionUpdateByJobsConfig.builder().applyMutation(versionUpdateByJobsConfig).build());
        }

        /**
         * <p>
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
         * this client token if a new idempotent request is required.
         * </p>
         * 
         * @param clientToken
         *        A unique case-sensitive identifier that you can provide to ensure the idempotency of the request.
         *        Don't reuse this client token if a new idempotent request is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private VersionUpdateByJobsConfig versionUpdateByJobsConfig;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePackageConfigurationRequest model) {
            super(model);
            versionUpdateByJobsConfig(model.versionUpdateByJobsConfig);
            clientToken(model.clientToken);
        }

        public final VersionUpdateByJobsConfig.Builder getVersionUpdateByJobsConfig() {
            return versionUpdateByJobsConfig != null ? versionUpdateByJobsConfig.toBuilder() : null;
        }

        public final void setVersionUpdateByJobsConfig(VersionUpdateByJobsConfig.BuilderImpl versionUpdateByJobsConfig) {
            this.versionUpdateByJobsConfig = versionUpdateByJobsConfig != null ? versionUpdateByJobsConfig.build() : null;
        }

        @Override
        public final Builder versionUpdateByJobsConfig(VersionUpdateByJobsConfig versionUpdateByJobsConfig) {
            this.versionUpdateByJobsConfig = versionUpdateByJobsConfig;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePackageConfigurationRequest build() {
            return new UpdatePackageConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
