/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an action that sends data to CloudWatch Logs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudwatchLogsAction implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudwatchLogsAction.Builder, CloudwatchLogsAction> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(CloudwatchLogsAction::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logGroupName").getter(getter(CloudwatchLogsAction::logGroupName)).setter(setter(Builder::logGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()).build();

    private static final SdkField<Boolean> BATCH_MODE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("batchMode").getter(getter(CloudwatchLogsAction::batchMode)).setter(setter(Builder::batchMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD,
            LOG_GROUP_NAME_FIELD, BATCH_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String roleArn;

    private final String logGroupName;

    private final Boolean batchMode;

    private CloudwatchLogsAction(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.logGroupName = builder.logGroupName;
        this.batchMode = builder.batchMode;
    }

    /**
     * <p>
     * The IAM role that allows access to the CloudWatch log.
     * </p>
     * 
     * @return The IAM role that allows access to the CloudWatch log.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The CloudWatch log group to which the action sends data.
     * </p>
     * 
     * @return The CloudWatch log group to which the action sends data.
     */
    public final String logGroupName() {
        return logGroupName;
    }

    /**
     * <p>
     * Indicates whether batches of log records will be extracted and uploaded into CloudWatch. Values include
     * <code>true</code> or <code>false</code> <i>(default)</i>.
     * </p>
     * 
     * @return Indicates whether batches of log records will be extracted and uploaded into CloudWatch. Values include
     *         <code>true</code> or <code>false</code> <i>(default)</i>.
     */
    public final Boolean batchMode() {
        return batchMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(batchMode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudwatchLogsAction)) {
            return false;
        }
        CloudwatchLogsAction other = (CloudwatchLogsAction) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(logGroupName(), other.logGroupName())
                && Objects.equals(batchMode(), other.batchMode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CloudwatchLogsAction").add("RoleArn", roleArn()).add("LogGroupName", logGroupName())
                .add("BatchMode", batchMode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "logGroupName":
            return Optional.ofNullable(clazz.cast(logGroupName()));
        case "batchMode":
            return Optional.ofNullable(clazz.cast(batchMode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("logGroupName", LOG_GROUP_NAME_FIELD);
        map.put("batchMode", BATCH_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CloudwatchLogsAction, T> g) {
        return obj -> g.apply((CloudwatchLogsAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudwatchLogsAction> {
        /**
         * <p>
         * The IAM role that allows access to the CloudWatch log.
         * </p>
         * 
         * @param roleArn
         *        The IAM role that allows access to the CloudWatch log.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The CloudWatch log group to which the action sends data.
         * </p>
         * 
         * @param logGroupName
         *        The CloudWatch log group to which the action sends data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * Indicates whether batches of log records will be extracted and uploaded into CloudWatch. Values include
         * <code>true</code> or <code>false</code> <i>(default)</i>.
         * </p>
         * 
         * @param batchMode
         *        Indicates whether batches of log records will be extracted and uploaded into CloudWatch. Values
         *        include <code>true</code> or <code>false</code> <i>(default)</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchMode(Boolean batchMode);
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private String logGroupName;

        private Boolean batchMode;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudwatchLogsAction model) {
            roleArn(model.roleArn);
            logGroupName(model.logGroupName);
            batchMode(model.batchMode);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final Boolean getBatchMode() {
            return batchMode;
        }

        public final void setBatchMode(Boolean batchMode) {
            this.batchMode = batchMode;
        }

        @Override
        public final Builder batchMode(Boolean batchMode) {
            this.batchMode = batchMode;
            return this;
        }

        @Override
        public CloudwatchLogsAction build() {
            return new CloudwatchLogsAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
