/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Send messages to an Amazon Managed Streaming for Apache Kafka (Amazon MSK) or self-managed Apache Kafka cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KafkaAction implements SdkPojo, Serializable, ToCopyableBuilder<KafkaAction.Builder, KafkaAction> {
    private static final SdkField<String> DESTINATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationArn").getter(getter(KafkaAction::destinationArn)).setter(setter(Builder::destinationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationArn").build()).build();

    private static final SdkField<String> TOPIC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("topic")
            .getter(getter(KafkaAction::topic)).setter(setter(Builder::topic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topic").build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("key")
            .getter(getter(KafkaAction::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()).build();

    private static final SdkField<String> PARTITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("partition").getter(getter(KafkaAction::partition)).setter(setter(Builder::partition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partition").build()).build();

    private static final SdkField<Map<String, String>> CLIENT_PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("clientProperties")
            .getter(getter(KafkaAction::clientProperties))
            .setter(setter(Builder::clientProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<KafkaActionHeader>> HEADERS_FIELD = SdkField
            .<List<KafkaActionHeader>> builder(MarshallingType.LIST)
            .memberName("headers")
            .getter(getter(KafkaAction::headers))
            .setter(setter(Builder::headers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("headers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KafkaActionHeader> builder(MarshallingType.SDK_POJO)
                                            .constructor(KafkaActionHeader::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_ARN_FIELD,
            TOPIC_FIELD, KEY_FIELD, PARTITION_FIELD, CLIENT_PROPERTIES_FIELD, HEADERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String destinationArn;

    private final String topic;

    private final String key;

    private final String partition;

    private final Map<String, String> clientProperties;

    private final List<KafkaActionHeader> headers;

    private KafkaAction(BuilderImpl builder) {
        this.destinationArn = builder.destinationArn;
        this.topic = builder.topic;
        this.key = builder.key;
        this.partition = builder.partition;
        this.clientProperties = builder.clientProperties;
        this.headers = builder.headers;
    }

    /**
     * <p>
     * The ARN of Kafka action's VPC <code>TopicRuleDestination</code>.
     * </p>
     * 
     * @return The ARN of Kafka action's VPC <code>TopicRuleDestination</code>.
     */
    public final String destinationArn() {
        return destinationArn;
    }

    /**
     * <p>
     * The Kafka topic for messages to be sent to the Kafka broker.
     * </p>
     * 
     * @return The Kafka topic for messages to be sent to the Kafka broker.
     */
    public final String topic() {
        return topic;
    }

    /**
     * <p>
     * The Kafka message key.
     * </p>
     * 
     * @return The Kafka message key.
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * The Kafka message partition.
     * </p>
     * 
     * @return The Kafka message partition.
     */
    public final String partition() {
        return partition;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClientProperties property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasClientProperties() {
        return clientProperties != null && !(clientProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Properties of the Apache Kafka producer client.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClientProperties} method.
     * </p>
     * 
     * @return Properties of the Apache Kafka producer client.
     */
    public final Map<String, String> clientProperties() {
        return clientProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the Headers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasHeaders() {
        return headers != null && !(headers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of Kafka headers that you specify.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHeaders} method.
     * </p>
     * 
     * @return The list of Kafka headers that you specify.
     */
    public final List<KafkaActionHeader> headers() {
        return headers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(topic());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(partition());
        hashCode = 31 * hashCode + Objects.hashCode(hasClientProperties() ? clientProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasHeaders() ? headers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KafkaAction)) {
            return false;
        }
        KafkaAction other = (KafkaAction) obj;
        return Objects.equals(destinationArn(), other.destinationArn()) && Objects.equals(topic(), other.topic())
                && Objects.equals(key(), other.key()) && Objects.equals(partition(), other.partition())
                && hasClientProperties() == other.hasClientProperties()
                && Objects.equals(clientProperties(), other.clientProperties()) && hasHeaders() == other.hasHeaders()
                && Objects.equals(headers(), other.headers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KafkaAction").add("DestinationArn", destinationArn()).add("Topic", topic()).add("Key", key())
                .add("Partition", partition()).add("ClientProperties", hasClientProperties() ? clientProperties() : null)
                .add("Headers", hasHeaders() ? headers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "destinationArn":
            return Optional.ofNullable(clazz.cast(destinationArn()));
        case "topic":
            return Optional.ofNullable(clazz.cast(topic()));
        case "key":
            return Optional.ofNullable(clazz.cast(key()));
        case "partition":
            return Optional.ofNullable(clazz.cast(partition()));
        case "clientProperties":
            return Optional.ofNullable(clazz.cast(clientProperties()));
        case "headers":
            return Optional.ofNullable(clazz.cast(headers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("destinationArn", DESTINATION_ARN_FIELD);
        map.put("topic", TOPIC_FIELD);
        map.put("key", KEY_FIELD);
        map.put("partition", PARTITION_FIELD);
        map.put("clientProperties", CLIENT_PROPERTIES_FIELD);
        map.put("headers", HEADERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KafkaAction, T> g) {
        return obj -> g.apply((KafkaAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KafkaAction> {
        /**
         * <p>
         * The ARN of Kafka action's VPC <code>TopicRuleDestination</code>.
         * </p>
         * 
         * @param destinationArn
         *        The ARN of Kafka action's VPC <code>TopicRuleDestination</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationArn(String destinationArn);

        /**
         * <p>
         * The Kafka topic for messages to be sent to the Kafka broker.
         * </p>
         * 
         * @param topic
         *        The Kafka topic for messages to be sent to the Kafka broker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topic(String topic);

        /**
         * <p>
         * The Kafka message key.
         * </p>
         * 
         * @param key
         *        The Kafka message key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The Kafka message partition.
         * </p>
         * 
         * @param partition
         *        The Kafka message partition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partition(String partition);

        /**
         * <p>
         * Properties of the Apache Kafka producer client.
         * </p>
         * 
         * @param clientProperties
         *        Properties of the Apache Kafka producer client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientProperties(Map<String, String> clientProperties);

        /**
         * <p>
         * The list of Kafka headers that you specify.
         * </p>
         * 
         * @param headers
         *        The list of Kafka headers that you specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headers(Collection<KafkaActionHeader> headers);

        /**
         * <p>
         * The list of Kafka headers that you specify.
         * </p>
         * 
         * @param headers
         *        The list of Kafka headers that you specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headers(KafkaActionHeader... headers);

        /**
         * <p>
         * The list of Kafka headers that you specify.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iot.model.KafkaActionHeader.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iot.model.KafkaActionHeader#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iot.model.KafkaActionHeader.Builder#build()} is called immediately and
         * its result is passed to {@link #headers(List<KafkaActionHeader>)}.
         * 
         * @param headers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iot.model.KafkaActionHeader.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #headers(java.util.Collection<KafkaActionHeader>)
         */
        Builder headers(Consumer<KafkaActionHeader.Builder>... headers);
    }

    static final class BuilderImpl implements Builder {
        private String destinationArn;

        private String topic;

        private String key;

        private String partition;

        private Map<String, String> clientProperties = DefaultSdkAutoConstructMap.getInstance();

        private List<KafkaActionHeader> headers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(KafkaAction model) {
            destinationArn(model.destinationArn);
            topic(model.topic);
            key(model.key);
            partition(model.partition);
            clientProperties(model.clientProperties);
            headers(model.headers);
        }

        public final String getDestinationArn() {
            return destinationArn;
        }

        public final void setDestinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
        }

        @Override
        public final Builder destinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
            return this;
        }

        public final String getTopic() {
            return topic;
        }

        public final void setTopic(String topic) {
            this.topic = topic;
        }

        @Override
        public final Builder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getPartition() {
            return partition;
        }

        public final void setPartition(String partition) {
            this.partition = partition;
        }

        @Override
        public final Builder partition(String partition) {
            this.partition = partition;
            return this;
        }

        public final Map<String, String> getClientProperties() {
            if (clientProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return clientProperties;
        }

        public final void setClientProperties(Map<String, String> clientProperties) {
            this.clientProperties = ClientPropertiesCopier.copy(clientProperties);
        }

        @Override
        public final Builder clientProperties(Map<String, String> clientProperties) {
            this.clientProperties = ClientPropertiesCopier.copy(clientProperties);
            return this;
        }

        public final List<KafkaActionHeader.Builder> getHeaders() {
            List<KafkaActionHeader.Builder> result = KafkaHeadersCopier.copyToBuilder(this.headers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHeaders(Collection<KafkaActionHeader.BuilderImpl> headers) {
            this.headers = KafkaHeadersCopier.copyFromBuilder(headers);
        }

        @Override
        public final Builder headers(Collection<KafkaActionHeader> headers) {
            this.headers = KafkaHeadersCopier.copy(headers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(KafkaActionHeader... headers) {
            headers(Arrays.asList(headers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(Consumer<KafkaActionHeader.Builder>... headers) {
            headers(Stream.of(headers).map(c -> KafkaActionHeader.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public KafkaAction build() {
            return new KafkaAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
