/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The job execution summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobExecutionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<JobExecutionSummary.Builder, JobExecutionSummary> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(JobExecutionSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> QUEUED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("queuedAt").getter(getter(JobExecutionSummary::queuedAt)).setter(setter(Builder::queuedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queuedAt").build()).build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startedAt").getter(getter(JobExecutionSummary::startedAt)).setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt").getter(getter(JobExecutionSummary::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()).build();

    private static final SdkField<Long> EXECUTION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("executionNumber").getter(getter(JobExecutionSummary::executionNumber))
            .setter(setter(Builder::executionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionNumber").build()).build();

    private static final SdkField<Integer> RETRY_ATTEMPT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("retryAttempt").getter(getter(JobExecutionSummary::retryAttempt)).setter(setter(Builder::retryAttempt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retryAttempt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, QUEUED_AT_FIELD,
            STARTED_AT_FIELD, LAST_UPDATED_AT_FIELD, EXECUTION_NUMBER_FIELD, RETRY_ATTEMPT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String status;

    private final Instant queuedAt;

    private final Instant startedAt;

    private final Instant lastUpdatedAt;

    private final Long executionNumber;

    private final Integer retryAttempt;

    private JobExecutionSummary(BuilderImpl builder) {
        this.status = builder.status;
        this.queuedAt = builder.queuedAt;
        this.startedAt = builder.startedAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.executionNumber = builder.executionNumber;
        this.retryAttempt = builder.retryAttempt;
    }

    /**
     * <p>
     * The status of the job execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the job execution.
     * @see JobExecutionStatus
     */
    public final JobExecutionStatus status() {
        return JobExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the job execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the job execution.
     * @see JobExecutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time, in seconds since the epoch, when the job execution was queued.
     * </p>
     * 
     * @return The time, in seconds since the epoch, when the job execution was queued.
     */
    public final Instant queuedAt() {
        return queuedAt;
    }

    /**
     * <p>
     * The time, in seconds since the epoch, when the job execution started.
     * </p>
     * 
     * @return The time, in seconds since the epoch, when the job execution started.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The time, in seconds since the epoch, when the job execution was last updated.
     * </p>
     * 
     * @return The time, in seconds since the epoch, when the job execution was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * A string (consisting of the digits "0" through "9") which identifies this particular job execution on this
     * particular device. It can be used later in commands which return or update job execution information.
     * </p>
     * 
     * @return A string (consisting of the digits "0" through "9") which identifies this particular job execution on
     *         this particular device. It can be used later in commands which return or update job execution
     *         information.
     */
    public final Long executionNumber() {
        return executionNumber;
    }

    /**
     * <p>
     * The number that indicates how many retry attempts have been completed for this job on this device.
     * </p>
     * 
     * @return The number that indicates how many retry attempts have been completed for this job on this device.
     */
    public final Integer retryAttempt() {
        return retryAttempt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(queuedAt());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(executionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(retryAttempt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobExecutionSummary)) {
            return false;
        }
        JobExecutionSummary other = (JobExecutionSummary) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(queuedAt(), other.queuedAt())
                && Objects.equals(startedAt(), other.startedAt()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(executionNumber(), other.executionNumber())
                && Objects.equals(retryAttempt(), other.retryAttempt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobExecutionSummary").add("Status", statusAsString()).add("QueuedAt", queuedAt())
                .add("StartedAt", startedAt()).add("LastUpdatedAt", lastUpdatedAt()).add("ExecutionNumber", executionNumber())
                .add("RetryAttempt", retryAttempt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "queuedAt":
            return Optional.ofNullable(clazz.cast(queuedAt()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "executionNumber":
            return Optional.ofNullable(clazz.cast(executionNumber()));
        case "retryAttempt":
            return Optional.ofNullable(clazz.cast(retryAttempt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("status", STATUS_FIELD);
        map.put("queuedAt", QUEUED_AT_FIELD);
        map.put("startedAt", STARTED_AT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("executionNumber", EXECUTION_NUMBER_FIELD);
        map.put("retryAttempt", RETRY_ATTEMPT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobExecutionSummary, T> g) {
        return obj -> g.apply((JobExecutionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobExecutionSummary> {
        /**
         * <p>
         * The status of the job execution.
         * </p>
         * 
         * @param status
         *        The status of the job execution.
         * @see JobExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the job execution.
         * </p>
         * 
         * @param status
         *        The status of the job execution.
         * @see JobExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobExecutionStatus
         */
        Builder status(JobExecutionStatus status);

        /**
         * <p>
         * The time, in seconds since the epoch, when the job execution was queued.
         * </p>
         * 
         * @param queuedAt
         *        The time, in seconds since the epoch, when the job execution was queued.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queuedAt(Instant queuedAt);

        /**
         * <p>
         * The time, in seconds since the epoch, when the job execution started.
         * </p>
         * 
         * @param startedAt
         *        The time, in seconds since the epoch, when the job execution started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * The time, in seconds since the epoch, when the job execution was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The time, in seconds since the epoch, when the job execution was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * A string (consisting of the digits "0" through "9") which identifies this particular job execution on this
         * particular device. It can be used later in commands which return or update job execution information.
         * </p>
         * 
         * @param executionNumber
         *        A string (consisting of the digits "0" through "9") which identifies this particular job execution on
         *        this particular device. It can be used later in commands which return or update job execution
         *        information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionNumber(Long executionNumber);

        /**
         * <p>
         * The number that indicates how many retry attempts have been completed for this job on this device.
         * </p>
         * 
         * @param retryAttempt
         *        The number that indicates how many retry attempts have been completed for this job on this device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryAttempt(Integer retryAttempt);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private Instant queuedAt;

        private Instant startedAt;

        private Instant lastUpdatedAt;

        private Long executionNumber;

        private Integer retryAttempt;

        private BuilderImpl() {
        }

        private BuilderImpl(JobExecutionSummary model) {
            status(model.status);
            queuedAt(model.queuedAt);
            startedAt(model.startedAt);
            lastUpdatedAt(model.lastUpdatedAt);
            executionNumber(model.executionNumber);
            retryAttempt(model.retryAttempt);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getQueuedAt() {
            return queuedAt;
        }

        public final void setQueuedAt(Instant queuedAt) {
            this.queuedAt = queuedAt;
        }

        @Override
        public final Builder queuedAt(Instant queuedAt) {
            this.queuedAt = queuedAt;
            return this;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final Long getExecutionNumber() {
            return executionNumber;
        }

        public final void setExecutionNumber(Long executionNumber) {
            this.executionNumber = executionNumber;
        }

        @Override
        public final Builder executionNumber(Long executionNumber) {
            this.executionNumber = executionNumber;
            return this;
        }

        public final Integer getRetryAttempt() {
            return retryAttempt;
        }

        public final void setRetryAttempt(Integer retryAttempt) {
            this.retryAttempt = retryAttempt;
        }

        @Override
        public final Builder retryAttempt(Integer retryAttempt) {
            this.retryAttempt = retryAttempt;
            return this;
        }

        @Override
        public JobExecutionSummary build() {
            return new JobExecutionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
