/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.iot.internal.IotServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.iot.model.AcceptCertificateTransferRequest;
import software.amazon.awssdk.services.iot.model.AcceptCertificateTransferResponse;
import software.amazon.awssdk.services.iot.model.AddThingToBillingGroupRequest;
import software.amazon.awssdk.services.iot.model.AddThingToBillingGroupResponse;
import software.amazon.awssdk.services.iot.model.AddThingToThingGroupRequest;
import software.amazon.awssdk.services.iot.model.AddThingToThingGroupResponse;
import software.amazon.awssdk.services.iot.model.AssociateSbomWithPackageVersionRequest;
import software.amazon.awssdk.services.iot.model.AssociateSbomWithPackageVersionResponse;
import software.amazon.awssdk.services.iot.model.AssociateTargetsWithJobRequest;
import software.amazon.awssdk.services.iot.model.AssociateTargetsWithJobResponse;
import software.amazon.awssdk.services.iot.model.AttachPolicyRequest;
import software.amazon.awssdk.services.iot.model.AttachPolicyResponse;
import software.amazon.awssdk.services.iot.model.AttachSecurityProfileRequest;
import software.amazon.awssdk.services.iot.model.AttachSecurityProfileResponse;
import software.amazon.awssdk.services.iot.model.AttachThingPrincipalRequest;
import software.amazon.awssdk.services.iot.model.AttachThingPrincipalResponse;
import software.amazon.awssdk.services.iot.model.CancelAuditMitigationActionsTaskRequest;
import software.amazon.awssdk.services.iot.model.CancelAuditMitigationActionsTaskResponse;
import software.amazon.awssdk.services.iot.model.CancelAuditTaskRequest;
import software.amazon.awssdk.services.iot.model.CancelAuditTaskResponse;
import software.amazon.awssdk.services.iot.model.CancelCertificateTransferRequest;
import software.amazon.awssdk.services.iot.model.CancelCertificateTransferResponse;
import software.amazon.awssdk.services.iot.model.CancelDetectMitigationActionsTaskRequest;
import software.amazon.awssdk.services.iot.model.CancelDetectMitigationActionsTaskResponse;
import software.amazon.awssdk.services.iot.model.CancelJobExecutionRequest;
import software.amazon.awssdk.services.iot.model.CancelJobExecutionResponse;
import software.amazon.awssdk.services.iot.model.CancelJobRequest;
import software.amazon.awssdk.services.iot.model.CancelJobResponse;
import software.amazon.awssdk.services.iot.model.CertificateConflictException;
import software.amazon.awssdk.services.iot.model.CertificateStateException;
import software.amazon.awssdk.services.iot.model.CertificateValidationException;
import software.amazon.awssdk.services.iot.model.ClearDefaultAuthorizerRequest;
import software.amazon.awssdk.services.iot.model.ClearDefaultAuthorizerResponse;
import software.amazon.awssdk.services.iot.model.ConfirmTopicRuleDestinationRequest;
import software.amazon.awssdk.services.iot.model.ConfirmTopicRuleDestinationResponse;
import software.amazon.awssdk.services.iot.model.ConflictException;
import software.amazon.awssdk.services.iot.model.ConflictingResourceUpdateException;
import software.amazon.awssdk.services.iot.model.CreateAuditSuppressionRequest;
import software.amazon.awssdk.services.iot.model.CreateAuditSuppressionResponse;
import software.amazon.awssdk.services.iot.model.CreateAuthorizerRequest;
import software.amazon.awssdk.services.iot.model.CreateAuthorizerResponse;
import software.amazon.awssdk.services.iot.model.CreateBillingGroupRequest;
import software.amazon.awssdk.services.iot.model.CreateBillingGroupResponse;
import software.amazon.awssdk.services.iot.model.CreateCertificateFromCsrRequest;
import software.amazon.awssdk.services.iot.model.CreateCertificateFromCsrResponse;
import software.amazon.awssdk.services.iot.model.CreateCertificateProviderRequest;
import software.amazon.awssdk.services.iot.model.CreateCertificateProviderResponse;
import software.amazon.awssdk.services.iot.model.CreateCommandRequest;
import software.amazon.awssdk.services.iot.model.CreateCommandResponse;
import software.amazon.awssdk.services.iot.model.CreateCustomMetricRequest;
import software.amazon.awssdk.services.iot.model.CreateCustomMetricResponse;
import software.amazon.awssdk.services.iot.model.CreateDimensionRequest;
import software.amazon.awssdk.services.iot.model.CreateDimensionResponse;
import software.amazon.awssdk.services.iot.model.CreateDomainConfigurationRequest;
import software.amazon.awssdk.services.iot.model.CreateDomainConfigurationResponse;
import software.amazon.awssdk.services.iot.model.CreateDynamicThingGroupRequest;
import software.amazon.awssdk.services.iot.model.CreateDynamicThingGroupResponse;
import software.amazon.awssdk.services.iot.model.CreateFleetMetricRequest;
import software.amazon.awssdk.services.iot.model.CreateFleetMetricResponse;
import software.amazon.awssdk.services.iot.model.CreateJobRequest;
import software.amazon.awssdk.services.iot.model.CreateJobResponse;
import software.amazon.awssdk.services.iot.model.CreateJobTemplateRequest;
import software.amazon.awssdk.services.iot.model.CreateJobTemplateResponse;
import software.amazon.awssdk.services.iot.model.CreateKeysAndCertificateRequest;
import software.amazon.awssdk.services.iot.model.CreateKeysAndCertificateResponse;
import software.amazon.awssdk.services.iot.model.CreateMitigationActionRequest;
import software.amazon.awssdk.services.iot.model.CreateMitigationActionResponse;
import software.amazon.awssdk.services.iot.model.CreateOtaUpdateRequest;
import software.amazon.awssdk.services.iot.model.CreateOtaUpdateResponse;
import software.amazon.awssdk.services.iot.model.CreatePackageRequest;
import software.amazon.awssdk.services.iot.model.CreatePackageResponse;
import software.amazon.awssdk.services.iot.model.CreatePackageVersionRequest;
import software.amazon.awssdk.services.iot.model.CreatePackageVersionResponse;
import software.amazon.awssdk.services.iot.model.CreatePolicyRequest;
import software.amazon.awssdk.services.iot.model.CreatePolicyResponse;
import software.amazon.awssdk.services.iot.model.CreatePolicyVersionRequest;
import software.amazon.awssdk.services.iot.model.CreatePolicyVersionResponse;
import software.amazon.awssdk.services.iot.model.CreateProvisioningClaimRequest;
import software.amazon.awssdk.services.iot.model.CreateProvisioningClaimResponse;
import software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateRequest;
import software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateResponse;
import software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateVersionRequest;
import software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateVersionResponse;
import software.amazon.awssdk.services.iot.model.CreateRoleAliasRequest;
import software.amazon.awssdk.services.iot.model.CreateRoleAliasResponse;
import software.amazon.awssdk.services.iot.model.CreateScheduledAuditRequest;
import software.amazon.awssdk.services.iot.model.CreateScheduledAuditResponse;
import software.amazon.awssdk.services.iot.model.CreateSecurityProfileRequest;
import software.amazon.awssdk.services.iot.model.CreateSecurityProfileResponse;
import software.amazon.awssdk.services.iot.model.CreateStreamRequest;
import software.amazon.awssdk.services.iot.model.CreateStreamResponse;
import software.amazon.awssdk.services.iot.model.CreateThingGroupRequest;
import software.amazon.awssdk.services.iot.model.CreateThingGroupResponse;
import software.amazon.awssdk.services.iot.model.CreateThingRequest;
import software.amazon.awssdk.services.iot.model.CreateThingResponse;
import software.amazon.awssdk.services.iot.model.CreateThingTypeRequest;
import software.amazon.awssdk.services.iot.model.CreateThingTypeResponse;
import software.amazon.awssdk.services.iot.model.CreateTopicRuleDestinationRequest;
import software.amazon.awssdk.services.iot.model.CreateTopicRuleDestinationResponse;
import software.amazon.awssdk.services.iot.model.CreateTopicRuleRequest;
import software.amazon.awssdk.services.iot.model.CreateTopicRuleResponse;
import software.amazon.awssdk.services.iot.model.DeleteAccountAuditConfigurationRequest;
import software.amazon.awssdk.services.iot.model.DeleteAccountAuditConfigurationResponse;
import software.amazon.awssdk.services.iot.model.DeleteAuditSuppressionRequest;
import software.amazon.awssdk.services.iot.model.DeleteAuditSuppressionResponse;
import software.amazon.awssdk.services.iot.model.DeleteAuthorizerRequest;
import software.amazon.awssdk.services.iot.model.DeleteAuthorizerResponse;
import software.amazon.awssdk.services.iot.model.DeleteBillingGroupRequest;
import software.amazon.awssdk.services.iot.model.DeleteBillingGroupResponse;
import software.amazon.awssdk.services.iot.model.DeleteCaCertificateRequest;
import software.amazon.awssdk.services.iot.model.DeleteCaCertificateResponse;
import software.amazon.awssdk.services.iot.model.DeleteCertificateProviderRequest;
import software.amazon.awssdk.services.iot.model.DeleteCertificateProviderResponse;
import software.amazon.awssdk.services.iot.model.DeleteCertificateRequest;
import software.amazon.awssdk.services.iot.model.DeleteCertificateResponse;
import software.amazon.awssdk.services.iot.model.DeleteCommandExecutionRequest;
import software.amazon.awssdk.services.iot.model.DeleteCommandExecutionResponse;
import software.amazon.awssdk.services.iot.model.DeleteCommandRequest;
import software.amazon.awssdk.services.iot.model.DeleteCommandResponse;
import software.amazon.awssdk.services.iot.model.DeleteConflictException;
import software.amazon.awssdk.services.iot.model.DeleteCustomMetricRequest;
import software.amazon.awssdk.services.iot.model.DeleteCustomMetricResponse;
import software.amazon.awssdk.services.iot.model.DeleteDimensionRequest;
import software.amazon.awssdk.services.iot.model.DeleteDimensionResponse;
import software.amazon.awssdk.services.iot.model.DeleteDomainConfigurationRequest;
import software.amazon.awssdk.services.iot.model.DeleteDomainConfigurationResponse;
import software.amazon.awssdk.services.iot.model.DeleteDynamicThingGroupRequest;
import software.amazon.awssdk.services.iot.model.DeleteDynamicThingGroupResponse;
import software.amazon.awssdk.services.iot.model.DeleteFleetMetricRequest;
import software.amazon.awssdk.services.iot.model.DeleteFleetMetricResponse;
import software.amazon.awssdk.services.iot.model.DeleteJobExecutionRequest;
import software.amazon.awssdk.services.iot.model.DeleteJobExecutionResponse;
import software.amazon.awssdk.services.iot.model.DeleteJobRequest;
import software.amazon.awssdk.services.iot.model.DeleteJobResponse;
import software.amazon.awssdk.services.iot.model.DeleteJobTemplateRequest;
import software.amazon.awssdk.services.iot.model.DeleteJobTemplateResponse;
import software.amazon.awssdk.services.iot.model.DeleteMitigationActionRequest;
import software.amazon.awssdk.services.iot.model.DeleteMitigationActionResponse;
import software.amazon.awssdk.services.iot.model.DeleteOtaUpdateRequest;
import software.amazon.awssdk.services.iot.model.DeleteOtaUpdateResponse;
import software.amazon.awssdk.services.iot.model.DeletePackageRequest;
import software.amazon.awssdk.services.iot.model.DeletePackageResponse;
import software.amazon.awssdk.services.iot.model.DeletePackageVersionRequest;
import software.amazon.awssdk.services.iot.model.DeletePackageVersionResponse;
import software.amazon.awssdk.services.iot.model.DeletePolicyRequest;
import software.amazon.awssdk.services.iot.model.DeletePolicyResponse;
import software.amazon.awssdk.services.iot.model.DeletePolicyVersionRequest;
import software.amazon.awssdk.services.iot.model.DeletePolicyVersionResponse;
import software.amazon.awssdk.services.iot.model.DeleteProvisioningTemplateRequest;
import software.amazon.awssdk.services.iot.model.DeleteProvisioningTemplateResponse;
import software.amazon.awssdk.services.iot.model.DeleteProvisioningTemplateVersionRequest;
import software.amazon.awssdk.services.iot.model.DeleteProvisioningTemplateVersionResponse;
import software.amazon.awssdk.services.iot.model.DeleteRegistrationCodeRequest;
import software.amazon.awssdk.services.iot.model.DeleteRegistrationCodeResponse;
import software.amazon.awssdk.services.iot.model.DeleteRoleAliasRequest;
import software.amazon.awssdk.services.iot.model.DeleteRoleAliasResponse;
import software.amazon.awssdk.services.iot.model.DeleteScheduledAuditRequest;
import software.amazon.awssdk.services.iot.model.DeleteScheduledAuditResponse;
import software.amazon.awssdk.services.iot.model.DeleteSecurityProfileRequest;
import software.amazon.awssdk.services.iot.model.DeleteSecurityProfileResponse;
import software.amazon.awssdk.services.iot.model.DeleteStreamRequest;
import software.amazon.awssdk.services.iot.model.DeleteStreamResponse;
import software.amazon.awssdk.services.iot.model.DeleteThingGroupRequest;
import software.amazon.awssdk.services.iot.model.DeleteThingGroupResponse;
import software.amazon.awssdk.services.iot.model.DeleteThingRequest;
import software.amazon.awssdk.services.iot.model.DeleteThingResponse;
import software.amazon.awssdk.services.iot.model.DeleteThingTypeRequest;
import software.amazon.awssdk.services.iot.model.DeleteThingTypeResponse;
import software.amazon.awssdk.services.iot.model.DeleteTopicRuleDestinationRequest;
import software.amazon.awssdk.services.iot.model.DeleteTopicRuleDestinationResponse;
import software.amazon.awssdk.services.iot.model.DeleteTopicRuleRequest;
import software.amazon.awssdk.services.iot.model.DeleteTopicRuleResponse;
import software.amazon.awssdk.services.iot.model.DeleteV2LoggingLevelRequest;
import software.amazon.awssdk.services.iot.model.DeleteV2LoggingLevelResponse;
import software.amazon.awssdk.services.iot.model.DeprecateThingTypeRequest;
import software.amazon.awssdk.services.iot.model.DeprecateThingTypeResponse;
import software.amazon.awssdk.services.iot.model.DescribeAccountAuditConfigurationRequest;
import software.amazon.awssdk.services.iot.model.DescribeAccountAuditConfigurationResponse;
import software.amazon.awssdk.services.iot.model.DescribeAuditFindingRequest;
import software.amazon.awssdk.services.iot.model.DescribeAuditFindingResponse;
import software.amazon.awssdk.services.iot.model.DescribeAuditMitigationActionsTaskRequest;
import software.amazon.awssdk.services.iot.model.DescribeAuditMitigationActionsTaskResponse;
import software.amazon.awssdk.services.iot.model.DescribeAuditSuppressionRequest;
import software.amazon.awssdk.services.iot.model.DescribeAuditSuppressionResponse;
import software.amazon.awssdk.services.iot.model.DescribeAuditTaskRequest;
import software.amazon.awssdk.services.iot.model.DescribeAuditTaskResponse;
import software.amazon.awssdk.services.iot.model.DescribeAuthorizerRequest;
import software.amazon.awssdk.services.iot.model.DescribeAuthorizerResponse;
import software.amazon.awssdk.services.iot.model.DescribeBillingGroupRequest;
import software.amazon.awssdk.services.iot.model.DescribeBillingGroupResponse;
import software.amazon.awssdk.services.iot.model.DescribeCaCertificateRequest;
import software.amazon.awssdk.services.iot.model.DescribeCaCertificateResponse;
import software.amazon.awssdk.services.iot.model.DescribeCertificateProviderRequest;
import software.amazon.awssdk.services.iot.model.DescribeCertificateProviderResponse;
import software.amazon.awssdk.services.iot.model.DescribeCertificateRequest;
import software.amazon.awssdk.services.iot.model.DescribeCertificateResponse;
import software.amazon.awssdk.services.iot.model.DescribeCustomMetricRequest;
import software.amazon.awssdk.services.iot.model.DescribeCustomMetricResponse;
import software.amazon.awssdk.services.iot.model.DescribeDefaultAuthorizerRequest;
import software.amazon.awssdk.services.iot.model.DescribeDefaultAuthorizerResponse;
import software.amazon.awssdk.services.iot.model.DescribeDetectMitigationActionsTaskRequest;
import software.amazon.awssdk.services.iot.model.DescribeDetectMitigationActionsTaskResponse;
import software.amazon.awssdk.services.iot.model.DescribeDimensionRequest;
import software.amazon.awssdk.services.iot.model.DescribeDimensionResponse;
import software.amazon.awssdk.services.iot.model.DescribeDomainConfigurationRequest;
import software.amazon.awssdk.services.iot.model.DescribeDomainConfigurationResponse;
import software.amazon.awssdk.services.iot.model.DescribeEndpointRequest;
import software.amazon.awssdk.services.iot.model.DescribeEndpointResponse;
import software.amazon.awssdk.services.iot.model.DescribeEventConfigurationsRequest;
import software.amazon.awssdk.services.iot.model.DescribeEventConfigurationsResponse;
import software.amazon.awssdk.services.iot.model.DescribeFleetMetricRequest;
import software.amazon.awssdk.services.iot.model.DescribeFleetMetricResponse;
import software.amazon.awssdk.services.iot.model.DescribeIndexRequest;
import software.amazon.awssdk.services.iot.model.DescribeIndexResponse;
import software.amazon.awssdk.services.iot.model.DescribeJobExecutionRequest;
import software.amazon.awssdk.services.iot.model.DescribeJobExecutionResponse;
import software.amazon.awssdk.services.iot.model.DescribeJobRequest;
import software.amazon.awssdk.services.iot.model.DescribeJobResponse;
import software.amazon.awssdk.services.iot.model.DescribeJobTemplateRequest;
import software.amazon.awssdk.services.iot.model.DescribeJobTemplateResponse;
import software.amazon.awssdk.services.iot.model.DescribeManagedJobTemplateRequest;
import software.amazon.awssdk.services.iot.model.DescribeManagedJobTemplateResponse;
import software.amazon.awssdk.services.iot.model.DescribeMitigationActionRequest;
import software.amazon.awssdk.services.iot.model.DescribeMitigationActionResponse;
import software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateRequest;
import software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateResponse;
import software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateVersionRequest;
import software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateVersionResponse;
import software.amazon.awssdk.services.iot.model.DescribeRoleAliasRequest;
import software.amazon.awssdk.services.iot.model.DescribeRoleAliasResponse;
import software.amazon.awssdk.services.iot.model.DescribeScheduledAuditRequest;
import software.amazon.awssdk.services.iot.model.DescribeScheduledAuditResponse;
import software.amazon.awssdk.services.iot.model.DescribeSecurityProfileRequest;
import software.amazon.awssdk.services.iot.model.DescribeSecurityProfileResponse;
import software.amazon.awssdk.services.iot.model.DescribeStreamRequest;
import software.amazon.awssdk.services.iot.model.DescribeStreamResponse;
import software.amazon.awssdk.services.iot.model.DescribeThingGroupRequest;
import software.amazon.awssdk.services.iot.model.DescribeThingGroupResponse;
import software.amazon.awssdk.services.iot.model.DescribeThingRegistrationTaskRequest;
import software.amazon.awssdk.services.iot.model.DescribeThingRegistrationTaskResponse;
import software.amazon.awssdk.services.iot.model.DescribeThingRequest;
import software.amazon.awssdk.services.iot.model.DescribeThingResponse;
import software.amazon.awssdk.services.iot.model.DescribeThingTypeRequest;
import software.amazon.awssdk.services.iot.model.DescribeThingTypeResponse;
import software.amazon.awssdk.services.iot.model.DetachPolicyRequest;
import software.amazon.awssdk.services.iot.model.DetachPolicyResponse;
import software.amazon.awssdk.services.iot.model.DetachSecurityProfileRequest;
import software.amazon.awssdk.services.iot.model.DetachSecurityProfileResponse;
import software.amazon.awssdk.services.iot.model.DetachThingPrincipalRequest;
import software.amazon.awssdk.services.iot.model.DetachThingPrincipalResponse;
import software.amazon.awssdk.services.iot.model.DisableTopicRuleRequest;
import software.amazon.awssdk.services.iot.model.DisableTopicRuleResponse;
import software.amazon.awssdk.services.iot.model.DisassociateSbomFromPackageVersionRequest;
import software.amazon.awssdk.services.iot.model.DisassociateSbomFromPackageVersionResponse;
import software.amazon.awssdk.services.iot.model.EnableTopicRuleRequest;
import software.amazon.awssdk.services.iot.model.EnableTopicRuleResponse;
import software.amazon.awssdk.services.iot.model.GetBehaviorModelTrainingSummariesRequest;
import software.amazon.awssdk.services.iot.model.GetBehaviorModelTrainingSummariesResponse;
import software.amazon.awssdk.services.iot.model.GetBucketsAggregationRequest;
import software.amazon.awssdk.services.iot.model.GetBucketsAggregationResponse;
import software.amazon.awssdk.services.iot.model.GetCardinalityRequest;
import software.amazon.awssdk.services.iot.model.GetCardinalityResponse;
import software.amazon.awssdk.services.iot.model.GetCommandExecutionRequest;
import software.amazon.awssdk.services.iot.model.GetCommandExecutionResponse;
import software.amazon.awssdk.services.iot.model.GetCommandRequest;
import software.amazon.awssdk.services.iot.model.GetCommandResponse;
import software.amazon.awssdk.services.iot.model.GetEffectivePoliciesRequest;
import software.amazon.awssdk.services.iot.model.GetEffectivePoliciesResponse;
import software.amazon.awssdk.services.iot.model.GetIndexingConfigurationRequest;
import software.amazon.awssdk.services.iot.model.GetIndexingConfigurationResponse;
import software.amazon.awssdk.services.iot.model.GetJobDocumentRequest;
import software.amazon.awssdk.services.iot.model.GetJobDocumentResponse;
import software.amazon.awssdk.services.iot.model.GetLoggingOptionsRequest;
import software.amazon.awssdk.services.iot.model.GetLoggingOptionsResponse;
import software.amazon.awssdk.services.iot.model.GetOtaUpdateRequest;
import software.amazon.awssdk.services.iot.model.GetOtaUpdateResponse;
import software.amazon.awssdk.services.iot.model.GetPackageConfigurationRequest;
import software.amazon.awssdk.services.iot.model.GetPackageConfigurationResponse;
import software.amazon.awssdk.services.iot.model.GetPackageRequest;
import software.amazon.awssdk.services.iot.model.GetPackageResponse;
import software.amazon.awssdk.services.iot.model.GetPackageVersionRequest;
import software.amazon.awssdk.services.iot.model.GetPackageVersionResponse;
import software.amazon.awssdk.services.iot.model.GetPercentilesRequest;
import software.amazon.awssdk.services.iot.model.GetPercentilesResponse;
import software.amazon.awssdk.services.iot.model.GetPolicyRequest;
import software.amazon.awssdk.services.iot.model.GetPolicyResponse;
import software.amazon.awssdk.services.iot.model.GetPolicyVersionRequest;
import software.amazon.awssdk.services.iot.model.GetPolicyVersionResponse;
import software.amazon.awssdk.services.iot.model.GetRegistrationCodeRequest;
import software.amazon.awssdk.services.iot.model.GetRegistrationCodeResponse;
import software.amazon.awssdk.services.iot.model.GetStatisticsRequest;
import software.amazon.awssdk.services.iot.model.GetStatisticsResponse;
import software.amazon.awssdk.services.iot.model.GetThingConnectivityDataRequest;
import software.amazon.awssdk.services.iot.model.GetThingConnectivityDataResponse;
import software.amazon.awssdk.services.iot.model.GetTopicRuleDestinationRequest;
import software.amazon.awssdk.services.iot.model.GetTopicRuleDestinationResponse;
import software.amazon.awssdk.services.iot.model.GetTopicRuleRequest;
import software.amazon.awssdk.services.iot.model.GetTopicRuleResponse;
import software.amazon.awssdk.services.iot.model.GetV2LoggingOptionsRequest;
import software.amazon.awssdk.services.iot.model.GetV2LoggingOptionsResponse;
import software.amazon.awssdk.services.iot.model.IndexNotReadyException;
import software.amazon.awssdk.services.iot.model.InternalException;
import software.amazon.awssdk.services.iot.model.InternalFailureException;
import software.amazon.awssdk.services.iot.model.InternalServerException;
import software.amazon.awssdk.services.iot.model.InvalidAggregationException;
import software.amazon.awssdk.services.iot.model.InvalidQueryException;
import software.amazon.awssdk.services.iot.model.InvalidRequestException;
import software.amazon.awssdk.services.iot.model.InvalidResponseException;
import software.amazon.awssdk.services.iot.model.InvalidStateTransitionException;
import software.amazon.awssdk.services.iot.model.IotException;
import software.amazon.awssdk.services.iot.model.LimitExceededException;
import software.amazon.awssdk.services.iot.model.ListActiveViolationsRequest;
import software.amazon.awssdk.services.iot.model.ListActiveViolationsResponse;
import software.amazon.awssdk.services.iot.model.ListAttachedPoliciesRequest;
import software.amazon.awssdk.services.iot.model.ListAttachedPoliciesResponse;
import software.amazon.awssdk.services.iot.model.ListAuditFindingsRequest;
import software.amazon.awssdk.services.iot.model.ListAuditFindingsResponse;
import software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsExecutionsRequest;
import software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsExecutionsResponse;
import software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsTasksRequest;
import software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsTasksResponse;
import software.amazon.awssdk.services.iot.model.ListAuditSuppressionsRequest;
import software.amazon.awssdk.services.iot.model.ListAuditSuppressionsResponse;
import software.amazon.awssdk.services.iot.model.ListAuditTasksRequest;
import software.amazon.awssdk.services.iot.model.ListAuditTasksResponse;
import software.amazon.awssdk.services.iot.model.ListAuthorizersRequest;
import software.amazon.awssdk.services.iot.model.ListAuthorizersResponse;
import software.amazon.awssdk.services.iot.model.ListBillingGroupsRequest;
import software.amazon.awssdk.services.iot.model.ListBillingGroupsResponse;
import software.amazon.awssdk.services.iot.model.ListCaCertificatesRequest;
import software.amazon.awssdk.services.iot.model.ListCaCertificatesResponse;
import software.amazon.awssdk.services.iot.model.ListCertificateProvidersRequest;
import software.amazon.awssdk.services.iot.model.ListCertificateProvidersResponse;
import software.amazon.awssdk.services.iot.model.ListCertificatesByCaRequest;
import software.amazon.awssdk.services.iot.model.ListCertificatesByCaResponse;
import software.amazon.awssdk.services.iot.model.ListCertificatesRequest;
import software.amazon.awssdk.services.iot.model.ListCertificatesResponse;
import software.amazon.awssdk.services.iot.model.ListCommandExecutionsRequest;
import software.amazon.awssdk.services.iot.model.ListCommandExecutionsResponse;
import software.amazon.awssdk.services.iot.model.ListCommandsRequest;
import software.amazon.awssdk.services.iot.model.ListCommandsResponse;
import software.amazon.awssdk.services.iot.model.ListCustomMetricsRequest;
import software.amazon.awssdk.services.iot.model.ListCustomMetricsResponse;
import software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsExecutionsRequest;
import software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsExecutionsResponse;
import software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsTasksRequest;
import software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsTasksResponse;
import software.amazon.awssdk.services.iot.model.ListDimensionsRequest;
import software.amazon.awssdk.services.iot.model.ListDimensionsResponse;
import software.amazon.awssdk.services.iot.model.ListDomainConfigurationsRequest;
import software.amazon.awssdk.services.iot.model.ListDomainConfigurationsResponse;
import software.amazon.awssdk.services.iot.model.ListFleetMetricsRequest;
import software.amazon.awssdk.services.iot.model.ListFleetMetricsResponse;
import software.amazon.awssdk.services.iot.model.ListIndicesRequest;
import software.amazon.awssdk.services.iot.model.ListIndicesResponse;
import software.amazon.awssdk.services.iot.model.ListJobExecutionsForJobRequest;
import software.amazon.awssdk.services.iot.model.ListJobExecutionsForJobResponse;
import software.amazon.awssdk.services.iot.model.ListJobExecutionsForThingRequest;
import software.amazon.awssdk.services.iot.model.ListJobExecutionsForThingResponse;
import software.amazon.awssdk.services.iot.model.ListJobTemplatesRequest;
import software.amazon.awssdk.services.iot.model.ListJobTemplatesResponse;
import software.amazon.awssdk.services.iot.model.ListJobsRequest;
import software.amazon.awssdk.services.iot.model.ListJobsResponse;
import software.amazon.awssdk.services.iot.model.ListManagedJobTemplatesRequest;
import software.amazon.awssdk.services.iot.model.ListManagedJobTemplatesResponse;
import software.amazon.awssdk.services.iot.model.ListMetricValuesRequest;
import software.amazon.awssdk.services.iot.model.ListMetricValuesResponse;
import software.amazon.awssdk.services.iot.model.ListMitigationActionsRequest;
import software.amazon.awssdk.services.iot.model.ListMitigationActionsResponse;
import software.amazon.awssdk.services.iot.model.ListOtaUpdatesRequest;
import software.amazon.awssdk.services.iot.model.ListOtaUpdatesResponse;
import software.amazon.awssdk.services.iot.model.ListOutgoingCertificatesRequest;
import software.amazon.awssdk.services.iot.model.ListOutgoingCertificatesResponse;
import software.amazon.awssdk.services.iot.model.ListPackageVersionsRequest;
import software.amazon.awssdk.services.iot.model.ListPackageVersionsResponse;
import software.amazon.awssdk.services.iot.model.ListPackagesRequest;
import software.amazon.awssdk.services.iot.model.ListPackagesResponse;
import software.amazon.awssdk.services.iot.model.ListPoliciesRequest;
import software.amazon.awssdk.services.iot.model.ListPoliciesResponse;
import software.amazon.awssdk.services.iot.model.ListPolicyVersionsRequest;
import software.amazon.awssdk.services.iot.model.ListPolicyVersionsResponse;
import software.amazon.awssdk.services.iot.model.ListPrincipalThingsRequest;
import software.amazon.awssdk.services.iot.model.ListPrincipalThingsResponse;
import software.amazon.awssdk.services.iot.model.ListPrincipalThingsV2Request;
import software.amazon.awssdk.services.iot.model.ListPrincipalThingsV2Response;
import software.amazon.awssdk.services.iot.model.ListProvisioningTemplateVersionsRequest;
import software.amazon.awssdk.services.iot.model.ListProvisioningTemplateVersionsResponse;
import software.amazon.awssdk.services.iot.model.ListProvisioningTemplatesRequest;
import software.amazon.awssdk.services.iot.model.ListProvisioningTemplatesResponse;
import software.amazon.awssdk.services.iot.model.ListRelatedResourcesForAuditFindingRequest;
import software.amazon.awssdk.services.iot.model.ListRelatedResourcesForAuditFindingResponse;
import software.amazon.awssdk.services.iot.model.ListRoleAliasesRequest;
import software.amazon.awssdk.services.iot.model.ListRoleAliasesResponse;
import software.amazon.awssdk.services.iot.model.ListSbomValidationResultsRequest;
import software.amazon.awssdk.services.iot.model.ListSbomValidationResultsResponse;
import software.amazon.awssdk.services.iot.model.ListScheduledAuditsRequest;
import software.amazon.awssdk.services.iot.model.ListScheduledAuditsResponse;
import software.amazon.awssdk.services.iot.model.ListSecurityProfilesForTargetRequest;
import software.amazon.awssdk.services.iot.model.ListSecurityProfilesForTargetResponse;
import software.amazon.awssdk.services.iot.model.ListSecurityProfilesRequest;
import software.amazon.awssdk.services.iot.model.ListSecurityProfilesResponse;
import software.amazon.awssdk.services.iot.model.ListStreamsRequest;
import software.amazon.awssdk.services.iot.model.ListStreamsResponse;
import software.amazon.awssdk.services.iot.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iot.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iot.model.ListTargetsForPolicyRequest;
import software.amazon.awssdk.services.iot.model.ListTargetsForPolicyResponse;
import software.amazon.awssdk.services.iot.model.ListTargetsForSecurityProfileRequest;
import software.amazon.awssdk.services.iot.model.ListTargetsForSecurityProfileResponse;
import software.amazon.awssdk.services.iot.model.ListThingGroupsForThingRequest;
import software.amazon.awssdk.services.iot.model.ListThingGroupsForThingResponse;
import software.amazon.awssdk.services.iot.model.ListThingGroupsRequest;
import software.amazon.awssdk.services.iot.model.ListThingGroupsResponse;
import software.amazon.awssdk.services.iot.model.ListThingPrincipalsRequest;
import software.amazon.awssdk.services.iot.model.ListThingPrincipalsResponse;
import software.amazon.awssdk.services.iot.model.ListThingPrincipalsV2Request;
import software.amazon.awssdk.services.iot.model.ListThingPrincipalsV2Response;
import software.amazon.awssdk.services.iot.model.ListThingRegistrationTaskReportsRequest;
import software.amazon.awssdk.services.iot.model.ListThingRegistrationTaskReportsResponse;
import software.amazon.awssdk.services.iot.model.ListThingRegistrationTasksRequest;
import software.amazon.awssdk.services.iot.model.ListThingRegistrationTasksResponse;
import software.amazon.awssdk.services.iot.model.ListThingTypesRequest;
import software.amazon.awssdk.services.iot.model.ListThingTypesResponse;
import software.amazon.awssdk.services.iot.model.ListThingsInBillingGroupRequest;
import software.amazon.awssdk.services.iot.model.ListThingsInBillingGroupResponse;
import software.amazon.awssdk.services.iot.model.ListThingsInThingGroupRequest;
import software.amazon.awssdk.services.iot.model.ListThingsInThingGroupResponse;
import software.amazon.awssdk.services.iot.model.ListThingsRequest;
import software.amazon.awssdk.services.iot.model.ListThingsResponse;
import software.amazon.awssdk.services.iot.model.ListTopicRuleDestinationsRequest;
import software.amazon.awssdk.services.iot.model.ListTopicRuleDestinationsResponse;
import software.amazon.awssdk.services.iot.model.ListTopicRulesRequest;
import software.amazon.awssdk.services.iot.model.ListTopicRulesResponse;
import software.amazon.awssdk.services.iot.model.ListV2LoggingLevelsRequest;
import software.amazon.awssdk.services.iot.model.ListV2LoggingLevelsResponse;
import software.amazon.awssdk.services.iot.model.ListViolationEventsRequest;
import software.amazon.awssdk.services.iot.model.ListViolationEventsResponse;
import software.amazon.awssdk.services.iot.model.MalformedPolicyException;
import software.amazon.awssdk.services.iot.model.NotConfiguredException;
import software.amazon.awssdk.services.iot.model.PutVerificationStateOnViolationRequest;
import software.amazon.awssdk.services.iot.model.PutVerificationStateOnViolationResponse;
import software.amazon.awssdk.services.iot.model.RegisterCaCertificateRequest;
import software.amazon.awssdk.services.iot.model.RegisterCaCertificateResponse;
import software.amazon.awssdk.services.iot.model.RegisterCertificateRequest;
import software.amazon.awssdk.services.iot.model.RegisterCertificateResponse;
import software.amazon.awssdk.services.iot.model.RegisterCertificateWithoutCaRequest;
import software.amazon.awssdk.services.iot.model.RegisterCertificateWithoutCaResponse;
import software.amazon.awssdk.services.iot.model.RegisterThingRequest;
import software.amazon.awssdk.services.iot.model.RegisterThingResponse;
import software.amazon.awssdk.services.iot.model.RegistrationCodeValidationException;
import software.amazon.awssdk.services.iot.model.RejectCertificateTransferRequest;
import software.amazon.awssdk.services.iot.model.RejectCertificateTransferResponse;
import software.amazon.awssdk.services.iot.model.RemoveThingFromBillingGroupRequest;
import software.amazon.awssdk.services.iot.model.RemoveThingFromBillingGroupResponse;
import software.amazon.awssdk.services.iot.model.RemoveThingFromThingGroupRequest;
import software.amazon.awssdk.services.iot.model.RemoveThingFromThingGroupResponse;
import software.amazon.awssdk.services.iot.model.ReplaceTopicRuleRequest;
import software.amazon.awssdk.services.iot.model.ReplaceTopicRuleResponse;
import software.amazon.awssdk.services.iot.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.iot.model.ResourceNotFoundException;
import software.amazon.awssdk.services.iot.model.ResourceRegistrationFailureException;
import software.amazon.awssdk.services.iot.model.SearchIndexRequest;
import software.amazon.awssdk.services.iot.model.SearchIndexResponse;
import software.amazon.awssdk.services.iot.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.iot.model.ServiceUnavailableException;
import software.amazon.awssdk.services.iot.model.SetDefaultAuthorizerRequest;
import software.amazon.awssdk.services.iot.model.SetDefaultAuthorizerResponse;
import software.amazon.awssdk.services.iot.model.SetDefaultPolicyVersionRequest;
import software.amazon.awssdk.services.iot.model.SetDefaultPolicyVersionResponse;
import software.amazon.awssdk.services.iot.model.SetLoggingOptionsRequest;
import software.amazon.awssdk.services.iot.model.SetLoggingOptionsResponse;
import software.amazon.awssdk.services.iot.model.SetV2LoggingLevelRequest;
import software.amazon.awssdk.services.iot.model.SetV2LoggingLevelResponse;
import software.amazon.awssdk.services.iot.model.SetV2LoggingOptionsRequest;
import software.amazon.awssdk.services.iot.model.SetV2LoggingOptionsResponse;
import software.amazon.awssdk.services.iot.model.SqlParseException;
import software.amazon.awssdk.services.iot.model.StartAuditMitigationActionsTaskRequest;
import software.amazon.awssdk.services.iot.model.StartAuditMitigationActionsTaskResponse;
import software.amazon.awssdk.services.iot.model.StartDetectMitigationActionsTaskRequest;
import software.amazon.awssdk.services.iot.model.StartDetectMitigationActionsTaskResponse;
import software.amazon.awssdk.services.iot.model.StartOnDemandAuditTaskRequest;
import software.amazon.awssdk.services.iot.model.StartOnDemandAuditTaskResponse;
import software.amazon.awssdk.services.iot.model.StartThingRegistrationTaskRequest;
import software.amazon.awssdk.services.iot.model.StartThingRegistrationTaskResponse;
import software.amazon.awssdk.services.iot.model.StopThingRegistrationTaskRequest;
import software.amazon.awssdk.services.iot.model.StopThingRegistrationTaskResponse;
import software.amazon.awssdk.services.iot.model.TagResourceRequest;
import software.amazon.awssdk.services.iot.model.TagResourceResponse;
import software.amazon.awssdk.services.iot.model.TaskAlreadyExistsException;
import software.amazon.awssdk.services.iot.model.TestAuthorizationRequest;
import software.amazon.awssdk.services.iot.model.TestAuthorizationResponse;
import software.amazon.awssdk.services.iot.model.TestInvokeAuthorizerRequest;
import software.amazon.awssdk.services.iot.model.TestInvokeAuthorizerResponse;
import software.amazon.awssdk.services.iot.model.ThrottlingException;
import software.amazon.awssdk.services.iot.model.TransferAlreadyCompletedException;
import software.amazon.awssdk.services.iot.model.TransferCertificateRequest;
import software.amazon.awssdk.services.iot.model.TransferCertificateResponse;
import software.amazon.awssdk.services.iot.model.TransferConflictException;
import software.amazon.awssdk.services.iot.model.UnauthorizedException;
import software.amazon.awssdk.services.iot.model.UntagResourceRequest;
import software.amazon.awssdk.services.iot.model.UntagResourceResponse;
import software.amazon.awssdk.services.iot.model.UpdateAccountAuditConfigurationRequest;
import software.amazon.awssdk.services.iot.model.UpdateAccountAuditConfigurationResponse;
import software.amazon.awssdk.services.iot.model.UpdateAuditSuppressionRequest;
import software.amazon.awssdk.services.iot.model.UpdateAuditSuppressionResponse;
import software.amazon.awssdk.services.iot.model.UpdateAuthorizerRequest;
import software.amazon.awssdk.services.iot.model.UpdateAuthorizerResponse;
import software.amazon.awssdk.services.iot.model.UpdateBillingGroupRequest;
import software.amazon.awssdk.services.iot.model.UpdateBillingGroupResponse;
import software.amazon.awssdk.services.iot.model.UpdateCaCertificateRequest;
import software.amazon.awssdk.services.iot.model.UpdateCaCertificateResponse;
import software.amazon.awssdk.services.iot.model.UpdateCertificateProviderRequest;
import software.amazon.awssdk.services.iot.model.UpdateCertificateProviderResponse;
import software.amazon.awssdk.services.iot.model.UpdateCertificateRequest;
import software.amazon.awssdk.services.iot.model.UpdateCertificateResponse;
import software.amazon.awssdk.services.iot.model.UpdateCommandRequest;
import software.amazon.awssdk.services.iot.model.UpdateCommandResponse;
import software.amazon.awssdk.services.iot.model.UpdateCustomMetricRequest;
import software.amazon.awssdk.services.iot.model.UpdateCustomMetricResponse;
import software.amazon.awssdk.services.iot.model.UpdateDimensionRequest;
import software.amazon.awssdk.services.iot.model.UpdateDimensionResponse;
import software.amazon.awssdk.services.iot.model.UpdateDomainConfigurationRequest;
import software.amazon.awssdk.services.iot.model.UpdateDomainConfigurationResponse;
import software.amazon.awssdk.services.iot.model.UpdateDynamicThingGroupRequest;
import software.amazon.awssdk.services.iot.model.UpdateDynamicThingGroupResponse;
import software.amazon.awssdk.services.iot.model.UpdateEventConfigurationsRequest;
import software.amazon.awssdk.services.iot.model.UpdateEventConfigurationsResponse;
import software.amazon.awssdk.services.iot.model.UpdateFleetMetricRequest;
import software.amazon.awssdk.services.iot.model.UpdateFleetMetricResponse;
import software.amazon.awssdk.services.iot.model.UpdateIndexingConfigurationRequest;
import software.amazon.awssdk.services.iot.model.UpdateIndexingConfigurationResponse;
import software.amazon.awssdk.services.iot.model.UpdateJobRequest;
import software.amazon.awssdk.services.iot.model.UpdateJobResponse;
import software.amazon.awssdk.services.iot.model.UpdateMitigationActionRequest;
import software.amazon.awssdk.services.iot.model.UpdateMitigationActionResponse;
import software.amazon.awssdk.services.iot.model.UpdatePackageConfigurationRequest;
import software.amazon.awssdk.services.iot.model.UpdatePackageConfigurationResponse;
import software.amazon.awssdk.services.iot.model.UpdatePackageRequest;
import software.amazon.awssdk.services.iot.model.UpdatePackageResponse;
import software.amazon.awssdk.services.iot.model.UpdatePackageVersionRequest;
import software.amazon.awssdk.services.iot.model.UpdatePackageVersionResponse;
import software.amazon.awssdk.services.iot.model.UpdateProvisioningTemplateRequest;
import software.amazon.awssdk.services.iot.model.UpdateProvisioningTemplateResponse;
import software.amazon.awssdk.services.iot.model.UpdateRoleAliasRequest;
import software.amazon.awssdk.services.iot.model.UpdateRoleAliasResponse;
import software.amazon.awssdk.services.iot.model.UpdateScheduledAuditRequest;
import software.amazon.awssdk.services.iot.model.UpdateScheduledAuditResponse;
import software.amazon.awssdk.services.iot.model.UpdateSecurityProfileRequest;
import software.amazon.awssdk.services.iot.model.UpdateSecurityProfileResponse;
import software.amazon.awssdk.services.iot.model.UpdateStreamRequest;
import software.amazon.awssdk.services.iot.model.UpdateStreamResponse;
import software.amazon.awssdk.services.iot.model.UpdateThingGroupRequest;
import software.amazon.awssdk.services.iot.model.UpdateThingGroupResponse;
import software.amazon.awssdk.services.iot.model.UpdateThingGroupsForThingRequest;
import software.amazon.awssdk.services.iot.model.UpdateThingGroupsForThingResponse;
import software.amazon.awssdk.services.iot.model.UpdateThingRequest;
import software.amazon.awssdk.services.iot.model.UpdateThingResponse;
import software.amazon.awssdk.services.iot.model.UpdateThingTypeRequest;
import software.amazon.awssdk.services.iot.model.UpdateThingTypeResponse;
import software.amazon.awssdk.services.iot.model.UpdateTopicRuleDestinationRequest;
import software.amazon.awssdk.services.iot.model.UpdateTopicRuleDestinationResponse;
import software.amazon.awssdk.services.iot.model.ValidateSecurityProfileBehaviorsRequest;
import software.amazon.awssdk.services.iot.model.ValidateSecurityProfileBehaviorsResponse;
import software.amazon.awssdk.services.iot.model.ValidationException;
import software.amazon.awssdk.services.iot.model.VersionConflictException;
import software.amazon.awssdk.services.iot.model.VersionsLimitExceededException;
import software.amazon.awssdk.services.iot.transform.AcceptCertificateTransferRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.AddThingToBillingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.AddThingToThingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.AssociateSbomWithPackageVersionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.AssociateTargetsWithJobRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.AttachPolicyRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.AttachSecurityProfileRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.AttachThingPrincipalRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CancelAuditMitigationActionsTaskRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CancelAuditTaskRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CancelCertificateTransferRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CancelDetectMitigationActionsTaskRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CancelJobExecutionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CancelJobRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ClearDefaultAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ConfirmTopicRuleDestinationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateAuditSuppressionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateBillingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateCertificateFromCsrRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateCertificateProviderRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateCommandRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateCustomMetricRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateDimensionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateDomainConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateDynamicThingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateFleetMetricRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateJobRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateJobTemplateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateKeysAndCertificateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateMitigationActionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateOtaUpdateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreatePackageRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreatePackageVersionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreatePolicyRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreatePolicyVersionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateProvisioningClaimRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateProvisioningTemplateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateProvisioningTemplateVersionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateRoleAliasRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateScheduledAuditRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateSecurityProfileRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateStreamRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateThingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateThingRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateThingTypeRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateTopicRuleDestinationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateTopicRuleRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteAccountAuditConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteAuditSuppressionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteBillingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteCaCertificateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteCertificateProviderRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteCertificateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteCommandExecutionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteCommandRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteCustomMetricRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteDimensionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteDomainConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteDynamicThingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteFleetMetricRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteJobExecutionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteJobRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteJobTemplateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteMitigationActionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteOtaUpdateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeletePackageRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeletePackageVersionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeletePolicyRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeletePolicyVersionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteProvisioningTemplateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteProvisioningTemplateVersionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteRegistrationCodeRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteRoleAliasRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteScheduledAuditRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteSecurityProfileRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteStreamRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteThingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteThingRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteThingTypeRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteTopicRuleDestinationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteTopicRuleRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteV2LoggingLevelRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeprecateThingTypeRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeAccountAuditConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeAuditFindingRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeAuditMitigationActionsTaskRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeAuditSuppressionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeAuditTaskRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeBillingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeCaCertificateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeCertificateProviderRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeCertificateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeCustomMetricRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeDefaultAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeDetectMitigationActionsTaskRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeDimensionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeDomainConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeEndpointRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeEventConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeFleetMetricRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeIndexRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeJobExecutionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeJobRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeJobTemplateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeManagedJobTemplateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeMitigationActionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeProvisioningTemplateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeProvisioningTemplateVersionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeRoleAliasRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeScheduledAuditRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeSecurityProfileRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeStreamRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeThingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeThingRegistrationTaskRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeThingRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeThingTypeRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DetachPolicyRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DetachSecurityProfileRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DetachThingPrincipalRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DisableTopicRuleRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DisassociateSbomFromPackageVersionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.EnableTopicRuleRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetBehaviorModelTrainingSummariesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetBucketsAggregationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetCardinalityRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetCommandExecutionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetCommandRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetEffectivePoliciesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetIndexingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetJobDocumentRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetLoggingOptionsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetOtaUpdateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetPackageConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetPackageRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetPackageVersionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetPercentilesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetPolicyRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetPolicyVersionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetRegistrationCodeRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetStatisticsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetThingConnectivityDataRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetTopicRuleDestinationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetTopicRuleRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetV2LoggingOptionsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListActiveViolationsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListAttachedPoliciesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListAuditFindingsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListAuditMitigationActionsExecutionsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListAuditMitigationActionsTasksRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListAuditSuppressionsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListAuditTasksRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListAuthorizersRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListBillingGroupsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListCaCertificatesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListCertificateProvidersRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListCertificatesByCaRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListCertificatesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListCommandExecutionsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListCommandsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListCustomMetricsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListDetectMitigationActionsExecutionsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListDetectMitigationActionsTasksRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListDimensionsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListDomainConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListFleetMetricsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListIndicesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListJobExecutionsForJobRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListJobExecutionsForThingRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListJobTemplatesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListJobsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListManagedJobTemplatesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListMetricValuesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListMitigationActionsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListOtaUpdatesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListOutgoingCertificatesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListPackageVersionsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListPackagesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListPoliciesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListPolicyVersionsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListPrincipalThingsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListPrincipalThingsV2RequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListProvisioningTemplateVersionsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListProvisioningTemplatesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListRelatedResourcesForAuditFindingRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListRoleAliasesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListSbomValidationResultsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListScheduledAuditsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListSecurityProfilesForTargetRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListSecurityProfilesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListStreamsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListTargetsForPolicyRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListTargetsForSecurityProfileRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListThingGroupsForThingRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListThingGroupsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListThingPrincipalsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListThingPrincipalsV2RequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListThingRegistrationTaskReportsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListThingRegistrationTasksRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListThingTypesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListThingsInBillingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListThingsInThingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListThingsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListTopicRuleDestinationsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListTopicRulesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListV2LoggingLevelsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListViolationEventsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.PutVerificationStateOnViolationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.RegisterCaCertificateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.RegisterCertificateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.RegisterCertificateWithoutCaRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.RegisterThingRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.RejectCertificateTransferRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.RemoveThingFromBillingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.RemoveThingFromThingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ReplaceTopicRuleRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.SearchIndexRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.SetDefaultAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.SetDefaultPolicyVersionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.SetLoggingOptionsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.SetV2LoggingLevelRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.SetV2LoggingOptionsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.StartAuditMitigationActionsTaskRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.StartDetectMitigationActionsTaskRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.StartOnDemandAuditTaskRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.StartThingRegistrationTaskRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.StopThingRegistrationTaskRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.TestAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.TestInvokeAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.TransferCertificateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateAccountAuditConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateAuditSuppressionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateBillingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateCaCertificateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateCertificateProviderRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateCertificateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateCommandRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateCustomMetricRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateDimensionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateDomainConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateDynamicThingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateEventConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateFleetMetricRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateIndexingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateJobRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateMitigationActionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdatePackageConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdatePackageRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdatePackageVersionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateProvisioningTemplateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateRoleAliasRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateScheduledAuditRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateSecurityProfileRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateStreamRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateThingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateThingGroupsForThingRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateThingRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateThingTypeRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateTopicRuleDestinationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ValidateSecurityProfileBehaviorsRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link IotClient}.
 *
 * @see IotClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultIotClient implements IotClient {
    private static final Logger log = Logger.loggerFor(DefaultIotClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultIotClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Accepts a pending certificate transfer. The default state of the certificate is INACTIVE.
     * </p>
     * <p>
     * To check for pending certificate transfers, call <a>ListCertificates</a> to enumerate your certificates.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >AcceptCertificateTransfer</a> action.
     * </p>
     *
     * @param acceptCertificateTransferRequest
     *        The input for the AcceptCertificateTransfer operation.
     * @return Result of the AcceptCertificateTransfer operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws TransferAlreadyCompletedException
     *         You can't revert the certificate transfer because the transfer is already complete.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.AcceptCertificateTransfer
     */
    @Override
    public AcceptCertificateTransferResponse acceptCertificateTransfer(
            AcceptCertificateTransferRequest acceptCertificateTransferRequest) throws ResourceNotFoundException,
            TransferAlreadyCompletedException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AcceptCertificateTransferResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AcceptCertificateTransferResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(acceptCertificateTransferRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, acceptCertificateTransferRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptCertificateTransfer");

            return clientHandler
                    .execute(new ClientExecutionParams<AcceptCertificateTransferRequest, AcceptCertificateTransferResponse>()
                            .withOperationName("AcceptCertificateTransfer").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(acceptCertificateTransferRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AcceptCertificateTransferRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds a thing to a billing group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >AddThingToBillingGroup</a> action.
     * </p>
     *
     * @param addThingToBillingGroupRequest
     * @return Result of the AddThingToBillingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.AddThingToBillingGroup
     */
    @Override
    public AddThingToBillingGroupResponse addThingToBillingGroup(AddThingToBillingGroupRequest addThingToBillingGroupRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AddThingToBillingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AddThingToBillingGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addThingToBillingGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addThingToBillingGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddThingToBillingGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<AddThingToBillingGroupRequest, AddThingToBillingGroupResponse>()
                            .withOperationName("AddThingToBillingGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(addThingToBillingGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AddThingToBillingGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds a thing to a thing group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >AddThingToThingGroup</a> action.
     * </p>
     *
     * @param addThingToThingGroupRequest
     * @return Result of the AddThingToThingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.AddThingToThingGroup
     */
    @Override
    public AddThingToThingGroupResponse addThingToThingGroup(AddThingToThingGroupRequest addThingToThingGroupRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AddThingToThingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AddThingToThingGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addThingToThingGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addThingToThingGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddThingToThingGroup");

            return clientHandler.execute(new ClientExecutionParams<AddThingToThingGroupRequest, AddThingToThingGroupResponse>()
                    .withOperationName("AddThingToThingGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(addThingToThingGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AddThingToThingGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates the selected software bill of materials (SBOM) with a specific software package version.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >AssociateSbomWithPackageVersion</a> action.
     * </p>
     *
     * @param associateSbomWithPackageVersionRequest
     * @return Result of the AssociateSbomWithPackageVersion operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ValidationException
     *         The request is not valid.
     * @throws ServiceQuotaExceededException
     *         Service quota has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.AssociateSbomWithPackageVersion
     */
    @Override
    public AssociateSbomWithPackageVersionResponse associateSbomWithPackageVersion(
            AssociateSbomWithPackageVersionRequest associateSbomWithPackageVersionRequest) throws ThrottlingException,
            ConflictException, InternalServerException, ValidationException, ServiceQuotaExceededException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateSbomWithPackageVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateSbomWithPackageVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateSbomWithPackageVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateSbomWithPackageVersionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateSbomWithPackageVersion");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateSbomWithPackageVersionRequest, AssociateSbomWithPackageVersionResponse>()
                            .withOperationName("AssociateSbomWithPackageVersion").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associateSbomWithPackageVersionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateSbomWithPackageVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a group with a continuous job. The following criteria must be met:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The job must have been created with the <code>targetSelection</code> field set to "CONTINUOUS".
     * </p>
     * </li>
     * <li>
     * <p>
     * The job status must currently be "IN_PROGRESS".
     * </p>
     * </li>
     * <li>
     * <p>
     * The total number of targets associated with a job must not exceed 100.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >AssociateTargetsWithJob</a> action.
     * </p>
     *
     * @param associateTargetsWithJobRequest
     * @return Result of the AssociateTargetsWithJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.AssociateTargetsWithJob
     */
    @Override
    public AssociateTargetsWithJobResponse associateTargetsWithJob(AssociateTargetsWithJobRequest associateTargetsWithJobRequest)
            throws InvalidRequestException, ResourceNotFoundException, LimitExceededException, ThrottlingException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateTargetsWithJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateTargetsWithJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateTargetsWithJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateTargetsWithJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateTargetsWithJob");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateTargetsWithJobRequest, AssociateTargetsWithJobResponse>()
                            .withOperationName("AssociateTargetsWithJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associateTargetsWithJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateTargetsWithJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Attaches the specified policy to the specified principal (certificate or other credential).
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >AttachPolicy</a> action.
     * </p>
     *
     * @param attachPolicyRequest
     * @return Result of the AttachPolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.AttachPolicy
     */
    @Override
    public AttachPolicyResponse attachPolicy(AttachPolicyRequest attachPolicyRequest) throws ResourceNotFoundException,
            InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, LimitExceededException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AttachPolicyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AttachPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(attachPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, attachPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AttachPolicy");

            return clientHandler.execute(new ClientExecutionParams<AttachPolicyRequest, AttachPolicyResponse>()
                    .withOperationName("AttachPolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(attachPolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AttachPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a Device Defender security profile with a thing group or this account. Each thing group or account can
     * have up to five security profiles associated with it.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >AttachSecurityProfile</a> action.
     * </p>
     *
     * @param attachSecurityProfileRequest
     * @return Result of the AttachSecurityProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws VersionConflictException
     *         An exception thrown when the version of an entity specified with the <code>expectedVersion</code>
     *         parameter does not match the latest version in the system.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.AttachSecurityProfile
     */
    @Override
    public AttachSecurityProfileResponse attachSecurityProfile(AttachSecurityProfileRequest attachSecurityProfileRequest)
            throws InvalidRequestException, ResourceNotFoundException, LimitExceededException, VersionConflictException,
            ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AttachSecurityProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AttachSecurityProfileResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(attachSecurityProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, attachSecurityProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AttachSecurityProfile");

            return clientHandler.execute(new ClientExecutionParams<AttachSecurityProfileRequest, AttachSecurityProfileResponse>()
                    .withOperationName("AttachSecurityProfile").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(attachSecurityProfileRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AttachSecurityProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Attaches the specified principal to the specified thing. A principal can be X.509 certificates, Amazon Cognito
     * identities or federated identities.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >AttachThingPrincipal</a> action.
     * </p>
     *
     * @param attachThingPrincipalRequest
     *        The input for the AttachThingPrincipal operation.
     * @return Result of the AttachThingPrincipal operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.AttachThingPrincipal
     */
    @Override
    public AttachThingPrincipalResponse attachThingPrincipal(AttachThingPrincipalRequest attachThingPrincipalRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AttachThingPrincipalResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AttachThingPrincipalResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(attachThingPrincipalRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, attachThingPrincipalRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AttachThingPrincipal");

            return clientHandler.execute(new ClientExecutionParams<AttachThingPrincipalRequest, AttachThingPrincipalResponse>()
                    .withOperationName("AttachThingPrincipal").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(attachThingPrincipalRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AttachThingPrincipalRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels a mitigation action task that is in progress. If the task is not in progress, an InvalidRequestException
     * occurs.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CancelAuditMitigationActionsTask</a> action.
     * </p>
     *
     * @param cancelAuditMitigationActionsTaskRequest
     * @return Result of the CancelAuditMitigationActionsTask operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CancelAuditMitigationActionsTask
     */
    @Override
    public CancelAuditMitigationActionsTaskResponse cancelAuditMitigationActionsTask(
            CancelAuditMitigationActionsTaskRequest cancelAuditMitigationActionsTaskRequest) throws ResourceNotFoundException,
            InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException,
            IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelAuditMitigationActionsTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CancelAuditMitigationActionsTaskResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelAuditMitigationActionsTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                cancelAuditMitigationActionsTaskRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelAuditMitigationActionsTask");

            return clientHandler
                    .execute(new ClientExecutionParams<CancelAuditMitigationActionsTaskRequest, CancelAuditMitigationActionsTaskResponse>()
                            .withOperationName("CancelAuditMitigationActionsTask").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(cancelAuditMitigationActionsTaskRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CancelAuditMitigationActionsTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels an audit that is in progress. The audit can be either scheduled or on demand. If the audit isn't in
     * progress, an "InvalidRequestException" occurs.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CancelAuditTask</a> action.
     * </p>
     *
     * @param cancelAuditTaskRequest
     * @return Result of the CancelAuditTask operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CancelAuditTask
     */
    @Override
    public CancelAuditTaskResponse cancelAuditTask(CancelAuditTaskRequest cancelAuditTaskRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelAuditTaskResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CancelAuditTaskResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelAuditTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelAuditTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelAuditTask");

            return clientHandler.execute(new ClientExecutionParams<CancelAuditTaskRequest, CancelAuditTaskResponse>()
                    .withOperationName("CancelAuditTask").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(cancelAuditTaskRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CancelAuditTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels a pending transfer for the specified certificate.
     * </p>
     * <p>
     * <b>Note</b> Only the transfer source account can use this operation to cancel a transfer. (Transfer destinations
     * can use <a>RejectCertificateTransfer</a> instead.) After transfer, IoT returns the certificate to the source
     * account in the INACTIVE state. After the destination account has accepted the transfer, the transfer cannot be
     * cancelled.
     * </p>
     * <p>
     * After a certificate transfer is cancelled, the status of the certificate changes from PENDING_TRANSFER to
     * INACTIVE.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CancelCertificateTransfer</a> action.
     * </p>
     *
     * @param cancelCertificateTransferRequest
     *        The input for the CancelCertificateTransfer operation.
     * @return Result of the CancelCertificateTransfer operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws TransferAlreadyCompletedException
     *         You can't revert the certificate transfer because the transfer is already complete.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CancelCertificateTransfer
     */
    @Override
    public CancelCertificateTransferResponse cancelCertificateTransfer(
            CancelCertificateTransferRequest cancelCertificateTransferRequest) throws ResourceNotFoundException,
            TransferAlreadyCompletedException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelCertificateTransferResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CancelCertificateTransferResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelCertificateTransferRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelCertificateTransferRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelCertificateTransfer");

            return clientHandler
                    .execute(new ClientExecutionParams<CancelCertificateTransferRequest, CancelCertificateTransferResponse>()
                            .withOperationName("CancelCertificateTransfer").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(cancelCertificateTransferRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CancelCertificateTransferRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels a Device Defender ML Detect mitigation action.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CancelDetectMitigationActionsTask</a> action.
     * </p>
     *
     * @param cancelDetectMitigationActionsTaskRequest
     * @return Result of the CancelDetectMitigationActionsTask operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CancelDetectMitigationActionsTask
     */
    @Override
    public CancelDetectMitigationActionsTaskResponse cancelDetectMitigationActionsTask(
            CancelDetectMitigationActionsTaskRequest cancelDetectMitigationActionsTaskRequest) throws ResourceNotFoundException,
            InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException,
            IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelDetectMitigationActionsTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CancelDetectMitigationActionsTaskResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelDetectMitigationActionsTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                cancelDetectMitigationActionsTaskRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelDetectMitigationActionsTask");

            return clientHandler
                    .execute(new ClientExecutionParams<CancelDetectMitigationActionsTaskRequest, CancelDetectMitigationActionsTaskResponse>()
                            .withOperationName("CancelDetectMitigationActionsTask").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(cancelDetectMitigationActionsTaskRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CancelDetectMitigationActionsTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels a job.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CancelJob</a> action.
     * </p>
     *
     * @param cancelJobRequest
     * @return Result of the CancelJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CancelJob
     */
    @Override
    public CancelJobResponse cancelJob(CancelJobRequest cancelJobRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, ServiceUnavailableException, LimitExceededException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CancelJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelJob");

            return clientHandler.execute(new ClientExecutionParams<CancelJobRequest, CancelJobResponse>()
                    .withOperationName("CancelJob").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(cancelJobRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CancelJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels the execution of a job for a given thing.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CancelJobExecution</a> action.
     * </p>
     *
     * @param cancelJobExecutionRequest
     * @return Result of the CancelJobExecution operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidStateTransitionException
     *         An attempt was made to change to an invalid state, for example by deleting a job or a job execution which
     *         is "IN_PROGRESS" without setting the <code>force</code> parameter.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws VersionConflictException
     *         An exception thrown when the version of an entity specified with the <code>expectedVersion</code>
     *         parameter does not match the latest version in the system.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CancelJobExecution
     */
    @Override
    public CancelJobExecutionResponse cancelJobExecution(CancelJobExecutionRequest cancelJobExecutionRequest)
            throws InvalidRequestException, InvalidStateTransitionException, ResourceNotFoundException, ThrottlingException,
            ServiceUnavailableException, VersionConflictException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelJobExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CancelJobExecutionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelJobExecutionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelJobExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelJobExecution");

            return clientHandler.execute(new ClientExecutionParams<CancelJobExecutionRequest, CancelJobExecutionResponse>()
                    .withOperationName("CancelJobExecution").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(cancelJobExecutionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CancelJobExecutionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Clears the default authorizer.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ClearDefaultAuthorizer</a> action.
     * </p>
     *
     * @param clearDefaultAuthorizerRequest
     * @return Result of the ClearDefaultAuthorizer operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ClearDefaultAuthorizer
     */
    @Override
    public ClearDefaultAuthorizerResponse clearDefaultAuthorizer(ClearDefaultAuthorizerRequest clearDefaultAuthorizerRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ClearDefaultAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ClearDefaultAuthorizerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(clearDefaultAuthorizerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, clearDefaultAuthorizerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ClearDefaultAuthorizer");

            return clientHandler
                    .execute(new ClientExecutionParams<ClearDefaultAuthorizerRequest, ClearDefaultAuthorizerResponse>()
                            .withOperationName("ClearDefaultAuthorizer").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(clearDefaultAuthorizerRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ClearDefaultAuthorizerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Confirms a topic rule destination. When you create a rule requiring a destination, IoT sends a confirmation
     * message to the endpoint or base address you specify. The message includes a token which you pass back when
     * calling <code>ConfirmTopicRuleDestination</code> to confirm that you own or have access to the endpoint.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ConfirmTopicRuleDestination</a> action.
     * </p>
     *
     * @param confirmTopicRuleDestinationRequest
     * @return Result of the ConfirmTopicRuleDestination operation returned by the service.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictingResourceUpdateException
     *         A conflicting resource update exception. This exception is thrown when two pending updates cause a
     *         conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ConfirmTopicRuleDestination
     */
    @Override
    public ConfirmTopicRuleDestinationResponse confirmTopicRuleDestination(
            ConfirmTopicRuleDestinationRequest confirmTopicRuleDestinationRequest) throws InternalException,
            InvalidRequestException, ServiceUnavailableException, UnauthorizedException, ConflictingResourceUpdateException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ConfirmTopicRuleDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ConfirmTopicRuleDestinationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(confirmTopicRuleDestinationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, confirmTopicRuleDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ConfirmTopicRuleDestination");

            return clientHandler
                    .execute(new ClientExecutionParams<ConfirmTopicRuleDestinationRequest, ConfirmTopicRuleDestinationResponse>()
                            .withOperationName("ConfirmTopicRuleDestination").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(confirmTopicRuleDestinationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ConfirmTopicRuleDestinationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a Device Defender audit suppression.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateAuditSuppression</a> action.
     * </p>
     *
     * @param createAuditSuppressionRequest
     * @return Result of the CreateAuditSuppression operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateAuditSuppression
     */
    @Override
    public CreateAuditSuppressionResponse createAuditSuppression(CreateAuditSuppressionRequest createAuditSuppressionRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, InternalFailureException,
            LimitExceededException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAuditSuppressionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateAuditSuppressionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAuditSuppressionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAuditSuppressionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAuditSuppression");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateAuditSuppressionRequest, CreateAuditSuppressionResponse>()
                            .withOperationName("CreateAuditSuppression").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createAuditSuppressionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateAuditSuppressionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an authorizer.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateAuthorizer</a> action.
     * </p>
     *
     * @param createAuthorizerRequest
     * @return Result of the CreateAuthorizer operation returned by the service.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateAuthorizer
     */
    @Override
    public CreateAuthorizerResponse createAuthorizer(CreateAuthorizerRequest createAuthorizerRequest)
            throws ResourceAlreadyExistsException, InvalidRequestException, LimitExceededException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateAuthorizerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAuthorizerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAuthorizerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAuthorizer");

            return clientHandler.execute(new ClientExecutionParams<CreateAuthorizerRequest, CreateAuthorizerResponse>()
                    .withOperationName("CreateAuthorizer").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createAuthorizerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateAuthorizerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a billing group. If this call is made multiple times using the same billing group name and configuration,
     * the call will succeed. If this call is made with the same billing group name but different configuration a
     * <code>ResourceAlreadyExistsException</code> is thrown.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateBillingGroup</a> action.
     * </p>
     *
     * @param createBillingGroupRequest
     * @return Result of the CreateBillingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateBillingGroup
     */
    @Override
    public CreateBillingGroupResponse createBillingGroup(CreateBillingGroupRequest createBillingGroupRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateBillingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateBillingGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBillingGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBillingGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBillingGroup");

            return clientHandler.execute(new ClientExecutionParams<CreateBillingGroupRequest, CreateBillingGroupResponse>()
                    .withOperationName("CreateBillingGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createBillingGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateBillingGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an X.509 certificate using the specified certificate signing request.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateCertificateFromCsr</a> action.
     * </p>
     * <note>
     * <p>
     * The CSR must include a public key that is either an RSA key with a length of at least 2048 bits or an ECC key
     * from NIST P-256, NIST P-384, or NIST P-521 curves. For supported certificates, consult <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html#x509-cert-algorithms">
     * Certificate signing algorithms supported by IoT</a>.
     * </p>
     * </note> <note>
     * <p>
     * Reusing the same certificate signing request (CSR) results in a distinct certificate.
     * </p>
     * </note>
     * <p>
     * You can create multiple certificates in a batch by creating a directory, copying multiple <code>.csr</code> files
     * into that directory, and then specifying that directory on the command line. The following commands show how to
     * create a batch of certificates given a batch of CSRs. In the following commands, we assume that a set of CSRs are
     * located inside of the directory my-csr-directory:
     * </p>
     * <p>
     * On Linux and OS X, the command is:
     * </p>
     * <p>
     * <code>&#36 ls my-csr-directory/ | xargs -I {} aws iot create-certificate-from-csr --certificate-signing-request file://my-csr-directory/{}</code>
     * </p>
     * <p>
     * This command lists all of the CSRs in my-csr-directory and pipes each CSR file name to the
     * <code>aws iot create-certificate-from-csr</code> Amazon Web Services CLI command to create a certificate for the
     * corresponding CSR.
     * </p>
     * <p>
     * You can also run the <code>aws iot create-certificate-from-csr</code> part of the command in parallel to speed up
     * the certificate creation process:
     * </p>
     * <p>
     * <code>&#36 ls my-csr-directory/ | xargs -P 10 -I {} aws iot create-certificate-from-csr --certificate-signing-request file://my-csr-directory/{} </code>
     * </p>
     * <p>
     * On Windows PowerShell, the command to create certificates for all CSRs in my-csr-directory is:
     * </p>
     * <p>
     * <code>&gt; ls -Name my-csr-directory | %{aws iot create-certificate-from-csr --certificate-signing-request file://my-csr-directory/&#36_} </code>
     * </p>
     * <p>
     * On a Windows command prompt, the command to create certificates for all CSRs in my-csr-directory is:
     * </p>
     * <p>
     * <code>&gt; forfiles /p my-csr-directory /c "cmd /c aws iot create-certificate-from-csr --certificate-signing-request file://@path" </code>
     * </p>
     *
     * @param createCertificateFromCsrRequest
     *        The input for the CreateCertificateFromCsr operation.
     * @return Result of the CreateCertificateFromCsr operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateCertificateFromCsr
     */
    @Override
    public CreateCertificateFromCsrResponse createCertificateFromCsr(
            CreateCertificateFromCsrRequest createCertificateFromCsrRequest) throws InvalidRequestException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateCertificateFromCsrResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateCertificateFromCsrResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCertificateFromCsrRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCertificateFromCsrRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCertificateFromCsr");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateCertificateFromCsrRequest, CreateCertificateFromCsrResponse>()
                            .withOperationName("CreateCertificateFromCsr").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createCertificateFromCsrRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateCertificateFromCsrRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Amazon Web Services IoT Core certificate provider. You can use Amazon Web Services IoT Core
     * certificate provider to customize how to sign a certificate signing request (CSR) in IoT fleet provisioning. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/provisioning-cert-provider.html">Customizing
     * certificate signing using Amazon Web Services IoT Core certificate provider</a> from <i>Amazon Web Services IoT
     * Core Developer Guide</i>.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateCertificateProvider</a> action.
     * </p>
     * <important>
     * <p>
     * After you create a certificate provider, the behavior of <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/fleet-provision-api.html#create-cert-csr">
     * <code>CreateCertificateFromCsr</code> API for fleet provisioning</a> will change and all API calls to
     * <code>CreateCertificateFromCsr</code> will invoke the certificate provider to create the certificates. It can
     * take up to a few minutes for this behavior to change after a certificate provider is created.
     * </p>
     * </important>
     *
     * @param createCertificateProviderRequest
     * @return Result of the CreateCertificateProvider operation returned by the service.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateCertificateProvider
     */
    @Override
    public CreateCertificateProviderResponse createCertificateProvider(
            CreateCertificateProviderRequest createCertificateProviderRequest) throws LimitExceededException,
            ResourceAlreadyExistsException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateCertificateProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateCertificateProviderResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCertificateProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCertificateProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCertificateProvider");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateCertificateProviderRequest, CreateCertificateProviderResponse>()
                            .withOperationName("CreateCertificateProvider").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createCertificateProviderRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateCertificateProviderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a command. A command contains reusable configurations that can be applied before they are sent to the
     * devices.
     * </p>
     *
     * @param createCommandRequest
     * @return Result of the CreateCommand operation returned by the service.
     * @throws ValidationException
     *         The request is not valid.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource.
     * @throws ServiceQuotaExceededException
     *         Service quota has been exceeded.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateCommand
     */
    @Override
    public CreateCommandResponse createCommand(CreateCommandRequest createCommandRequest) throws ValidationException,
            ConflictException, ServiceQuotaExceededException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateCommandResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateCommandResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCommandRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCommandRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCommand");

            return clientHandler.execute(new ClientExecutionParams<CreateCommandRequest, CreateCommandResponse>()
                    .withOperationName("CreateCommand").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createCommandRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateCommandRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Use this API to define a Custom Metric published by your devices to Device Defender.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateCustomMetric</a> action.
     * </p>
     *
     * @param createCustomMetricRequest
     * @return Result of the CreateCustomMetric operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateCustomMetric
     */
    @Override
    public CreateCustomMetricResponse createCustomMetric(CreateCustomMetricRequest createCustomMetricRequest)
            throws InvalidRequestException, LimitExceededException, ResourceAlreadyExistsException, ThrottlingException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateCustomMetricResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateCustomMetricResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCustomMetricRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCustomMetricRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCustomMetric");

            return clientHandler.execute(new ClientExecutionParams<CreateCustomMetricRequest, CreateCustomMetricResponse>()
                    .withOperationName("CreateCustomMetric").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createCustomMetricRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateCustomMetricRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create a dimension that you can use to limit the scope of a metric used in a security profile for IoT Device
     * Defender. For example, using a <code>TOPIC_FILTER</code> dimension, you can narrow down the scope of the metric
     * only to MQTT topics whose name match the pattern specified in the dimension.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateDimension</a> action.
     * </p>
     *
     * @param createDimensionRequest
     * @return Result of the CreateDimension operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateDimension
     */
    @Override
    public CreateDimensionResponse createDimension(CreateDimensionRequest createDimensionRequest)
            throws InternalFailureException, InvalidRequestException, LimitExceededException, ResourceAlreadyExistsException,
            ThrottlingException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDimensionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateDimensionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDimensionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDimensionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDimension");

            return clientHandler.execute(new ClientExecutionParams<CreateDimensionRequest, CreateDimensionResponse>()
                    .withOperationName("CreateDimension").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createDimensionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDimensionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a domain configuration.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateDomainConfiguration</a> action.
     * </p>
     *
     * @param createDomainConfigurationRequest
     * @return Result of the CreateDomainConfiguration operation returned by the service.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws CertificateValidationException
     *         The certificate is invalid.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateDomainConfiguration
     */
    @Override
    public CreateDomainConfigurationResponse createDomainConfiguration(
            CreateDomainConfigurationRequest createDomainConfigurationRequest) throws LimitExceededException,
            CertificateValidationException, ResourceAlreadyExistsException, ServiceUnavailableException,
            InternalFailureException, InvalidRequestException, UnauthorizedException, ThrottlingException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDomainConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateDomainConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDomainConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDomainConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDomainConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateDomainConfigurationRequest, CreateDomainConfigurationResponse>()
                            .withOperationName("CreateDomainConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createDomainConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateDomainConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a dynamic thing group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateDynamicThingGroup</a> action.
     * </p>
     *
     * @param createDynamicThingGroupRequest
     * @return Result of the CreateDynamicThingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidQueryException
     *         The query is invalid.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateDynamicThingGroup
     */
    @Override
    public CreateDynamicThingGroupResponse createDynamicThingGroup(CreateDynamicThingGroupRequest createDynamicThingGroupRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ResourceNotFoundException, ThrottlingException,
            InternalFailureException, InvalidQueryException, LimitExceededException, AwsServiceException, SdkClientException,
            IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDynamicThingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateDynamicThingGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDynamicThingGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDynamicThingGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDynamicThingGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateDynamicThingGroupRequest, CreateDynamicThingGroupResponse>()
                            .withOperationName("CreateDynamicThingGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createDynamicThingGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateDynamicThingGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a fleet metric.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateFleetMetric</a> action.
     * </p>
     *
     * @param createFleetMetricRequest
     * @return Result of the CreateFleetMetric operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidQueryException
     *         The query is invalid.
     * @throws InvalidAggregationException
     *         The aggregation is invalid.
     * @throws IndexNotReadyException
     *         The index is not ready.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateFleetMetric
     */
    @Override
    public CreateFleetMetricResponse createFleetMetric(CreateFleetMetricRequest createFleetMetricRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, LimitExceededException, ResourceAlreadyExistsException, ResourceNotFoundException,
            InvalidQueryException, InvalidAggregationException, IndexNotReadyException, AwsServiceException, SdkClientException,
            IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateFleetMetricResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateFleetMetricResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFleetMetricRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFleetMetricRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFleetMetric");

            return clientHandler.execute(new ClientExecutionParams<CreateFleetMetricRequest, CreateFleetMetricResponse>()
                    .withOperationName("CreateFleetMetric").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createFleetMetricRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateFleetMetricRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a job.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateJob</a> action.
     * </p>
     *
     * @param createJobRequest
     * @return Result of the CreateJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateJob
     */
    @Override
    public CreateJobResponse createJob(CreateJobRequest createJobRequest) throws InvalidRequestException,
            ResourceNotFoundException, ResourceAlreadyExistsException, LimitExceededException, ThrottlingException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateJob");

            return clientHandler.execute(new ClientExecutionParams<CreateJobRequest, CreateJobResponse>()
                    .withOperationName("CreateJob").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createJobRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a job template.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateJobTemplate</a> action.
     * </p>
     *
     * @param createJobTemplateRequest
     * @return Result of the CreateJobTemplate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateJobTemplate
     */
    @Override
    public CreateJobTemplateResponse createJobTemplate(CreateJobTemplateRequest createJobTemplateRequest)
            throws InvalidRequestException, ResourceNotFoundException, ConflictException, LimitExceededException,
            ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateJobTemplateResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateJobTemplateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createJobTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createJobTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateJobTemplate");

            return clientHandler.execute(new ClientExecutionParams<CreateJobTemplateRequest, CreateJobTemplateResponse>()
                    .withOperationName("CreateJobTemplate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createJobTemplateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateJobTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a 2048-bit RSA key pair and issues an X.509 certificate using the issued public key. You can also call
     * <code>CreateKeysAndCertificate</code> over MQTT from a device, for more information, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/provision-wo-cert.html#provision-mqtt-api"
     * >Provisioning MQTT API</a>.
     * </p>
     * <p>
     * <b>Note</b> This is the only time IoT issues the private key for this certificate, so it is important to keep it
     * in a secure location.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateKeysAndCertificate</a> action.
     * </p>
     *
     * @param createKeysAndCertificateRequest
     *        The input for the CreateKeysAndCertificate operation.</p>
     *        <p>
     *        Requires permission to access the <a href=
     *        "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     *        >CreateKeysAndCertificateRequest</a> action.
     * @return Result of the CreateKeysAndCertificate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateKeysAndCertificate
     */
    @Override
    public CreateKeysAndCertificateResponse createKeysAndCertificate(
            CreateKeysAndCertificateRequest createKeysAndCertificateRequest) throws InvalidRequestException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateKeysAndCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateKeysAndCertificateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createKeysAndCertificateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createKeysAndCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateKeysAndCertificate");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateKeysAndCertificateRequest, CreateKeysAndCertificateResponse>()
                            .withOperationName("CreateKeysAndCertificate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createKeysAndCertificateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateKeysAndCertificateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Defines an action that can be applied to audit findings by using StartAuditMitigationActionsTask. Only certain
     * types of mitigation actions can be applied to specific check names. For more information, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/device-defender-mitigation-actions.html">Mitigation
     * actions</a>. Each mitigation action can apply only one type of change.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateMitigationAction</a> action.
     * </p>
     *
     * @param createMitigationActionRequest
     * @return Result of the CreateMitigationAction operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateMitigationAction
     */
    @Override
    public CreateMitigationActionResponse createMitigationAction(CreateMitigationActionRequest createMitigationActionRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, LimitExceededException, ThrottlingException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateMitigationActionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateMitigationActionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMitigationActionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMitigationActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMitigationAction");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateMitigationActionRequest, CreateMitigationActionResponse>()
                            .withOperationName("CreateMitigationAction").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createMitigationActionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateMitigationActionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an IoT OTA update on a target group of things or groups.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateOTAUpdate</a> action.
     * </p>
     *
     * @param createOtaUpdateRequest
     * @return Result of the CreateOTAUpdate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateOTAUpdate
     */
    @Override
    public CreateOtaUpdateResponse createOTAUpdate(CreateOtaUpdateRequest createOtaUpdateRequest) throws InvalidRequestException,
            LimitExceededException, ResourceNotFoundException, ResourceAlreadyExistsException, ThrottlingException,
            UnauthorizedException, InternalFailureException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateOtaUpdateResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateOtaUpdateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createOtaUpdateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createOtaUpdateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateOTAUpdate");

            return clientHandler.execute(new ClientExecutionParams<CreateOtaUpdateRequest, CreateOtaUpdateResponse>()
                    .withOperationName("CreateOTAUpdate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createOtaUpdateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateOtaUpdateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an IoT software package that can be deployed to your fleet.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreatePackage</a> and <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetIndexingConfiguration</a> actions.
     * </p>
     *
     * @param createPackageRequest
     * @return Result of the CreatePackage operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ValidationException
     *         The request is not valid.
     * @throws ServiceQuotaExceededException
     *         Service quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreatePackage
     */
    @Override
    public CreatePackageResponse createPackage(CreatePackageRequest createPackageRequest) throws ThrottlingException,
            ConflictException, InternalServerException, ValidationException, ServiceQuotaExceededException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePackageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreatePackageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPackageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPackageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePackage");

            return clientHandler.execute(new ClientExecutionParams<CreatePackageRequest, CreatePackageResponse>()
                    .withOperationName("CreatePackage").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createPackageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreatePackageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new version for an existing IoT software package.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreatePackageVersion</a> and <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetIndexingConfiguration</a> actions.
     * </p>
     *
     * @param createPackageVersionRequest
     * @return Result of the CreatePackageVersion operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ValidationException
     *         The request is not valid.
     * @throws ServiceQuotaExceededException
     *         Service quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreatePackageVersion
     */
    @Override
    public CreatePackageVersionResponse createPackageVersion(CreatePackageVersionRequest createPackageVersionRequest)
            throws ThrottlingException, ConflictException, InternalServerException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePackageVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreatePackageVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPackageVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPackageVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePackageVersion");

            return clientHandler.execute(new ClientExecutionParams<CreatePackageVersionRequest, CreatePackageVersionResponse>()
                    .withOperationName("CreatePackageVersion").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createPackageVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreatePackageVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an IoT policy.
     * </p>
     * <p>
     * The created policy is the default version for the policy. This operation creates a policy version with a version
     * identifier of <b>1</b> and sets <b>1</b> as the policy's default version.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreatePolicy</a> action.
     * </p>
     *
     * @param createPolicyRequest
     *        The input for the CreatePolicy operation.
     * @return Result of the CreatePolicy operation returned by the service.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws MalformedPolicyException
     *         The policy documentation is not valid.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreatePolicy
     */
    @Override
    public CreatePolicyResponse createPolicy(CreatePolicyRequest createPolicyRequest) throws ResourceAlreadyExistsException,
            MalformedPolicyException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePolicyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreatePolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePolicy");

            return clientHandler.execute(new ClientExecutionParams<CreatePolicyRequest, CreatePolicyResponse>()
                    .withOperationName("CreatePolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createPolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreatePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new version of the specified IoT policy. To update a policy, create a new policy version. A managed
     * policy can have up to five versions. If the policy has five versions, you must use <a>DeletePolicyVersion</a> to
     * delete an existing version before you create a new one.
     * </p>
     * <p>
     * Optionally, you can set the new version as the policy's default version. The default version is the operative
     * version (that is, the version that is in effect for the certificates to which the policy is attached).
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreatePolicyVersion</a> action.
     * </p>
     *
     * @param createPolicyVersionRequest
     *        The input for the CreatePolicyVersion operation.
     * @return Result of the CreatePolicyVersion operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws MalformedPolicyException
     *         The policy documentation is not valid.
     * @throws VersionsLimitExceededException
     *         The number of policy versions exceeds the limit.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreatePolicyVersion
     */
    @Override
    public CreatePolicyVersionResponse createPolicyVersion(CreatePolicyVersionRequest createPolicyVersionRequest)
            throws ResourceNotFoundException, MalformedPolicyException, VersionsLimitExceededException, InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePolicyVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreatePolicyVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPolicyVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPolicyVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePolicyVersion");

            return clientHandler.execute(new ClientExecutionParams<CreatePolicyVersionRequest, CreatePolicyVersionResponse>()
                    .withOperationName("CreatePolicyVersion").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createPolicyVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreatePolicyVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a provisioning claim.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateProvisioningClaim</a> action.
     * </p>
     *
     * @param createProvisioningClaimRequest
     * @return Result of the CreateProvisioningClaim operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateProvisioningClaim
     */
    @Override
    public CreateProvisioningClaimResponse createProvisioningClaim(CreateProvisioningClaimRequest createProvisioningClaimRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateProvisioningClaimResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateProvisioningClaimResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createProvisioningClaimRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createProvisioningClaimRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateProvisioningClaim");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateProvisioningClaimRequest, CreateProvisioningClaimResponse>()
                            .withOperationName("CreateProvisioningClaim").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createProvisioningClaimRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateProvisioningClaimRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a provisioning template.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateProvisioningTemplate</a> action.
     * </p>
     *
     * @param createProvisioningTemplateRequest
     * @return Result of the CreateProvisioningTemplate operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateProvisioningTemplate
     */
    @Override
    public CreateProvisioningTemplateResponse createProvisioningTemplate(
            CreateProvisioningTemplateRequest createProvisioningTemplateRequest) throws InternalFailureException,
            InvalidRequestException, LimitExceededException, ThrottlingException, UnauthorizedException,
            ResourceAlreadyExistsException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateProvisioningTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateProvisioningTemplateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createProvisioningTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createProvisioningTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateProvisioningTemplate");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateProvisioningTemplateRequest, CreateProvisioningTemplateResponse>()
                            .withOperationName("CreateProvisioningTemplate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createProvisioningTemplateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateProvisioningTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new version of a provisioning template.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateProvisioningTemplateVersion</a> action.
     * </p>
     *
     * @param createProvisioningTemplateVersionRequest
     * @return Result of the CreateProvisioningTemplateVersion operation returned by the service.
     * @throws VersionsLimitExceededException
     *         The number of policy versions exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictingResourceUpdateException
     *         A conflicting resource update exception. This exception is thrown when two pending updates cause a
     *         conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateProvisioningTemplateVersion
     */
    @Override
    public CreateProvisioningTemplateVersionResponse createProvisioningTemplateVersion(
            CreateProvisioningTemplateVersionRequest createProvisioningTemplateVersionRequest)
            throws VersionsLimitExceededException, InternalFailureException, InvalidRequestException, ThrottlingException,
            ResourceNotFoundException, UnauthorizedException, ConflictingResourceUpdateException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateProvisioningTemplateVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateProvisioningTemplateVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createProvisioningTemplateVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createProvisioningTemplateVersionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateProvisioningTemplateVersion");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateProvisioningTemplateVersionRequest, CreateProvisioningTemplateVersionResponse>()
                            .withOperationName("CreateProvisioningTemplateVersion").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createProvisioningTemplateVersionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateProvisioningTemplateVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a role alias.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateRoleAlias</a> action.
     * </p>
     * <important>
     * <p>
     * The value of <a href=
     * "https://docs.aws.amazon.com/iot/latest/apireference/API_CreateRoleAlias.html#iot-CreateRoleAlias-request-credentialDurationSeconds"
     * > <code>credentialDurationSeconds</code> </a> must be less than or equal to the maximum session duration of the
     * IAM role that the role alias references. For more information, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/roles-managingrole-editing-api.html#roles-modify_max-session-duration-api"
     * > Modifying a role maximum session duration (Amazon Web Services API)</a> from the Amazon Web Services Identity
     * and Access Management User Guide.
     * </p>
     * </important>
     *
     * @param createRoleAliasRequest
     * @return Result of the CreateRoleAlias operation returned by the service.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateRoleAlias
     */
    @Override
    public CreateRoleAliasResponse createRoleAlias(CreateRoleAliasRequest createRoleAliasRequest)
            throws ResourceAlreadyExistsException, InvalidRequestException, LimitExceededException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateRoleAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateRoleAliasResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRoleAliasRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRoleAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRoleAlias");

            return clientHandler.execute(new ClientExecutionParams<CreateRoleAliasRequest, CreateRoleAliasResponse>()
                    .withOperationName("CreateRoleAlias").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createRoleAliasRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateRoleAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a scheduled audit that is run at a specified time interval.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateScheduledAudit</a> action.
     * </p>
     *
     * @param createScheduledAuditRequest
     * @return Result of the CreateScheduledAudit operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateScheduledAudit
     */
    @Override
    public CreateScheduledAuditResponse createScheduledAudit(CreateScheduledAuditRequest createScheduledAuditRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, InternalFailureException,
            LimitExceededException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateScheduledAuditResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateScheduledAuditResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createScheduledAuditRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createScheduledAuditRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateScheduledAudit");

            return clientHandler.execute(new ClientExecutionParams<CreateScheduledAuditRequest, CreateScheduledAuditResponse>()
                    .withOperationName("CreateScheduledAudit").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createScheduledAuditRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateScheduledAuditRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a Device Defender security profile.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateSecurityProfile</a> action.
     * </p>
     *
     * @param createSecurityProfileRequest
     * @return Result of the CreateSecurityProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateSecurityProfile
     */
    @Override
    public CreateSecurityProfileResponse createSecurityProfile(CreateSecurityProfileRequest createSecurityProfileRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateSecurityProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateSecurityProfileResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSecurityProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSecurityProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSecurityProfile");

            return clientHandler.execute(new ClientExecutionParams<CreateSecurityProfileRequest, CreateSecurityProfileResponse>()
                    .withOperationName("CreateSecurityProfile").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createSecurityProfileRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateSecurityProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a stream for delivering one or more large files in chunks over MQTT. A stream transports data bytes in
     * chunks or blocks packaged as MQTT messages from a source like S3. You can have one or more files associated with
     * a stream.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateStream</a> action.
     * </p>
     *
     * @param createStreamRequest
     * @return Result of the CreateStream operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateStream
     */
    @Override
    public CreateStreamResponse createStream(CreateStreamRequest createStreamRequest) throws InvalidRequestException,
            LimitExceededException, ResourceNotFoundException, ResourceAlreadyExistsException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateStreamResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateStreamResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createStreamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createStreamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStream");

            return clientHandler.execute(new ClientExecutionParams<CreateStreamRequest, CreateStreamResponse>()
                    .withOperationName("CreateStream").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createStreamRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateStreamRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a thing record in the registry. If this call is made multiple times using the same thing name and
     * configuration, the call will succeed. If this call is made with the same thing name but different configuration a
     * <code>ResourceAlreadyExistsException</code> is thrown.
     * </p>
     * <note>
     * <p>
     * This is a control plane operation. See <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-authorization.html">Authorization</a> for
     * information about authorizing control plane actions.
     * </p>
     * </note>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateThing</a> action.
     * </p>
     *
     * @param createThingRequest
     *        The input for the CreateThing operation.
     * @return Result of the CreateThing operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateThing
     */
    @Override
    public CreateThingResponse createThing(CreateThingRequest createThingRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            ResourceAlreadyExistsException, ResourceNotFoundException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateThingResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateThingResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createThingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createThingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateThing");

            return clientHandler.execute(new ClientExecutionParams<CreateThingRequest, CreateThingResponse>()
                    .withOperationName("CreateThing").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createThingRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateThingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create a thing group.
     * </p>
     * <note>
     * <p>
     * This is a control plane operation. See <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-authorization.html">Authorization</a> for
     * information about authorizing control plane actions.
     * </p>
     * <p>
     * If the <code>ThingGroup</code> that you create has the exact same attributes as an existing
     * <code>ThingGroup</code>, you will get a 200 success response.
     * </p>
     * </note>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateThingGroup</a> action.
     * </p>
     *
     * @param createThingGroupRequest
     * @return Result of the CreateThingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateThingGroup
     */
    @Override
    public CreateThingGroupResponse createThingGroup(CreateThingGroupRequest createThingGroupRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateThingGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateThingGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createThingGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createThingGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateThingGroup");

            return clientHandler.execute(new ClientExecutionParams<CreateThingGroupRequest, CreateThingGroupResponse>()
                    .withOperationName("CreateThingGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createThingGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateThingGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new thing type. If this call is made multiple times using the same thing type name and configuration,
     * the call will succeed. If this call is made with the same thing type name but different configuration a
     * <code>ResourceAlreadyExistsException</code> is thrown.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateThingType</a> action.
     * </p>
     *
     * @param createThingTypeRequest
     *        The input for the CreateThingType operation.
     * @return Result of the CreateThingType operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateThingType
     */
    @Override
    public CreateThingTypeResponse createThingType(CreateThingTypeRequest createThingTypeRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            ResourceAlreadyExistsException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateThingTypeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateThingTypeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createThingTypeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createThingTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateThingType");

            return clientHandler.execute(new ClientExecutionParams<CreateThingTypeRequest, CreateThingTypeResponse>()
                    .withOperationName("CreateThingType").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createThingTypeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateThingTypeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a rule. Creating rules is an administrator-level action. Any user who has permission to create rules will
     * be able to access data processed by the rule.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateTopicRule</a> action.
     * </p>
     *
     * @param createTopicRuleRequest
     *        The input for the CreateTopicRule operation.
     * @return Result of the CreateTopicRule operation returned by the service.
     * @throws SqlParseException
     *         The Rule-SQL expression can't be parsed correctly.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ConflictingResourceUpdateException
     *         A conflicting resource update exception. This exception is thrown when two pending updates cause a
     *         conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateTopicRule
     */
    @Override
    public CreateTopicRuleResponse createTopicRule(CreateTopicRuleRequest createTopicRuleRequest) throws SqlParseException,
            InternalException, InvalidRequestException, ResourceAlreadyExistsException, ServiceUnavailableException,
            ConflictingResourceUpdateException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateTopicRuleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateTopicRuleResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTopicRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTopicRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTopicRule");

            return clientHandler.execute(new ClientExecutionParams<CreateTopicRuleRequest, CreateTopicRuleResponse>()
                    .withOperationName("CreateTopicRule").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createTopicRuleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateTopicRuleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a topic rule destination. The destination must be confirmed prior to use.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateTopicRuleDestination</a> action.
     * </p>
     *
     * @param createTopicRuleDestinationRequest
     * @return Result of the CreateTopicRuleDestination operation returned by the service.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ConflictingResourceUpdateException
     *         A conflicting resource update exception. This exception is thrown when two pending updates cause a
     *         conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateTopicRuleDestination
     */
    @Override
    public CreateTopicRuleDestinationResponse createTopicRuleDestination(
            CreateTopicRuleDestinationRequest createTopicRuleDestinationRequest) throws InternalException,
            InvalidRequestException, ResourceAlreadyExistsException, ServiceUnavailableException,
            ConflictingResourceUpdateException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateTopicRuleDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateTopicRuleDestinationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTopicRuleDestinationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTopicRuleDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTopicRuleDestination");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateTopicRuleDestinationRequest, CreateTopicRuleDestinationResponse>()
                            .withOperationName("CreateTopicRuleDestination").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createTopicRuleDestinationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateTopicRuleDestinationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Restores the default settings for Device Defender audits for this account. Any configuration data you entered is
     * deleted and all audit checks are reset to disabled.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteAccountAuditConfiguration</a> action.
     * </p>
     *
     * @param deleteAccountAuditConfigurationRequest
     * @return Result of the DeleteAccountAuditConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteAccountAuditConfiguration
     */
    @Override
    public DeleteAccountAuditConfigurationResponse deleteAccountAuditConfiguration(
            DeleteAccountAuditConfigurationRequest deleteAccountAuditConfigurationRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException,
            IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAccountAuditConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteAccountAuditConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAccountAuditConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteAccountAuditConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAccountAuditConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteAccountAuditConfigurationRequest, DeleteAccountAuditConfigurationResponse>()
                            .withOperationName("DeleteAccountAuditConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteAccountAuditConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteAccountAuditConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a Device Defender audit suppression.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteAuditSuppression</a> action.
     * </p>
     *
     * @param deleteAuditSuppressionRequest
     * @return Result of the DeleteAuditSuppression operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteAuditSuppression
     */
    @Override
    public DeleteAuditSuppressionResponse deleteAuditSuppression(DeleteAuditSuppressionRequest deleteAuditSuppressionRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAuditSuppressionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteAuditSuppressionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAuditSuppressionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAuditSuppressionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAuditSuppression");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteAuditSuppressionRequest, DeleteAuditSuppressionResponse>()
                            .withOperationName("DeleteAuditSuppression").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteAuditSuppressionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteAuditSuppressionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an authorizer.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteAuthorizer</a> action.
     * </p>
     *
     * @param deleteAuthorizerRequest
     * @return Result of the DeleteAuthorizer operation returned by the service.
     * @throws DeleteConflictException
     *         You can't delete the resource because it is attached to one or more resources.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteAuthorizer
     */
    @Override
    public DeleteAuthorizerResponse deleteAuthorizer(DeleteAuthorizerRequest deleteAuthorizerRequest)
            throws DeleteConflictException, ResourceNotFoundException, InvalidRequestException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteAuthorizerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAuthorizerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAuthorizerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAuthorizer");

            return clientHandler.execute(new ClientExecutionParams<DeleteAuthorizerRequest, DeleteAuthorizerResponse>()
                    .withOperationName("DeleteAuthorizer").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteAuthorizerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAuthorizerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the billing group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteBillingGroup</a> action.
     * </p>
     *
     * @param deleteBillingGroupRequest
     * @return Result of the DeleteBillingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws VersionConflictException
     *         An exception thrown when the version of an entity specified with the <code>expectedVersion</code>
     *         parameter does not match the latest version in the system.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteBillingGroup
     */
    @Override
    public DeleteBillingGroupResponse deleteBillingGroup(DeleteBillingGroupRequest deleteBillingGroupRequest)
            throws InvalidRequestException, VersionConflictException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteBillingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteBillingGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBillingGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBillingGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBillingGroup");

            return clientHandler.execute(new ClientExecutionParams<DeleteBillingGroupRequest, DeleteBillingGroupResponse>()
                    .withOperationName("DeleteBillingGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteBillingGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteBillingGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a registered CA certificate.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteCACertificate</a> action.
     * </p>
     *
     * @param deleteCaCertificateRequest
     *        Input for the DeleteCACertificate operation.
     * @return Result of the DeleteCACertificate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws CertificateStateException
     *         The certificate operation is not allowed.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteCACertificate
     */
    @Override
    public DeleteCaCertificateResponse deleteCACertificate(DeleteCaCertificateRequest deleteCaCertificateRequest)
            throws InvalidRequestException, CertificateStateException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteCaCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteCaCertificateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCaCertificateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCaCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCACertificate");

            return clientHandler.execute(new ClientExecutionParams<DeleteCaCertificateRequest, DeleteCaCertificateResponse>()
                    .withOperationName("DeleteCACertificate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteCaCertificateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteCaCertificateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified certificate.
     * </p>
     * <p>
     * A certificate cannot be deleted if it has a policy or IoT thing attached to it or if its status is set to ACTIVE.
     * To delete a certificate, first use the <a>DetachPolicy</a> action to detach all policies. Next, use the
     * <a>UpdateCertificate</a> action to set the certificate to the INACTIVE status.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteCertificate</a> action.
     * </p>
     *
     * @param deleteCertificateRequest
     *        The input for the DeleteCertificate operation.
     * @return Result of the DeleteCertificate operation returned by the service.
     * @throws CertificateStateException
     *         The certificate operation is not allowed.
     * @throws DeleteConflictException
     *         You can't delete the resource because it is attached to one or more resources.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteCertificate
     */
    @Override
    public DeleteCertificateResponse deleteCertificate(DeleteCertificateRequest deleteCertificateRequest)
            throws CertificateStateException, DeleteConflictException, InvalidRequestException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteCertificateResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteCertificateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCertificateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCertificate");

            return clientHandler.execute(new ClientExecutionParams<DeleteCertificateRequest, DeleteCertificateResponse>()
                    .withOperationName("DeleteCertificate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteCertificateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteCertificateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a certificate provider.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteCertificateProvider</a> action.
     * </p>
     * <p>
     * If you delete the certificate provider resource, the behavior of <code>CreateCertificateFromCsr</code> will
     * resume, and IoT will create certificates signed by IoT from a certificate signing request (CSR).
     * </p>
     *
     * @param deleteCertificateProviderRequest
     * @return Result of the DeleteCertificateProvider operation returned by the service.
     * @throws DeleteConflictException
     *         You can't delete the resource because it is attached to one or more resources.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteCertificateProvider
     */
    @Override
    public DeleteCertificateProviderResponse deleteCertificateProvider(
            DeleteCertificateProviderRequest deleteCertificateProviderRequest) throws DeleteConflictException,
            ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteCertificateProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteCertificateProviderResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCertificateProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCertificateProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCertificateProvider");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteCertificateProviderRequest, DeleteCertificateProviderResponse>()
                            .withOperationName("DeleteCertificateProvider").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteCertificateProviderRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteCertificateProviderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete a command resource.
     * </p>
     *
     * @param deleteCommandRequest
     * @return Result of the DeleteCommand operation returned by the service.
     * @throws ValidationException
     *         The request is not valid.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteCommand
     */
    @Override
    public DeleteCommandResponse deleteCommand(DeleteCommandRequest deleteCommandRequest) throws ValidationException,
            ConflictException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteCommandResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteCommandResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCommandRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCommandRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCommand");

            return clientHandler.execute(new ClientExecutionParams<DeleteCommandRequest, DeleteCommandResponse>()
                    .withOperationName("DeleteCommand").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteCommandRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteCommandRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete a command execution.
     * </p>
     * <note>
     * <p>
     * Only command executions that enter a terminal state can be deleted from your account.
     * </p>
     * </note>
     *
     * @param deleteCommandExecutionRequest
     * @return Result of the DeleteCommandExecution operation returned by the service.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource.
     * @throws ValidationException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteCommandExecution
     */
    @Override
    public DeleteCommandExecutionResponse deleteCommandExecution(DeleteCommandExecutionRequest deleteCommandExecutionRequest)
            throws ConflictException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteCommandExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteCommandExecutionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCommandExecutionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCommandExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCommandExecution");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteCommandExecutionRequest, DeleteCommandExecutionResponse>()
                            .withOperationName("DeleteCommandExecution").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteCommandExecutionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteCommandExecutionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a Device Defender detect custom metric.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteCustomMetric</a> action.
     * </p>
     * <note>
     * <p>
     * Before you can delete a custom metric, you must first remove the custom metric from all security profiles it's a
     * part of. The security profile associated with the custom metric can be found using the <a
     * href="https://docs.aws.amazon.com/iot/latest/apireference/API_ListSecurityProfiles.html">ListSecurityProfiles</a>
     * API with <code>metricName</code> set to your custom metric name.
     * </p>
     * </note>
     *
     * @param deleteCustomMetricRequest
     * @return Result of the DeleteCustomMetric operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteCustomMetric
     */
    @Override
    public DeleteCustomMetricResponse deleteCustomMetric(DeleteCustomMetricRequest deleteCustomMetricRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteCustomMetricResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteCustomMetricResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCustomMetricRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCustomMetricRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCustomMetric");

            return clientHandler.execute(new ClientExecutionParams<DeleteCustomMetricRequest, DeleteCustomMetricResponse>()
                    .withOperationName("DeleteCustomMetric").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteCustomMetricRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteCustomMetricRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes the specified dimension from your Amazon Web Services accounts.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteDimension</a> action.
     * </p>
     *
     * @param deleteDimensionRequest
     * @return Result of the DeleteDimension operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteDimension
     */
    @Override
    public DeleteDimensionResponse deleteDimension(DeleteDimensionRequest deleteDimensionRequest)
            throws InternalFailureException, InvalidRequestException, ThrottlingException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDimensionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteDimensionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDimensionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDimensionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDimension");

            return clientHandler.execute(new ClientExecutionParams<DeleteDimensionRequest, DeleteDimensionResponse>()
                    .withOperationName("DeleteDimension").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteDimensionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDimensionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified domain configuration.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteDomainConfiguration</a> action.
     * </p>
     *
     * @param deleteDomainConfigurationRequest
     * @return Result of the DeleteDomainConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteDomainConfiguration
     */
    @Override
    public DeleteDomainConfigurationResponse deleteDomainConfiguration(
            DeleteDomainConfigurationRequest deleteDomainConfigurationRequest) throws ResourceNotFoundException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            InvalidRequestException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDomainConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteDomainConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDomainConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDomainConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDomainConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteDomainConfigurationRequest, DeleteDomainConfigurationResponse>()
                            .withOperationName("DeleteDomainConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteDomainConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteDomainConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a dynamic thing group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteDynamicThingGroup</a> action.
     * </p>
     *
     * @param deleteDynamicThingGroupRequest
     * @return Result of the DeleteDynamicThingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws VersionConflictException
     *         An exception thrown when the version of an entity specified with the <code>expectedVersion</code>
     *         parameter does not match the latest version in the system.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteDynamicThingGroup
     */
    @Override
    public DeleteDynamicThingGroupResponse deleteDynamicThingGroup(DeleteDynamicThingGroupRequest deleteDynamicThingGroupRequest)
            throws InvalidRequestException, VersionConflictException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDynamicThingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteDynamicThingGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDynamicThingGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDynamicThingGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDynamicThingGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteDynamicThingGroupRequest, DeleteDynamicThingGroupResponse>()
                            .withOperationName("DeleteDynamicThingGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteDynamicThingGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteDynamicThingGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified fleet metric. Returns successfully with no error if the deletion is successful or you
     * specify a fleet metric that doesn't exist.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteFleetMetric</a> action.
     * </p>
     *
     * @param deleteFleetMetricRequest
     * @return Result of the DeleteFleetMetric operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws VersionConflictException
     *         An exception thrown when the version of an entity specified with the <code>expectedVersion</code>
     *         parameter does not match the latest version in the system.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteFleetMetric
     */
    @Override
    public DeleteFleetMetricResponse deleteFleetMetric(DeleteFleetMetricRequest deleteFleetMetricRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, VersionConflictException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteFleetMetricResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteFleetMetricResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFleetMetricRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFleetMetricRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFleetMetric");

            return clientHandler.execute(new ClientExecutionParams<DeleteFleetMetricRequest, DeleteFleetMetricResponse>()
                    .withOperationName("DeleteFleetMetric").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteFleetMetricRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteFleetMetricRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a job and its related job executions.
     * </p>
     * <p>
     * Deleting a job may take time, depending on the number of job executions created for the job and various other
     * factors. While the job is being deleted, the status of the job will be shown as "DELETION_IN_PROGRESS".
     * Attempting to delete or cancel a job whose status is already "DELETION_IN_PROGRESS" will result in an error.
     * </p>
     * <p>
     * Only 10 jobs may have status "DELETION_IN_PROGRESS" at the same time, or a LimitExceededException will occur.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteJob</a> action.
     * </p>
     *
     * @param deleteJobRequest
     * @return Result of the DeleteJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidStateTransitionException
     *         An attempt was made to change to an invalid state, for example by deleting a job or a job execution which
     *         is "IN_PROGRESS" without setting the <code>force</code> parameter.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteJob
     */
    @Override
    public DeleteJobResponse deleteJob(DeleteJobRequest deleteJobRequest) throws InvalidRequestException,
            InvalidStateTransitionException, ResourceNotFoundException, LimitExceededException, ThrottlingException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteJob");

            return clientHandler.execute(new ClientExecutionParams<DeleteJobRequest, DeleteJobResponse>()
                    .withOperationName("DeleteJob").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteJobRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a job execution.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteJobExecution</a> action.
     * </p>
     *
     * @param deleteJobExecutionRequest
     * @return Result of the DeleteJobExecution operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidStateTransitionException
     *         An attempt was made to change to an invalid state, for example by deleting a job or a job execution which
     *         is "IN_PROGRESS" without setting the <code>force</code> parameter.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteJobExecution
     */
    @Override
    public DeleteJobExecutionResponse deleteJobExecution(DeleteJobExecutionRequest deleteJobExecutionRequest)
            throws InvalidRequestException, InvalidStateTransitionException, ResourceNotFoundException, ThrottlingException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteJobExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteJobExecutionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteJobExecutionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteJobExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteJobExecution");

            return clientHandler.execute(new ClientExecutionParams<DeleteJobExecutionRequest, DeleteJobExecutionResponse>()
                    .withOperationName("DeleteJobExecution").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteJobExecutionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteJobExecutionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified job template.
     * </p>
     *
     * @param deleteJobTemplateRequest
     * @return Result of the DeleteJobTemplate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteJobTemplate
     */
    @Override
    public DeleteJobTemplateResponse deleteJobTemplate(DeleteJobTemplateRequest deleteJobTemplateRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteJobTemplateResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteJobTemplateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteJobTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteJobTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteJobTemplate");

            return clientHandler.execute(new ClientExecutionParams<DeleteJobTemplateRequest, DeleteJobTemplateResponse>()
                    .withOperationName("DeleteJobTemplate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteJobTemplateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteJobTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a defined mitigation action from your Amazon Web Services accounts.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteMitigationAction</a> action.
     * </p>
     *
     * @param deleteMitigationActionRequest
     * @return Result of the DeleteMitigationAction operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteMitigationAction
     */
    @Override
    public DeleteMitigationActionResponse deleteMitigationAction(DeleteMitigationActionRequest deleteMitigationActionRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteMitigationActionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteMitigationActionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMitigationActionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMitigationActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMitigationAction");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteMitigationActionRequest, DeleteMitigationActionResponse>()
                            .withOperationName("DeleteMitigationAction").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteMitigationActionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteMitigationActionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete an OTA update.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteOTAUpdate</a> action.
     * </p>
     *
     * @param deleteOtaUpdateRequest
     * @return Result of the DeleteOTAUpdate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws VersionConflictException
     *         An exception thrown when the version of an entity specified with the <code>expectedVersion</code>
     *         parameter does not match the latest version in the system.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteOTAUpdate
     */
    @Override
    public DeleteOtaUpdateResponse deleteOTAUpdate(DeleteOtaUpdateRequest deleteOtaUpdateRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, UnauthorizedException, InternalFailureException,
            ServiceUnavailableException, VersionConflictException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteOtaUpdateResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteOtaUpdateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteOtaUpdateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteOtaUpdateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteOTAUpdate");

            return clientHandler.execute(new ClientExecutionParams<DeleteOtaUpdateRequest, DeleteOtaUpdateResponse>()
                    .withOperationName("DeleteOTAUpdate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteOtaUpdateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteOtaUpdateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a specific version from a software package.
     * </p>
     * <p>
     * <b>Note:</b> All package versions must be deleted before deleting the software package.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeletePackageVersion</a> action.
     * </p>
     *
     * @param deletePackageRequest
     * @return Result of the DeletePackage operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ValidationException
     *         The request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeletePackage
     */
    @Override
    public DeletePackageResponse deletePackage(DeletePackageRequest deletePackageRequest) throws ThrottlingException,
            InternalServerException, ValidationException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeletePackageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeletePackageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deletePackageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePackageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePackage");

            return clientHandler.execute(new ClientExecutionParams<DeletePackageRequest, DeletePackageResponse>()
                    .withOperationName("DeletePackage").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deletePackageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeletePackageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a specific version from a software package.
     * </p>
     * <p>
     * <b>Note:</b> If a package version is designated as default, you must remove the designation from the software
     * package using the <a>UpdatePackage</a> action.
     * </p>
     *
     * @param deletePackageVersionRequest
     * @return Result of the DeletePackageVersion operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ValidationException
     *         The request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeletePackageVersion
     */
    @Override
    public DeletePackageVersionResponse deletePackageVersion(DeletePackageVersionRequest deletePackageVersionRequest)
            throws ThrottlingException, InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeletePackageVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeletePackageVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deletePackageVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePackageVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePackageVersion");

            return clientHandler.execute(new ClientExecutionParams<DeletePackageVersionRequest, DeletePackageVersionResponse>()
                    .withOperationName("DeletePackageVersion").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deletePackageVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeletePackageVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified policy.
     * </p>
     * <p>
     * A policy cannot be deleted if it has non-default versions or it is attached to any certificate.
     * </p>
     * <p>
     * To delete a policy, use the <a>DeletePolicyVersion</a> action to delete all non-default versions of the policy;
     * use the <a>DetachPolicy</a> action to detach the policy from any certificate; and then use the DeletePolicy
     * action to delete the policy.
     * </p>
     * <p>
     * When a policy is deleted using DeletePolicy, its default version is deleted with it.
     * </p>
     * <note>
     * <p>
     * Because of the distributed nature of Amazon Web Services, it can take up to five minutes after a policy is
     * detached before it's ready to be deleted.
     * </p>
     * </note>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeletePolicy</a> action.
     * </p>
     *
     * @param deletePolicyRequest
     *        The input for the DeletePolicy operation.
     * @return Result of the DeletePolicy operation returned by the service.
     * @throws DeleteConflictException
     *         You can't delete the resource because it is attached to one or more resources.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeletePolicy
     */
    @Override
    public DeletePolicyResponse deletePolicy(DeletePolicyRequest deletePolicyRequest) throws DeleteConflictException,
            ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeletePolicyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeletePolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deletePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePolicy");

            return clientHandler.execute(new ClientExecutionParams<DeletePolicyRequest, DeletePolicyResponse>()
                    .withOperationName("DeletePolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deletePolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeletePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified version of the specified policy. You cannot delete the default version of a policy using
     * this action. To delete the default version of a policy, use <a>DeletePolicy</a>. To find out which version of a
     * policy is marked as the default version, use ListPolicyVersions.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeletePolicyVersion</a> action.
     * </p>
     *
     * @param deletePolicyVersionRequest
     *        The input for the DeletePolicyVersion operation.
     * @return Result of the DeletePolicyVersion operation returned by the service.
     * @throws DeleteConflictException
     *         You can't delete the resource because it is attached to one or more resources.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeletePolicyVersion
     */
    @Override
    public DeletePolicyVersionResponse deletePolicyVersion(DeletePolicyVersionRequest deletePolicyVersionRequest)
            throws DeleteConflictException, ResourceNotFoundException, InvalidRequestException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeletePolicyVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeletePolicyVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "NotConfiguredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotConfiguredException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotConfiguredException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryException::builder).build());
            case "DeleteConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DeleteConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DeleteConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "CertificateConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(CertificateConflictException::builder).build());
            case "RegistrationCodeValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RegistrationCodeValidationException::builder).build());
            case "InvalidResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResponseException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ConflictingResourceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InternalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalException::builder).build());
            case "VersionsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionsLimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionsLimitExceededException::builder).build());
            case "CertificateStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateStateException").httpStatusCode(406)
                        .exceptionBuilderSupplier(CertificateStateException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(410)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "TransferAlreadyCompletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException").httpStatusCode(410)
                        .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "MalformedPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedPolicyException::builder).build());
            case "InvalidStateTransitionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").httpStatusCode(409)
                        .exceptionBuilderSupplier(InvalidStateTransitionException::builder).build());
            case "ResourceRegistrationFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).build());
            case "InvalidAggregationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregationException::builder).build());
            case "SqlParseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SqlParseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SqlParseException::builder).build());
            case "TransferConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TransferConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(TransferConflictException::builder).build());
            case "IndexNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotReadyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IndexNotReadyException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "VersionConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("VersionConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(VersionConflictException::builder).build());
            case "TaskAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).build());
            case "CertificateValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deletePolicyVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePolicyVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePolicyVersion");

            return clientHandler.execute(new ClientExecutionParams<DeletePolicyVersionRequest, DeletePolicyVersionResponse>()
                    .withOperationName("DeletePolicyVersion").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deletePolicyVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeletePolicyVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a provisioning template.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteProvisioningTemplate</a> act