/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteOtaUpdateRequest extends IotRequest implements
        ToCopyableBuilder<DeleteOtaUpdateRequest.Builder, DeleteOtaUpdateRequest> {
    private static final SdkField<String> OTA_UPDATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("otaUpdateId").getter(getter(DeleteOtaUpdateRequest::otaUpdateId)).setter(setter(Builder::otaUpdateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("otaUpdateId").build()).build();

    private static final SdkField<Boolean> DELETE_STREAM_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("deleteStream").getter(getter(DeleteOtaUpdateRequest::deleteStream))
            .setter(setter(Builder::deleteStream))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("deleteStream").build()).build();

    private static final SdkField<Boolean> FORCE_DELETE_AWS_JOB_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("forceDeleteAWSJob").getter(getter(DeleteOtaUpdateRequest::forceDeleteAWSJob))
            .setter(setter(Builder::forceDeleteAWSJob))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("forceDeleteAWSJob").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OTA_UPDATE_ID_FIELD,
            DELETE_STREAM_FIELD, FORCE_DELETE_AWS_JOB_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String otaUpdateId;

    private final Boolean deleteStream;

    private final Boolean forceDeleteAWSJob;

    private DeleteOtaUpdateRequest(BuilderImpl builder) {
        super(builder);
        this.otaUpdateId = builder.otaUpdateId;
        this.deleteStream = builder.deleteStream;
        this.forceDeleteAWSJob = builder.forceDeleteAWSJob;
    }

    /**
     * <p>
     * The ID of the OTA update to delete.
     * </p>
     * 
     * @return The ID of the OTA update to delete.
     */
    public final String otaUpdateId() {
        return otaUpdateId;
    }

    /**
     * <p>
     * When true, the stream created by the OTAUpdate process is deleted when the OTA update is deleted. Ignored if the
     * stream specified in the OTAUpdate is supplied by the user.
     * </p>
     * 
     * @return When true, the stream created by the OTAUpdate process is deleted when the OTA update is deleted. Ignored
     *         if the stream specified in the OTAUpdate is supplied by the user.
     */
    public final Boolean deleteStream() {
        return deleteStream;
    }

    /**
     * <p>
     * When true, deletes the IoT job created by the OTAUpdate process even if it is "IN_PROGRESS". Otherwise, if the
     * job is not in a terminal state ("COMPLETED" or "CANCELED") an exception will occur. The default is false.
     * </p>
     * 
     * @return When true, deletes the IoT job created by the OTAUpdate process even if it is "IN_PROGRESS". Otherwise,
     *         if the job is not in a terminal state ("COMPLETED" or "CANCELED") an exception will occur. The default is
     *         false.
     */
    public final Boolean forceDeleteAWSJob() {
        return forceDeleteAWSJob;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(otaUpdateId());
        hashCode = 31 * hashCode + Objects.hashCode(deleteStream());
        hashCode = 31 * hashCode + Objects.hashCode(forceDeleteAWSJob());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteOtaUpdateRequest)) {
            return false;
        }
        DeleteOtaUpdateRequest other = (DeleteOtaUpdateRequest) obj;
        return Objects.equals(otaUpdateId(), other.otaUpdateId()) && Objects.equals(deleteStream(), other.deleteStream())
                && Objects.equals(forceDeleteAWSJob(), other.forceDeleteAWSJob());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteOtaUpdateRequest").add("OtaUpdateId", otaUpdateId()).add("DeleteStream", deleteStream())
                .add("ForceDeleteAWSJob", forceDeleteAWSJob()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "otaUpdateId":
            return Optional.ofNullable(clazz.cast(otaUpdateId()));
        case "deleteStream":
            return Optional.ofNullable(clazz.cast(deleteStream()));
        case "forceDeleteAWSJob":
            return Optional.ofNullable(clazz.cast(forceDeleteAWSJob()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("otaUpdateId", OTA_UPDATE_ID_FIELD);
        map.put("deleteStream", DELETE_STREAM_FIELD);
        map.put("forceDeleteAWSJob", FORCE_DELETE_AWS_JOB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteOtaUpdateRequest, T> g) {
        return obj -> g.apply((DeleteOtaUpdateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteOtaUpdateRequest> {
        /**
         * <p>
         * The ID of the OTA update to delete.
         * </p>
         * 
         * @param otaUpdateId
         *        The ID of the OTA update to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otaUpdateId(String otaUpdateId);

        /**
         * <p>
         * When true, the stream created by the OTAUpdate process is deleted when the OTA update is deleted. Ignored if
         * the stream specified in the OTAUpdate is supplied by the user.
         * </p>
         * 
         * @param deleteStream
         *        When true, the stream created by the OTAUpdate process is deleted when the OTA update is deleted.
         *        Ignored if the stream specified in the OTAUpdate is supplied by the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteStream(Boolean deleteStream);

        /**
         * <p>
         * When true, deletes the IoT job created by the OTAUpdate process even if it is "IN_PROGRESS". Otherwise, if
         * the job is not in a terminal state ("COMPLETED" or "CANCELED") an exception will occur. The default is false.
         * </p>
         * 
         * @param forceDeleteAWSJob
         *        When true, deletes the IoT job created by the OTAUpdate process even if it is "IN_PROGRESS".
         *        Otherwise, if the job is not in a terminal state ("COMPLETED" or "CANCELED") an exception will occur.
         *        The default is false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forceDeleteAWSJob(Boolean forceDeleteAWSJob);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String otaUpdateId;

        private Boolean deleteStream;

        private Boolean forceDeleteAWSJob;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteOtaUpdateRequest model) {
            super(model);
            otaUpdateId(model.otaUpdateId);
            deleteStream(model.deleteStream);
            forceDeleteAWSJob(model.forceDeleteAWSJob);
        }

        public final String getOtaUpdateId() {
            return otaUpdateId;
        }

        public final void setOtaUpdateId(String otaUpdateId) {
            this.otaUpdateId = otaUpdateId;
        }

        @Override
        public final Builder otaUpdateId(String otaUpdateId) {
            this.otaUpdateId = otaUpdateId;
            return this;
        }

        public final Boolean getDeleteStream() {
            return deleteStream;
        }

        public final void setDeleteStream(Boolean deleteStream) {
            this.deleteStream = deleteStream;
        }

        @Override
        public final Builder deleteStream(Boolean deleteStream) {
            this.deleteStream = deleteStream;
            return this;
        }

        public final Boolean getForceDeleteAWSJob() {
            return forceDeleteAWSJob;
        }

        public final void setForceDeleteAWSJob(Boolean forceDeleteAWSJob) {
            this.forceDeleteAWSJob = forceDeleteAWSJob;
        }

        @Override
        public final Builder forceDeleteAWSJob(Boolean forceDeleteAWSJob) {
            this.forceDeleteAWSJob = forceDeleteAWSJob;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteOtaUpdateRequest build() {
            return new DeleteOtaUpdateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
