/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iot.model.AdditionalParameterMapCopier;
import software.amazon.awssdk.services.iot.model.AwsJobExecutionsRolloutConfig;
import software.amazon.awssdk.services.iot.model.AwsJobPresignedUrlConfig;
import software.amazon.awssdk.services.iot.model.ErrorInfo;
import software.amazon.awssdk.services.iot.model.OTAUpdateFile;
import software.amazon.awssdk.services.iot.model.OTAUpdateFilesCopier;
import software.amazon.awssdk.services.iot.model.OTAUpdateStatus;
import software.amazon.awssdk.services.iot.model.Protocol;
import software.amazon.awssdk.services.iot.model.ProtocolsCopier;
import software.amazon.awssdk.services.iot.model.TargetSelection;
import software.amazon.awssdk.services.iot.model.TargetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OTAUpdateInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OTAUpdateInfo> {
    private static final SdkField<String> OTA_UPDATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("otaUpdateId").getter(OTAUpdateInfo.getter(OTAUpdateInfo::otaUpdateId)).setter(OTAUpdateInfo.setter(Builder::otaUpdateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("otaUpdateId").build()}).build();
    private static final SdkField<String> OTA_UPDATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("otaUpdateArn").getter(OTAUpdateInfo.getter(OTAUpdateInfo::otaUpdateArn)).setter(OTAUpdateInfo.setter(Builder::otaUpdateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("otaUpdateArn").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDate").getter(OTAUpdateInfo.getter(OTAUpdateInfo::creationDate)).setter(OTAUpdateInfo.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedDate").getter(OTAUpdateInfo.getter(OTAUpdateInfo::lastModifiedDate)).setter(OTAUpdateInfo.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(OTAUpdateInfo.getter(OTAUpdateInfo::description)).setter(OTAUpdateInfo.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("targets").getter(OTAUpdateInfo.getter(OTAUpdateInfo::targets)).setter(OTAUpdateInfo.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PROTOCOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("protocols").getter(OTAUpdateInfo.getter(OTAUpdateInfo::protocolsAsStrings)).setter(OTAUpdateInfo.setter(Builder::protocolsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocols").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AwsJobExecutionsRolloutConfig> AWS_JOB_EXECUTIONS_ROLLOUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("awsJobExecutionsRolloutConfig").getter(OTAUpdateInfo.getter(OTAUpdateInfo::awsJobExecutionsRolloutConfig)).setter(OTAUpdateInfo.setter(Builder::awsJobExecutionsRolloutConfig)).constructor(AwsJobExecutionsRolloutConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsJobExecutionsRolloutConfig").build()}).build();
    private static final SdkField<AwsJobPresignedUrlConfig> AWS_JOB_PRESIGNED_URL_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("awsJobPresignedUrlConfig").getter(OTAUpdateInfo.getter(OTAUpdateInfo::awsJobPresignedUrlConfig)).setter(OTAUpdateInfo.setter(Builder::awsJobPresignedUrlConfig)).constructor(AwsJobPresignedUrlConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsJobPresignedUrlConfig").build()}).build();
    private static final SdkField<String> TARGET_SELECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetSelection").getter(OTAUpdateInfo.getter(OTAUpdateInfo::targetSelectionAsString)).setter(OTAUpdateInfo.setter(Builder::targetSelection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetSelection").build()}).build();
    private static final SdkField<List<OTAUpdateFile>> OTA_UPDATE_FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("otaUpdateFiles").getter(OTAUpdateInfo.getter(OTAUpdateInfo::otaUpdateFiles)).setter(OTAUpdateInfo.setter(Builder::otaUpdateFiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("otaUpdateFiles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OTAUpdateFile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OTA_UPDATE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("otaUpdateStatus").getter(OTAUpdateInfo.getter(OTAUpdateInfo::otaUpdateStatusAsString)).setter(OTAUpdateInfo.setter(Builder::otaUpdateStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("otaUpdateStatus").build()}).build();
    private static final SdkField<String> AWS_IOT_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsIotJobId").getter(OTAUpdateInfo.getter(OTAUpdateInfo::awsIotJobId)).setter(OTAUpdateInfo.setter(Builder::awsIotJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsIotJobId").build()}).build();
    private static final SdkField<String> AWS_IOT_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsIotJobArn").getter(OTAUpdateInfo.getter(OTAUpdateInfo::awsIotJobArn)).setter(OTAUpdateInfo.setter(Builder::awsIotJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsIotJobArn").build()}).build();
    private static final SdkField<ErrorInfo> ERROR_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("errorInfo").getter(OTAUpdateInfo.getter(OTAUpdateInfo::errorInfo)).setter(OTAUpdateInfo.setter(Builder::errorInfo)).constructor(ErrorInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorInfo").build()}).build();
    private static final SdkField<Map<String, String>> ADDITIONAL_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("additionalParameters").getter(OTAUpdateInfo.getter(OTAUpdateInfo::additionalParameters)).setter(OTAUpdateInfo.setter(Builder::additionalParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OTA_UPDATE_ID_FIELD, OTA_UPDATE_ARN_FIELD, CREATION_DATE_FIELD, LAST_MODIFIED_DATE_FIELD, DESCRIPTION_FIELD, TARGETS_FIELD, PROTOCOLS_FIELD, AWS_JOB_EXECUTIONS_ROLLOUT_CONFIG_FIELD, AWS_JOB_PRESIGNED_URL_CONFIG_FIELD, TARGET_SELECTION_FIELD, OTA_UPDATE_FILES_FIELD, OTA_UPDATE_STATUS_FIELD, AWS_IOT_JOB_ID_FIELD, AWS_IOT_JOB_ARN_FIELD, ERROR_INFO_FIELD, ADDITIONAL_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OTAUpdateInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String otaUpdateId;
    private final String otaUpdateArn;
    private final Instant creationDate;
    private final Instant lastModifiedDate;
    private final String description;
    private final List<String> targets;
    private final List<String> protocols;
    private final AwsJobExecutionsRolloutConfig awsJobExecutionsRolloutConfig;
    private final AwsJobPresignedUrlConfig awsJobPresignedUrlConfig;
    private final String targetSelection;
    private final List<OTAUpdateFile> otaUpdateFiles;
    private final String otaUpdateStatus;
    private final String awsIotJobId;
    private final String awsIotJobArn;
    private final ErrorInfo errorInfo;
    private final Map<String, String> additionalParameters;

    private OTAUpdateInfo(BuilderImpl builder) {
        this.otaUpdateId = builder.otaUpdateId;
        this.otaUpdateArn = builder.otaUpdateArn;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.description = builder.description;
        this.targets = builder.targets;
        this.protocols = builder.protocols;
        this.awsJobExecutionsRolloutConfig = builder.awsJobExecutionsRolloutConfig;
        this.awsJobPresignedUrlConfig = builder.awsJobPresignedUrlConfig;
        this.targetSelection = builder.targetSelection;
        this.otaUpdateFiles = builder.otaUpdateFiles;
        this.otaUpdateStatus = builder.otaUpdateStatus;
        this.awsIotJobId = builder.awsIotJobId;
        this.awsIotJobArn = builder.awsIotJobArn;
        this.errorInfo = builder.errorInfo;
        this.additionalParameters = builder.additionalParameters;
    }

    public final String otaUpdateId() {
        return this.otaUpdateId;
    }

    public final String otaUpdateArn() {
        return this.otaUpdateArn;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTargets() {
        return this.targets != null && !(this.targets instanceof SdkAutoConstructList);
    }

    public final List<String> targets() {
        return this.targets;
    }

    public final List<Protocol> protocols() {
        return ProtocolsCopier.copyStringToEnum(this.protocols);
    }

    public final boolean hasProtocols() {
        return this.protocols != null && !(this.protocols instanceof SdkAutoConstructList);
    }

    public final List<String> protocolsAsStrings() {
        return this.protocols;
    }

    public final AwsJobExecutionsRolloutConfig awsJobExecutionsRolloutConfig() {
        return this.awsJobExecutionsRolloutConfig;
    }

    public final AwsJobPresignedUrlConfig awsJobPresignedUrlConfig() {
        return this.awsJobPresignedUrlConfig;
    }

    public final TargetSelection targetSelection() {
        return TargetSelection.fromValue(this.targetSelection);
    }

    public final String targetSelectionAsString() {
        return this.targetSelection;
    }

    public final boolean hasOtaUpdateFiles() {
        return this.otaUpdateFiles != null && !(this.otaUpdateFiles instanceof SdkAutoConstructList);
    }

    public final List<OTAUpdateFile> otaUpdateFiles() {
        return this.otaUpdateFiles;
    }

    public final OTAUpdateStatus otaUpdateStatus() {
        return OTAUpdateStatus.fromValue(this.otaUpdateStatus);
    }

    public final String otaUpdateStatusAsString() {
        return this.otaUpdateStatus;
    }

    public final String awsIotJobId() {
        return this.awsIotJobId;
    }

    public final String awsIotJobArn() {
        return this.awsIotJobArn;
    }

    public final ErrorInfo errorInfo() {
        return this.errorInfo;
    }

    public final boolean hasAdditionalParameters() {
        return this.additionalParameters != null && !(this.additionalParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> additionalParameters() {
        return this.additionalParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.otaUpdateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.otaUpdateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargets() ? this.targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProtocols() ? this.protocolsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.awsJobExecutionsRolloutConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsJobPresignedUrlConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetSelectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOtaUpdateFiles() ? this.otaUpdateFiles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.otaUpdateStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsIotJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsIotJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalParameters() ? this.additionalParameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OTAUpdateInfo)) {
            return false;
        }
        OTAUpdateInfo other = (OTAUpdateInfo)obj;
        return Objects.equals(this.otaUpdateId(), other.otaUpdateId()) && Objects.equals(this.otaUpdateArn(), other.otaUpdateArn()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.description(), other.description()) && this.hasTargets() == other.hasTargets() && Objects.equals(this.targets(), other.targets()) && this.hasProtocols() == other.hasProtocols() && Objects.equals(this.protocolsAsStrings(), other.protocolsAsStrings()) && Objects.equals(this.awsJobExecutionsRolloutConfig(), other.awsJobExecutionsRolloutConfig()) && Objects.equals(this.awsJobPresignedUrlConfig(), other.awsJobPresignedUrlConfig()) && Objects.equals(this.targetSelectionAsString(), other.targetSelectionAsString()) && this.hasOtaUpdateFiles() == other.hasOtaUpdateFiles() && Objects.equals(this.otaUpdateFiles(), other.otaUpdateFiles()) && Objects.equals(this.otaUpdateStatusAsString(), other.otaUpdateStatusAsString()) && Objects.equals(this.awsIotJobId(), other.awsIotJobId()) && Objects.equals(this.awsIotJobArn(), other.awsIotJobArn()) && Objects.equals(this.errorInfo(), other.errorInfo()) && this.hasAdditionalParameters() == other.hasAdditionalParameters() && Objects.equals(this.additionalParameters(), other.additionalParameters());
    }

    public final String toString() {
        return ToString.builder((String)"OTAUpdateInfo").add("OtaUpdateId", (Object)this.otaUpdateId()).add("OtaUpdateArn", (Object)this.otaUpdateArn()).add("CreationDate", (Object)this.creationDate()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("Description", (Object)this.description()).add("Targets", this.hasTargets() ? this.targets() : null).add("Protocols", this.hasProtocols() ? this.protocolsAsStrings() : null).add("AwsJobExecutionsRolloutConfig", (Object)this.awsJobExecutionsRolloutConfig()).add("AwsJobPresignedUrlConfig", (Object)this.awsJobPresignedUrlConfig()).add("TargetSelection", (Object)this.targetSelectionAsString()).add("OtaUpdateFiles", this.hasOtaUpdateFiles() ? this.otaUpdateFiles() : null).add("OtaUpdateStatus", (Object)this.otaUpdateStatusAsString()).add("AwsIotJobId", (Object)this.awsIotJobId()).add("AwsIotJobArn", (Object)this.awsIotJobArn()).add("ErrorInfo", (Object)this.errorInfo()).add("AdditionalParameters", this.hasAdditionalParameters() ? this.additionalParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "otaUpdateId": {
                return Optional.ofNullable(clazz.cast(this.otaUpdateId()));
            }
            case "otaUpdateArn": {
                return Optional.ofNullable(clazz.cast(this.otaUpdateArn()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "lastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "protocols": {
                return Optional.ofNullable(clazz.cast(this.protocolsAsStrings()));
            }
            case "awsJobExecutionsRolloutConfig": {
                return Optional.ofNullable(clazz.cast(this.awsJobExecutionsRolloutConfig()));
            }
            case "awsJobPresignedUrlConfig": {
                return Optional.ofNullable(clazz.cast(this.awsJobPresignedUrlConfig()));
            }
            case "targetSelection": {
                return Optional.ofNullable(clazz.cast(this.targetSelectionAsString()));
            }
            case "otaUpdateFiles": {
                return Optional.ofNullable(clazz.cast(this.otaUpdateFiles()));
            }
            case "otaUpdateStatus": {
                return Optional.ofNullable(clazz.cast(this.otaUpdateStatusAsString()));
            }
            case "awsIotJobId": {
                return Optional.ofNullable(clazz.cast(this.awsIotJobId()));
            }
            case "awsIotJobArn": {
                return Optional.ofNullable(clazz.cast(this.awsIotJobArn()));
            }
            case "errorInfo": {
                return Optional.ofNullable(clazz.cast(this.errorInfo()));
            }
            case "additionalParameters": {
                return Optional.ofNullable(clazz.cast(this.additionalParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("otaUpdateId", OTA_UPDATE_ID_FIELD);
        map.put("otaUpdateArn", OTA_UPDATE_ARN_FIELD);
        map.put("creationDate", CREATION_DATE_FIELD);
        map.put("lastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("targets", TARGETS_FIELD);
        map.put("protocols", PROTOCOLS_FIELD);
        map.put("awsJobExecutionsRolloutConfig", AWS_JOB_EXECUTIONS_ROLLOUT_CONFIG_FIELD);
        map.put("awsJobPresignedUrlConfig", AWS_JOB_PRESIGNED_URL_CONFIG_FIELD);
        map.put("targetSelection", TARGET_SELECTION_FIELD);
        map.put("otaUpdateFiles", OTA_UPDATE_FILES_FIELD);
        map.put("otaUpdateStatus", OTA_UPDATE_STATUS_FIELD);
        map.put("awsIotJobId", AWS_IOT_JOB_ID_FIELD);
        map.put("awsIotJobArn", AWS_IOT_JOB_ARN_FIELD);
        map.put("errorInfo", ERROR_INFO_FIELD);
        map.put("additionalParameters", ADDITIONAL_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OTAUpdateInfo, T> g) {
        return obj -> g.apply((OTAUpdateInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String otaUpdateId;
        private String otaUpdateArn;
        private Instant creationDate;
        private Instant lastModifiedDate;
        private String description;
        private List<String> targets = DefaultSdkAutoConstructList.getInstance();
        private List<String> protocols = DefaultSdkAutoConstructList.getInstance();
        private AwsJobExecutionsRolloutConfig awsJobExecutionsRolloutConfig;
        private AwsJobPresignedUrlConfig awsJobPresignedUrlConfig;
        private String targetSelection;
        private List<OTAUpdateFile> otaUpdateFiles = DefaultSdkAutoConstructList.getInstance();
        private String otaUpdateStatus;
        private String awsIotJobId;
        private String awsIotJobArn;
        private ErrorInfo errorInfo;
        private Map<String, String> additionalParameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OTAUpdateInfo model) {
            this.otaUpdateId(model.otaUpdateId);
            this.otaUpdateArn(model.otaUpdateArn);
            this.creationDate(model.creationDate);
            this.lastModifiedDate(model.lastModifiedDate);
            this.description(model.description);
            this.targets(model.targets);
            this.protocolsWithStrings(model.protocols);
            this.awsJobExecutionsRolloutConfig(model.awsJobExecutionsRolloutConfig);
            this.awsJobPresignedUrlConfig(model.awsJobPresignedUrlConfig);
            this.targetSelection(model.targetSelection);
            this.otaUpdateFiles(model.otaUpdateFiles);
            this.otaUpdateStatus(model.otaUpdateStatus);
            this.awsIotJobId(model.awsIotJobId);
            this.awsIotJobArn(model.awsIotJobArn);
            this.errorInfo(model.errorInfo);
            this.additionalParameters(model.additionalParameters);
        }

        public final String getOtaUpdateId() {
            return this.otaUpdateId;
        }

        public final void setOtaUpdateId(String otaUpdateId) {
            this.otaUpdateId = otaUpdateId;
        }

        @Override
        public final Builder otaUpdateId(String otaUpdateId) {
            this.otaUpdateId = otaUpdateId;
            return this;
        }

        public final String getOtaUpdateArn() {
            return this.otaUpdateArn;
        }

        public final void setOtaUpdateArn(String otaUpdateArn) {
            this.otaUpdateArn = otaUpdateArn;
        }

        @Override
        public final Builder otaUpdateArn(String otaUpdateArn) {
            this.otaUpdateArn = otaUpdateArn;
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getTargets() {
            if (this.targets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targets;
        }

        public final void setTargets(Collection<String> targets) {
            this.targets = TargetsCopier.copy(targets);
        }

        @Override
        public final Builder targets(Collection<String> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(String ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        public final Collection<String> getProtocols() {
            if (this.protocols instanceof SdkAutoConstructList) {
                return null;
            }
            return this.protocols;
        }

        public final void setProtocols(Collection<String> protocols) {
            this.protocols = ProtocolsCopier.copy(protocols);
        }

        @Override
        public final Builder protocolsWithStrings(Collection<String> protocols) {
            this.protocols = ProtocolsCopier.copy(protocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocolsWithStrings(String ... protocols) {
            this.protocolsWithStrings(Arrays.asList(protocols));
            return this;
        }

        @Override
        public final Builder protocols(Collection<Protocol> protocols) {
            this.protocols = ProtocolsCopier.copyEnumToString(protocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocols(Protocol ... protocols) {
            this.protocols(Arrays.asList(protocols));
            return this;
        }

        public final AwsJobExecutionsRolloutConfig.Builder getAwsJobExecutionsRolloutConfig() {
            return this.awsJobExecutionsRolloutConfig != null ? this.awsJobExecutionsRolloutConfig.toBuilder() : null;
        }

        public final void setAwsJobExecutionsRolloutConfig(AwsJobExecutionsRolloutConfig.BuilderImpl awsJobExecutionsRolloutConfig) {
            this.awsJobExecutionsRolloutConfig = awsJobExecutionsRolloutConfig != null ? awsJobExecutionsRolloutConfig.build() : null;
        }

        @Override
        public final Builder awsJobExecutionsRolloutConfig(AwsJobExecutionsRolloutConfig awsJobExecutionsRolloutConfig) {
            this.awsJobExecutionsRolloutConfig = awsJobExecutionsRolloutConfig;
            return this;
        }

        public final AwsJobPresignedUrlConfig.Builder getAwsJobPresignedUrlConfig() {
            return this.awsJobPresignedUrlConfig != null ? this.awsJobPresignedUrlConfig.toBuilder() : null;
        }

        public final void setAwsJobPresignedUrlConfig(AwsJobPresignedUrlConfig.BuilderImpl awsJobPresignedUrlConfig) {
            this.awsJobPresignedUrlConfig = awsJobPresignedUrlConfig != null ? awsJobPresignedUrlConfig.build() : null;
        }

        @Override
        public final Builder awsJobPresignedUrlConfig(AwsJobPresignedUrlConfig awsJobPresignedUrlConfig) {
            this.awsJobPresignedUrlConfig = awsJobPresignedUrlConfig;
            return this;
        }

        public final String getTargetSelection() {
            return this.targetSelection;
        }

        public final void setTargetSelection(String targetSelection) {
            this.targetSelection = targetSelection;
        }

        @Override
        public final Builder targetSelection(String targetSelection) {
            this.targetSelection = targetSelection;
            return this;
        }

        @Override
        public final Builder targetSelection(TargetSelection targetSelection) {
            this.targetSelection(targetSelection == null ? null : targetSelection.toString());
            return this;
        }

        public final List<OTAUpdateFile.Builder> getOtaUpdateFiles() {
            List<OTAUpdateFile.Builder> result = OTAUpdateFilesCopier.copyToBuilder(this.otaUpdateFiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOtaUpdateFiles(Collection<OTAUpdateFile.BuilderImpl> otaUpdateFiles) {
            this.otaUpdateFiles = OTAUpdateFilesCopier.copyFromBuilder(otaUpdateFiles);
        }

        @Override
        public final Builder otaUpdateFiles(Collection<OTAUpdateFile> otaUpdateFiles) {
            this.otaUpdateFiles = OTAUpdateFilesCopier.copy(otaUpdateFiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder otaUpdateFiles(OTAUpdateFile ... otaUpdateFiles) {
            this.otaUpdateFiles(Arrays.asList(otaUpdateFiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder otaUpdateFiles(Consumer<OTAUpdateFile.Builder> ... otaUpdateFiles) {
            this.otaUpdateFiles(Stream.of(otaUpdateFiles).map(c -> (OTAUpdateFile)((OTAUpdateFile.Builder)OTAUpdateFile.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOtaUpdateStatus() {
            return this.otaUpdateStatus;
        }

        public final void setOtaUpdateStatus(String otaUpdateStatus) {
            this.otaUpdateStatus = otaUpdateStatus;
        }

        @Override
        public final Builder otaUpdateStatus(String otaUpdateStatus) {
            this.otaUpdateStatus = otaUpdateStatus;
            return this;
        }

        @Override
        public final Builder otaUpdateStatus(OTAUpdateStatus otaUpdateStatus) {
            this.otaUpdateStatus(otaUpdateStatus == null ? null : otaUpdateStatus.toString());
            return this;
        }

        public final String getAwsIotJobId() {
            return this.awsIotJobId;
        }

        public final void setAwsIotJobId(String awsIotJobId) {
            this.awsIotJobId = awsIotJobId;
        }

        @Override
        public final Builder awsIotJobId(String awsIotJobId) {
            this.awsIotJobId = awsIotJobId;
            return this;
        }

        public final String getAwsIotJobArn() {
            return this.awsIotJobArn;
        }

        public final void setAwsIotJobArn(String awsIotJobArn) {
            this.awsIotJobArn = awsIotJobArn;
        }

        @Override
        public final Builder awsIotJobArn(String awsIotJobArn) {
            this.awsIotJobArn = awsIotJobArn;
            return this;
        }

        public final ErrorInfo.Builder getErrorInfo() {
            return this.errorInfo != null ? this.errorInfo.toBuilder() : null;
        }

        public final void setErrorInfo(ErrorInfo.BuilderImpl errorInfo) {
            this.errorInfo = errorInfo != null ? errorInfo.build() : null;
        }

        @Override
        public final Builder errorInfo(ErrorInfo errorInfo) {
            this.errorInfo = errorInfo;
            return this;
        }

        public final Map<String, String> getAdditionalParameters() {
            if (this.additionalParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.additionalParameters;
        }

        public final void setAdditionalParameters(Map<String, String> additionalParameters) {
            this.additionalParameters = AdditionalParameterMapCopier.copy(additionalParameters);
        }

        @Override
        public final Builder additionalParameters(Map<String, String> additionalParameters) {
            this.additionalParameters = AdditionalParameterMapCopier.copy(additionalParameters);
            return this;
        }

        public OTAUpdateInfo build() {
            return new OTAUpdateInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OTAUpdateInfo> {
        public Builder otaUpdateId(String var1);

        public Builder otaUpdateArn(String var1);

        public Builder creationDate(Instant var1);

        public Builder lastModifiedDate(Instant var1);

        public Builder description(String var1);

        public Builder targets(Collection<String> var1);

        public Builder targets(String ... var1);

        public Builder protocolsWithStrings(Collection<String> var1);

        public Builder protocolsWithStrings(String ... var1);

        public Builder protocols(Collection<Protocol> var1);

        public Builder protocols(Protocol ... var1);

        public Builder awsJobExecutionsRolloutConfig(AwsJobExecutionsRolloutConfig var1);

        default public Builder awsJobExecutionsRolloutConfig(Consumer<AwsJobExecutionsRolloutConfig.Builder> awsJobExecutionsRolloutConfig) {
            return this.awsJobExecutionsRolloutConfig((AwsJobExecutionsRolloutConfig)((AwsJobExecutionsRolloutConfig.Builder)AwsJobExecutionsRolloutConfig.builder().applyMutation(awsJobExecutionsRolloutConfig)).build());
        }

        public Builder awsJobPresignedUrlConfig(AwsJobPresignedUrlConfig var1);

        default public Builder awsJobPresignedUrlConfig(Consumer<AwsJobPresignedUrlConfig.Builder> awsJobPresignedUrlConfig) {
            return this.awsJobPresignedUrlConfig((AwsJobPresignedUrlConfig)((AwsJobPresignedUrlConfig.Builder)AwsJobPresignedUrlConfig.builder().applyMutation(awsJobPresignedUrlConfig)).build());
        }

        public Builder targetSelection(String var1);

        public Builder targetSelection(TargetSelection var1);

        public Builder otaUpdateFiles(Collection<OTAUpdateFile> var1);

        public Builder otaUpdateFiles(OTAUpdateFile ... var1);

        public Builder otaUpdateFiles(Consumer<OTAUpdateFile.Builder> ... var1);

        public Builder otaUpdateStatus(String var1);

        public Builder otaUpdateStatus(OTAUpdateStatus var1);

        public Builder awsIotJobId(String var1);

        public Builder awsIotJobArn(String var1);

        public Builder errorInfo(ErrorInfo var1);

        default public Builder errorInfo(Consumer<ErrorInfo.Builder> errorInfo) {
            return this.errorInfo((ErrorInfo)((ErrorInfo.Builder)ErrorInfo.builder().applyMutation(errorInfo)).build());
        }

        public Builder additionalParameters(Map<String, String> var1);
    }
}

