/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.CommandExecutionSummary;
import software.amazon.awssdk.services.iot.model.ListCommandExecutionsRequest;
import software.amazon.awssdk.services.iot.model.ListCommandExecutionsResponse;

public class ListCommandExecutionsPublisher
implements SdkPublisher<ListCommandExecutionsResponse> {
    private final IotAsyncClient client;
    private final ListCommandExecutionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCommandExecutionsPublisher(IotAsyncClient client, ListCommandExecutionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCommandExecutionsPublisher(IotAsyncClient client, ListCommandExecutionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCommandExecutionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCommandExecutionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CommandExecutionSummary> commandExecutions() {
        Function<ListCommandExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.commandExecutions() != null) {
                return response.commandExecutions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCommandExecutionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCommandExecutionsResponseFetcher
    implements AsyncPageFetcher<ListCommandExecutionsResponse> {
        private ListCommandExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListCommandExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCommandExecutionsResponse> nextPage(ListCommandExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListCommandExecutionsPublisher.this.client.listCommandExecutions(ListCommandExecutionsPublisher.this.firstRequest);
            }
            return ListCommandExecutionsPublisher.this.client.listCommandExecutions((ListCommandExecutionsRequest)((Object)ListCommandExecutionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

