/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBucketsAggregationRequest extends IotRequest implements
        ToCopyableBuilder<GetBucketsAggregationRequest.Builder, GetBucketsAggregationRequest> {
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("indexName").getter(getter(GetBucketsAggregationRequest::indexName)).setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexName").build()).build();

    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queryString").getter(getter(GetBucketsAggregationRequest::queryString))
            .setter(setter(Builder::queryString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryString").build()).build();

    private static final SdkField<String> AGGREGATION_FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aggregationField").getter(getter(GetBucketsAggregationRequest::aggregationField))
            .setter(setter(Builder::aggregationField))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationField").build()).build();

    private static final SdkField<String> QUERY_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queryVersion").getter(getter(GetBucketsAggregationRequest::queryVersion))
            .setter(setter(Builder::queryVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryVersion").build()).build();

    private static final SdkField<BucketsAggregationType> BUCKETS_AGGREGATION_TYPE_FIELD = SdkField
            .<BucketsAggregationType> builder(MarshallingType.SDK_POJO).memberName("bucketsAggregationType")
            .getter(getter(GetBucketsAggregationRequest::bucketsAggregationType)).setter(setter(Builder::bucketsAggregationType))
            .constructor(BucketsAggregationType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketsAggregationType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_NAME_FIELD,
            QUERY_STRING_FIELD, AGGREGATION_FIELD_FIELD, QUERY_VERSION_FIELD, BUCKETS_AGGREGATION_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String indexName;

    private final String queryString;

    private final String aggregationField;

    private final String queryVersion;

    private final BucketsAggregationType bucketsAggregationType;

    private GetBucketsAggregationRequest(BuilderImpl builder) {
        super(builder);
        this.indexName = builder.indexName;
        this.queryString = builder.queryString;
        this.aggregationField = builder.aggregationField;
        this.queryVersion = builder.queryVersion;
        this.bucketsAggregationType = builder.bucketsAggregationType;
    }

    /**
     * <p>
     * The name of the index to search.
     * </p>
     * 
     * @return The name of the index to search.
     */
    public final String indexName() {
        return indexName;
    }

    /**
     * <p>
     * The search query string.
     * </p>
     * 
     * @return The search query string.
     */
    public final String queryString() {
        return queryString;
    }

    /**
     * <p>
     * The aggregation field.
     * </p>
     * 
     * @return The aggregation field.
     */
    public final String aggregationField() {
        return aggregationField;
    }

    /**
     * <p>
     * The version of the query.
     * </p>
     * 
     * @return The version of the query.
     */
    public final String queryVersion() {
        return queryVersion;
    }

    /**
     * <p>
     * The basic control of the response shape and the bucket aggregation type to perform.
     * </p>
     * 
     * @return The basic control of the response shape and the bucket aggregation type to perform.
     */
    public final BucketsAggregationType bucketsAggregationType() {
        return bucketsAggregationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(queryString());
        hashCode = 31 * hashCode + Objects.hashCode(aggregationField());
        hashCode = 31 * hashCode + Objects.hashCode(queryVersion());
        hashCode = 31 * hashCode + Objects.hashCode(bucketsAggregationType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketsAggregationRequest)) {
            return false;
        }
        GetBucketsAggregationRequest other = (GetBucketsAggregationRequest) obj;
        return Objects.equals(indexName(), other.indexName()) && Objects.equals(queryString(), other.queryString())
                && Objects.equals(aggregationField(), other.aggregationField())
                && Objects.equals(queryVersion(), other.queryVersion())
                && Objects.equals(bucketsAggregationType(), other.bucketsAggregationType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetBucketsAggregationRequest").add("IndexName", indexName()).add("QueryString", queryString())
                .add("AggregationField", aggregationField()).add("QueryVersion", queryVersion())
                .add("BucketsAggregationType", bucketsAggregationType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "indexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "queryString":
            return Optional.ofNullable(clazz.cast(queryString()));
        case "aggregationField":
            return Optional.ofNullable(clazz.cast(aggregationField()));
        case "queryVersion":
            return Optional.ofNullable(clazz.cast(queryVersion()));
        case "bucketsAggregationType":
            return Optional.ofNullable(clazz.cast(bucketsAggregationType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("indexName", INDEX_NAME_FIELD);
        map.put("queryString", QUERY_STRING_FIELD);
        map.put("aggregationField", AGGREGATION_FIELD_FIELD);
        map.put("queryVersion", QUERY_VERSION_FIELD);
        map.put("bucketsAggregationType", BUCKETS_AGGREGATION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetBucketsAggregationRequest, T> g) {
        return obj -> g.apply((GetBucketsAggregationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetBucketsAggregationRequest> {
        /**
         * <p>
         * The name of the index to search.
         * </p>
         * 
         * @param indexName
         *        The name of the index to search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * The search query string.
         * </p>
         * 
         * @param queryString
         *        The search query string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryString(String queryString);

        /**
         * <p>
         * The aggregation field.
         * </p>
         * 
         * @param aggregationField
         *        The aggregation field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationField(String aggregationField);

        /**
         * <p>
         * The version of the query.
         * </p>
         * 
         * @param queryVersion
         *        The version of the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryVersion(String queryVersion);

        /**
         * <p>
         * The basic control of the response shape and the bucket aggregation type to perform.
         * </p>
         * 
         * @param bucketsAggregationType
         *        The basic control of the response shape and the bucket aggregation type to perform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketsAggregationType(BucketsAggregationType bucketsAggregationType);

        /**
         * <p>
         * The basic control of the response shape and the bucket aggregation type to perform.
         * </p>
         * This is a convenience method that creates an instance of the {@link BucketsAggregationType.Builder} avoiding
         * the need to create one manually via {@link BucketsAggregationType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BucketsAggregationType.Builder#build()} is called immediately and
         * its result is passed to {@link #bucketsAggregationType(BucketsAggregationType)}.
         * 
         * @param bucketsAggregationType
         *        a consumer that will call methods on {@link BucketsAggregationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bucketsAggregationType(BucketsAggregationType)
         */
        default Builder bucketsAggregationType(Consumer<BucketsAggregationType.Builder> bucketsAggregationType) {
            return bucketsAggregationType(BucketsAggregationType.builder().applyMutation(bucketsAggregationType).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String indexName;

        private String queryString;

        private String aggregationField;

        private String queryVersion;

        private BucketsAggregationType bucketsAggregationType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketsAggregationRequest model) {
            super(model);
            indexName(model.indexName);
            queryString(model.queryString);
            aggregationField(model.aggregationField);
            queryVersion(model.queryVersion);
            bucketsAggregationType(model.bucketsAggregationType);
        }

        public final String getIndexName() {
            return indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final String getQueryString() {
            return queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final String getAggregationField() {
            return aggregationField;
        }

        public final void setAggregationField(String aggregationField) {
            this.aggregationField = aggregationField;
        }

        @Override
        public final Builder aggregationField(String aggregationField) {
            this.aggregationField = aggregationField;
            return this;
        }

        public final String getQueryVersion() {
            return queryVersion;
        }

        public final void setQueryVersion(String queryVersion) {
            this.queryVersion = queryVersion;
        }

        @Override
        public final Builder queryVersion(String queryVersion) {
            this.queryVersion = queryVersion;
            return this;
        }

        public final BucketsAggregationType.Builder getBucketsAggregationType() {
            return bucketsAggregationType != null ? bucketsAggregationType.toBuilder() : null;
        }

        public final void setBucketsAggregationType(BucketsAggregationType.BuilderImpl bucketsAggregationType) {
            this.bucketsAggregationType = bucketsAggregationType != null ? bucketsAggregationType.build() : null;
        }

        @Override
        public final Builder bucketsAggregationType(BucketsAggregationType bucketsAggregationType) {
            this.bucketsAggregationType = bucketsAggregationType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetBucketsAggregationRequest build() {
            return new GetBucketsAggregationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
