/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of information about a provisioning template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvisioningTemplateSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ProvisioningTemplateSummary.Builder, ProvisioningTemplateSummary> {
    private static final SdkField<String> TEMPLATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateArn").getter(getter(ProvisioningTemplateSummary::templateArn))
            .setter(setter(Builder::templateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateArn").build()).build();

    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateName").getter(getter(ProvisioningTemplateSummary::templateName))
            .setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ProvisioningTemplateSummary::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate").getter(getter(ProvisioningTemplateSummary::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedDate").getter(getter(ProvisioningTemplateSummary::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(ProvisioningTemplateSummary::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ProvisioningTemplateSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_ARN_FIELD,
            TEMPLATE_NAME_FIELD, DESCRIPTION_FIELD, CREATION_DATE_FIELD, LAST_MODIFIED_DATE_FIELD, ENABLED_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String templateArn;

    private final String templateName;

    private final String description;

    private final Instant creationDate;

    private final Instant lastModifiedDate;

    private final Boolean enabled;

    private final String type;

    private ProvisioningTemplateSummary(BuilderImpl builder) {
        this.templateArn = builder.templateArn;
        this.templateName = builder.templateName;
        this.description = builder.description;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.enabled = builder.enabled;
        this.type = builder.type;
    }

    /**
     * <p>
     * The ARN of the provisioning template.
     * </p>
     * 
     * @return The ARN of the provisioning template.
     */
    public final String templateArn() {
        return templateArn;
    }

    /**
     * <p>
     * The name of the provisioning template.
     * </p>
     * 
     * @return The name of the provisioning template.
     */
    public final String templateName() {
        return templateName;
    }

    /**
     * <p>
     * The description of the provisioning template.
     * </p>
     * 
     * @return The description of the provisioning template.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The date when the provisioning template summary was created.
     * </p>
     * 
     * @return The date when the provisioning template summary was created.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The date when the provisioning template summary was last modified.
     * </p>
     * 
     * @return The date when the provisioning template summary was last modified.
     */
    public final Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * True if the fleet provision template is enabled, otherwise false.
     * </p>
     * 
     * @return True if the fleet provision template is enabled, otherwise false.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The type you define in a provisioning template. You can create a template with only one type. You can't change
     * the template type after its creation. The default value is <code>FLEET_PROVISIONING</code>. For more information
     * about provisioning template, see: <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/provision-template.html">Provisioning template</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TemplateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type you define in a provisioning template. You can create a template with only one type. You can't
     *         change the template type after its creation. The default value is <code>FLEET_PROVISIONING</code>. For
     *         more information about provisioning template, see: <a
     *         href="https://docs.aws.amazon.com/iot/latest/developerguide/provision-template.html">Provisioning
     *         template</a>.
     * @see TemplateType
     */
    public final TemplateType type() {
        return TemplateType.fromValue(type);
    }

    /**
     * <p>
     * The type you define in a provisioning template. You can create a template with only one type. You can't change
     * the template type after its creation. The default value is <code>FLEET_PROVISIONING</code>. For more information
     * about provisioning template, see: <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/provision-template.html">Provisioning template</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TemplateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type you define in a provisioning template. You can create a template with only one type. You can't
     *         change the template type after its creation. The default value is <code>FLEET_PROVISIONING</code>. For
     *         more information about provisioning template, see: <a
     *         href="https://docs.aws.amazon.com/iot/latest/developerguide/provision-template.html">Provisioning
     *         template</a>.
     * @see TemplateType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(templateArn());
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisioningTemplateSummary)) {
            return false;
        }
        ProvisioningTemplateSummary other = (ProvisioningTemplateSummary) obj;
        return Objects.equals(templateArn(), other.templateArn()) && Objects.equals(templateName(), other.templateName())
                && Objects.equals(description(), other.description()) && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(enabled(), other.enabled())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProvisioningTemplateSummary").add("TemplateArn", templateArn())
                .add("TemplateName", templateName()).add("Description", description()).add("CreationDate", creationDate())
                .add("LastModifiedDate", lastModifiedDate()).add("Enabled", enabled()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "templateArn":
            return Optional.ofNullable(clazz.cast(templateArn()));
        case "templateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "lastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("templateArn", TEMPLATE_ARN_FIELD);
        map.put("templateName", TEMPLATE_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("creationDate", CREATION_DATE_FIELD);
        map.put("lastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        map.put("enabled", ENABLED_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProvisioningTemplateSummary, T> g) {
        return obj -> g.apply((ProvisioningTemplateSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProvisioningTemplateSummary> {
        /**
         * <p>
         * The ARN of the provisioning template.
         * </p>
         * 
         * @param templateArn
         *        The ARN of the provisioning template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateArn(String templateArn);

        /**
         * <p>
         * The name of the provisioning template.
         * </p>
         * 
         * @param templateName
         *        The name of the provisioning template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * The description of the provisioning template.
         * </p>
         * 
         * @param description
         *        The description of the provisioning template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The date when the provisioning template summary was created.
         * </p>
         * 
         * @param creationDate
         *        The date when the provisioning template summary was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The date when the provisioning template summary was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date when the provisioning template summary was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);

        /**
         * <p>
         * True if the fleet provision template is enabled, otherwise false.
         * </p>
         * 
         * @param enabled
         *        True if the fleet provision template is enabled, otherwise false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The type you define in a provisioning template. You can create a template with only one type. You can't
         * change the template type after its creation. The default value is <code>FLEET_PROVISIONING</code>. For more
         * information about provisioning template, see: <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/provision-template.html">Provisioning
         * template</a>.
         * </p>
         * 
         * @param type
         *        The type you define in a provisioning template. You can create a template with only one type. You
         *        can't change the template type after its creation. The default value is
         *        <code>FLEET_PROVISIONING</code>. For more information about provisioning template, see: <a
         *        href="https://docs.aws.amazon.com/iot/latest/developerguide/provision-template.html">Provisioning
         *        template</a>.
         * @see TemplateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemplateType
         */
        Builder type(String type);

        /**
         * <p>
         * The type you define in a provisioning template. You can create a template with only one type. You can't
         * change the template type after its creation. The default value is <code>FLEET_PROVISIONING</code>. For more
         * information about provisioning template, see: <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/provision-template.html">Provisioning
         * template</a>.
         * </p>
         * 
         * @param type
         *        The type you define in a provisioning template. You can create a template with only one type. You
         *        can't change the template type after its creation. The default value is
         *        <code>FLEET_PROVISIONING</code>. For more information about provisioning template, see: <a
         *        href="https://docs.aws.amazon.com/iot/latest/developerguide/provision-template.html">Provisioning
         *        template</a>.
         * @see TemplateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemplateType
         */
        Builder type(TemplateType type);
    }

    static final class BuilderImpl implements Builder {
        private String templateArn;

        private String templateName;

        private String description;

        private Instant creationDate;

        private Instant lastModifiedDate;

        private Boolean enabled;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisioningTemplateSummary model) {
            templateArn(model.templateArn);
            templateName(model.templateName);
            description(model.description);
            creationDate(model.creationDate);
            lastModifiedDate(model.lastModifiedDate);
            enabled(model.enabled);
            type(model.type);
        }

        public final String getTemplateArn() {
            return templateArn;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        @Override
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        public final String getTemplateName() {
            return templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TemplateType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public ProvisioningTemplateSummary build() {
            return new ProvisioningTemplateSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
