/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAuditSuppressionsResponse extends IotResponse implements
        ToCopyableBuilder<ListAuditSuppressionsResponse.Builder, ListAuditSuppressionsResponse> {
    private static final SdkField<List<AuditSuppression>> SUPPRESSIONS_FIELD = SdkField
            .<List<AuditSuppression>> builder(MarshallingType.LIST)
            .memberName("suppressions")
            .getter(getter(ListAuditSuppressionsResponse::suppressions))
            .setter(setter(Builder::suppressions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suppressions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AuditSuppression> builder(MarshallingType.SDK_POJO)
                                            .constructor(AuditSuppression::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAuditSuppressionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUPPRESSIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AuditSuppression> suppressions;

    private final String nextToken;

    private ListAuditSuppressionsResponse(BuilderImpl builder) {
        super(builder);
        this.suppressions = builder.suppressions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Suppressions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSuppressions() {
        return suppressions != null && !(suppressions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of audit suppressions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuppressions} method.
     * </p>
     * 
     * @return List of audit suppressions.
     */
    public final List<AuditSuppression> suppressions() {
        return suppressions;
    }

    /**
     * <p>
     * A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional
     * results.
     * </p>
     * 
     * @return A token that can be used to retrieve the next set of results, or <code>null</code> if there are no
     *         additional results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSuppressions() ? suppressions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAuditSuppressionsResponse)) {
            return false;
        }
        ListAuditSuppressionsResponse other = (ListAuditSuppressionsResponse) obj;
        return hasSuppressions() == other.hasSuppressions() && Objects.equals(suppressions(), other.suppressions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAuditSuppressionsResponse").add("Suppressions", hasSuppressions() ? suppressions() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "suppressions":
            return Optional.ofNullable(clazz.cast(suppressions()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("suppressions", SUPPRESSIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAuditSuppressionsResponse, T> g) {
        return obj -> g.apply((ListAuditSuppressionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAuditSuppressionsResponse> {
        /**
         * <p>
         * List of audit suppressions.
         * </p>
         * 
         * @param suppressions
         *        List of audit suppressions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suppressions(Collection<AuditSuppression> suppressions);

        /**
         * <p>
         * List of audit suppressions.
         * </p>
         * 
         * @param suppressions
         *        List of audit suppressions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suppressions(AuditSuppression... suppressions);

        /**
         * <p>
         * List of audit suppressions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iot.model.AuditSuppression.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iot.model.AuditSuppression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iot.model.AuditSuppression.Builder#build()} is called immediately and
         * its result is passed to {@link #suppressions(List<AuditSuppression>)}.
         * 
         * @param suppressions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iot.model.AuditSuppression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #suppressions(java.util.Collection<AuditSuppression>)
         */
        Builder suppressions(Consumer<AuditSuppression.Builder>... suppressions);

        /**
         * <p>
         * A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional
         * results.
         * </p>
         * 
         * @param nextToken
         *        A token that can be used to retrieve the next set of results, or <code>null</code> if there are no
         *        additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<AuditSuppression> suppressions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAuditSuppressionsResponse model) {
            super(model);
            suppressions(model.suppressions);
            nextToken(model.nextToken);
        }

        public final List<AuditSuppression.Builder> getSuppressions() {
            List<AuditSuppression.Builder> result = AuditSuppressionListCopier.copyToBuilder(this.suppressions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuppressions(Collection<AuditSuppression.BuilderImpl> suppressions) {
            this.suppressions = AuditSuppressionListCopier.copyFromBuilder(suppressions);
        }

        @Override
        public final Builder suppressions(Collection<AuditSuppression> suppressions) {
            this.suppressions = AuditSuppressionListCopier.copy(suppressions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suppressions(AuditSuppression... suppressions) {
            suppressions(Arrays.asList(suppressions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suppressions(Consumer<AuditSuppression.Builder>... suppressions) {
            suppressions(Stream.of(suppressions).map(c -> AuditSuppression.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAuditSuppressionsResponse build() {
            return new ListAuditSuppressionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
