/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListThingRegistrationTaskReportsRequest extends IotRequest implements
        ToCopyableBuilder<ListThingRegistrationTaskReportsRequest.Builder, ListThingRegistrationTaskReportsRequest> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("taskId")
            .getter(getter(ListThingRegistrationTaskReportsRequest::taskId)).setter(setter(Builder::taskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("taskId").build()).build();

    private static final SdkField<String> REPORT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("reportType").getter(getter(ListThingRegistrationTaskReportsRequest::reportTypeAsString))
            .setter(setter(Builder::reportType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("reportType").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListThingRegistrationTaskReportsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListThingRegistrationTaskReportsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD,
            REPORT_TYPE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String taskId;

    private final String reportType;

    private final String nextToken;

    private final Integer maxResults;

    private ListThingRegistrationTaskReportsRequest(BuilderImpl builder) {
        super(builder);
        this.taskId = builder.taskId;
        this.reportType = builder.reportType;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The id of the task.
     * </p>
     * 
     * @return The id of the task.
     */
    public final String taskId() {
        return taskId;
    }

    /**
     * <p>
     * The type of task report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reportType} will
     * return {@link ReportType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reportTypeAsString}.
     * </p>
     * 
     * @return The type of task report.
     * @see ReportType
     */
    public final ReportType reportType() {
        return ReportType.fromValue(reportType);
    }

    /**
     * <p>
     * The type of task report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reportType} will
     * return {@link ReportType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reportTypeAsString}.
     * </p>
     * 
     * @return The type of task report.
     * @see ReportType
     */
    public final String reportTypeAsString() {
        return reportType;
    }

    /**
     * <p>
     * To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise
     * <b>null</b> to receive the first set of results.
     * </p>
     * 
     * @return To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise
     *         <b>null</b> to receive the first set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return per request.
     * </p>
     * 
     * @return The maximum number of results to return per request.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(taskId());
        hashCode = 31 * hashCode + Objects.hashCode(reportTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListThingRegistrationTaskReportsRequest)) {
            return false;
        }
        ListThingRegistrationTaskReportsRequest other = (ListThingRegistrationTaskReportsRequest) obj;
        return Objects.equals(taskId(), other.taskId()) && Objects.equals(reportTypeAsString(), other.reportTypeAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListThingRegistrationTaskReportsRequest").add("TaskId", taskId())
                .add("ReportType", reportTypeAsString()).add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskId":
            return Optional.ofNullable(clazz.cast(taskId()));
        case "reportType":
            return Optional.ofNullable(clazz.cast(reportTypeAsString()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("taskId", TASK_ID_FIELD);
        map.put("reportType", REPORT_TYPE_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListThingRegistrationTaskReportsRequest, T> g) {
        return obj -> g.apply((ListThingRegistrationTaskReportsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListThingRegistrationTaskReportsRequest> {
        /**
         * <p>
         * The id of the task.
         * </p>
         * 
         * @param taskId
         *        The id of the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);

        /**
         * <p>
         * The type of task report.
         * </p>
         * 
         * @param reportType
         *        The type of task report.
         * @see ReportType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportType
         */
        Builder reportType(String reportType);

        /**
         * <p>
         * The type of task report.
         * </p>
         * 
         * @param reportType
         *        The type of task report.
         * @see ReportType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportType
         */
        Builder reportType(ReportType reportType);

        /**
         * <p>
         * To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise
         * <b>null</b> to receive the first set of results.
         * </p>
         * 
         * @param nextToken
         *        To retrieve the next set of results, the <code>nextToken</code> value from a previous response;
         *        otherwise <b>null</b> to receive the first set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return per request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return per request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String taskId;

        private String reportType;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListThingRegistrationTaskReportsRequest model) {
            super(model);
            taskId(model.taskId);
            reportType(model.reportType);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getTaskId() {
            return taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final String getReportType() {
            return reportType;
        }

        public final void setReportType(String reportType) {
            this.reportType = reportType;
        }

        @Override
        public final Builder reportType(String reportType) {
            this.reportType = reportType;
            return this;
        }

        @Override
        public final Builder reportType(ReportType reportType) {
            this.reportType(reportType == null ? null : reportType.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListThingRegistrationTaskReportsRequest build() {
            return new ListThingRegistrationTaskReportsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
