/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamInfo implements SdkPojo, Serializable, ToCopyableBuilder<StreamInfo.Builder, StreamInfo> {
    private static final SdkField<String> STREAM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("streamId").getter(getter(StreamInfo::streamId)).setter(setter(Builder::streamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamId").build()).build();

    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("streamArn").getter(getter(StreamInfo::streamArn)).setter(setter(Builder::streamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamArn").build()).build();

    private static final SdkField<Integer> STREAM_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("streamVersion").getter(getter(StreamInfo::streamVersion)).setter(setter(Builder::streamVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamVersion").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(StreamInfo::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<StreamFile>> FILES_FIELD = SdkField
            .<List<StreamFile>> builder(MarshallingType.LIST)
            .memberName("files")
            .getter(getter(StreamInfo::files))
            .setter(setter(Builder::files))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("files").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StreamFile> builder(MarshallingType.SDK_POJO)
                                            .constructor(StreamFile::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(StreamInfo::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt").getter(getter(StreamInfo::lastUpdatedAt)).setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(StreamInfo::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ID_FIELD,
            STREAM_ARN_FIELD, STREAM_VERSION_FIELD, DESCRIPTION_FIELD, FILES_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD,
            ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String streamId;

    private final String streamArn;

    private final Integer streamVersion;

    private final String description;

    private final List<StreamFile> files;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final String roleArn;

    private StreamInfo(BuilderImpl builder) {
        this.streamId = builder.streamId;
        this.streamArn = builder.streamArn;
        this.streamVersion = builder.streamVersion;
        this.description = builder.description;
        this.files = builder.files;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The stream ID.
     * </p>
     * 
     * @return The stream ID.
     */
    public final String streamId() {
        return streamId;
    }

    /**
     * <p>
     * The stream ARN.
     * </p>
     * 
     * @return The stream ARN.
     */
    public final String streamArn() {
        return streamArn;
    }

    /**
     * <p>
     * The stream version.
     * </p>
     * 
     * @return The stream version.
     */
    public final Integer streamVersion() {
        return streamVersion;
    }

    /**
     * <p>
     * The description of the stream.
     * </p>
     * 
     * @return The description of the stream.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Files property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasFiles() {
        return files != null && !(files instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The files to stream.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFiles} method.
     * </p>
     * 
     * @return The files to stream.
     */
    public final List<StreamFile> files() {
        return files;
    }

    /**
     * <p>
     * The date when the stream was created.
     * </p>
     * 
     * @return The date when the stream was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The date when the stream was last updated.
     * </p>
     * 
     * @return The date when the stream was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * An IAM role IoT assumes to access your S3 files.
     * </p>
     * 
     * @return An IAM role IoT assumes to access your S3 files.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamId());
        hashCode = 31 * hashCode + Objects.hashCode(streamArn());
        hashCode = 31 * hashCode + Objects.hashCode(streamVersion());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasFiles() ? files() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamInfo)) {
            return false;
        }
        StreamInfo other = (StreamInfo) obj;
        return Objects.equals(streamId(), other.streamId()) && Objects.equals(streamArn(), other.streamArn())
                && Objects.equals(streamVersion(), other.streamVersion()) && Objects.equals(description(), other.description())
                && hasFiles() == other.hasFiles() && Objects.equals(files(), other.files())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StreamInfo").add("StreamId", streamId()).add("StreamArn", streamArn())
                .add("StreamVersion", streamVersion()).add("Description", description())
                .add("Files", hasFiles() ? files() : null).add("CreatedAt", createdAt()).add("LastUpdatedAt", lastUpdatedAt())
                .add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "streamId":
            return Optional.ofNullable(clazz.cast(streamId()));
        case "streamArn":
            return Optional.ofNullable(clazz.cast(streamArn()));
        case "streamVersion":
            return Optional.ofNullable(clazz.cast(streamVersion()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "files":
            return Optional.ofNullable(clazz.cast(files()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("streamId", STREAM_ID_FIELD);
        map.put("streamArn", STREAM_ARN_FIELD);
        map.put("streamVersion", STREAM_VERSION_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("files", FILES_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StreamInfo, T> g) {
        return obj -> g.apply((StreamInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamInfo> {
        /**
         * <p>
         * The stream ID.
         * </p>
         * 
         * @param streamId
         *        The stream ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamId(String streamId);

        /**
         * <p>
         * The stream ARN.
         * </p>
         * 
         * @param streamArn
         *        The stream ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamArn(String streamArn);

        /**
         * <p>
         * The stream version.
         * </p>
         * 
         * @param streamVersion
         *        The stream version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamVersion(Integer streamVersion);

        /**
         * <p>
         * The description of the stream.
         * </p>
         * 
         * @param description
         *        The description of the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The files to stream.
         * </p>
         * 
         * @param files
         *        The files to stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder files(Collection<StreamFile> files);

        /**
         * <p>
         * The files to stream.
         * </p>
         * 
         * @param files
         *        The files to stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder files(StreamFile... files);

        /**
         * <p>
         * The files to stream.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iot.model.StreamFile.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.iot.model.StreamFile#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iot.model.StreamFile.Builder#build()} is called immediately and its
         * result is passed to {@link #files(List<StreamFile>)}.
         * 
         * @param files
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iot.model.StreamFile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #files(java.util.Collection<StreamFile>)
         */
        Builder files(Consumer<StreamFile.Builder>... files);

        /**
         * <p>
         * The date when the stream was created.
         * </p>
         * 
         * @param createdAt
         *        The date when the stream was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The date when the stream was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The date when the stream was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * An IAM role IoT assumes to access your S3 files.
         * </p>
         * 
         * @param roleArn
         *        An IAM role IoT assumes to access your S3 files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private String streamId;

        private String streamArn;

        private Integer streamVersion;

        private String description;

        private List<StreamFile> files = DefaultSdkAutoConstructList.getInstance();

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamInfo model) {
            streamId(model.streamId);
            streamArn(model.streamArn);
            streamVersion(model.streamVersion);
            description(model.description);
            files(model.files);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
            roleArn(model.roleArn);
        }

        public final String getStreamId() {
            return streamId;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public final String getStreamArn() {
            return streamArn;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final Integer getStreamVersion() {
            return streamVersion;
        }

        public final void setStreamVersion(Integer streamVersion) {
            this.streamVersion = streamVersion;
        }

        @Override
        public final Builder streamVersion(Integer streamVersion) {
            this.streamVersion = streamVersion;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<StreamFile.Builder> getFiles() {
            List<StreamFile.Builder> result = StreamFilesCopier.copyToBuilder(this.files);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFiles(Collection<StreamFile.BuilderImpl> files) {
            this.files = StreamFilesCopier.copyFromBuilder(files);
        }

        @Override
        public final Builder files(Collection<StreamFile> files) {
            this.files = StreamFilesCopier.copy(files);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder files(StreamFile... files) {
            files(Arrays.asList(files));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder files(Consumer<StreamFile.Builder>... files) {
            files(Stream.of(files).map(c -> StreamFile.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public StreamInfo build() {
            return new StreamInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
