/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDimensionsResponse extends IotResponse implements
        ToCopyableBuilder<ListDimensionsResponse.Builder, ListDimensionsResponse> {
    private static final SdkField<List<String>> DIMENSION_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("dimensionNames")
            .getter(getter(ListDimensionsResponse::dimensionNames))
            .setter(setter(Builder::dimensionNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dimensionNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListDimensionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSION_NAMES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> dimensionNames;

    private final String nextToken;

    private ListDimensionsResponse(BuilderImpl builder) {
        super(builder);
        this.dimensionNames = builder.dimensionNames;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the DimensionNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDimensionNames() {
        return dimensionNames != null && !(dimensionNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the names of the defined dimensions. Use <code>DescribeDimension</code> to get details for a dimension.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDimensionNames} method.
     * </p>
     * 
     * @return A list of the names of the defined dimensions. Use <code>DescribeDimension</code> to get details for a
     *         dimension.
     */
    public final List<String> dimensionNames() {
        return dimensionNames;
    }

    /**
     * <p>
     * A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional
     * results.
     * </p>
     * 
     * @return A token that can be used to retrieve the next set of results, or <code>null</code> if there are no
     *         additional results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDimensionNames() ? dimensionNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDimensionsResponse)) {
            return false;
        }
        ListDimensionsResponse other = (ListDimensionsResponse) obj;
        return hasDimensionNames() == other.hasDimensionNames() && Objects.equals(dimensionNames(), other.dimensionNames())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDimensionsResponse").add("DimensionNames", hasDimensionNames() ? dimensionNames() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dimensionNames":
            return Optional.ofNullable(clazz.cast(dimensionNames()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dimensionNames", DIMENSION_NAMES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDimensionsResponse, T> g) {
        return obj -> g.apply((ListDimensionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListDimensionsResponse> {
        /**
         * <p>
         * A list of the names of the defined dimensions. Use <code>DescribeDimension</code> to get details for a
         * dimension.
         * </p>
         * 
         * @param dimensionNames
         *        A list of the names of the defined dimensions. Use <code>DescribeDimension</code> to get details for a
         *        dimension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionNames(Collection<String> dimensionNames);

        /**
         * <p>
         * A list of the names of the defined dimensions. Use <code>DescribeDimension</code> to get details for a
         * dimension.
         * </p>
         * 
         * @param dimensionNames
         *        A list of the names of the defined dimensions. Use <code>DescribeDimension</code> to get details for a
         *        dimension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionNames(String... dimensionNames);

        /**
         * <p>
         * A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional
         * results.
         * </p>
         * 
         * @param nextToken
         *        A token that can be used to retrieve the next set of results, or <code>null</code> if there are no
         *        additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<String> dimensionNames = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDimensionsResponse model) {
            super(model);
            dimensionNames(model.dimensionNames);
            nextToken(model.nextToken);
        }

        public final Collection<String> getDimensionNames() {
            if (dimensionNames instanceof SdkAutoConstructList) {
                return null;
            }
            return dimensionNames;
        }

        public final void setDimensionNames(Collection<String> dimensionNames) {
            this.dimensionNames = DimensionNamesCopier.copy(dimensionNames);
        }

        @Override
        public final Builder dimensionNames(Collection<String> dimensionNames) {
            this.dimensionNames = DimensionNamesCopier.copy(dimensionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionNames(String... dimensionNames) {
            dimensionNames(Arrays.asList(dimensionNames));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDimensionsResponse build() {
            return new ListDimensionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
