/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCommandsRequest extends IotRequest implements
        ToCopyableBuilder<ListCommandsRequest.Builder, ListCommandsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListCommandsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListCommandsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespace").getter(getter(ListCommandsRequest::namespaceAsString)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("namespace").build()).build();

    private static final SdkField<String> COMMAND_PARAMETER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("commandParameterName").getter(getter(ListCommandsRequest::commandParameterName))
            .setter(setter(Builder::commandParameterName))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("commandParameterName").build())
            .build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sortOrder").getter(getter(ListCommandsRequest::sortOrderAsString)).setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sortOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, NAMESPACE_FIELD, COMMAND_PARAMETER_NAME_FIELD, SORT_ORDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer maxResults;

    private final String nextToken;

    private final String namespace;

    private final String commandParameterName;

    private final String sortOrder;

    private ListCommandsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.namespace = builder.namespace;
        this.commandParameterName = builder.commandParameterName;
        this.sortOrder = builder.sortOrder;
    }

    /**
     * <p>
     * The maximum number of results to return in this operation. By default, the API returns up to a maximum of 25
     * results. You can override this default value to return up to a maximum of 100 results for this operation.
     * </p>
     * 
     * @return The maximum number of results to return in this operation. By default, the API returns up to a maximum of
     *         25 results. You can override this default value to return up to a maximum of 100 results for this
     *         operation.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise
     * <code>null</code> to receive the first set of results.
     * </p>
     * 
     * @return To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise
     *         <code>null</code> to receive the first set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The namespace of the command. By default, the API returns all commands that have been created for both
     * <code>AWS-IoT</code> and <code>AWS-IoT-FleetWise</code> namespaces. You can override this default value if you
     * want to return all commands that have been created only for a specific namespace.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #namespace} will
     * return {@link CommandNamespace#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #namespaceAsString}.
     * </p>
     * 
     * @return The namespace of the command. By default, the API returns all commands that have been created for both
     *         <code>AWS-IoT</code> and <code>AWS-IoT-FleetWise</code> namespaces. You can override this default value
     *         if you want to return all commands that have been created only for a specific namespace.
     * @see CommandNamespace
     */
    public final CommandNamespace namespace() {
        return CommandNamespace.fromValue(namespace);
    }

    /**
     * <p>
     * The namespace of the command. By default, the API returns all commands that have been created for both
     * <code>AWS-IoT</code> and <code>AWS-IoT-FleetWise</code> namespaces. You can override this default value if you
     * want to return all commands that have been created only for a specific namespace.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #namespace} will
     * return {@link CommandNamespace#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #namespaceAsString}.
     * </p>
     * 
     * @return The namespace of the command. By default, the API returns all commands that have been created for both
     *         <code>AWS-IoT</code> and <code>AWS-IoT-FleetWise</code> namespaces. You can override this default value
     *         if you want to return all commands that have been created only for a specific namespace.
     * @see CommandNamespace
     */
    public final String namespaceAsString() {
        return namespace;
    }

    /**
     * <p>
     * A filter that can be used to display the list of commands that have a specific command parameter name.
     * </p>
     * 
     * @return A filter that can be used to display the list of commands that have a specific command parameter name.
     */
    public final String commandParameterName() {
        return commandParameterName;
    }

    /**
     * <p>
     * Specify whether to list the commands that you have created in the ascending or descending order. By default, the
     * API returns all commands in the descending order based on the time that they were created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Specify whether to list the commands that you have created in the ascending or descending order. By
     *         default, the API returns all commands in the descending order based on the time that they were created.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * Specify whether to list the commands that you have created in the ascending or descending order. By default, the
     * API returns all commands in the descending order based on the time that they were created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Specify whether to list the commands that you have created in the ascending or descending order. By
     *         default, the API returns all commands in the descending order based on the time that they were created.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(namespaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(commandParameterName());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCommandsRequest)) {
            return false;
        }
        ListCommandsRequest other = (ListCommandsRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(namespaceAsString(), other.namespaceAsString())
                && Objects.equals(commandParameterName(), other.commandParameterName())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCommandsRequest").add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("Namespace", namespaceAsString()).add("CommandParameterName", commandParameterName())
                .add("SortOrder", sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespaceAsString()));
        case "commandParameterName":
            return Optional.ofNullable(clazz.cast(commandParameterName()));
        case "sortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("namespace", NAMESPACE_FIELD);
        map.put("commandParameterName", COMMAND_PARAMETER_NAME_FIELD);
        map.put("sortOrder", SORT_ORDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCommandsRequest, T> g) {
        return obj -> g.apply((ListCommandsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListCommandsRequest> {
        /**
         * <p>
         * The maximum number of results to return in this operation. By default, the API returns up to a maximum of 25
         * results. You can override this default value to return up to a maximum of 100 results for this operation.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in this operation. By default, the API returns up to a maximum
         *        of 25 results. You can override this default value to return up to a maximum of 100 results for this
         *        operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise
         * <code>null</code> to receive the first set of results.
         * </p>
         * 
         * @param nextToken
         *        To retrieve the next set of results, the <code>nextToken</code> value from a previous response;
         *        otherwise <code>null</code> to receive the first set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The namespace of the command. By default, the API returns all commands that have been created for both
         * <code>AWS-IoT</code> and <code>AWS-IoT-FleetWise</code> namespaces. You can override this default value if
         * you want to return all commands that have been created only for a specific namespace.
         * </p>
         * 
         * @param namespace
         *        The namespace of the command. By default, the API returns all commands that have been created for both
         *        <code>AWS-IoT</code> and <code>AWS-IoT-FleetWise</code> namespaces. You can override this default
         *        value if you want to return all commands that have been created only for a specific namespace.
         * @see CommandNamespace
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommandNamespace
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The namespace of the command. By default, the API returns all commands that have been created for both
         * <code>AWS-IoT</code> and <code>AWS-IoT-FleetWise</code> namespaces. You can override this default value if
         * you want to return all commands that have been created only for a specific namespace.
         * </p>
         * 
         * @param namespace
         *        The namespace of the command. By default, the API returns all commands that have been created for both
         *        <code>AWS-IoT</code> and <code>AWS-IoT-FleetWise</code> namespaces. You can override this default
         *        value if you want to return all commands that have been created only for a specific namespace.
         * @see CommandNamespace
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommandNamespace
         */
        Builder namespace(CommandNamespace namespace);

        /**
         * <p>
         * A filter that can be used to display the list of commands that have a specific command parameter name.
         * </p>
         * 
         * @param commandParameterName
         *        A filter that can be used to display the list of commands that have a specific command parameter name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commandParameterName(String commandParameterName);

        /**
         * <p>
         * Specify whether to list the commands that you have created in the ascending or descending order. By default,
         * the API returns all commands in the descending order based on the time that they were created.
         * </p>
         * 
         * @param sortOrder
         *        Specify whether to list the commands that you have created in the ascending or descending order. By
         *        default, the API returns all commands in the descending order based on the time that they were
         *        created.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * Specify whether to list the commands that you have created in the ascending or descending order. By default,
         * the API returns all commands in the descending order based on the time that they were created.
         * </p>
         * 
         * @param sortOrder
         *        Specify whether to list the commands that you have created in the ascending or descending order. By
         *        default, the API returns all commands in the descending order based on the time that they were
         *        created.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private String namespace;

        private String commandParameterName;

        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCommandsRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            namespace(model.namespace);
            commandParameterName(model.commandParameterName);
            sortOrder(model.sortOrder);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        public final Builder namespace(CommandNamespace namespace) {
            this.namespace(namespace == null ? null : namespace.toString());
            return this;
        }

        public final String getCommandParameterName() {
            return commandParameterName;
        }

        public final void setCommandParameterName(String commandParameterName) {
            this.commandParameterName = commandParameterName;
        }

        @Override
        public final Builder commandParameterName(String commandParameterName) {
            this.commandParameterName = commandParameterName;
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCommandsRequest build() {
            return new ListCommandsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
