/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A map of key-value pairs containing the patterns that need to be replaced in a managed template job document schema.
 * You can use the description of each key as a guidance to specify the inputs during runtime when creating a job.
 * </p>
 * <note>
 * <p>
 * <code>documentParameters</code> can only be used when creating jobs from Amazon Web Services managed templates. This
 * parameter can't be used with custom job templates or to create jobs from them.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentParameter implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentParameter.Builder, DocumentParameter> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("key")
            .getter(getter(DocumentParameter::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(DocumentParameter::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> REGEX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("regex")
            .getter(getter(DocumentParameter::regex)).setter(setter(Builder::regex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regex").build()).build();

    private static final SdkField<String> EXAMPLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("example")
            .getter(getter(DocumentParameter::example)).setter(setter(Builder::example))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("example").build()).build();

    private static final SdkField<Boolean> OPTIONAL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("optional").getter(getter(DocumentParameter::optional)).setter(setter(Builder::optional))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("optional").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, DESCRIPTION_FIELD,
            REGEX_FIELD, EXAMPLE_FIELD, OPTIONAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String key;

    private final String description;

    private final String regex;

    private final String example;

    private final Boolean optional;

    private DocumentParameter(BuilderImpl builder) {
        this.key = builder.key;
        this.description = builder.description;
        this.regex = builder.regex;
        this.example = builder.example;
        this.optional = builder.optional;
    }

    /**
     * <p>
     * Key of the map field containing the patterns that need to be replaced in a managed template job document schema.
     * </p>
     * 
     * @return Key of the map field containing the patterns that need to be replaced in a managed template job document
     *         schema.
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * Description of the map field containing the patterns that need to be replaced in a managed template job document
     * schema.
     * </p>
     * 
     * @return Description of the map field containing the patterns that need to be replaced in a managed template job
     *         document schema.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A regular expression of the patterns that need to be replaced in a managed template job document schema.
     * </p>
     * 
     * @return A regular expression of the patterns that need to be replaced in a managed template job document schema.
     */
    public final String regex() {
        return regex;
    }

    /**
     * <p>
     * An example illustrating a pattern that need to be replaced in a managed template job document schema.
     * </p>
     * 
     * @return An example illustrating a pattern that need to be replaced in a managed template job document schema.
     */
    public final String example() {
        return example;
    }

    /**
     * <p>
     * Specifies whether a pattern that needs to be replaced in a managed template job document schema is optional or
     * required.
     * </p>
     * 
     * @return Specifies whether a pattern that needs to be replaced in a managed template job document schema is
     *         optional or required.
     */
    public final Boolean optional() {
        return optional;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(regex());
        hashCode = 31 * hashCode + Objects.hashCode(example());
        hashCode = 31 * hashCode + Objects.hashCode(optional());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentParameter)) {
            return false;
        }
        DocumentParameter other = (DocumentParameter) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(description(), other.description())
                && Objects.equals(regex(), other.regex()) && Objects.equals(example(), other.example())
                && Objects.equals(optional(), other.optional());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentParameter").add("Key", key()).add("Description", description()).add("Regex", regex())
                .add("Example", example()).add("Optional", optional()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "key":
            return Optional.ofNullable(clazz.cast(key()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "regex":
            return Optional.ofNullable(clazz.cast(regex()));
        case "example":
            return Optional.ofNullable(clazz.cast(example()));
        case "optional":
            return Optional.ofNullable(clazz.cast(optional()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("key", KEY_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("regex", REGEX_FIELD);
        map.put("example", EXAMPLE_FIELD);
        map.put("optional", OPTIONAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DocumentParameter, T> g) {
        return obj -> g.apply((DocumentParameter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentParameter> {
        /**
         * <p>
         * Key of the map field containing the patterns that need to be replaced in a managed template job document
         * schema.
         * </p>
         * 
         * @param key
         *        Key of the map field containing the patterns that need to be replaced in a managed template job
         *        document schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * Description of the map field containing the patterns that need to be replaced in a managed template job
         * document schema.
         * </p>
         * 
         * @param description
         *        Description of the map field containing the patterns that need to be replaced in a managed template
         *        job document schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A regular expression of the patterns that need to be replaced in a managed template job document schema.
         * </p>
         * 
         * @param regex
         *        A regular expression of the patterns that need to be replaced in a managed template job document
         *        schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regex(String regex);

        /**
         * <p>
         * An example illustrating a pattern that need to be replaced in a managed template job document schema.
         * </p>
         * 
         * @param example
         *        An example illustrating a pattern that need to be replaced in a managed template job document schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder example(String example);

        /**
         * <p>
         * Specifies whether a pattern that needs to be replaced in a managed template job document schema is optional
         * or required.
         * </p>
         * 
         * @param optional
         *        Specifies whether a pattern that needs to be replaced in a managed template job document schema is
         *        optional or required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optional(Boolean optional);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private String description;

        private String regex;

        private String example;

        private Boolean optional;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentParameter model) {
            key(model.key);
            description(model.description);
            regex(model.regex);
            example(model.example);
            optional(model.optional);
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRegex() {
            return regex;
        }

        public final void setRegex(String regex) {
            this.regex = regex;
        }

        @Override
        public final Builder regex(String regex) {
            this.regex = regex;
            return this;
        }

        public final String getExample() {
            return example;
        }

        public final void setExample(String example) {
            this.example = example;
        }

        @Override
        public final Builder example(String example) {
            this.example = example;
            return this;
        }

        public final Boolean getOptional() {
            return optional;
        }

        public final void setOptional(Boolean optional) {
            this.optional = optional;
        }

        @Override
        public final Builder optional(Boolean optional) {
            this.optional = optional;
            return this;
        }

        @Override
        public DocumentParameter build() {
            return new DocumentParameter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
