/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the topic rule destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicRuleDestinationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<TopicRuleDestinationSummary.Builder, TopicRuleDestinationSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(TopicRuleDestinationSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(TopicRuleDestinationSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(TopicRuleDestinationSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt").getter(getter(TopicRuleDestinationSummary::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(TopicRuleDestinationSummary::statusReason))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<HttpUrlDestinationSummary> HTTP_URL_SUMMARY_FIELD = SdkField
            .<HttpUrlDestinationSummary> builder(MarshallingType.SDK_POJO).memberName("httpUrlSummary")
            .getter(getter(TopicRuleDestinationSummary::httpUrlSummary)).setter(setter(Builder::httpUrlSummary))
            .constructor(HttpUrlDestinationSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpUrlSummary").build()).build();

    private static final SdkField<VpcDestinationSummary> VPC_DESTINATION_SUMMARY_FIELD = SdkField
            .<VpcDestinationSummary> builder(MarshallingType.SDK_POJO).memberName("vpcDestinationSummary")
            .getter(getter(TopicRuleDestinationSummary::vpcDestinationSummary)).setter(setter(Builder::vpcDestinationSummary))
            .constructor(VpcDestinationSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcDestinationSummary").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, STATUS_FIELD,
            CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, STATUS_REASON_FIELD, HTTP_URL_SUMMARY_FIELD, VPC_DESTINATION_SUMMARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String status;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final String statusReason;

    private final HttpUrlDestinationSummary httpUrlSummary;

    private final VpcDestinationSummary vpcDestinationSummary;

    private TopicRuleDestinationSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.statusReason = builder.statusReason;
        this.httpUrlSummary = builder.httpUrlSummary;
        this.vpcDestinationSummary = builder.vpcDestinationSummary;
    }

    /**
     * <p>
     * The topic rule destination ARN.
     * </p>
     * 
     * @return The topic rule destination ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The status of the topic rule destination. Valid values are:
     * </p>
     * <dl>
     * <dt>IN_PROGRESS</dt>
     * <dd>
     * <p>
     * A topic rule destination was created but has not been confirmed. You can set <code>status</code> to
     * <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
     * <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation
     * endpoint.
     * </p>
     * </dd>
     * <dt>ENABLED</dt>
     * <dd>
     * <p>
     * Confirmation was completed, and traffic to this destination is allowed. You can set <code>status</code> to
     * <code>DISABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
     * </p>
     * </dd>
     * <dt>DISABLED</dt>
     * <dd>
     * <p>
     * Confirmation was completed, and traffic to this destination is not allowed. You can set <code>status</code> to
     * <code>ENABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
     * </p>
     * </dd>
     * <dt>ERROR</dt>
     * <dd>
     * <p>
     * Confirmation could not be completed, for example if the confirmation timed out. You can call
     * <code>GetTopicRuleDestination</code> for details about the error. You can set <code>status</code> to
     * <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
     * <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation
     * endpoint.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TopicRuleDestinationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the topic rule destination. Valid values are:</p>
     *         <dl>
     *         <dt>IN_PROGRESS</dt>
     *         <dd>
     *         <p>
     *         A topic rule destination was created but has not been confirmed. You can set <code>status</code> to
     *         <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
     *         <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your
     *         confirmation endpoint.
     *         </p>
     *         </dd>
     *         <dt>ENABLED</dt>
     *         <dd>
     *         <p>
     *         Confirmation was completed, and traffic to this destination is allowed. You can set <code>status</code>
     *         to <code>DISABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
     *         </p>
     *         </dd>
     *         <dt>DISABLED</dt>
     *         <dd>
     *         <p>
     *         Confirmation was completed, and traffic to this destination is not allowed. You can set
     *         <code>status</code> to <code>ENABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
     *         </p>
     *         </dd>
     *         <dt>ERROR</dt>
     *         <dd>
     *         <p>
     *         Confirmation could not be completed, for example if the confirmation timed out. You can call
     *         <code>GetTopicRuleDestination</code> for details about the error. You can set <code>status</code> to
     *         <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
     *         <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your
     *         confirmation endpoint.
     *         </p>
     *         </dd>
     * @see TopicRuleDestinationStatus
     */
    public final TopicRuleDestinationStatus status() {
        return TopicRuleDestinationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the topic rule destination. Valid values are:
     * </p>
     * <dl>
     * <dt>IN_PROGRESS</dt>
     * <dd>
     * <p>
     * A topic rule destination was created but has not been confirmed. You can set <code>status</code> to
     * <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
     * <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation
     * endpoint.
     * </p>
     * </dd>
     * <dt>ENABLED</dt>
     * <dd>
     * <p>
     * Confirmation was completed, and traffic to this destination is allowed. You can set <code>status</code> to
     * <code>DISABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
     * </p>
     * </dd>
     * <dt>DISABLED</dt>
     * <dd>
     * <p>
     * Confirmation was completed, and traffic to this destination is not allowed. You can set <code>status</code> to
     * <code>ENABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
     * </p>
     * </dd>
     * <dt>ERROR</dt>
     * <dd>
     * <p>
     * Confirmation could not be completed, for example if the confirmation timed out. You can call
     * <code>GetTopicRuleDestination</code> for details about the error. You can set <code>status</code> to
     * <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
     * <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation
     * endpoint.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TopicRuleDestinationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the topic rule destination. Valid values are:</p>
     *         <dl>
     *         <dt>IN_PROGRESS</dt>
     *         <dd>
     *         <p>
     *         A topic rule destination was created but has not been confirmed. You can set <code>status</code> to
     *         <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
     *         <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your
     *         confirmation endpoint.
     *         </p>
     *         </dd>
     *         <dt>ENABLED</dt>
     *         <dd>
     *         <p>
     *         Confirmation was completed, and traffic to this destination is allowed. You can set <code>status</code>
     *         to <code>DISABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
     *         </p>
     *         </dd>
     *         <dt>DISABLED</dt>
     *         <dd>
     *         <p>
     *         Confirmation was completed, and traffic to this destination is not allowed. You can set
     *         <code>status</code> to <code>ENABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
     *         </p>
     *         </dd>
     *         <dt>ERROR</dt>
     *         <dd>
     *         <p>
     *         Confirmation could not be completed, for example if the confirmation timed out. You can call
     *         <code>GetTopicRuleDestination</code> for details about the error. You can set <code>status</code> to
     *         <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
     *         <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your
     *         confirmation endpoint.
     *         </p>
     *         </dd>
     * @see TopicRuleDestinationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date and time when the topic rule destination was created.
     * </p>
     * 
     * @return The date and time when the topic rule destination was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The date and time when the topic rule destination was last updated.
     * </p>
     * 
     * @return The date and time when the topic rule destination was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The reason the topic rule destination is in the current status.
     * </p>
     * 
     * @return The reason the topic rule destination is in the current status.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * Information about the HTTP URL.
     * </p>
     * 
     * @return Information about the HTTP URL.
     */
    public final HttpUrlDestinationSummary httpUrlSummary() {
        return httpUrlSummary;
    }

    /**
     * <p>
     * Information about the virtual private cloud (VPC) connection.
     * </p>
     * 
     * @return Information about the virtual private cloud (VPC) connection.
     */
    public final VpcDestinationSummary vpcDestinationSummary() {
        return vpcDestinationSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(httpUrlSummary());
        hashCode = 31 * hashCode + Objects.hashCode(vpcDestinationSummary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicRuleDestinationSummary)) {
            return false;
        }
        TopicRuleDestinationSummary other = (TopicRuleDestinationSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(statusReason(), other.statusReason())
                && Objects.equals(httpUrlSummary(), other.httpUrlSummary())
                && Objects.equals(vpcDestinationSummary(), other.vpcDestinationSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TopicRuleDestinationSummary").add("Arn", arn()).add("Status", statusAsString())
                .add("CreatedAt", createdAt()).add("LastUpdatedAt", lastUpdatedAt()).add("StatusReason", statusReason())
                .add("HttpUrlSummary", httpUrlSummary()).add("VpcDestinationSummary", vpcDestinationSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "httpUrlSummary":
            return Optional.ofNullable(clazz.cast(httpUrlSummary()));
        case "vpcDestinationSummary":
            return Optional.ofNullable(clazz.cast(vpcDestinationSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("httpUrlSummary", HTTP_URL_SUMMARY_FIELD);
        map.put("vpcDestinationSummary", VPC_DESTINATION_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TopicRuleDestinationSummary, T> g) {
        return obj -> g.apply((TopicRuleDestinationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicRuleDestinationSummary> {
        /**
         * <p>
         * The topic rule destination ARN.
         * </p>
         * 
         * @param arn
         *        The topic rule destination ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The status of the topic rule destination. Valid values are:
         * </p>
         * <dl>
         * <dt>IN_PROGRESS</dt>
         * <dd>
         * <p>
         * A topic rule destination was created but has not been confirmed. You can set <code>status</code> to
         * <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
         * <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation
         * endpoint.
         * </p>
         * </dd>
         * <dt>ENABLED</dt>
         * <dd>
         * <p>
         * Confirmation was completed, and traffic to this destination is allowed. You can set <code>status</code> to
         * <code>DISABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
         * </p>
         * </dd>
         * <dt>DISABLED</dt>
         * <dd>
         * <p>
         * Confirmation was completed, and traffic to this destination is not allowed. You can set <code>status</code>
         * to <code>ENABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
         * </p>
         * </dd>
         * <dt>ERROR</dt>
         * <dd>
         * <p>
         * Confirmation could not be completed, for example if the confirmation timed out. You can call
         * <code>GetTopicRuleDestination</code> for details about the error. You can set <code>status</code> to
         * <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
         * <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation
         * endpoint.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param status
         *        The status of the topic rule destination. Valid values are:</p>
         *        <dl>
         *        <dt>IN_PROGRESS</dt>
         *        <dd>
         *        <p>
         *        A topic rule destination was created but has not been confirmed. You can set <code>status</code> to
         *        <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
         *        <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your
         *        confirmation endpoint.
         *        </p>
         *        </dd>
         *        <dt>ENABLED</dt>
         *        <dd>
         *        <p>
         *        Confirmation was completed, and traffic to this destination is allowed. You can set
         *        <code>status</code> to <code>DISABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
         *        </p>
         *        </dd>
         *        <dt>DISABLED</dt>
         *        <dd>
         *        <p>
         *        Confirmation was completed, and traffic to this destination is not allowed. You can set
         *        <code>status</code> to <code>ENABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
         *        </p>
         *        </dd>
         *        <dt>ERROR</dt>
         *        <dd>
         *        <p>
         *        Confirmation could not be completed, for example if the confirmation timed out. You can call
         *        <code>GetTopicRuleDestination</code> for details about the error. You can set <code>status</code> to
         *        <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
         *        <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your
         *        confirmation endpoint.
         *        </p>
         *        </dd>
         * @see TopicRuleDestinationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicRuleDestinationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the topic rule destination. Valid values are:
         * </p>
         * <dl>
         * <dt>IN_PROGRESS</dt>
         * <dd>
         * <p>
         * A topic rule destination was created but has not been confirmed. You can set <code>status</code> to
         * <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
         * <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation
         * endpoint.
         * </p>
         * </dd>
         * <dt>ENABLED</dt>
         * <dd>
         * <p>
         * Confirmation was completed, and traffic to this destination is allowed. You can set <code>status</code> to
         * <code>DISABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
         * </p>
         * </dd>
         * <dt>DISABLED</dt>
         * <dd>
         * <p>
         * Confirmation was completed, and traffic to this destination is not allowed. You can set <code>status</code>
         * to <code>ENABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
         * </p>
         * </dd>
         * <dt>ERROR</dt>
         * <dd>
         * <p>
         * Confirmation could not be completed, for example if the confirmation timed out. You can call
         * <code>GetTopicRuleDestination</code> for details about the error. You can set <code>status</code> to
         * <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
         * <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation
         * endpoint.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param status
         *        The status of the topic rule destination. Valid values are:</p>
         *        <dl>
         *        <dt>IN_PROGRESS</dt>
         *        <dd>
         *        <p>
         *        A topic rule destination was created but has not been confirmed. You can set <code>status</code> to
         *        <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
         *        <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your
         *        confirmation endpoint.
         *        </p>
         *        </dd>
         *        <dt>ENABLED</dt>
         *        <dd>
         *        <p>
         *        Confirmation was completed, and traffic to this destination is allowed. You can set
         *        <code>status</code> to <code>DISABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
         *        </p>
         *        </dd>
         *        <dt>DISABLED</dt>
         *        <dd>
         *        <p>
         *        Confirmation was completed, and traffic to this destination is not allowed. You can set
         *        <code>status</code> to <code>ENABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
         *        </p>
         *        </dd>
         *        <dt>ERROR</dt>
         *        <dd>
         *        <p>
         *        Confirmation could not be completed, for example if the confirmation timed out. You can call
         *        <code>GetTopicRuleDestination</code> for details about the error. You can set <code>status</code> to
         *        <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
         *        <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your
         *        confirmation endpoint.
         *        </p>
         *        </dd>
         * @see TopicRuleDestinationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicRuleDestinationStatus
         */
        Builder status(TopicRuleDestinationStatus status);

        /**
         * <p>
         * The date and time when the topic rule destination was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time when the topic rule destination was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The date and time when the topic rule destination was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The date and time when the topic rule destination was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The reason the topic rule destination is in the current status.
         * </p>
         * 
         * @param statusReason
         *        The reason the topic rule destination is in the current status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * Information about the HTTP URL.
         * </p>
         * 
         * @param httpUrlSummary
         *        Information about the HTTP URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpUrlSummary(HttpUrlDestinationSummary httpUrlSummary);

        /**
         * <p>
         * Information about the HTTP URL.
         * </p>
         * This is a convenience method that creates an instance of the {@link HttpUrlDestinationSummary.Builder}
         * avoiding the need to create one manually via {@link HttpUrlDestinationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HttpUrlDestinationSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #httpUrlSummary(HttpUrlDestinationSummary)}.
         * 
         * @param httpUrlSummary
         *        a consumer that will call methods on {@link HttpUrlDestinationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #httpUrlSummary(HttpUrlDestinationSummary)
         */
        default Builder httpUrlSummary(Consumer<HttpUrlDestinationSummary.Builder> httpUrlSummary) {
            return httpUrlSummary(HttpUrlDestinationSummary.builder().applyMutation(httpUrlSummary).build());
        }

        /**
         * <p>
         * Information about the virtual private cloud (VPC) connection.
         * </p>
         * 
         * @param vpcDestinationSummary
         *        Information about the virtual private cloud (VPC) connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcDestinationSummary(VpcDestinationSummary vpcDestinationSummary);

        /**
         * <p>
         * Information about the virtual private cloud (VPC) connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcDestinationSummary.Builder} avoiding
         * the need to create one manually via {@link VpcDestinationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcDestinationSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #vpcDestinationSummary(VpcDestinationSummary)}.
         * 
         * @param vpcDestinationSummary
         *        a consumer that will call methods on {@link VpcDestinationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcDestinationSummary(VpcDestinationSummary)
         */
        default Builder vpcDestinationSummary(Consumer<VpcDestinationSummary.Builder> vpcDestinationSummary) {
            return vpcDestinationSummary(VpcDestinationSummary.builder().applyMutation(vpcDestinationSummary).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String status;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private String statusReason;

        private HttpUrlDestinationSummary httpUrlSummary;

        private VpcDestinationSummary vpcDestinationSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicRuleDestinationSummary model) {
            arn(model.arn);
            status(model.status);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
            statusReason(model.statusReason);
            httpUrlSummary(model.httpUrlSummary);
            vpcDestinationSummary(model.vpcDestinationSummary);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TopicRuleDestinationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final HttpUrlDestinationSummary.Builder getHttpUrlSummary() {
            return httpUrlSummary != null ? httpUrlSummary.toBuilder() : null;
        }

        public final void setHttpUrlSummary(HttpUrlDestinationSummary.BuilderImpl httpUrlSummary) {
            this.httpUrlSummary = httpUrlSummary != null ? httpUrlSummary.build() : null;
        }

        @Override
        public final Builder httpUrlSummary(HttpUrlDestinationSummary httpUrlSummary) {
            this.httpUrlSummary = httpUrlSummary;
            return this;
        }

        public final VpcDestinationSummary.Builder getVpcDestinationSummary() {
            return vpcDestinationSummary != null ? vpcDestinationSummary.toBuilder() : null;
        }

        public final void setVpcDestinationSummary(VpcDestinationSummary.BuilderImpl vpcDestinationSummary) {
            this.vpcDestinationSummary = vpcDestinationSummary != null ? vpcDestinationSummary.build() : null;
        }

        @Override
        public final Builder vpcDestinationSummary(VpcDestinationSummary vpcDestinationSummary) {
            this.vpcDestinationSummary = vpcDestinationSummary;
            return this;
        }

        @Override
        public TopicRuleDestinationSummary build() {
            return new TopicRuleDestinationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
