/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.GeoLocationTarget;
import software.amazon.awssdk.services.iot.model.GeoLocationsFilterCopier;
import software.amazon.awssdk.services.iot.model.NamedShadowNamesFilterCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IndexingFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IndexingFilter> {
    private static final SdkField<List<String>> NAMED_SHADOW_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("namedShadowNames").getter(IndexingFilter.getter(IndexingFilter::namedShadowNames)).setter(IndexingFilter.setter(Builder::namedShadowNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namedShadowNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<GeoLocationTarget>> GEO_LOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("geoLocations").getter(IndexingFilter.getter(IndexingFilter::geoLocations)).setter(IndexingFilter.setter(Builder::geoLocations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("geoLocations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GeoLocationTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMED_SHADOW_NAMES_FIELD, GEO_LOCATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IndexingFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> namedShadowNames;
    private final List<GeoLocationTarget> geoLocations;

    private IndexingFilter(BuilderImpl builder) {
        this.namedShadowNames = builder.namedShadowNames;
        this.geoLocations = builder.geoLocations;
    }

    public final boolean hasNamedShadowNames() {
        return this.namedShadowNames != null && !(this.namedShadowNames instanceof SdkAutoConstructList);
    }

    public final List<String> namedShadowNames() {
        return this.namedShadowNames;
    }

    public final boolean hasGeoLocations() {
        return this.geoLocations != null && !(this.geoLocations instanceof SdkAutoConstructList);
    }

    public final List<GeoLocationTarget> geoLocations() {
        return this.geoLocations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNamedShadowNames() ? this.namedShadowNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGeoLocations() ? this.geoLocations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexingFilter)) {
            return false;
        }
        IndexingFilter other = (IndexingFilter)obj;
        return this.hasNamedShadowNames() == other.hasNamedShadowNames() && Objects.equals(this.namedShadowNames(), other.namedShadowNames()) && this.hasGeoLocations() == other.hasGeoLocations() && Objects.equals(this.geoLocations(), other.geoLocations());
    }

    public final String toString() {
        return ToString.builder((String)"IndexingFilter").add("NamedShadowNames", this.hasNamedShadowNames() ? this.namedShadowNames() : null).add("GeoLocations", this.hasGeoLocations() ? this.geoLocations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "namedShadowNames": {
                return Optional.ofNullable(clazz.cast(this.namedShadowNames()));
            }
            case "geoLocations": {
                return Optional.ofNullable(clazz.cast(this.geoLocations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("namedShadowNames", NAMED_SHADOW_NAMES_FIELD);
        map.put("geoLocations", GEO_LOCATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IndexingFilter, T> g) {
        return obj -> g.apply((IndexingFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> namedShadowNames = DefaultSdkAutoConstructList.getInstance();
        private List<GeoLocationTarget> geoLocations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IndexingFilter model) {
            this.namedShadowNames(model.namedShadowNames);
            this.geoLocations(model.geoLocations);
        }

        public final Collection<String> getNamedShadowNames() {
            if (this.namedShadowNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.namedShadowNames;
        }

        public final void setNamedShadowNames(Collection<String> namedShadowNames) {
            this.namedShadowNames = NamedShadowNamesFilterCopier.copy(namedShadowNames);
        }

        @Override
        public final Builder namedShadowNames(Collection<String> namedShadowNames) {
            this.namedShadowNames = NamedShadowNamesFilterCopier.copy(namedShadowNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namedShadowNames(String ... namedShadowNames) {
            this.namedShadowNames(Arrays.asList(namedShadowNames));
            return this;
        }

        public final List<GeoLocationTarget.Builder> getGeoLocations() {
            List<GeoLocationTarget.Builder> result = GeoLocationsFilterCopier.copyToBuilder(this.geoLocations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGeoLocations(Collection<GeoLocationTarget.BuilderImpl> geoLocations) {
            this.geoLocations = GeoLocationsFilterCopier.copyFromBuilder(geoLocations);
        }

        @Override
        public final Builder geoLocations(Collection<GeoLocationTarget> geoLocations) {
            this.geoLocations = GeoLocationsFilterCopier.copy(geoLocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder geoLocations(GeoLocationTarget ... geoLocations) {
            this.geoLocations(Arrays.asList(geoLocations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder geoLocations(Consumer<GeoLocationTarget.Builder> ... geoLocations) {
            this.geoLocations(Stream.of(geoLocations).map(c -> (GeoLocationTarget)((GeoLocationTarget.Builder)GeoLocationTarget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public IndexingFilter build() {
            return new IndexingFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IndexingFilter> {
        public Builder namedShadowNames(Collection<String> var1);

        public Builder namedShadowNames(String ... var1);

        public Builder geoLocations(Collection<GeoLocationTarget> var1);

        public Builder geoLocations(GeoLocationTarget ... var1);

        public Builder geoLocations(Consumer<GeoLocationTarget.Builder> ... var1);
    }
}

