/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of an ML Detect behavior model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BehaviorModelTrainingSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<BehaviorModelTrainingSummary.Builder, BehaviorModelTrainingSummary> {
    private static final SdkField<String> SECURITY_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("securityProfileName").getter(getter(BehaviorModelTrainingSummary::securityProfileName))
            .setter(setter(Builder::securityProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityProfileName").build())
            .build();

    private static final SdkField<String> BEHAVIOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("behaviorName").getter(getter(BehaviorModelTrainingSummary::behaviorName))
            .setter(setter(Builder::behaviorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("behaviorName").build()).build();

    private static final SdkField<Instant> TRAINING_DATA_COLLECTION_START_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("trainingDataCollectionStartDate")
            .getter(getter(BehaviorModelTrainingSummary::trainingDataCollectionStartDate))
            .setter(setter(Builder::trainingDataCollectionStartDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingDataCollectionStartDate")
                    .build()).build();

    private static final SdkField<String> MODEL_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelStatus").getter(getter(BehaviorModelTrainingSummary::modelStatusAsString))
            .setter(setter(Builder::modelStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelStatus").build()).build();

    private static final SdkField<Double> DATAPOINTS_COLLECTION_PERCENTAGE_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("datapointsCollectionPercentage")
            .getter(getter(BehaviorModelTrainingSummary::datapointsCollectionPercentage))
            .setter(setter(Builder::datapointsCollectionPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datapointsCollectionPercentage")
                    .build()).build();

    private static final SdkField<Instant> LAST_MODEL_REFRESH_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModelRefreshDate").getter(getter(BehaviorModelTrainingSummary::lastModelRefreshDate))
            .setter(setter(Builder::lastModelRefreshDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModelRefreshDate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_PROFILE_NAME_FIELD,
            BEHAVIOR_NAME_FIELD, TRAINING_DATA_COLLECTION_START_DATE_FIELD, MODEL_STATUS_FIELD,
            DATAPOINTS_COLLECTION_PERCENTAGE_FIELD, LAST_MODEL_REFRESH_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String securityProfileName;

    private final String behaviorName;

    private final Instant trainingDataCollectionStartDate;

    private final String modelStatus;

    private final Double datapointsCollectionPercentage;

    private final Instant lastModelRefreshDate;

    private BehaviorModelTrainingSummary(BuilderImpl builder) {
        this.securityProfileName = builder.securityProfileName;
        this.behaviorName = builder.behaviorName;
        this.trainingDataCollectionStartDate = builder.trainingDataCollectionStartDate;
        this.modelStatus = builder.modelStatus;
        this.datapointsCollectionPercentage = builder.datapointsCollectionPercentage;
        this.lastModelRefreshDate = builder.lastModelRefreshDate;
    }

    /**
     * <p>
     * The name of the security profile.
     * </p>
     * 
     * @return The name of the security profile.
     */
    public final String securityProfileName() {
        return securityProfileName;
    }

    /**
     * <p>
     * The name of the behavior.
     * </p>
     * 
     * @return The name of the behavior.
     */
    public final String behaviorName() {
        return behaviorName;
    }

    /**
     * <p>
     * The date a training model started collecting data.
     * </p>
     * 
     * @return The date a training model started collecting data.
     */
    public final Instant trainingDataCollectionStartDate() {
        return trainingDataCollectionStartDate;
    }

    /**
     * <p>
     * The status of the behavior model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelStatus} will
     * return {@link ModelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modelStatusAsString}.
     * </p>
     * 
     * @return The status of the behavior model.
     * @see ModelStatus
     */
    public final ModelStatus modelStatus() {
        return ModelStatus.fromValue(modelStatus);
    }

    /**
     * <p>
     * The status of the behavior model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelStatus} will
     * return {@link ModelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modelStatusAsString}.
     * </p>
     * 
     * @return The status of the behavior model.
     * @see ModelStatus
     */
    public final String modelStatusAsString() {
        return modelStatus;
    }

    /**
     * <p>
     * The percentage of datapoints collected.
     * </p>
     * 
     * @return The percentage of datapoints collected.
     */
    public final Double datapointsCollectionPercentage() {
        return datapointsCollectionPercentage;
    }

    /**
     * <p>
     * The date the model was last refreshed.
     * </p>
     * 
     * @return The date the model was last refreshed.
     */
    public final Instant lastModelRefreshDate() {
        return lastModelRefreshDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(securityProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(behaviorName());
        hashCode = 31 * hashCode + Objects.hashCode(trainingDataCollectionStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(modelStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(datapointsCollectionPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(lastModelRefreshDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BehaviorModelTrainingSummary)) {
            return false;
        }
        BehaviorModelTrainingSummary other = (BehaviorModelTrainingSummary) obj;
        return Objects.equals(securityProfileName(), other.securityProfileName())
                && Objects.equals(behaviorName(), other.behaviorName())
                && Objects.equals(trainingDataCollectionStartDate(), other.trainingDataCollectionStartDate())
                && Objects.equals(modelStatusAsString(), other.modelStatusAsString())
                && Objects.equals(datapointsCollectionPercentage(), other.datapointsCollectionPercentage())
                && Objects.equals(lastModelRefreshDate(), other.lastModelRefreshDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BehaviorModelTrainingSummary").add("SecurityProfileName", securityProfileName())
                .add("BehaviorName", behaviorName()).add("TrainingDataCollectionStartDate", trainingDataCollectionStartDate())
                .add("ModelStatus", modelStatusAsString())
                .add("DatapointsCollectionPercentage", datapointsCollectionPercentage())
                .add("LastModelRefreshDate", lastModelRefreshDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "securityProfileName":
            return Optional.ofNullable(clazz.cast(securityProfileName()));
        case "behaviorName":
            return Optional.ofNullable(clazz.cast(behaviorName()));
        case "trainingDataCollectionStartDate":
            return Optional.ofNullable(clazz.cast(trainingDataCollectionStartDate()));
        case "modelStatus":
            return Optional.ofNullable(clazz.cast(modelStatusAsString()));
        case "datapointsCollectionPercentage":
            return Optional.ofNullable(clazz.cast(datapointsCollectionPercentage()));
        case "lastModelRefreshDate":
            return Optional.ofNullable(clazz.cast(lastModelRefreshDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("securityProfileName", SECURITY_PROFILE_NAME_FIELD);
        map.put("behaviorName", BEHAVIOR_NAME_FIELD);
        map.put("trainingDataCollectionStartDate", TRAINING_DATA_COLLECTION_START_DATE_FIELD);
        map.put("modelStatus", MODEL_STATUS_FIELD);
        map.put("datapointsCollectionPercentage", DATAPOINTS_COLLECTION_PERCENTAGE_FIELD);
        map.put("lastModelRefreshDate", LAST_MODEL_REFRESH_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BehaviorModelTrainingSummary, T> g) {
        return obj -> g.apply((BehaviorModelTrainingSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BehaviorModelTrainingSummary> {
        /**
         * <p>
         * The name of the security profile.
         * </p>
         * 
         * @param securityProfileName
         *        The name of the security profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileName(String securityProfileName);

        /**
         * <p>
         * The name of the behavior.
         * </p>
         * 
         * @param behaviorName
         *        The name of the behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder behaviorName(String behaviorName);

        /**
         * <p>
         * The date a training model started collecting data.
         * </p>
         * 
         * @param trainingDataCollectionStartDate
         *        The date a training model started collecting data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingDataCollectionStartDate(Instant trainingDataCollectionStartDate);

        /**
         * <p>
         * The status of the behavior model.
         * </p>
         * 
         * @param modelStatus
         *        The status of the behavior model.
         * @see ModelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelStatus
         */
        Builder modelStatus(String modelStatus);

        /**
         * <p>
         * The status of the behavior model.
         * </p>
         * 
         * @param modelStatus
         *        The status of the behavior model.
         * @see ModelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelStatus
         */
        Builder modelStatus(ModelStatus modelStatus);

        /**
         * <p>
         * The percentage of datapoints collected.
         * </p>
         * 
         * @param datapointsCollectionPercentage
         *        The percentage of datapoints collected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datapointsCollectionPercentage(Double datapointsCollectionPercentage);

        /**
         * <p>
         * The date the model was last refreshed.
         * </p>
         * 
         * @param lastModelRefreshDate
         *        The date the model was last refreshed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModelRefreshDate(Instant lastModelRefreshDate);
    }

    static final class BuilderImpl implements Builder {
        private String securityProfileName;

        private String behaviorName;

        private Instant trainingDataCollectionStartDate;

        private String modelStatus;

        private Double datapointsCollectionPercentage;

        private Instant lastModelRefreshDate;

        private BuilderImpl() {
        }

        private BuilderImpl(BehaviorModelTrainingSummary model) {
            securityProfileName(model.securityProfileName);
            behaviorName(model.behaviorName);
            trainingDataCollectionStartDate(model.trainingDataCollectionStartDate);
            modelStatus(model.modelStatus);
            datapointsCollectionPercentage(model.datapointsCollectionPercentage);
            lastModelRefreshDate(model.lastModelRefreshDate);
        }

        public final String getSecurityProfileName() {
            return securityProfileName;
        }

        public final void setSecurityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
        }

        @Override
        public final Builder securityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
            return this;
        }

        public final String getBehaviorName() {
            return behaviorName;
        }

        public final void setBehaviorName(String behaviorName) {
            this.behaviorName = behaviorName;
        }

        @Override
        public final Builder behaviorName(String behaviorName) {
            this.behaviorName = behaviorName;
            return this;
        }

        public final Instant getTrainingDataCollectionStartDate() {
            return trainingDataCollectionStartDate;
        }

        public final void setTrainingDataCollectionStartDate(Instant trainingDataCollectionStartDate) {
            this.trainingDataCollectionStartDate = trainingDataCollectionStartDate;
        }

        @Override
        public final Builder trainingDataCollectionStartDate(Instant trainingDataCollectionStartDate) {
            this.trainingDataCollectionStartDate = trainingDataCollectionStartDate;
            return this;
        }

        public final String getModelStatus() {
            return modelStatus;
        }

        public final void setModelStatus(String modelStatus) {
            this.modelStatus = modelStatus;
        }

        @Override
        public final Builder modelStatus(String modelStatus) {
            this.modelStatus = modelStatus;
            return this;
        }

        @Override
        public final Builder modelStatus(ModelStatus modelStatus) {
            this.modelStatus(modelStatus == null ? null : modelStatus.toString());
            return this;
        }

        public final Double getDatapointsCollectionPercentage() {
            return datapointsCollectionPercentage;
        }

        public final void setDatapointsCollectionPercentage(Double datapointsCollectionPercentage) {
            this.datapointsCollectionPercentage = datapointsCollectionPercentage;
        }

        @Override
        public final Builder datapointsCollectionPercentage(Double datapointsCollectionPercentage) {
            this.datapointsCollectionPercentage = datapointsCollectionPercentage;
            return this;
        }

        public final Instant getLastModelRefreshDate() {
            return lastModelRefreshDate;
        }

        public final void setLastModelRefreshDate(Instant lastModelRefreshDate) {
            this.lastModelRefreshDate = lastModelRefreshDate;
        }

        @Override
        public final Builder lastModelRefreshDate(Instant lastModelRefreshDate) {
            this.lastModelRefreshDate = lastModelRefreshDate;
            return this;
        }

        @Override
        public BehaviorModelTrainingSummary build() {
            return new BehaviorModelTrainingSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
