/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeProvisioningTemplateVersionResponse extends IotResponse implements
        ToCopyableBuilder<DescribeProvisioningTemplateVersionResponse.Builder, DescribeProvisioningTemplateVersionResponse> {
    private static final SdkField<Integer> VERSION_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("versionId").getter(getter(DescribeProvisioningTemplateVersionResponse::versionId))
            .setter(setter(Builder::versionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionId").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate").getter(getter(DescribeProvisioningTemplateVersionResponse::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final SdkField<String> TEMPLATE_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateBody").getter(getter(DescribeProvisioningTemplateVersionResponse::templateBody))
            .setter(setter(Builder::templateBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateBody").build()).build();

    private static final SdkField<Boolean> IS_DEFAULT_VERSION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isDefaultVersion").getter(getter(DescribeProvisioningTemplateVersionResponse::isDefaultVersion))
            .setter(setter(Builder::isDefaultVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isDefaultVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_ID_FIELD,
            CREATION_DATE_FIELD, TEMPLATE_BODY_FIELD, IS_DEFAULT_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer versionId;

    private final Instant creationDate;

    private final String templateBody;

    private final Boolean isDefaultVersion;

    private DescribeProvisioningTemplateVersionResponse(BuilderImpl builder) {
        super(builder);
        this.versionId = builder.versionId;
        this.creationDate = builder.creationDate;
        this.templateBody = builder.templateBody;
        this.isDefaultVersion = builder.isDefaultVersion;
    }

    /**
     * <p>
     * The provisioning template version ID.
     * </p>
     * 
     * @return The provisioning template version ID.
     */
    public final Integer versionId() {
        return versionId;
    }

    /**
     * <p>
     * The date when the provisioning template version was created.
     * </p>
     * 
     * @return The date when the provisioning template version was created.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The JSON formatted contents of the provisioning template version.
     * </p>
     * 
     * @return The JSON formatted contents of the provisioning template version.
     */
    public final String templateBody() {
        return templateBody;
    }

    /**
     * <p>
     * True if the provisioning template version is the default version.
     * </p>
     * 
     * @return True if the provisioning template version is the default version.
     */
    public final Boolean isDefaultVersion() {
        return isDefaultVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(isDefaultVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProvisioningTemplateVersionResponse)) {
            return false;
        }
        DescribeProvisioningTemplateVersionResponse other = (DescribeProvisioningTemplateVersionResponse) obj;
        return Objects.equals(versionId(), other.versionId()) && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(templateBody(), other.templateBody())
                && Objects.equals(isDefaultVersion(), other.isDefaultVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeProvisioningTemplateVersionResponse").add("VersionId", versionId())
                .add("CreationDate", creationDate()).add("TemplateBody", templateBody())
                .add("IsDefaultVersion", isDefaultVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "versionId":
            return Optional.ofNullable(clazz.cast(versionId()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "templateBody":
            return Optional.ofNullable(clazz.cast(templateBody()));
        case "isDefaultVersion":
            return Optional.ofNullable(clazz.cast(isDefaultVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("versionId", VERSION_ID_FIELD);
        map.put("creationDate", CREATION_DATE_FIELD);
        map.put("templateBody", TEMPLATE_BODY_FIELD);
        map.put("isDefaultVersion", IS_DEFAULT_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeProvisioningTemplateVersionResponse, T> g) {
        return obj -> g.apply((DescribeProvisioningTemplateVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeProvisioningTemplateVersionResponse> {
        /**
         * <p>
         * The provisioning template version ID.
         * </p>
         * 
         * @param versionId
         *        The provisioning template version ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(Integer versionId);

        /**
         * <p>
         * The date when the provisioning template version was created.
         * </p>
         * 
         * @param creationDate
         *        The date when the provisioning template version was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The JSON formatted contents of the provisioning template version.
         * </p>
         * 
         * @param templateBody
         *        The JSON formatted contents of the provisioning template version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateBody(String templateBody);

        /**
         * <p>
         * True if the provisioning template version is the default version.
         * </p>
         * 
         * @param isDefaultVersion
         *        True if the provisioning template version is the default version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDefaultVersion(Boolean isDefaultVersion);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private Integer versionId;

        private Instant creationDate;

        private String templateBody;

        private Boolean isDefaultVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProvisioningTemplateVersionResponse model) {
            super(model);
            versionId(model.versionId);
            creationDate(model.creationDate);
            templateBody(model.templateBody);
            isDefaultVersion(model.isDefaultVersion);
        }

        public final Integer getVersionId() {
            return versionId;
        }

        public final void setVersionId(Integer versionId) {
            this.versionId = versionId;
        }

        @Override
        public final Builder versionId(Integer versionId) {
            this.versionId = versionId;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getTemplateBody() {
            return templateBody;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final Boolean getIsDefaultVersion() {
            return isDefaultVersion;
        }

        public final void setIsDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
        }

        @Override
        public final Builder isDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
            return this;
        }

        @Override
        public DescribeProvisioningTemplateVersionResponse build() {
            return new DescribeProvisioningTemplateVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
