/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon Location rule action sends device location updates from an MQTT message to an Amazon Location tracker
 * resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LocationAction implements SdkPojo, Serializable, ToCopyableBuilder<LocationAction.Builder, LocationAction> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(LocationAction::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> TRACKER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trackerName").getter(getter(LocationAction::trackerName)).setter(setter(Builder::trackerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trackerName").build()).build();

    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deviceId").getter(getter(LocationAction::deviceId)).setter(setter(Builder::deviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceId").build()).build();

    private static final SdkField<LocationTimestamp> TIMESTAMP_FIELD = SdkField
            .<LocationTimestamp> builder(MarshallingType.SDK_POJO).memberName("timestamp")
            .getter(getter(LocationAction::timestamp)).setter(setter(Builder::timestamp)).constructor(LocationTimestamp::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()).build();

    private static final SdkField<String> LATITUDE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("latitude").getter(getter(LocationAction::latitude)).setter(setter(Builder::latitude))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latitude").build()).build();

    private static final SdkField<String> LONGITUDE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("longitude").getter(getter(LocationAction::longitude)).setter(setter(Builder::longitude))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("longitude").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD,
            TRACKER_NAME_FIELD, DEVICE_ID_FIELD, TIMESTAMP_FIELD, LATITUDE_FIELD, LONGITUDE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String roleArn;

    private final String trackerName;

    private final String deviceId;

    private final LocationTimestamp timestamp;

    private final String latitude;

    private final String longitude;

    private LocationAction(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.trackerName = builder.trackerName;
        this.deviceId = builder.deviceId;
        this.timestamp = builder.timestamp;
        this.latitude = builder.latitude;
        this.longitude = builder.longitude;
    }

    /**
     * <p>
     * The IAM role that grants permission to write to the Amazon Location resource.
     * </p>
     * 
     * @return The IAM role that grants permission to write to the Amazon Location resource.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The name of the tracker resource in Amazon Location in which the location is updated.
     * </p>
     * 
     * @return The name of the tracker resource in Amazon Location in which the location is updated.
     */
    public final String trackerName() {
        return trackerName;
    }

    /**
     * <p>
     * The unique ID of the device providing the location data.
     * </p>
     * 
     * @return The unique ID of the device providing the location data.
     */
    public final String deviceId() {
        return deviceId;
    }

    /**
     * <p>
     * The time that the location data was sampled. The default value is the time the MQTT message was processed.
     * </p>
     * 
     * @return The time that the location data was sampled. The default value is the time the MQTT message was
     *         processed.
     */
    public final LocationTimestamp timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * A string that evaluates to a double value that represents the latitude of the device's location.
     * </p>
     * 
     * @return A string that evaluates to a double value that represents the latitude of the device's location.
     */
    public final String latitude() {
        return latitude;
    }

    /**
     * <p>
     * A string that evaluates to a double value that represents the longitude of the device's location.
     * </p>
     * 
     * @return A string that evaluates to a double value that represents the longitude of the device's location.
     */
    public final String longitude() {
        return longitude;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(trackerName());
        hashCode = 31 * hashCode + Objects.hashCode(deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(latitude());
        hashCode = 31 * hashCode + Objects.hashCode(longitude());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocationAction)) {
            return false;
        }
        LocationAction other = (LocationAction) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(trackerName(), other.trackerName())
                && Objects.equals(deviceId(), other.deviceId()) && Objects.equals(timestamp(), other.timestamp())
                && Objects.equals(latitude(), other.latitude()) && Objects.equals(longitude(), other.longitude());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LocationAction").add("RoleArn", roleArn()).add("TrackerName", trackerName())
                .add("DeviceId", deviceId()).add("Timestamp", timestamp()).add("Latitude", latitude())
                .add("Longitude", longitude()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "trackerName":
            return Optional.ofNullable(clazz.cast(trackerName()));
        case "deviceId":
            return Optional.ofNullable(clazz.cast(deviceId()));
        case "timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "latitude":
            return Optional.ofNullable(clazz.cast(latitude()));
        case "longitude":
            return Optional.ofNullable(clazz.cast(longitude()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("trackerName", TRACKER_NAME_FIELD);
        map.put("deviceId", DEVICE_ID_FIELD);
        map.put("timestamp", TIMESTAMP_FIELD);
        map.put("latitude", LATITUDE_FIELD);
        map.put("longitude", LONGITUDE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LocationAction, T> g) {
        return obj -> g.apply((LocationAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LocationAction> {
        /**
         * <p>
         * The IAM role that grants permission to write to the Amazon Location resource.
         * </p>
         * 
         * @param roleArn
         *        The IAM role that grants permission to write to the Amazon Location resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The name of the tracker resource in Amazon Location in which the location is updated.
         * </p>
         * 
         * @param trackerName
         *        The name of the tracker resource in Amazon Location in which the location is updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackerName(String trackerName);

        /**
         * <p>
         * The unique ID of the device providing the location data.
         * </p>
         * 
         * @param deviceId
         *        The unique ID of the device providing the location data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceId(String deviceId);

        /**
         * <p>
         * The time that the location data was sampled. The default value is the time the MQTT message was processed.
         * </p>
         * 
         * @param timestamp
         *        The time that the location data was sampled. The default value is the time the MQTT message was
         *        processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(LocationTimestamp timestamp);

        /**
         * <p>
         * The time that the location data was sampled. The default value is the time the MQTT message was processed.
         * </p>
         * This is a convenience method that creates an instance of the {@link LocationTimestamp.Builder} avoiding the
         * need to create one manually via {@link LocationTimestamp#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LocationTimestamp.Builder#build()} is called immediately and its
         * result is passed to {@link #timestamp(LocationTimestamp)}.
         * 
         * @param timestamp
         *        a consumer that will call methods on {@link LocationTimestamp.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timestamp(LocationTimestamp)
         */
        default Builder timestamp(Consumer<LocationTimestamp.Builder> timestamp) {
            return timestamp(LocationTimestamp.builder().applyMutation(timestamp).build());
        }

        /**
         * <p>
         * A string that evaluates to a double value that represents the latitude of the device's location.
         * </p>
         * 
         * @param latitude
         *        A string that evaluates to a double value that represents the latitude of the device's location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latitude(String latitude);

        /**
         * <p>
         * A string that evaluates to a double value that represents the longitude of the device's location.
         * </p>
         * 
         * @param longitude
         *        A string that evaluates to a double value that represents the longitude of the device's location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder longitude(String longitude);
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private String trackerName;

        private String deviceId;

        private LocationTimestamp timestamp;

        private String latitude;

        private String longitude;

        private BuilderImpl() {
        }

        private BuilderImpl(LocationAction model) {
            roleArn(model.roleArn);
            trackerName(model.trackerName);
            deviceId(model.deviceId);
            timestamp(model.timestamp);
            latitude(model.latitude);
            longitude(model.longitude);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getTrackerName() {
            return trackerName;
        }

        public final void setTrackerName(String trackerName) {
            this.trackerName = trackerName;
        }

        @Override
        public final Builder trackerName(String trackerName) {
            this.trackerName = trackerName;
            return this;
        }

        public final String getDeviceId() {
            return deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final LocationTimestamp.Builder getTimestamp() {
            return timestamp != null ? timestamp.toBuilder() : null;
        }

        public final void setTimestamp(LocationTimestamp.BuilderImpl timestamp) {
            this.timestamp = timestamp != null ? timestamp.build() : null;
        }

        @Override
        public final Builder timestamp(LocationTimestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getLatitude() {
            return latitude;
        }

        public final void setLatitude(String latitude) {
            this.latitude = latitude;
        }

        @Override
        public final Builder latitude(String latitude) {
            this.latitude = latitude;
            return this;
        }

        public final String getLongitude() {
            return longitude;
        }

        public final void setLongitude(String longitude) {
            this.longitude = longitude;
        }

        @Override
        public final Builder longitude(String longitude) {
            this.longitude = longitude;
            return this;
        }

        @Override
        public LocationAction build() {
            return new LocationAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
