/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCommandExecutionRequest extends IotRequest implements
        ToCopyableBuilder<GetCommandExecutionRequest.Builder, GetCommandExecutionRequest> {
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionId").getter(getter(GetCommandExecutionRequest::executionId))
            .setter(setter(Builder::executionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("executionId").build()).build();

    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetArn").getter(getter(GetCommandExecutionRequest::targetArn)).setter(setter(Builder::targetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("targetArn").build()).build();

    private static final SdkField<Boolean> INCLUDE_RESULT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeResult").getter(getter(GetCommandExecutionRequest::includeResult))
            .setter(setter(Builder::includeResult))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("includeResult").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ID_FIELD,
            TARGET_ARN_FIELD, INCLUDE_RESULT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String executionId;

    private final String targetArn;

    private final Boolean includeResult;

    private GetCommandExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.executionId = builder.executionId;
        this.targetArn = builder.targetArn;
        this.includeResult = builder.includeResult;
    }

    /**
     * <p>
     * The unique identifier for the command execution. This information is returned as a response of the
     * <code>StartCommandExecution</code> API request.
     * </p>
     * 
     * @return The unique identifier for the command execution. This information is returned as a response of the
     *         <code>StartCommandExecution</code> API request.
     */
    public final String executionId() {
        return executionId;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the device on which the command execution is being performed.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the device on which the command execution is being performed.
     */
    public final String targetArn() {
        return targetArn;
    }

    /**
     * <p>
     * Can be used to specify whether to include the result of the command execution in the
     * <code>GetCommandExecution</code> API response. Your device can use this field to provide additional information
     * about the command execution. You only need to specify this field when using the <code>AWS-IoT</code> namespace.
     * </p>
     * 
     * @return Can be used to specify whether to include the result of the command execution in the
     *         <code>GetCommandExecution</code> API response. Your device can use this field to provide additional
     *         information about the command execution. You only need to specify this field when using the
     *         <code>AWS-IoT</code> namespace.
     */
    public final Boolean includeResult() {
        return includeResult;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(executionId());
        hashCode = 31 * hashCode + Objects.hashCode(targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(includeResult());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCommandExecutionRequest)) {
            return false;
        }
        GetCommandExecutionRequest other = (GetCommandExecutionRequest) obj;
        return Objects.equals(executionId(), other.executionId()) && Objects.equals(targetArn(), other.targetArn())
                && Objects.equals(includeResult(), other.includeResult());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCommandExecutionRequest").add("ExecutionId", executionId()).add("TargetArn", targetArn())
                .add("IncludeResult", includeResult()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "executionId":
            return Optional.ofNullable(clazz.cast(executionId()));
        case "targetArn":
            return Optional.ofNullable(clazz.cast(targetArn()));
        case "includeResult":
            return Optional.ofNullable(clazz.cast(includeResult()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("executionId", EXECUTION_ID_FIELD);
        map.put("targetArn", TARGET_ARN_FIELD);
        map.put("includeResult", INCLUDE_RESULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCommandExecutionRequest, T> g) {
        return obj -> g.apply((GetCommandExecutionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetCommandExecutionRequest> {
        /**
         * <p>
         * The unique identifier for the command execution. This information is returned as a response of the
         * <code>StartCommandExecution</code> API request.
         * </p>
         * 
         * @param executionId
         *        The unique identifier for the command execution. This information is returned as a response of the
         *        <code>StartCommandExecution</code> API request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionId(String executionId);

        /**
         * <p>
         * The Amazon Resource Number (ARN) of the device on which the command execution is being performed.
         * </p>
         * 
         * @param targetArn
         *        The Amazon Resource Number (ARN) of the device on which the command execution is being performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetArn(String targetArn);

        /**
         * <p>
         * Can be used to specify whether to include the result of the command execution in the
         * <code>GetCommandExecution</code> API response. Your device can use this field to provide additional
         * information about the command execution. You only need to specify this field when using the
         * <code>AWS-IoT</code> namespace.
         * </p>
         * 
         * @param includeResult
         *        Can be used to specify whether to include the result of the command execution in the
         *        <code>GetCommandExecution</code> API response. Your device can use this field to provide additional
         *        information about the command execution. You only need to specify this field when using the
         *        <code>AWS-IoT</code> namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeResult(Boolean includeResult);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String executionId;

        private String targetArn;

        private Boolean includeResult;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCommandExecutionRequest model) {
            super(model);
            executionId(model.executionId);
            targetArn(model.targetArn);
            includeResult(model.includeResult);
        }

        public final String getExecutionId() {
            return executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final String getTargetArn() {
            return targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final Boolean getIncludeResult() {
            return includeResult;
        }

        public final void setIncludeResult(Boolean includeResult) {
            this.includeResult = includeResult;
        }

        @Override
        public final Builder includeResult(Boolean includeResult) {
            this.includeResult = includeResult;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCommandExecutionRequest build() {
            return new GetCommandExecutionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
