/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The range of possible values that's used to describe a specific command parameter.
 * </p>
 * <note>
 * <p>
 * The <code>commandParameterValue</code> can only have one of the below fields listed.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CommandParameterValue implements SdkPojo, Serializable,
        ToCopyableBuilder<CommandParameterValue.Builder, CommandParameterValue> {
    private static final SdkField<String> S_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("S")
            .getter(getter(CommandParameterValue::s)).setter(setter(Builder::s))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S").build()).build();

    private static final SdkField<Boolean> B_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("B")
            .getter(getter(CommandParameterValue::b)).setter(setter(Builder::b))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("B").build()).build();

    private static final SdkField<Integer> I_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("I")
            .getter(getter(CommandParameterValue::i)).setter(setter(Builder::i))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("I").build()).build();

    private static final SdkField<Long> L_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("L")
            .getter(getter(CommandParameterValue::l)).setter(setter(Builder::l))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("L").build()).build();

    private static final SdkField<Double> D_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("D")
            .getter(getter(CommandParameterValue::d)).setter(setter(Builder::d))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("D").build()).build();

    private static final SdkField<SdkBytes> BIN_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES).memberName("BIN")
            .getter(getter(CommandParameterValue::bin)).setter(setter(Builder::bin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BIN").build()).build();

    private static final SdkField<String> UL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UL")
            .getter(getter(CommandParameterValue::ul)).setter(setter(Builder::ul))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UL").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S_FIELD, B_FIELD, I_FIELD,
            L_FIELD, D_FIELD, BIN_FIELD, UL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String s;

    private final Boolean b;

    private final Integer i;

    private final Long l;

    private final Double d;

    private final SdkBytes bin;

    private final String ul;

    private CommandParameterValue(BuilderImpl builder) {
        this.s = builder.s;
        this.b = builder.b;
        this.i = builder.i;
        this.l = builder.l;
        this.d = builder.d;
        this.bin = builder.bin;
        this.ul = builder.ul;
    }

    /**
     * <p>
     * An attribute of type String. For example:
     * </p>
     * <p>
     * <code>"S": "Hello"</code>
     * </p>
     * 
     * @return An attribute of type String. For example:</p>
     *         <p>
     *         <code>"S": "Hello"</code>
     */
    public final String s() {
        return s;
    }

    /**
     * <p>
     * An attribute of type Boolean. For example:
     * </p>
     * <p>
     * <code>"BOOL": true</code>
     * </p>
     * 
     * @return An attribute of type Boolean. For example:</p>
     *         <p>
     *         <code>"BOOL": true</code>
     */
    public final Boolean b() {
        return b;
    }

    /**
     * <p>
     * An attribute of type Integer (Thirty-Two Bits).
     * </p>
     * 
     * @return An attribute of type Integer (Thirty-Two Bits).
     */
    public final Integer i() {
        return i;
    }

    /**
     * <p>
     * An attribute of type Long.
     * </p>
     * 
     * @return An attribute of type Long.
     */
    public final Long l() {
        return l;
    }

    /**
     * <p>
     * An attribute of type Double (Sixty-Four Bits).
     * </p>
     * 
     * @return An attribute of type Double (Sixty-Four Bits).
     */
    public final Double d() {
        return d;
    }

    /**
     * <p>
     * An attribute of type Binary. For example:
     * </p>
     * <p>
     * <code>"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"</code>
     * </p>
     * 
     * @return An attribute of type Binary. For example:</p>
     *         <p>
     *         <code>"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"</code>
     */
    public final SdkBytes bin() {
        return bin;
    }

    /**
     * <p>
     * An attribute of type unsigned long.
     * </p>
     * 
     * @return An attribute of type unsigned long.
     */
    public final String ul() {
        return ul;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s());
        hashCode = 31 * hashCode + Objects.hashCode(b());
        hashCode = 31 * hashCode + Objects.hashCode(i());
        hashCode = 31 * hashCode + Objects.hashCode(l());
        hashCode = 31 * hashCode + Objects.hashCode(d());
        hashCode = 31 * hashCode + Objects.hashCode(bin());
        hashCode = 31 * hashCode + Objects.hashCode(ul());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommandParameterValue)) {
            return false;
        }
        CommandParameterValue other = (CommandParameterValue) obj;
        return Objects.equals(s(), other.s()) && Objects.equals(b(), other.b()) && Objects.equals(i(), other.i())
                && Objects.equals(l(), other.l()) && Objects.equals(d(), other.d()) && Objects.equals(bin(), other.bin())
                && Objects.equals(ul(), other.ul());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CommandParameterValue").add("S", s()).add("B", b()).add("I", i()).add("L", l()).add("D", d())
                .add("BIN", bin()).add("UL", ul()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S":
            return Optional.ofNullable(clazz.cast(s()));
        case "B":
            return Optional.ofNullable(clazz.cast(b()));
        case "I":
            return Optional.ofNullable(clazz.cast(i()));
        case "L":
            return Optional.ofNullable(clazz.cast(l()));
        case "D":
            return Optional.ofNullable(clazz.cast(d()));
        case "BIN":
            return Optional.ofNullable(clazz.cast(bin()));
        case "UL":
            return Optional.ofNullable(clazz.cast(ul()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("S", S_FIELD);
        map.put("B", B_FIELD);
        map.put("I", I_FIELD);
        map.put("L", L_FIELD);
        map.put("D", D_FIELD);
        map.put("BIN", BIN_FIELD);
        map.put("UL", UL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CommandParameterValue, T> g) {
        return obj -> g.apply((CommandParameterValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CommandParameterValue> {
        /**
         * <p>
         * An attribute of type String. For example:
         * </p>
         * <p>
         * <code>"S": "Hello"</code>
         * </p>
         * 
         * @param s
         *        An attribute of type String. For example:</p>
         *        <p>
         *        <code>"S": "Hello"</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s(String s);

        /**
         * <p>
         * An attribute of type Boolean. For example:
         * </p>
         * <p>
         * <code>"BOOL": true</code>
         * </p>
         * 
         * @param b
         *        An attribute of type Boolean. For example:</p>
         *        <p>
         *        <code>"BOOL": true</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder b(Boolean b);

        /**
         * <p>
         * An attribute of type Integer (Thirty-Two Bits).
         * </p>
         * 
         * @param i
         *        An attribute of type Integer (Thirty-Two Bits).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder i(Integer i);

        /**
         * <p>
         * An attribute of type Long.
         * </p>
         * 
         * @param l
         *        An attribute of type Long.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder l(Long l);

        /**
         * <p>
         * An attribute of type Double (Sixty-Four Bits).
         * </p>
         * 
         * @param d
         *        An attribute of type Double (Sixty-Four Bits).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder d(Double d);

        /**
         * <p>
         * An attribute of type Binary. For example:
         * </p>
         * <p>
         * <code>"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"</code>
         * </p>
         * 
         * @param bin
         *        An attribute of type Binary. For example:</p>
         *        <p>
         *        <code>"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bin(SdkBytes bin);

        /**
         * <p>
         * An attribute of type unsigned long.
         * </p>
         * 
         * @param ul
         *        An attribute of type unsigned long.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ul(String ul);
    }

    static final class BuilderImpl implements Builder {
        private String s;

        private Boolean b;

        private Integer i;

        private Long l;

        private Double d;

        private SdkBytes bin;

        private String ul;

        private BuilderImpl() {
        }

        private BuilderImpl(CommandParameterValue model) {
            s(model.s);
            b(model.b);
            i(model.i);
            l(model.l);
            d(model.d);
            bin(model.bin);
            ul(model.ul);
        }

        public final String getS() {
            return s;
        }

        public final void setS(String s) {
            this.s = s;
        }

        @Override
        public final Builder s(String s) {
            this.s = s;
            return this;
        }

        public final Boolean getB() {
            return b;
        }

        public final void setB(Boolean b) {
            this.b = b;
        }

        @Override
        public final Builder b(Boolean b) {
            this.b = b;
            return this;
        }

        public final Integer getI() {
            return i;
        }

        public final void setI(Integer i) {
            this.i = i;
        }

        @Override
        public final Builder i(Integer i) {
            this.i = i;
            return this;
        }

        public final Long getL() {
            return l;
        }

        public final void setL(Long l) {
            this.l = l;
        }

        @Override
        public final Builder l(Long l) {
            this.l = l;
            return this;
        }

        public final Double getD() {
            return d;
        }

        public final void setD(Double d) {
            this.d = d;
        }

        @Override
        public final Builder d(Double d) {
            this.d = d;
            return this;
        }

        public final ByteBuffer getBin() {
            return bin == null ? null : bin.asByteBuffer();
        }

        public final void setBin(ByteBuffer bin) {
            bin(bin == null ? null : SdkBytes.fromByteBuffer(bin));
        }

        @Override
        public final Builder bin(SdkBytes bin) {
            this.bin = bin;
            return this;
        }

        public final String getUl() {
            return ul;
        }

        public final void setUl(String ul) {
            this.ul = ul;
        }

        @Override
        public final Builder ul(String ul) {
            this.ul = ul;
            return this;
        }

        @Override
        public CommandParameterValue build() {
            return new CommandParameterValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
