/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PolicyVersionIdentifier
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PolicyVersionIdentifier> {
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyName").getter(PolicyVersionIdentifier.getter(PolicyVersionIdentifier::policyName)).setter(PolicyVersionIdentifier.setter(Builder::policyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyName").build()}).build();
    private static final SdkField<String> POLICY_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyVersionId").getter(PolicyVersionIdentifier.getter(PolicyVersionIdentifier::policyVersionId)).setter(PolicyVersionIdentifier.setter(Builder::policyVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyVersionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_NAME_FIELD, POLICY_VERSION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PolicyVersionIdentifier.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String policyName;
    private final String policyVersionId;

    private PolicyVersionIdentifier(BuilderImpl builder) {
        this.policyName = builder.policyName;
        this.policyVersionId = builder.policyVersionId;
    }

    public final String policyName() {
        return this.policyName;
    }

    public final String policyVersionId() {
        return this.policyVersionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyVersionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyVersionIdentifier)) {
            return false;
        }
        PolicyVersionIdentifier other = (PolicyVersionIdentifier)obj;
        return Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.policyVersionId(), other.policyVersionId());
    }

    public final String toString() {
        return ToString.builder((String)"PolicyVersionIdentifier").add("PolicyName", (Object)this.policyName()).add("PolicyVersionId", (Object)this.policyVersionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyName": {
                return Optional.ofNullable(clazz.cast(this.policyName()));
            }
            case "policyVersionId": {
                return Optional.ofNullable(clazz.cast(this.policyVersionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("policyName", POLICY_NAME_FIELD);
        map.put("policyVersionId", POLICY_VERSION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PolicyVersionIdentifier, T> g) {
        return obj -> g.apply((PolicyVersionIdentifier)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String policyName;
        private String policyVersionId;

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyVersionIdentifier model) {
            this.policyName(model.policyName);
            this.policyVersionId(model.policyVersionId);
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final String getPolicyVersionId() {
            return this.policyVersionId;
        }

        public final void setPolicyVersionId(String policyVersionId) {
            this.policyVersionId = policyVersionId;
        }

        @Override
        public final Builder policyVersionId(String policyVersionId) {
            this.policyVersionId = policyVersionId;
            return this;
        }

        public PolicyVersionIdentifier build() {
            return new PolicyVersionIdentifier(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PolicyVersionIdentifier> {
        public Builder policyName(String var1);

        public Builder policyVersionId(String var1);
    }
}

