/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a summary of information about job executions for a specific job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobExecutionSummaryForJob implements SdkPojo, Serializable,
        ToCopyableBuilder<JobExecutionSummaryForJob.Builder, JobExecutionSummaryForJob> {
    private static final SdkField<String> THING_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingArn").getter(getter(JobExecutionSummaryForJob::thingArn)).setter(setter(Builder::thingArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingArn").build()).build();

    private static final SdkField<JobExecutionSummary> JOB_EXECUTION_SUMMARY_FIELD = SdkField
            .<JobExecutionSummary> builder(MarshallingType.SDK_POJO).memberName("jobExecutionSummary")
            .getter(getter(JobExecutionSummaryForJob::jobExecutionSummary)).setter(setter(Builder::jobExecutionSummary))
            .constructor(JobExecutionSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobExecutionSummary").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_ARN_FIELD,
            JOB_EXECUTION_SUMMARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String thingArn;

    private final JobExecutionSummary jobExecutionSummary;

    private JobExecutionSummaryForJob(BuilderImpl builder) {
        this.thingArn = builder.thingArn;
        this.jobExecutionSummary = builder.jobExecutionSummary;
    }

    /**
     * <p>
     * The ARN of the thing on which the job execution is running.
     * </p>
     * 
     * @return The ARN of the thing on which the job execution is running.
     */
    public final String thingArn() {
        return thingArn;
    }

    /**
     * <p>
     * Contains a subset of information about a job execution.
     * </p>
     * 
     * @return Contains a subset of information about a job execution.
     */
    public final JobExecutionSummary jobExecutionSummary() {
        return jobExecutionSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(thingArn());
        hashCode = 31 * hashCode + Objects.hashCode(jobExecutionSummary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobExecutionSummaryForJob)) {
            return false;
        }
        JobExecutionSummaryForJob other = (JobExecutionSummaryForJob) obj;
        return Objects.equals(thingArn(), other.thingArn()) && Objects.equals(jobExecutionSummary(), other.jobExecutionSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobExecutionSummaryForJob").add("ThingArn", thingArn())
                .add("JobExecutionSummary", jobExecutionSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingArn":
            return Optional.ofNullable(clazz.cast(thingArn()));
        case "jobExecutionSummary":
            return Optional.ofNullable(clazz.cast(jobExecutionSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("thingArn", THING_ARN_FIELD);
        map.put("jobExecutionSummary", JOB_EXECUTION_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobExecutionSummaryForJob, T> g) {
        return obj -> g.apply((JobExecutionSummaryForJob) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobExecutionSummaryForJob> {
        /**
         * <p>
         * The ARN of the thing on which the job execution is running.
         * </p>
         * 
         * @param thingArn
         *        The ARN of the thing on which the job execution is running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingArn(String thingArn);

        /**
         * <p>
         * Contains a subset of information about a job execution.
         * </p>
         * 
         * @param jobExecutionSummary
         *        Contains a subset of information about a job execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobExecutionSummary(JobExecutionSummary jobExecutionSummary);

        /**
         * <p>
         * Contains a subset of information about a job execution.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobExecutionSummary.Builder} avoiding the
         * need to create one manually via {@link JobExecutionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobExecutionSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #jobExecutionSummary(JobExecutionSummary)}.
         * 
         * @param jobExecutionSummary
         *        a consumer that will call methods on {@link JobExecutionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobExecutionSummary(JobExecutionSummary)
         */
        default Builder jobExecutionSummary(Consumer<JobExecutionSummary.Builder> jobExecutionSummary) {
            return jobExecutionSummary(JobExecutionSummary.builder().applyMutation(jobExecutionSummary).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String thingArn;

        private JobExecutionSummary jobExecutionSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(JobExecutionSummaryForJob model) {
            thingArn(model.thingArn);
            jobExecutionSummary(model.jobExecutionSummary);
        }

        public final String getThingArn() {
            return thingArn;
        }

        public final void setThingArn(String thingArn) {
            this.thingArn = thingArn;
        }

        @Override
        public final Builder thingArn(String thingArn) {
            this.thingArn = thingArn;
            return this;
        }

        public final JobExecutionSummary.Builder getJobExecutionSummary() {
            return jobExecutionSummary != null ? jobExecutionSummary.toBuilder() : null;
        }

        public final void setJobExecutionSummary(JobExecutionSummary.BuilderImpl jobExecutionSummary) {
            this.jobExecutionSummary = jobExecutionSummary != null ? jobExecutionSummary.build() : null;
        }

        @Override
        public final Builder jobExecutionSummary(JobExecutionSummary jobExecutionSummary) {
            this.jobExecutionSummary = jobExecutionSummary;
            return this;
        }

        @Override
        public JobExecutionSummaryForJob build() {
            return new JobExecutionSummaryForJob(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
