/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPackageResponse extends IotResponse implements
        ToCopyableBuilder<GetPackageResponse.Builder, GetPackageResponse> {
    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("packageName").getter(getter(GetPackageResponse::packageName)).setter(setter(Builder::packageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageName").build()).build();

    private static final SdkField<String> PACKAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("packageArn").getter(getter(GetPackageResponse::packageArn)).setter(setter(Builder::packageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetPackageResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DEFAULT_VERSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultVersionName").getter(getter(GetPackageResponse::defaultVersionName))
            .setter(setter(Builder::defaultVersionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultVersionName").build())
            .build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate").getter(getter(GetPackageResponse::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedDate").getter(getter(GetPackageResponse::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_NAME_FIELD,
            PACKAGE_ARN_FIELD, DESCRIPTION_FIELD, DEFAULT_VERSION_NAME_FIELD, CREATION_DATE_FIELD, LAST_MODIFIED_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String packageName;

    private final String packageArn;

    private final String description;

    private final String defaultVersionName;

    private final Instant creationDate;

    private final Instant lastModifiedDate;

    private GetPackageResponse(BuilderImpl builder) {
        super(builder);
        this.packageName = builder.packageName;
        this.packageArn = builder.packageArn;
        this.description = builder.description;
        this.defaultVersionName = builder.defaultVersionName;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    /**
     * <p>
     * The name of the software package.
     * </p>
     * 
     * @return The name of the software package.
     */
    public final String packageName() {
        return packageName;
    }

    /**
     * <p>
     * The ARN for the package.
     * </p>
     * 
     * @return The ARN for the package.
     */
    public final String packageArn() {
        return packageArn;
    }

    /**
     * <p>
     * The package description.
     * </p>
     * 
     * @return The package description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the default package version.
     * </p>
     * 
     * @return The name of the default package version.
     */
    public final String defaultVersionName() {
        return defaultVersionName;
    }

    /**
     * <p>
     * The date the package was created.
     * </p>
     * 
     * @return The date the package was created.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The date when the package was last updated.
     * </p>
     * 
     * @return The date when the package was last updated.
     */
    public final Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(packageName());
        hashCode = 31 * hashCode + Objects.hashCode(packageArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(defaultVersionName());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPackageResponse)) {
            return false;
        }
        GetPackageResponse other = (GetPackageResponse) obj;
        return Objects.equals(packageName(), other.packageName()) && Objects.equals(packageArn(), other.packageArn())
                && Objects.equals(description(), other.description())
                && Objects.equals(defaultVersionName(), other.defaultVersionName())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPackageResponse").add("PackageName", packageName()).add("PackageArn", packageArn())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DefaultVersionName", defaultVersionName()).add("CreationDate", creationDate())
                .add("LastModifiedDate", lastModifiedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "packageName":
            return Optional.ofNullable(clazz.cast(packageName()));
        case "packageArn":
            return Optional.ofNullable(clazz.cast(packageArn()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "defaultVersionName":
            return Optional.ofNullable(clazz.cast(defaultVersionName()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "lastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("packageName", PACKAGE_NAME_FIELD);
        map.put("packageArn", PACKAGE_ARN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("defaultVersionName", DEFAULT_VERSION_NAME_FIELD);
        map.put("creationDate", CREATION_DATE_FIELD);
        map.put("lastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPackageResponse, T> g) {
        return obj -> g.apply((GetPackageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetPackageResponse> {
        /**
         * <p>
         * The name of the software package.
         * </p>
         * 
         * @param packageName
         *        The name of the software package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageName(String packageName);

        /**
         * <p>
         * The ARN for the package.
         * </p>
         * 
         * @param packageArn
         *        The ARN for the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageArn(String packageArn);

        /**
         * <p>
         * The package description.
         * </p>
         * 
         * @param description
         *        The package description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the default package version.
         * </p>
         * 
         * @param defaultVersionName
         *        The name of the default package version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultVersionName(String defaultVersionName);

        /**
         * <p>
         * The date the package was created.
         * </p>
         * 
         * @param creationDate
         *        The date the package was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The date when the package was last updated.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date when the package was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String packageName;

        private String packageArn;

        private String description;

        private String defaultVersionName;

        private Instant creationDate;

        private Instant lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPackageResponse model) {
            super(model);
            packageName(model.packageName);
            packageArn(model.packageArn);
            description(model.description);
            defaultVersionName(model.defaultVersionName);
            creationDate(model.creationDate);
            lastModifiedDate(model.lastModifiedDate);
        }

        public final String getPackageName() {
            return packageName;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final String getPackageArn() {
            return packageArn;
        }

        public final void setPackageArn(String packageArn) {
            this.packageArn = packageArn;
        }

        @Override
        public final Builder packageArn(String packageArn) {
            this.packageArn = packageArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDefaultVersionName() {
            return defaultVersionName;
        }

        public final void setDefaultVersionName(String defaultVersionName) {
            this.defaultVersionName = defaultVersionName;
        }

        @Override
        public final Builder defaultVersionName(String defaultVersionName) {
            this.defaultVersionName = defaultVersionName;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        @Override
        public GetPackageResponse build() {
            return new GetPackageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
