/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The ThingTypeMetadata contains additional information about the thing type including: creation date and time, a value
 * indicating whether the thing type is deprecated, and a date and time when time was deprecated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThingTypeMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<ThingTypeMetadata.Builder, ThingTypeMetadata> {
    private static final SdkField<Boolean> DEPRECATED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("deprecated").getter(getter(ThingTypeMetadata::deprecated)).setter(setter(Builder::deprecated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deprecated").build()).build();

    private static final SdkField<Instant> DEPRECATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("deprecationDate").getter(getter(ThingTypeMetadata::deprecationDate))
            .setter(setter(Builder::deprecationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deprecationDate").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate").getter(getter(ThingTypeMetadata::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPRECATED_FIELD,
            DEPRECATION_DATE_FIELD, CREATION_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean deprecated;

    private final Instant deprecationDate;

    private final Instant creationDate;

    private ThingTypeMetadata(BuilderImpl builder) {
        this.deprecated = builder.deprecated;
        this.deprecationDate = builder.deprecationDate;
        this.creationDate = builder.creationDate;
    }

    /**
     * <p>
     * Whether the thing type is deprecated. If <b>true</b>, no new things could be associated with this type.
     * </p>
     * 
     * @return Whether the thing type is deprecated. If <b>true</b>, no new things could be associated with this type.
     */
    public final Boolean deprecated() {
        return deprecated;
    }

    /**
     * <p>
     * The date and time when the thing type was deprecated.
     * </p>
     * 
     * @return The date and time when the thing type was deprecated.
     */
    public final Instant deprecationDate() {
        return deprecationDate;
    }

    /**
     * <p>
     * The date and time when the thing type was created.
     * </p>
     * 
     * @return The date and time when the thing type was created.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deprecated());
        hashCode = 31 * hashCode + Objects.hashCode(deprecationDate());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingTypeMetadata)) {
            return false;
        }
        ThingTypeMetadata other = (ThingTypeMetadata) obj;
        return Objects.equals(deprecated(), other.deprecated()) && Objects.equals(deprecationDate(), other.deprecationDate())
                && Objects.equals(creationDate(), other.creationDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ThingTypeMetadata").add("Deprecated", deprecated()).add("DeprecationDate", deprecationDate())
                .add("CreationDate", creationDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deprecated":
            return Optional.ofNullable(clazz.cast(deprecated()));
        case "deprecationDate":
            return Optional.ofNullable(clazz.cast(deprecationDate()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("deprecated", DEPRECATED_FIELD);
        map.put("deprecationDate", DEPRECATION_DATE_FIELD);
        map.put("creationDate", CREATION_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ThingTypeMetadata, T> g) {
        return obj -> g.apply((ThingTypeMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ThingTypeMetadata> {
        /**
         * <p>
         * Whether the thing type is deprecated. If <b>true</b>, no new things could be associated with this type.
         * </p>
         * 
         * @param deprecated
         *        Whether the thing type is deprecated. If <b>true</b>, no new things could be associated with this
         *        type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deprecated(Boolean deprecated);

        /**
         * <p>
         * The date and time when the thing type was deprecated.
         * </p>
         * 
         * @param deprecationDate
         *        The date and time when the thing type was deprecated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deprecationDate(Instant deprecationDate);

        /**
         * <p>
         * The date and time when the thing type was created.
         * </p>
         * 
         * @param creationDate
         *        The date and time when the thing type was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);
    }

    static final class BuilderImpl implements Builder {
        private Boolean deprecated;

        private Instant deprecationDate;

        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ThingTypeMetadata model) {
            deprecated(model.deprecated);
            deprecationDate(model.deprecationDate);
            creationDate(model.creationDate);
        }

        public final Boolean getDeprecated() {
            return deprecated;
        }

        public final void setDeprecated(Boolean deprecated) {
            this.deprecated = deprecated;
        }

        @Override
        public final Builder deprecated(Boolean deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        public final Instant getDeprecationDate() {
            return deprecationDate;
        }

        public final void setDeprecationDate(Instant deprecationDate) {
            this.deprecationDate = deprecationDate;
        }

        @Override
        public final Builder deprecationDate(Instant deprecationDate) {
            this.deprecationDate = deprecationDate;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        @Override
        public ThingTypeMetadata build() {
            return new ThingTypeMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
