/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an action to republish to another topic.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RepublishAction implements SdkPojo, Serializable, ToCopyableBuilder<RepublishAction.Builder, RepublishAction> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(RepublishAction::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> TOPIC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("topic")
            .getter(getter(RepublishAction::topic)).setter(setter(Builder::topic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topic").build()).build();

    private static final SdkField<Integer> QOS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("qos")
            .getter(getter(RepublishAction::qos)).setter(setter(Builder::qos))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qos").build()).build();

    private static final SdkField<MqttHeaders> HEADERS_FIELD = SdkField.<MqttHeaders> builder(MarshallingType.SDK_POJO)
            .memberName("headers").getter(getter(RepublishAction::headers)).setter(setter(Builder::headers))
            .constructor(MqttHeaders::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("headers").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, TOPIC_FIELD,
            QOS_FIELD, HEADERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String roleArn;

    private final String topic;

    private final Integer qos;

    private final MqttHeaders headers;

    private RepublishAction(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.topic = builder.topic;
        this.qos = builder.qos;
        this.headers = builder.headers;
    }

    /**
     * <p>
     * The ARN of the IAM role that grants access.
     * </p>
     * 
     * @return The ARN of the IAM role that grants access.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The name of the MQTT topic.
     * </p>
     * 
     * @return The name of the MQTT topic.
     */
    public final String topic() {
        return topic;
    }

    /**
     * <p>
     * The Quality of Service (QoS) level to use when republishing messages. The default value is 0.
     * </p>
     * 
     * @return The Quality of Service (QoS) level to use when republishing messages. The default value is 0.
     */
    public final Integer qos() {
        return qos;
    }

    /**
     * <p>
     * MQTT Version 5.0 headers information. For more information, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/mqtt.html"> MQTT</a> from the Amazon Web Services IoT
     * Core Developer Guide.
     * </p>
     * 
     * @return MQTT Version 5.0 headers information. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot/latest/developerguide/mqtt.html"> MQTT</a> from the Amazon Web
     *         Services IoT Core Developer Guide.
     */
    public final MqttHeaders headers() {
        return headers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(topic());
        hashCode = 31 * hashCode + Objects.hashCode(qos());
        hashCode = 31 * hashCode + Objects.hashCode(headers());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepublishAction)) {
            return false;
        }
        RepublishAction other = (RepublishAction) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(topic(), other.topic())
                && Objects.equals(qos(), other.qos()) && Objects.equals(headers(), other.headers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RepublishAction").add("RoleArn", roleArn()).add("Topic", topic()).add("Qos", qos())
                .add("Headers", headers()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "topic":
            return Optional.ofNullable(clazz.cast(topic()));
        case "qos":
            return Optional.ofNullable(clazz.cast(qos()));
        case "headers":
            return Optional.ofNullable(clazz.cast(headers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("topic", TOPIC_FIELD);
        map.put("qos", QOS_FIELD);
        map.put("headers", HEADERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RepublishAction, T> g) {
        return obj -> g.apply((RepublishAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RepublishAction> {
        /**
         * <p>
         * The ARN of the IAM role that grants access.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role that grants access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The name of the MQTT topic.
         * </p>
         * 
         * @param topic
         *        The name of the MQTT topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topic(String topic);

        /**
         * <p>
         * The Quality of Service (QoS) level to use when republishing messages. The default value is 0.
         * </p>
         * 
         * @param qos
         *        The Quality of Service (QoS) level to use when republishing messages. The default value is 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qos(Integer qos);

        /**
         * <p>
         * MQTT Version 5.0 headers information. For more information, see <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/mqtt.html"> MQTT</a> from the Amazon Web Services
         * IoT Core Developer Guide.
         * </p>
         * 
         * @param headers
         *        MQTT Version 5.0 headers information. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot/latest/developerguide/mqtt.html"> MQTT</a> from the Amazon Web
         *        Services IoT Core Developer Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headers(MqttHeaders headers);

        /**
         * <p>
         * MQTT Version 5.0 headers information. For more information, see <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/mqtt.html"> MQTT</a> from the Amazon Web Services
         * IoT Core Developer Guide.
         * </p>
         * This is a convenience method that creates an instance of the {@link MqttHeaders.Builder} avoiding the need to
         * create one manually via {@link MqttHeaders#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MqttHeaders.Builder#build()} is called immediately and its result
         * is passed to {@link #headers(MqttHeaders)}.
         * 
         * @param headers
         *        a consumer that will call methods on {@link MqttHeaders.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #headers(MqttHeaders)
         */
        default Builder headers(Consumer<MqttHeaders.Builder> headers) {
            return headers(MqttHeaders.builder().applyMutation(headers).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private String topic;

        private Integer qos;

        private MqttHeaders headers;

        private BuilderImpl() {
        }

        private BuilderImpl(RepublishAction model) {
            roleArn(model.roleArn);
            topic(model.topic);
            qos(model.qos);
            headers(model.headers);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getTopic() {
            return topic;
        }

        public final void setTopic(String topic) {
            this.topic = topic;
        }

        @Override
        public final Builder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public final Integer getQos() {
            return qos;
        }

        public final void setQos(Integer qos) {
            this.qos = qos;
        }

        @Override
        public final Builder qos(Integer qos) {
            this.qos = qos;
            return this;
        }

        public final MqttHeaders.Builder getHeaders() {
            return headers != null ? headers.toBuilder() : null;
        }

        public final void setHeaders(MqttHeaders.BuilderImpl headers) {
            this.headers = headers != null ? headers.build() : null;
        }

        @Override
        public final Builder headers(MqttHeaders headers) {
            this.headers = headers;
            return this;
        }

        @Override
        public RepublishAction build() {
            return new RepublishAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
