/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains information about the managed template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManagedJobTemplateSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ManagedJobTemplateSummary.Builder, ManagedJobTemplateSummary> {
    private static final SdkField<String> TEMPLATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateArn").getter(getter(ManagedJobTemplateSummary::templateArn))
            .setter(setter(Builder::templateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateArn").build()).build();

    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateName").getter(getter(ManagedJobTemplateSummary::templateName))
            .setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ManagedJobTemplateSummary::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<String>> ENVIRONMENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("environments")
            .getter(getter(ManagedJobTemplateSummary::environments))
            .setter(setter(Builder::environments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TEMPLATE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateVersion").getter(getter(ManagedJobTemplateSummary::templateVersion))
            .setter(setter(Builder::templateVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_ARN_FIELD,
            TEMPLATE_NAME_FIELD, DESCRIPTION_FIELD, ENVIRONMENTS_FIELD, TEMPLATE_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String templateArn;

    private final String templateName;

    private final String description;

    private final List<String> environments;

    private final String templateVersion;

    private ManagedJobTemplateSummary(BuilderImpl builder) {
        this.templateArn = builder.templateArn;
        this.templateName = builder.templateName;
        this.description = builder.description;
        this.environments = builder.environments;
        this.templateVersion = builder.templateVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for a managed template.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for a managed template.
     */
    public final String templateArn() {
        return templateArn;
    }

    /**
     * <p>
     * The unique Name for a managed template.
     * </p>
     * 
     * @return The unique Name for a managed template.
     */
    public final String templateName() {
        return templateName;
    }

    /**
     * <p>
     * The description for a managed template.
     * </p>
     * 
     * @return The description for a managed template.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Environments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnvironments() {
        return environments != null && !(environments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of environments that are supported with the managed job template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironments} method.
     * </p>
     * 
     * @return A list of environments that are supported with the managed job template.
     */
    public final List<String> environments() {
        return environments;
    }

    /**
     * <p>
     * The version for a managed template.
     * </p>
     * 
     * @return The version for a managed template.
     */
    public final String templateVersion() {
        return templateVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(templateArn());
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironments() ? environments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(templateVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedJobTemplateSummary)) {
            return false;
        }
        ManagedJobTemplateSummary other = (ManagedJobTemplateSummary) obj;
        return Objects.equals(templateArn(), other.templateArn()) && Objects.equals(templateName(), other.templateName())
                && Objects.equals(description(), other.description()) && hasEnvironments() == other.hasEnvironments()
                && Objects.equals(environments(), other.environments())
                && Objects.equals(templateVersion(), other.templateVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ManagedJobTemplateSummary").add("TemplateArn", templateArn())
                .add("TemplateName", templateName()).add("Description", description())
                .add("Environments", hasEnvironments() ? environments() : null).add("TemplateVersion", templateVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "templateArn":
            return Optional.ofNullable(clazz.cast(templateArn()));
        case "templateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "environments":
            return Optional.ofNullable(clazz.cast(environments()));
        case "templateVersion":
            return Optional.ofNullable(clazz.cast(templateVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("templateArn", TEMPLATE_ARN_FIELD);
        map.put("templateName", TEMPLATE_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("environments", ENVIRONMENTS_FIELD);
        map.put("templateVersion", TEMPLATE_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedJobTemplateSummary, T> g) {
        return obj -> g.apply((ManagedJobTemplateSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManagedJobTemplateSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for a managed template.
         * </p>
         * 
         * @param templateArn
         *        The Amazon Resource Name (ARN) for a managed template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateArn(String templateArn);

        /**
         * <p>
         * The unique Name for a managed template.
         * </p>
         * 
         * @param templateName
         *        The unique Name for a managed template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * The description for a managed template.
         * </p>
         * 
         * @param description
         *        The description for a managed template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of environments that are supported with the managed job template.
         * </p>
         * 
         * @param environments
         *        A list of environments that are supported with the managed job template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environments(Collection<String> environments);

        /**
         * <p>
         * A list of environments that are supported with the managed job template.
         * </p>
         * 
         * @param environments
         *        A list of environments that are supported with the managed job template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environments(String... environments);

        /**
         * <p>
         * The version for a managed template.
         * </p>
         * 
         * @param templateVersion
         *        The version for a managed template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateVersion(String templateVersion);
    }

    static final class BuilderImpl implements Builder {
        private String templateArn;

        private String templateName;

        private String description;

        private List<String> environments = DefaultSdkAutoConstructList.getInstance();

        private String templateVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedJobTemplateSummary model) {
            templateArn(model.templateArn);
            templateName(model.templateName);
            description(model.description);
            environments(model.environments);
            templateVersion(model.templateVersion);
        }

        public final String getTemplateArn() {
            return templateArn;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        @Override
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        public final String getTemplateName() {
            return templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getEnvironments() {
            if (environments instanceof SdkAutoConstructList) {
                return null;
            }
            return environments;
        }

        public final void setEnvironments(Collection<String> environments) {
            this.environments = EnvironmentsCopier.copy(environments);
        }

        @Override
        public final Builder environments(Collection<String> environments) {
            this.environments = EnvironmentsCopier.copy(environments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environments(String... environments) {
            environments(Arrays.asList(environments));
            return this;
        }

        public final String getTemplateVersion() {
            return templateVersion;
        }

        public final void setTemplateVersion(String templateVersion) {
            this.templateVersion = templateVersion;
        }

        @Override
        public final Builder templateVersion(String templateVersion) {
            this.templateVersion = templateVersion;
            return this;
        }

        @Override
        public ManagedJobTemplateSummary build() {
            return new ManagedJobTemplateSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
